/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.impl;

import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.workflow.task.busin.service.QryTodoTaskProcInstMapBusiService;
import com.cgd.workflow.task.busin.service.bo.QueryTodoTaskProcInstMapReqBO;
import com.cgd.workflow.task.busin.service.bo.QueryTodoTaskProcInstMapRspBO;
import com.cgd.workflow.task.busin.service.bo.TaskRspBO;
import com.ohaotian.commodity.busi.QryGroupWaitAuditSkuService;
import com.ohaotian.commodity.busi.bo.QryWaitAuditSkuReqBO;
import com.ohaotian.commodity.busi.bo.QryWaitAuditSkuRspBO;
import com.ohaotian.commodity.busi.constant.SupplyConstant;
import com.ohaotian.commodity.common.exception.BusinessException;
import com.ohaotian.commodity.dao.CatalogCommodityTypeMapper;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.SkuOnShelveLogMapper;
import com.ohaotian.commodity.dao.po.CatalogCommodityType;
import com.ohaotian.commodity.dao.po.QryWaitAuditSkuPO;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QryGroupWaitAuditSkuServiceImpl
implements QryGroupWaitAuditSkuService {
    private static final Logger logger = LoggerFactory.getLogger(QryGroupWaitAuditSkuServiceImpl.class);
    SkuMapper skuMapper;
    private QryTodoTaskProcInstMapBusiService qryTodoTaskProcInstMapBusiService;
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;
    private SkuOnShelveLogMapper skuOnShelveLogMapper;
    private CatalogCommodityTypeMapper catalogCommodityTypeMapper;

    public RspPageBO<QryWaitAuditSkuRspBO> qryGroupWaitAuditSkuList(QryWaitAuditSkuReqBO qryWaitAuditSkuReqBO) {
        RspPageBO rspPageBO = new RspPageBO();
        logger.debug("\u67e5\u8be2\u96c6\u56e2\u5f85\u5ba1\u6838\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryWaitAuditSkuReqBO.toString());
        if (qryWaitAuditSkuReqBO.getDiscountStart() != null && !QryGroupWaitAuditSkuServiceImpl.isNumeric(qryWaitAuditSkuReqBO.getDiscountStart().toString())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5f85\u5ba1\u6838\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u6298\u6263\u7387\u533a\u95f4\u503c\u4e0d\u662f\u6570\u5b57");
        }
        if (qryWaitAuditSkuReqBO.getDiscountEnd() != null) {
            if (!QryGroupWaitAuditSkuServiceImpl.isNumeric(qryWaitAuditSkuReqBO.getDiscountEnd().toString())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5f85\u5ba1\u6838\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u6298\u6263\u7387\u533a\u95f4\u503c\u4e0d\u662f\u6570\u5b57");
            }
            if (qryWaitAuditSkuReqBO.getDiscountEnd() > 99) {
                qryWaitAuditSkuReqBO.setDiscountEnd(null);
            }
        }
        try {
            Page page = new Page(qryWaitAuditSkuReqBO.getPageNo(), qryWaitAuditSkuReqBO.getPageSize());
            Object supplierId = null;
            logger.info("\u67e5\u8be2\u96c6\u56e2\u5f85\u5ba1\u6838\u5546\u54c1\u4e1a\u52a1\u67e5\u8be2\u7c7b\u76ee\u5173\u8054\u8868\uff1a" + qryWaitAuditSkuReqBO.getGuideCatalogId());
            LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
            if (null != qryWaitAuditSkuReqBO.getGuideCatalogId()) {
                List<CatalogCommodityType> catalogs = this.catalogCommodityTypeMapper.selectByCatalogId(qryWaitAuditSkuReqBO.getGuideCatalogId());
                for (CatalogCommodityType catalogCommodityType : catalogs) {
                    commodityTypeIds.add(catalogCommodityType.getCommodityTypeId());
                }
            }
            logger.info("\u67e5\u8be2\u96c6\u56e2\u5f85\u5ba1\u6838\u5546\u54c1\u4e1a\u52a1\u67e5\u8be2\u7c7b\u76ee\u5173\u8054\u8868\u7ed3\u675f\uff1a" + ((Object)commodityTypeIds).toString());
            List<QryWaitAuditSkuPO> pageList = this.skuMapper.qryGroupWaitAuditSku((Page<QryWaitAuditSkuReqBO>)page, qryWaitAuditSkuReqBO, commodityTypeIds);
            ArrayList<String> procInstlIds = new ArrayList<String>();
            for (QryWaitAuditSkuPO po : pageList) {
                procInstlIds.add(po.getProcInstlId());
            }
            if (procInstlIds.size() > 0) {
                QueryTodoTaskProcInstMapReqBO queryTodoTaskProcInstMapReqBO = new QueryTodoTaskProcInstMapReqBO();
                queryTodoTaskProcInstMapReqBO.setUserId(qryWaitAuditSkuReqBO.getUserId());
                queryTodoTaskProcInstMapReqBO.setBusinessType("14");
                queryTodoTaskProcInstMapReqBO.setProcInstIds(procInstlIds);
                QueryTodoTaskProcInstMapRspBO queryTodoTaskProcInst = this.queryTodoTaskProcInst(queryTodoTaskProcInstMapReqBO);
                for (QryWaitAuditSkuPO po : pageList) {
                    TaskRspBO taskRspBO;
                    String skuProcInstId = po.getProcInstlId();
                    if (queryTodoTaskProcInst == null || queryTodoTaskProcInst.getProcinstTaskMap() == null || queryTodoTaskProcInst.getProcinstTaskMap().size() <= 0 || (taskRspBO = (TaskRspBO)queryTodoTaskProcInst.getProcinstTaskMap().get(skuProcInstId)) == null) continue;
                    po.setTaskId(taskRspBO.getTaskId());
                }
            }
            ArrayList<QryWaitAuditSkuRspBO> arrayList = new ArrayList<QryWaitAuditSkuRspBO>();
            for (QryWaitAuditSkuPO po : pageList) {
                QryWaitAuditSkuRspBO rsp = new QryWaitAuditSkuRspBO();
                BeanUtils.copyProperties((Object)rsp, (Object)po);
                if (po.getApproveType().toString().equals(SupplyConstant.APPROVE_GROUP_AUDIT_TYPE.toString())) {
                    rsp.setBusinessType("14");
                } else if (po.getApproveType().toString().equals(SupplyConstant.APPROVE_ON_SHELF_TYPE.toString())) {
                    rsp.setBusinessType("10");
                }
                arrayList.add(rsp);
            }
            logger.info("\u67e5\u8be2\u96c6\u56e2\u5f85\u5ba1\u6838\u5546\u54c1\u4e1a\u52a1\u67e5\u8be2\u7ed3\u679c\uff1a" + ((Object)arrayList).toString());
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setTotal(page.getTotalPages());
            rspPageBO.setPageNo(qryWaitAuditSkuReqBO.getPageNo());
            rspPageBO.setRows(arrayList);
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u96c6\u56e2\u5f85\u5ba1\u6838\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u96c6\u56e2\u5f85\u5ba1\u6838\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private QueryTodoTaskProcInstMapRspBO queryTodoTaskProcInst(QueryTodoTaskProcInstMapReqBO queryTodoTaskProcInstMapReqBO) {
        try {
            QueryTodoTaskProcInstMapRspBO queryTodoTaskProcInstMap = this.qryTodoTaskProcInstMapBusiService.queryTodoTaskProcInstMapB(queryTodoTaskProcInstMapReqBO);
            return queryTodoTaskProcInstMap;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5de5\u4f5c\u6d41\u67e5\u8be2\u5f85\u529e\u4efb\u52a1\u4e0e\u6d41\u7a0b\u5b9e\u4f8bid\u5173\u8054\u7684map\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u5de5\u4f5c\u6d41\u67e5\u8be2\u5f85\u529e\u4efb\u52a1\u4e0e\u6d41\u7a0b\u5b9e\u4f8bid\u5173\u8054\u7684map\u670d\u52a1\u5931\u8d25");
        }
    }

    private static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setQryTodoTaskProcInstMapBusiService(QryTodoTaskProcInstMapBusiService qryTodoTaskProcInstMapBusiService) {
        this.qryTodoTaskProcInstMapBusiService = qryTodoTaskProcInstMapBusiService;
    }

    public void setSelectUserInfoByUserIdBusiService(SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService) {
        this.selectUserInfoByUserIdBusiService = selectUserInfoByUserIdBusiService;
    }

    public void setSkuOnShelveLogMapper(SkuOnShelveLogMapper skuOnShelveLogMapper) {
        this.skuOnShelveLogMapper = skuOnShelveLogMapper;
    }

    public void setCatalogCommodityTypeMapper(CatalogCommodityTypeMapper catalogCommodityTypeMapper) {
        this.catalogCommodityTypeMapper = catalogCommodityTypeMapper;
    }
}

