/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryAgrEnableService;
import com.cgd.commodity.busi.bo.agreement.QryAgrEnableReqBO;
import com.cgd.commodity.busi.bo.agreement.QryAgrEnableRspBO;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.dao.SupplierAgreementSkuMapper;
import com.cgd.commodity.po.SupplierAgreement;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdAndCompIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdAndCompIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdAndCompIdRspBO;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QryAgrEnableServiceImpl
implements QryAgrEnableService {
    private static final Logger logger = LoggerFactory.getLogger(QryAgrEnableServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SelectUserInfoByUserIdAndCompIdBusiService selectUserInfoByUserIdAndCompIdBusiService;
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;
    private SupplierAgreementMapper supplierAgreementMapper;

    public void setSelectUserInfoByUserIdAndCompIdBusiService(SelectUserInfoByUserIdAndCompIdBusiService selectUserInfoByUserIdAndCompIdBusiService) {
        this.selectUserInfoByUserIdAndCompIdBusiService = selectUserInfoByUserIdAndCompIdBusiService;
    }

    public void setSupplierAgreementSkuMapper(SupplierAgreementSkuMapper supplierAgreementSkuMapper) {
        this.supplierAgreementSkuMapper = supplierAgreementSkuMapper;
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public RspPageBO<QryAgrEnableRspBO> qryAgrEnable(QryAgrEnableReqBO qryAgrEnableReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u542f\u7528\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryAgrEnableReqBO.toString());
        }
        if (null == qryAgrEnableReqBO.getUserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237ID[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long supplierId = null;
        supplierId = "0".equals(qryAgrEnableReqBO.getIsprofess()) ? qryAgrEnableReqBO.getCompanyId() : this.getUserSupplierId(qryAgrEnableReqBO.getUserId());
        if (null == supplierId) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237ID[" + qryAgrEnableReqBO.getUserId() + "]\u6ca1\u6709\u5bf9\u5e94\u7684\u4e13\u4e1a\u673a\u6784");
        }
        try {
            Page page = new Page(qryAgrEnableReqBO.getPageNo(), qryAgrEnableReqBO.getPageSize());
            List<SupplierAgreement> supplierAgreements = this.supplierAgreementMapper.qryAgrIdOfEnable((Page<QryAgrEnableReqBO>)page, qryAgrEnableReqBO, supplierId);
            List<QryAgrEnableRspBO> result = this.resolveRsp(supplierAgreements);
            RspPageBO rspPageBO = new RspPageBO();
            rspPageBO.setRows(result);
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setTotal(page.getTotalPages());
            rspPageBO.setPageNo(qryAgrEnableReqBO.getPageNo());
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u542f\u7528\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u542f\u7528\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private Long getUserSupplierId(Long userId) {
        try {
            SelectUserInfoByUserIdAndCompIdReqBO selectUserInfoAndCompIdReqBO = new SelectUserInfoByUserIdAndCompIdReqBO();
            selectUserInfoAndCompIdReqBO.setUserId(userId);
            SelectUserInfoByUserIdAndCompIdRspBO selectUserInfoByUserIdAndCompIdRspBO = this.selectUserInfoByUserIdAndCompIdBusiService.selectUserInfoByUserIdAndCompId(selectUserInfoAndCompIdReqBO);
            if ("0000".equals(selectUserInfoByUserIdAndCompIdRspBO.getRespCode())) {
                return selectUserInfoByUserIdAndCompIdRspBO.getCompId();
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u542f\u7528\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u6839\u636e\u7528\u6237\u67e5\u94fa\u8d27\u5355\u4f4d\u4fe1\u606f\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u6839\u636e\u7528\u6237\u67e5\u94fa\u8d27\u5355\u4f4d\u4fe1\u606f\u5931\u8d25");
        }
    }

    private List<QryAgrEnableRspBO> resolveRsp(List<SupplierAgreement> supplierAgreements) {
        try {
            ArrayList<QryAgrEnableRspBO> qryAgrEnableRspBOs = new ArrayList<QryAgrEnableRspBO>();
            if (!supplierAgreements.isEmpty()) {
                for (SupplierAgreement supplierAgreement : supplierAgreements) {
                    Map<String, Long> skuNumMap = this.supplierAgreementSkuMapper.qryNumsByAgrId(supplierAgreement.getAgreementId(), supplierAgreement.getSupplierId());
                    QryAgrEnableRspBO qryAgrEnableRspBO = new QryAgrEnableRspBO();
                    qryAgrEnableRspBO.setAgreementId(supplierAgreement.getAgreementId());
                    qryAgrEnableRspBO.setAgreementName(supplierAgreement.getAgreementName());
                    qryAgrEnableRspBO.setAgreementType(supplierAgreement.getAgreementType());
                    qryAgrEnableRspBO.setEntAgreementCode(supplierAgreement.getEntAgreementCode());
                    qryAgrEnableRspBO.setPlaAgreementCode(supplierAgreement.getPlaAgreementCode());
                    qryAgrEnableRspBO.setSupplierId(supplierAgreement.getSupplierId());
                    qryAgrEnableRspBO.setProducerName(supplierAgreement.getProducerName());
                    qryAgrEnableRspBO.setIsDispatch(supplierAgreement.getIsDispatch());
                    qryAgrEnableRspBO.setSignTime(supplierAgreement.getSignTime());
                    qryAgrEnableRspBO.setVendorId(supplierAgreement.getVendorId());
                    qryAgrEnableRspBO.setVendorName(supplierAgreement.getVendorName());
                    if (!skuNumMap.isEmpty()) {
                        qryAgrEnableRspBO.setCount(skuNumMap.get("SKU_NUM"));
                    }
                    qryAgrEnableRspBOs.add(qryAgrEnableRspBO);
                }
                return qryAgrEnableRspBOs;
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u542f\u7528\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u7edf\u8ba1\u5546\u54c1\u5404\u72b6\u6001\u6570\u91cf-\u5c01\u88c5\u54cd\u5e94\u6570\u636e\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u7edf\u8ba1\u5546\u54c1\u5404\u72b6\u6001\u6570\u91cf-\u5c01\u88c5\u54cd\u5e94\u6570\u636e\u5931\u8d25");
        }
    }
}

