/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.MdmSyncMaterialService;
import com.cgd.commodity.busi.bo.MdmSyncMaterialReqBO;
import com.cgd.commodity.busi.bo.MdmSyncMaterialRspBO;
import com.cgd.commodity.busi.bo.MdmSyncMaterialRspVO;
import com.cgd.commodity.busi.vo.MdmPropertyCodeParam;
import com.cgd.commodity.busi.vo.MdmSpecialityCodeParam;
import com.cgd.commodity.busi.vo.MdmSyncMaterialDataInfoVO;
import com.cgd.commodity.busi.vo.MdmValidationResultVO;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.EMdmMaterialMapper;
import com.cgd.commodity.dao.EMdmPropValueMapper;
import com.cgd.commodity.dao.MdmCatalogMapper;
import com.cgd.commodity.dao.MdmMetadataMapper;
import com.cgd.commodity.dao.MdmPropDefMapper;
import com.cgd.commodity.po.EMdmMaterial;
import com.cgd.commodity.po.EMdmPropValue;
import com.cgd.commodity.po.MdmCatalogPO;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class MdmSyncMaterialServiceImpl
implements MdmSyncMaterialService {
    private static final Logger logger = LoggerFactory.getLogger(MdmSyncMaterialServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    MdmCatalogMapper mdmCatalogMapper;
    EMdmMaterialMapper eMdmMaterialMapper;
    EMdmPropValueMapper eMdmPropValueMapper;
    MdmPropDefMapper mdmPropDefMapper;
    MdmMetadataMapper mdmMetadataMapper;

    public MdmSyncMaterialRspBO syncMaterial(MdmSyncMaterialReqBO mdmSyncMaterialReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u4e3b\u6570\u636e\u7269\u6599\u4fe1\u606f\u540c\u6b65\u5165\u53c2\uff1a" + mdmSyncMaterialReqBO.toString());
        }
        MdmSyncMaterialRspBO rspBO = new MdmSyncMaterialRspBO();
        try {
            LinkedList<MdmValidationResultVO> validateModelList = new LinkedList<MdmValidationResultVO>();
            ArrayList<MdmSyncMaterialRspVO> mdmSyncMaterialRspVOs = new ArrayList<MdmSyncMaterialRspVO>();
            List validateList = mdmSyncMaterialReqBO.getMdmSyncMaterialDataInfoVOs();
            String errorText = "";
            for (int i = 0; i < validateList.size(); ++i) {
                List<MdmValidationResultVO> vrs = MdmSyncMaterialServiceImpl.validateModel(validateList.get(i));
                validateModelList.addAll(vrs);
                if (vrs.size() <= 0) continue;
                MdmSyncMaterialRspVO mdmSyncMaterialRspVO = new MdmSyncMaterialRspVO();
                mdmSyncMaterialRspVO.setStatus(1);
                mdmSyncMaterialRspVO.setUuid(((MdmSyncMaterialDataInfoVO)validateList.get(i)).getUuid());
                for (MdmValidationResultVO value : vrs) {
                    errorText = errorText + value.getValidationMsg() + ",";
                }
                mdmSyncMaterialRspVO.setErrorText(errorText);
                mdmSyncMaterialRspVOs.add(mdmSyncMaterialRspVO);
            }
            if (!validateModelList.isEmpty()) {
                rspBO.setRespCode("7777");
                rspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
                rspBO.setMdmSyncMaterialRspVOs(mdmSyncMaterialRspVOs);
                return rspBO;
            }
            boolean isFail = false;
            for (MdmSyncMaterialDataInfoVO mdmSyncMaterialDataInfoVO : this.replaceQuote(mdmSyncMaterialReqBO).getMdmSyncMaterialDataInfoVOs()) {
                MdmSyncMaterialRspVO mdmSyncMaterialRspVO;
                MdmCatalogPO mdmCatalogPO = this.mdmCatalogMapper.getCheckByCatalogId(mdmSyncMaterialDataInfoVO.getCatalogId());
                ArrayList<EMdmPropValue> eMdmPropValues = new ArrayList<EMdmPropValue>();
                if (null != mdmCatalogPO) {
                    EMdmMaterial eMdmMaterial = new EMdmMaterial();
                    BeanUtils.copyProperties((Object)mdmSyncMaterialDataInfoVO, (Object)eMdmMaterial);
                    eMdmMaterial.setCreateTime(new Date());
                    eMdmMaterial.setIsDelete((byte)Constant.IS_DELETE.intValue());
                    eMdmMaterial.setSysId(mdmCatalogPO.getSysId());
                    eMdmMaterial.setPropDefVer(mdmSyncMaterialDataInfoVO.getCategoryVersion());
                    eMdmMaterial.setUpdateTime(mdmSyncMaterialDataInfoVO.getLastModifyRecordTime());
                    EMdmMaterial eMdmMaterialResult = this.eMdmMaterialMapper.selectByPrimaryKey(eMdmMaterial.getMaterialId());
                    if (eMdmMaterialResult != null && eMdmMaterial.getMaterialCode().equals(eMdmMaterialResult.getMaterialCode())) {
                        this.eMdmPropValueMapper.deleteByMaterialCode(eMdmMaterialResult.getMaterialCode());
                        this.eMdmMaterialMapper.deleteByPrimaryKey(eMdmMaterialResult.getMaterialId());
                    }
                    for (MdmSpecialityCodeParam mdmSpecialityCodeParam : mdmSyncMaterialDataInfoVO.getMdmSpecialityCodeParams()) {
                        Long propDefId = this.mdmPropDefMapper.getPrimaryKey(mdmCatalogPO.getSysId(), mdmCatalogPO.getCatalogId(), mdmCatalogPO.getCatalogVer(), mdmSpecialityCodeParam.getPropCode());
                        for (MdmPropertyCodeParam mdmPropertyCodeParam : mdmSpecialityCodeParam.getMdmPropertyCodeParams()) {
                            EMdmPropValue eMdmPropValue = new EMdmPropValue();
                            BeanUtils.copyProperties((Object)mdmPropertyCodeParam, (Object)eMdmPropValue);
                            eMdmPropValue.setCatalogId(mdmSpecialityCodeParam.getCatalogId());
                            eMdmPropValue.setPropCode(mdmSpecialityCodeParam.getPropCode());
                            eMdmPropValue.setMaterialId(mdmSyncMaterialDataInfoVO.getMaterialId());
                            eMdmPropValue.setPropName(mdmSpecialityCodeParam.getPropName());
                            eMdmPropValue.setCreateTime(new Date());
                            eMdmPropValue.setIsDelete((byte)Constant.IS_DELETE.intValue());
                            if (eMdmPropValue.getPropCode().equals("C1")) {
                                eMdmPropValue.setPropDefId(0L);
                            } else {
                                eMdmPropValue.setPropDefId(propDefId);
                            }
                            eMdmPropValue.setMaterialCode(mdmSyncMaterialDataInfoVO.getMaterialCode());
                            eMdmPropValue.setUpdateTime(mdmSyncMaterialDataInfoVO.getLastModifyRecordTime());
                            if (!eMdmPropValue.getPropCode().equals("C1") && !this.mdmMetadataMapper.getMetadataCode(eMdmPropValue.getCatalogId(), mdmSyncMaterialDataInfoVO.getCategoryVersion(), eMdmPropValue.getPropCode()).contains(eMdmPropValue.getMetadataCode())) {
                                isFail = true;
                                MdmSyncMaterialRspVO mdmSyncMaterialRspVO2 = new MdmSyncMaterialRspVO();
                                mdmSyncMaterialRspVO2.setErrorText("\u5728\u5206\u7c7b\u4fe1\u606f\u4e2d\u672a\u627e\u5230\u5bf9\u5e94\u5143\u5c5e\u6027");
                                mdmSyncMaterialRspVO2.setStatus(1);
                                mdmSyncMaterialRspVO2.setUuid(mdmSyncMaterialDataInfoVO.getUuid());
                                mdmSyncMaterialRspVOs.add(mdmSyncMaterialRspVO2);
                                break;
                            }
                            eMdmPropValues.add(eMdmPropValue);
                        }
                        if (!isFail) continue;
                        break;
                    }
                    if (!isFail) {
                        this.eMdmPropValueMapper.insertBatch(eMdmPropValues);
                        this.eMdmMaterialMapper.insert(eMdmMaterial);
                    }
                } else {
                    isFail = true;
                    mdmSyncMaterialRspVO = new MdmSyncMaterialRspVO();
                    mdmSyncMaterialRspVO.setErrorText("\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u5206\u7c7b\u4fe1\u606f");
                    mdmSyncMaterialRspVO.setStatus(1);
                    mdmSyncMaterialRspVO.setUuid(mdmSyncMaterialDataInfoVO.getUuid());
                    mdmSyncMaterialRspVOs.add(mdmSyncMaterialRspVO);
                    continue;
                }
                if (isFail) continue;
                mdmSyncMaterialRspVO = new MdmSyncMaterialRspVO();
                mdmSyncMaterialRspVO.setErrorText("");
                mdmSyncMaterialRspVO.setStatus(0);
                mdmSyncMaterialRspVO.setUuid(mdmSyncMaterialDataInfoVO.getUuid());
                mdmSyncMaterialRspVOs.add(mdmSyncMaterialRspVO);
            }
            if (isFail) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5931\u8d25");
                rspBO.setMdmSyncMaterialRspVOs(mdmSyncMaterialRspVOs);
            } else {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setMdmSyncMaterialRspVOs(mdmSyncMaterialRspVOs);
            }
        }
        catch (Exception e) {
            rspBO.setRespDesc("\u4e3b\u6570\u636e\u7269\u6599\u4fe1\u606f\u66f4\u65b0\u51fa\u9519");
            rspBO.setRespCode("8888");
            logger.error("\u4e3b\u6570\u636e\u7269\u6599\u4fe1\u606f\u66f4\u65b0\u51fa\u9519", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e3b\u6570\u636e\u7269\u6599\u6570\u636e\u4fe1\u606f\u540c\u6b65\u670d\u52a1\u51fa\u9519");
        }
        return rspBO;
    }

    public void setMdmCatalogMapper(MdmCatalogMapper mdmCatalogMapper) {
        this.mdmCatalogMapper = mdmCatalogMapper;
    }

    public void seteMdmMaterialMapper(EMdmMaterialMapper eMdmMaterialMapper) {
        this.eMdmMaterialMapper = eMdmMaterialMapper;
    }

    public void seteMdmPropValueMapper(EMdmPropValueMapper eMdmPropValueMapper) {
        this.eMdmPropValueMapper = eMdmPropValueMapper;
    }

    public void setMdmPropDefMapper(MdmPropDefMapper mdmPropDefMapper) {
        this.mdmPropDefMapper = mdmPropDefMapper;
    }

    public void setMdmMetadataMapper(MdmMetadataMapper mdmMetadataMapper) {
        this.mdmMetadataMapper = mdmMetadataMapper;
    }

    private MdmSyncMaterialReqBO replaceQuote(MdmSyncMaterialReqBO mdmSyncMaterialReqBO) {
        ArrayList<MdmSyncMaterialDataInfoVO> mdmSyncMaterialDataInfoVOs = new ArrayList<MdmSyncMaterialDataInfoVO>();
        for (MdmSyncMaterialDataInfoVO mdmSyncMaterialDataInfoVO : mdmSyncMaterialReqBO.getMdmSyncMaterialDataInfoVOs()) {
            if (null != mdmSyncMaterialDataInfoVO.getCatalogName()) {
                mdmSyncMaterialDataInfoVO.setCatalogName(mdmSyncMaterialDataInfoVO.getCatalogName().replace("33ff2e27c7cb2811", "\""));
            }
            if (null != mdmSyncMaterialDataInfoVO.getMaterialName()) {
                mdmSyncMaterialDataInfoVO.setMaterialName(mdmSyncMaterialDataInfoVO.getMaterialName().replace("33ff2e27c7cb2811", "\""));
            }
            if (null != mdmSyncMaterialDataInfoVO.getModel()) {
                mdmSyncMaterialDataInfoVO.setModel(mdmSyncMaterialDataInfoVO.getModel().replace("33ff2e27c7cb2811", "\""));
            }
            if (null != mdmSyncMaterialDataInfoVO.getSpec()) {
                mdmSyncMaterialDataInfoVO.setSpec(mdmSyncMaterialDataInfoVO.getSpec().replace("33ff2e27c7cb2811", "\""));
            }
            if (null != mdmSyncMaterialDataInfoVO.getTexture()) {
                mdmSyncMaterialDataInfoVO.setTexture(mdmSyncMaterialDataInfoVO.getTexture().replace("33ff2e27c7cb2811", "\""));
            }
            if (null != mdmSyncMaterialDataInfoVO.getFigure()) {
                mdmSyncMaterialDataInfoVO.setFigure(mdmSyncMaterialDataInfoVO.getFigure().replace("33ff2e27c7cb2811", "\""));
            }
            if (null != mdmSyncMaterialDataInfoVO.getMainModel()) {
                mdmSyncMaterialDataInfoVO.setMainModel(mdmSyncMaterialDataInfoVO.getMainModel().replace("33ff2e27c7cb2811", "\""));
            }
            if (null != mdmSyncMaterialDataInfoVO.getManufacturer()) {
                mdmSyncMaterialDataInfoVO.setManufacturer(mdmSyncMaterialDataInfoVO.getManufacturer().replace("33ff2e27c7cb2811", "\""));
            }
            if (null != mdmSyncMaterialDataInfoVO.getMeasure()) {
                mdmSyncMaterialDataInfoVO.setMeasure(mdmSyncMaterialDataInfoVO.getMeasure().replace("33ff2e27c7cb2811", "\""));
            }
            if (null != mdmSyncMaterialDataInfoVO.getLongDesc()) {
                mdmSyncMaterialDataInfoVO.setLongDesc(mdmSyncMaterialDataInfoVO.getLongDesc().replace("33ff2e27c7cb2811", "\""));
            }
            if (null != mdmSyncMaterialDataInfoVO.getShortDesc()) {
                mdmSyncMaterialDataInfoVO.setShortDesc(mdmSyncMaterialDataInfoVO.getShortDesc().replace("33ff2e27c7cb2811", "\""));
            }
            ArrayList<MdmSpecialityCodeParam> mdmSpecialityCodeParams = new ArrayList<MdmSpecialityCodeParam>();
            for (MdmSpecialityCodeParam mdmSpecialityCodeParam : mdmSyncMaterialDataInfoVO.getMdmSpecialityCodeParams()) {
                if (null != mdmSpecialityCodeParam.getPropName()) {
                    mdmSpecialityCodeParam.setPropName(mdmSpecialityCodeParam.getPropName().replace("33ff2e27c7cb2811", "\""));
                }
                ArrayList<MdmPropertyCodeParam> mdmPropertyCodeParams = new ArrayList<MdmPropertyCodeParam>();
                for (MdmPropertyCodeParam mdmPropertyCodeParam : mdmSpecialityCodeParam.getMdmPropertyCodeParams()) {
                    if (null != mdmPropertyCodeParam.getMetadataName()) {
                        mdmPropertyCodeParam.setMeatadataName(mdmPropertyCodeParam.getMetadataName().replace("33ff2e27c7cb2811", "\""));
                    }
                    if (null != mdmPropertyCodeParam.getPrefixValue()) {
                        mdmPropertyCodeParam.setPrefixValue(mdmPropertyCodeParam.getPrefixValue().replace("33ff2e27c7cb2811", "\""));
                    }
                    if (null != mdmPropertyCodeParam.getSuffixValue()) {
                        mdmPropertyCodeParam.setSuffixValue(mdmPropertyCodeParam.getSuffixValue().replace("33ff2e27c7cb2811", "\""));
                    }
                    if (null != mdmPropertyCodeParam.getBoundSymbol()) {
                        mdmPropertyCodeParam.setBoundSymbol(mdmPropertyCodeParam.getBoundSymbol().replace("33ff2e27c7cb2811", "\""));
                    }
                    if (null != mdmPropertyCodeParam.getUnitValue()) {
                        mdmPropertyCodeParam.setUnitValue(mdmPropertyCodeParam.getUnitValue().replace("33ff2e27c7cb2811", "\""));
                    }
                    if (null != mdmPropertyCodeParam.getPropValue()) {
                        mdmPropertyCodeParam.setPropValue(mdmPropertyCodeParam.getPropValue().replace("33ff2e27c7cb2811", "\""));
                    }
                    if (null != mdmPropertyCodeParam.getSymbolValue()) {
                        mdmPropertyCodeParam.setSymbolValue(mdmPropertyCodeParam.getSymbolValue().replace("33ff2e27c7cb2811", "\""));
                    }
                    if (null != mdmPropertyCodeParam.getPropLen()) {
                        mdmPropertyCodeParam.setPropLen(mdmPropertyCodeParam.getPropLen().replace("33ff2e27c7cb2811", "\""));
                    }
                    mdmPropertyCodeParams.add(mdmPropertyCodeParam);
                }
                mdmSpecialityCodeParam.setMdmPropertyCodeParams(mdmPropertyCodeParams);
                mdmSpecialityCodeParams.add(mdmSpecialityCodeParam);
            }
            mdmSyncMaterialDataInfoVO.setMdmSpecialityCodeParams(mdmSpecialityCodeParams);
            mdmSyncMaterialDataInfoVOs.add(mdmSyncMaterialDataInfoVO);
        }
        mdmSyncMaterialReqBO.setMdmSyncMaterialDataInfoVOs(mdmSyncMaterialDataInfoVOs);
        return mdmSyncMaterialReqBO;
    }

    private static List<MdmValidationResultVO> validateModel(Object obj) {
        LinkedList<MdmValidationResultVO> list = new LinkedList<MdmValidationResultVO>();
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        Set constraintViolations = validator.validate(obj, new Class[0]);
        Iterator iter = constraintViolations.iterator();
        while (iter.hasNext()) {
            MdmValidationResultVO vr = new MdmValidationResultVO();
            ConstraintViolation next = (ConstraintViolation)iter.next();
            String message = next.getMessage();
            Path propertyPath = next.getPropertyPath();
            vr.setPropertyName(propertyPath.toString());
            vr.setValidationMsg(message);
            list.add(vr);
        }
        return list;
    }
}

