/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.custom.search.impl;

import com.ohaotian.commodity.custom.search.SearchEsSQLService;
import com.ohaotian.commodity.custom.search.bo.QueryParamBO;
import com.ohaotian.commodity.custom.search.bo.SearchEsSQLReqBO;
import com.ohaotian.commodity.custom.search.bo.SearchEsSQLRspBO;
import com.ohaotian.commodity.custom.search.bo.SearchEsSQLXlsRspBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.LinkedList;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Qualifier
public class SearchEsSQLServiceImpl
implements SearchEsSQLService {
    private static final Logger logger = LoggerFactory.getLogger(SearchEsSQLServiceImpl.class);

    public SearchEsSQLRspBO buildSQL(SearchEsSQLReqBO searchEsSQLReqBO) {
        SearchEsSQLRspBO searchBarEsSQLRspBO = new SearchEsSQLRspBO();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (int)2));
        if (searchEsSQLReqBO.getSupplierId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (String)searchEsSQLReqBO.getSupplierId()));
        }
        if (searchEsSQLReqBO.getQueryLocation() != null && searchEsSQLReqBO.getQueryLocation() != 0) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_location", (Object)searchEsSQLReqBO.getQueryLocation()));
        }
        logger.error("searchEsSQLReqBO.getQueryStr()=========" + searchEsSQLReqBO.getQueryStr());
        if (searchEsSQLReqBO.getQueryStr() != null && !"".equals(searchEsSQLReqBO.getQueryStr())) {
            BoolQueryBuilder boolQueryBuilder1 = QueryBuilders.boolQuery();
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"sku_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"brand_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"supplier_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"l2_category_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"l3_category_id_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder.must((QueryBuilder)boolQueryBuilder1);
        }
        LinkedList<String> hiddenParamsForRsp = new LinkedList<String>();
        if (searchEsSQLReqBO.getQueryParams() != null) {
            for (int i = 0; i < searchEsSQLReqBO.getQueryParams().size(); ++i) {
                int j;
                QueryParamBO param = (QueryParamBO)searchEsSQLReqBO.getQueryParams().get(i);
                hiddenParamsForRsp.add(param.getFilterId());
                BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
                if ("supplier_id_name".equals(param.getFilterId())) {
                    for (j = 0; j < param.getFilterValues().size(); ++j) {
                        boolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id_name", (String)((String)param.getFilterValues().get(j)))));
                    }
                    continue;
                }
                if ("brand_id_name".equals(param.getFilterId())) {
                    for (j = 0; j < param.getFilterValues().size(); ++j) {
                        boolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"brand_id_name", (String)((String)param.getFilterValues().get(j)))));
                    }
                    continue;
                }
                if (!"l3_category_id_name".equals(param.getFilterId())) continue;
                for (j = 0; j < param.getFilterValues().size(); ++j) {
                    boolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_id_name", (String)((String)param.getFilterValues().get(j) + "*~~" + searchEsSQLReqBO.getQueryLocation()))));
                }
            }
        }
        if (searchEsSQLReqBO.getCategoryId() != null && searchEsSQLReqBO.getLevel() != null) {
            if (searchEsSQLReqBO.getLevel() == 1) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l1_category_id", (String)searchEsSQLReqBO.getCategoryId()));
            } else if (searchEsSQLReqBO.getLevel() == 2) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l2_category_id", (String)searchEsSQLReqBO.getCategoryId()));
            } else if (searchEsSQLReqBO.getLevel() == 3) {
                Integer queryLocation = searchEsSQLReqBO.getQueryLocation();
                queryLocation = queryLocation == null ? 0 : queryLocation;
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_id", (String)(searchEsSQLReqBO.getCategoryId() + "*~~" + queryLocation)));
            }
        }
        try {
            RangeQueryBuilder qb = null;
            if (null != searchEsSQLReqBO.getMinSalesPrice()) {
                qb = searchEsSQLReqBO.getMinSalesPrice().compareTo(BigDecimal.ZERO) != 0 ? QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.BigDecimal2Long((BigDecimal)searchEsSQLReqBO.getMinSalesPrice())) : QueryBuilders.rangeQuery((String)"sale_price").gte((Object)0);
            }
            if (null != searchEsSQLReqBO.getMaxSalesPrice() && searchEsSQLReqBO.getMaxSalesPrice().compareTo(BigDecimal.ZERO) != 0) {
                qb.lte((Object)MoneyUtils.BigDecimal2Long((BigDecimal)searchEsSQLReqBO.getMaxSalesPrice()));
            }
            if (qb != null) {
                boolQueryBuilder.must(qb);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6700\u4f4e\u9500\u552e\u4ef7\u683c\u6216\u6700\u9ad8\u9500\u552e\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        SortOrder orderType = SortOrder.DESC;
        if (searchEsSQLReqBO.getOrderType() != null && searchEsSQLReqBO.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        String sortField = "on_shelve_time";
        if (searchEsSQLReqBO.getOrderByColumn() != null) {
            if (searchEsSQLReqBO.getOrderByColumn() == 1) {
                sortField = "sold_number";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 2) {
                sortField = "on_shelve_time";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 3) {
                sortField = "sale_price";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 4) {
                sortField = "discount_rate";
            }
        }
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
        searchBarEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        searchBarEsSQLRspBO.setSortQuery(sortQuery);
        searchBarEsSQLRspBO.setHiddenParamsForRsp(hiddenParamsForRsp);
        searchBarEsSQLRspBO.setPageNo(searchEsSQLReqBO.getPageNo());
        searchBarEsSQLRspBO.setPageSize(searchEsSQLReqBO.getPageSize());
        return searchBarEsSQLRspBO;
    }

    public SearchEsSQLXlsRspBO buildSQLXls(SearchEsSQLReqBO searchEsSQLReqBO) {
        SearchEsSQLXlsRspBO searchEsSQLXlsRspBO = new SearchEsSQLXlsRspBO();
        CollapseBuilder collapseBuilder = new CollapseBuilder("commodity_id");
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (int)2));
        if (searchEsSQLReqBO.getSupplierId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (String)searchEsSQLReqBO.getSupplierId()));
        }
        if (searchEsSQLReqBO.getQueryLocation() != null && searchEsSQLReqBO.getQueryLocation() != 0) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_location", (Object)searchEsSQLReqBO.getQueryLocation()));
        }
        logger.error("searchEsSQLReqBO.getQueryStr()=========" + searchEsSQLReqBO.getQueryStr());
        if (searchEsSQLReqBO.getQueryStr() != null && !"".equals(searchEsSQLReqBO.getQueryStr())) {
            BoolQueryBuilder boolQueryBuilder1 = QueryBuilders.boolQuery();
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"sku_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"brand_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"supplier_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"l2_category_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"l3_category_id_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder.must((QueryBuilder)boolQueryBuilder1);
        }
        LinkedList<String> hiddenParamsForRsp = new LinkedList<String>();
        if (searchEsSQLReqBO.getQueryParams() != null) {
            for (int i = 0; i < searchEsSQLReqBO.getQueryParams().size(); ++i) {
                int j;
                QueryParamBO param = (QueryParamBO)searchEsSQLReqBO.getQueryParams().get(i);
                hiddenParamsForRsp.add(param.getFilterId());
                BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
                if ("supplier_id_name".equals(param.getFilterId())) {
                    for (j = 0; j < param.getFilterValues().size(); ++j) {
                        boolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id_name", (String)((String)param.getFilterValues().get(j)))));
                    }
                    continue;
                }
                if ("brand_id_name".equals(param.getFilterId())) {
                    for (j = 0; j < param.getFilterValues().size(); ++j) {
                        boolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"brand_id_name", (String)((String)param.getFilterValues().get(j)))));
                    }
                    continue;
                }
                if (!"l3_category_id_name".equals(param.getFilterId())) continue;
                for (j = 0; j < param.getFilterValues().size(); ++j) {
                    boolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_id_name", (String)((String)param.getFilterValues().get(j) + "*~~" + searchEsSQLReqBO.getQueryLocation()))));
                }
            }
        }
        if (searchEsSQLReqBO.getCategoryId() != null && searchEsSQLReqBO.getLevel() != null) {
            if (searchEsSQLReqBO.getLevel() == 1) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l1_category_id", (String)searchEsSQLReqBO.getCategoryId()));
            } else if (searchEsSQLReqBO.getLevel() == 2) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l2_category_id", (String)searchEsSQLReqBO.getCategoryId()));
            } else if (searchEsSQLReqBO.getLevel() == 3) {
                Integer queryLocation = searchEsSQLReqBO.getQueryLocation();
                queryLocation = queryLocation == null ? 0 : queryLocation;
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_id", (String)(searchEsSQLReqBO.getCategoryId() + "*~~" + queryLocation)));
            }
        }
        try {
            RangeQueryBuilder qb = null;
            if (null != searchEsSQLReqBO.getMinSalesPrice()) {
                qb = searchEsSQLReqBO.getMinSalesPrice().compareTo(BigDecimal.ZERO) != 0 ? QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.BigDecimal2Long((BigDecimal)searchEsSQLReqBO.getMinSalesPrice())) : QueryBuilders.rangeQuery((String)"sale_price").gte((Object)0);
            }
            if (null != searchEsSQLReqBO.getMaxSalesPrice() && searchEsSQLReqBO.getMaxSalesPrice().compareTo(BigDecimal.ZERO) != 0) {
                qb.lte((Object)MoneyUtils.BigDecimal2Long((BigDecimal)searchEsSQLReqBO.getMaxSalesPrice()));
            }
            if (qb != null) {
                boolQueryBuilder.must(qb);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6700\u4f4e\u9500\u552e\u4ef7\u683c\u6216\u6700\u9ad8\u9500\u552e\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        SortOrder orderType = SortOrder.DESC;
        if (searchEsSQLReqBO.getOrderType() != null && searchEsSQLReqBO.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        String sortField = "on_shelve_time";
        if (searchEsSQLReqBO.getOrderByColumn() != null) {
            if (searchEsSQLReqBO.getOrderByColumn() == 1) {
                sortField = "sold_number";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 2) {
                sortField = "on_shelve_time";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 3) {
                sortField = "sale_price";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 4) {
                sortField = "discount_rate";
            }
        }
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
        searchEsSQLXlsRspBO.setCollapseBuilder(collapseBuilder);
        searchEsSQLXlsRspBO.setBoolQueryBuilder(boolQueryBuilder);
        searchEsSQLXlsRspBO.setSortQuery(sortQuery);
        searchEsSQLXlsRspBO.setHiddenParamsForRsp(hiddenParamsForRsp);
        searchEsSQLXlsRspBO.setPageNo(searchEsSQLReqBO.getPageNo());
        searchEsSQLXlsRspBO.setPageSize(searchEsSQLReqBO.getPageSize());
        return searchEsSQLXlsRspBO;
    }
}

