/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.BatQrySkuService;
import com.cgd.commodity.busi.bo.BatQrySkuReqBO;
import com.cgd.commodity.busi.bo.BatQrySkuRspBO;
import com.cgd.commodity.busi.bo.SkuInfoRsp;
import com.cgd.commodity.busi.bo.SkuSpecRspBO;
import com.cgd.commodity.dao.CommodityMeasureMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.dao.SkuSpecMapper;
import com.cgd.commodity.po.CommodityMeasure;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuPrice;
import com.cgd.commodity.po.SkuSpec;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BatQrySkuServiceImpl
implements BatQrySkuService {
    private static final Logger logger = LoggerFactory.getLogger(BatQrySkuServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private SkuPriceMapper skuPriceMapper;
    @Autowired
    private SkuSpecMapper skuSpecMapper;
    @Autowired
    private CommodityMeasureMapper commodityMeasureMapper;
    private Properties prop;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public BatQrySkuRspBO batQrySku(BatQrySkuReqBO batQrySkuReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u4e2d\u5fc3\u6279\u91cf\u83b7\u53d6Sku\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + batQrySkuReqBO.toString());
        }
        if (null == batQrySkuReqBO.getSkuIds()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4e2d\u5fc3\u6279\u91cf\u83b7\u53d6Sku\u4e1a\u52a1\u670d\u52a1\u5355\u54c1IDS[skuIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == batQrySkuReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4e2d\u5fc3\u6279\u91cf\u83b7\u53d6Sku\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            HashMap<String, Object> skuIdsParam = new HashMap<String, Object>();
            List skuIds = batQrySkuReqBO.getSkuIds();
            skuIdsParam.put("skuIds", skuIds);
            skuIdsParam.put("supplierId", batQrySkuReqBO.getSupplierId());
            List<Sku> skuList = this.skuMapper.qrySkuBySkuIdsAndSupplierId(skuIdsParam);
            BatQrySkuRspBO batQrySkuRspBO = new BatQrySkuRspBO();
            if (batQrySkuReqBO.getUserId() != null) {
                batQrySkuRspBO.setIsLogin(Boolean.valueOf(true));
            } else {
                batQrySkuRspBO.setIsLogin(Boolean.valueOf(false));
            }
            ArrayList<SkuInfoRsp> results = new ArrayList<SkuInfoRsp>();
            List<SkuPrice> skuPriceList = this.skuPriceMapper.qryPriceBySkuIdsAndSupplierId(skuIdsParam);
            List<SkuSpec> skuSpecList = this.skuSpecMapper.qrySpecBySkuIdsAndSupplierId(skuIdsParam);
            ArrayList<Long> measureIds = new ArrayList<Long>();
            for (Sku value : skuList) {
                if (null == value.getMeasureId()) continue;
                measureIds.add(value.getMeasureId());
            }
            HashMap<Long, CommodityMeasure> commodityMeasureMap = new HashMap<Long, CommodityMeasure>();
            if (measureIds.size() > 0) {
                List<CommodityMeasure> commodityMeasures = this.commodityMeasureMapper.selectByMeasureIds(measureIds);
                for (CommodityMeasure commodityMeasure : commodityMeasures) {
                    commodityMeasureMap.put(commodityMeasure.getMeasureId(), commodityMeasure);
                }
            }
            if (skuList != null && skuList.size() > 0) {
                Long vendorId = Long.parseLong(this.prop.getProperty("VENDOR_ID"));
                for (Sku sku : skuList) {
                    SkuInfoRsp skuInfoRsp = new SkuInfoRsp();
                    BeanUtils.copyProperties((Object)skuInfoRsp, (Object)sku);
                    skuInfoRsp.setVendorId(vendorId);
                    if (null != sku.getMeasureId() && commodityMeasureMap.size() != 0) {
                        skuInfoRsp.setMeasureType(((CommodityMeasure)commodityMeasureMap.get(sku.getMeasureId())).getMeasureType());
                    }
                    if (skuPriceList != null && skuPriceList.size() > 0) {
                        for (SkuPrice skuPrice : skuPriceList) {
                            if (!sku.getSkuId().equals(skuPrice.getSkuId())) continue;
                            if (skuPrice.getMarketPrice() != null) {
                                skuInfoRsp.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)skuPrice.getMarketPrice()));
                            }
                            if (skuPrice.getAgreementPrice() != null) {
                                skuInfoRsp.setAgreementPrice(MoneyUtils.Long2BigDecimal((Long)skuPrice.getAgreementPrice()));
                            }
                            if (skuPrice.getMemberPrice() != null) {
                                skuInfoRsp.setMemberPrice(MoneyUtils.Long2BigDecimal((Long)skuPrice.getMemberPrice()));
                            }
                            if (skuPrice.getSalePrice() != null) {
                                skuInfoRsp.setSalePrice(MoneyUtils.Long2BigDecimal((Long)skuPrice.getSalePrice()));
                            }
                            if (skuPrice.getCurrencyType() == null) break;
                            skuInfoRsp.setCurrencyType(skuPrice.getCurrencyType());
                            break;
                        }
                    }
                    if (skuSpecList != null && skuSpecList.size() > 0) {
                        ArrayList<SkuSpecRspBO> skuSpec = new ArrayList<SkuSpecRspBO>();
                        for (SkuSpec spec : skuSpecList) {
                            if (!sku.getSkuId().equals(spec.getSkuId())) continue;
                            SkuSpecRspBO skuSpecRspBO = new SkuSpecRspBO();
                            skuSpecRspBO.setPropDefId(spec.getCommoditySpecId());
                            skuSpecRspBO.setPropGroupId(spec.getCommodityPropGrpId());
                            skuSpecRspBO.setPropName(spec.getPropName());
                            skuSpecRspBO.setPropShowName(spec.getPropShowName());
                            skuSpecRspBO.setPropValue(spec.getPropValue());
                            skuSpecRspBO.setPropValueId(spec.getPropValueListId());
                            skuSpecRspBO.setSkuSpecId(spec.getSkuSpecId());
                            skuSpec.add(skuSpecRspBO);
                        }
                        skuInfoRsp.setSkuSpec(skuSpec);
                    }
                    results.add(skuInfoRsp);
                }
                batQrySkuRspBO.setResults(results);
            }
            if (this.isDebugEnabled) {
                logger.debug("\u5546\u54c1\u4e2d\u5fc3\u6279\u91cf\u83b7\u53d6Sku\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2\uff1a" + batQrySkuRspBO.toString());
            }
            return batQrySkuRspBO;
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u4e2d\u5fc3\u6279\u91cf\u83b7\u53d6Sku\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u4e2d\u5fc3\u6279\u91cf\u83b7\u53d6Sku\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
    }

    public void setProp(Properties prop) {
        this.prop = prop;
    }
}

