/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryCanAddCommodityTypeService;
import com.cgd.commodity.busi.bo.BusiCommodityTypeRspBO;
import com.cgd.commodity.busi.bo.catalog.QryCatalogDetailReqBO;
import com.cgd.commodity.busi.impl.QryCommodityTypeServiceImpl;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.CommodityTypeMapper;
import com.cgd.commodity.po.CommodityGuideCatalog;
import com.cgd.commodity.po.CommodityTypePO;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class QryCanAddCommodityTypeServiceImpl
implements QryCanAddCommodityTypeService {
    private static final Logger logger = LoggerFactory.getLogger(QryCommodityTypeServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private CommodityTypeMapper commodityTypeMapper;
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;

    public RspPageBO<BusiCommodityTypeRspBO> qryCanAddCommodityType(QryCatalogDetailReqBO qryCatalogDetailReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u7c7b\u578b\u67e5\u8be2\u670d\u52a1\u5165\u53c2\uff1a" + qryCatalogDetailReqBO.toString());
        }
        RspPageBO rsp = new RspPageBO();
        try {
            Page page = new Page(qryCatalogDetailReqBO.getPageNo().intValue(), qryCatalogDetailReqBO.getPageSize().intValue());
            CommodityGuideCatalog commodityGuideCatalog = this.commodityGuideCatalogMapper.selectByPrimaryKey(qryCatalogDetailReqBO.getGuideCatalogId());
            int channelId = 0;
            if (commodityGuideCatalog == null) {
                rsp.setRemark("\u8be5\u7c7b\u76ee\u65e0\u5bf9\u5e94\u9891\u9053");
                return rsp;
            }
            channelId = commodityGuideCatalog.getChannelId();
            List<Object> comTypeInfoList = new ArrayList();
            comTypeInfoList = this.commodityTypeMapper.getList(channelId, qryCatalogDetailReqBO.getCommodityTypeName(), (Page<CommodityTypePO>)page);
            ArrayList<BusiCommodityTypeRspBO> comTypeInfoBOList = new ArrayList<BusiCommodityTypeRspBO>();
            for (int i = 0; i < comTypeInfoList.size(); ++i) {
                BusiCommodityTypeRspBO busiCommodityTypeRspBO = new BusiCommodityTypeRspBO();
                BeanUtils.copyProperties((Object)comTypeInfoList.get(i), (Object)busiCommodityTypeRspBO);
                comTypeInfoBOList.add(busiCommodityTypeRspBO);
            }
            rsp.setRows(comTypeInfoBOList);
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setTotal(page.getTotalPages());
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u7c7b\u578b\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u7c7b\u578b\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    public void setCommodityTypeMapper(CommodityTypeMapper commodityTypeMapper) {
        this.commodityTypeMapper = commodityTypeMapper;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }
}

