/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.SkuStatusChangeService;
import com.cgd.commodity.busi.bo.supply.SkuStatusChangeReqBO;
import com.cgd.commodity.busi.bo.supply.SkuStatusChangeRspBO;
import com.cgd.commodity.busi.vo.supply.SkuStatusChangeTaskVO;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.po.SupplierAgreement;
import com.cgd.workflow.bo.DoTaskCompleteBatchReqBO;
import com.cgd.workflow.bo.DoTaskCompleteBatchRspBO;
import com.cgd.workflow.bo.DoTaskCompleteReqBO;
import com.cgd.workflow.busin.service.DoTaskCompleteBatchBusinService;
import com.ohaotian.commodity.busi.bo.SkuApprTaskParamBO;
import com.ohaotian.commodity.dao.SkuChangeApprTaskMapper;
import com.ohaotian.commodity.dao.SkuOffShelveApprTaskMapper;
import com.ohaotian.commodity.dao.SkuOnShelveApprTaskMapper;
import com.ohaotian.commodity.dao.SkuRegainOnShelveApprTaskMapper;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SkuStatusChangeServiceImpl
implements SkuStatusChangeService {
    private static final Logger logger = LoggerFactory.getLogger(SkuStatusChangeServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private DoTaskCompleteBatchBusinService doTaskCompleteBatchBusinService;
    @Autowired
    private SupplierAgreementMapper supplierAgreementMapper;
    @Autowired
    private SkuOnShelveApprTaskMapper skuOnShelveApprTaskMapper;
    @Autowired
    private SkuOffShelveApprTaskMapper skuOffShelveApprTaskMapper;
    @Autowired
    private SkuChangeApprTaskMapper skuChangeApprTaskMapper;
    @Autowired
    private SkuRegainOnShelveApprTaskMapper skuRegainOnShelveApprTaskMapper;

    public SkuStatusChangeRspBO skuStatusChange(SkuStatusChangeReqBO skuStatusChangeReqBO) {
        if (this.isDebugEnabled) {
            logger.info("\u53d8\u66f4\u5546\u54c1\u72b6\u6001\u6d88\u8d39\u8005\u7ec4\u5408\u670d\u52a1\u5165\u53c2\uff1a" + skuStatusChangeReqBO.toString());
        }
        SkuStatusChangeRspBO rsp = new SkuStatusChangeRspBO();
        try {
            if (skuStatusChangeReqBO.getSkuStatusChangeTaskList() != null && skuStatusChangeReqBO.getSkuStatusChangeTaskList().size() > 0) {
                SupplierAgreement supplierAgreement = this.supplierAgreementMapper.selectById(skuStatusChangeReqBO.getAgreementId(), skuStatusChangeReqBO.getSupplierId());
                DoTaskCompleteBatchReqBO doTaskCompleteBatchReqBO = new DoTaskCompleteBatchReqBO();
                ArrayList<DoTaskCompleteReqBO> doTaskCompleteReqBOS = new ArrayList<DoTaskCompleteReqBO>();
                ArrayList<String> taskIdList = new ArrayList<String>();
                HashMap<Long, String> skuIdAndTaskIdMap = new HashMap<Long, String>();
                String seqFlowId = ((SkuStatusChangeTaskVO)skuStatusChangeReqBO.getSkuStatusChangeTaskList().get(0)).getSeqFlowId();
                String comment = ((SkuStatusChangeTaskVO)skuStatusChangeReqBO.getSkuStatusChangeTaskList().get(0)).getComment();
                String businessType = ((SkuStatusChangeTaskVO)skuStatusChangeReqBO.getSkuStatusChangeTaskList().get(0)).getBusinessType();
                for (Object skuStatusChangeTaskVO : skuStatusChangeReqBO.getSkuStatusChangeTaskList()) {
                    DoTaskCompleteReqBO doTaskCompleteReqBO = new DoTaskCompleteReqBO();
                    doTaskCompleteReqBO.setBusinessType(skuStatusChangeTaskVO.getBusinessType());
                    doTaskCompleteReqBO.setTaskId(skuStatusChangeTaskVO.getTaskId());
                    doTaskCompleteReqBO.setSeqFlowId(skuStatusChangeTaskVO.getSeqFlowId());
                    doTaskCompleteReqBO.setComment(skuStatusChangeTaskVO.getComment());
                    doTaskCompleteReqBO.setOperateName(skuStatusChangeTaskVO.getOperateName());
                    doTaskCompleteReqBO.setBusinessId(skuStatusChangeTaskVO.getSkuId());
                    doTaskCompleteReqBO.setUserId(skuStatusChangeReqBO.getUserId());
                    HashMap<String, Object> variable = new HashMap<String, Object>();
                    variable.put("userId", skuStatusChangeReqBO.getUserId());
                    variable.put("skuId", skuStatusChangeTaskVO.getSkuId());
                    variable.put("approveType", skuStatusChangeTaskVO.getBusinessType());
                    variable.put("supplierId", skuStatusChangeReqBO.getSupplierId());
                    variable.put("agreementId", skuStatusChangeReqBO.getAgreementId());
                    variable.put("agrLocation", supplierAgreement.getAgrLocation());
                    variable.put("userName", skuStatusChangeReqBO.getUserName());
                    doTaskCompleteReqBO.setVariable(variable);
                    doTaskCompleteReqBOS.add(doTaskCompleteReqBO);
                    taskIdList.add(skuStatusChangeTaskVO.getTaskId());
                    skuIdAndTaskIdMap.put(skuStatusChangeTaskVO.getSkuId(), skuStatusChangeTaskVO.getTaskId());
                }
                doTaskCompleteBatchReqBO.setDoTaskCompleteReqBOS(doTaskCompleteReqBOS);
                DoTaskCompleteBatchRspBO doTaskCompleteBatchRspBO = this.doTaskCompleteBatchBusinService.doTaskCompleteBatch(doTaskCompleteBatchReqBO);
                if (doTaskCompleteBatchRspBO != null) {
                    if (!doTaskCompleteBatchRspBO.getRespCode().equals("0000")) {
                        rsp.setSuccess(false);
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5de5\u4f5c\u6d41\u5b8c\u6210\u5ba1\u6279\u51fa\u9519");
                    }
                    if (doTaskCompleteBatchRspBO.getBusinessIds() != null && doTaskCompleteBatchRspBO.getBusinessIds().size() > 0) {
                        rsp.setSkuIdList(doTaskCompleteBatchRspBO.getBusinessIds());
                        for (Long skuId : doTaskCompleteBatchRspBO.getBusinessIds()) {
                            taskIdList.remove(skuIdAndTaskIdMap.get(skuId));
                        }
                        rsp.setSuccess(false);
                    } else {
                        rsp.setSuccess(true);
                    }
                    if (taskIdList.size() > 0) {
                        SkuApprTaskParamBO skuApprTaskParamBO = new SkuApprTaskParamBO();
                        if (seqFlowId.equals("1")) {
                            skuApprTaskParamBO.setTaskStatus(Byte.valueOf((byte)1));
                        } else {
                            skuApprTaskParamBO.setTaskStatus(Byte.valueOf((byte)2));
                        }
                        skuApprTaskParamBO.setApprovalComment(comment);
                        skuApprTaskParamBO.setOperId(skuStatusChangeReqBO.getUserId());
                        skuApprTaskParamBO.setOperName(skuStatusChangeReqBO.getUserName());
                        skuApprTaskParamBO.setUpdateLoginId(skuStatusChangeReqBO.getUserId());
                        skuApprTaskParamBO.setUpdateTime(new Date());
                        skuApprTaskParamBO.setTaskIdList(taskIdList);
                        if (businessType.equals("10")) {
                            this.skuOnShelveApprTaskMapper.updateByTaskIds(skuApprTaskParamBO);
                        } else if (businessType.equals("11")) {
                            this.skuOffShelveApprTaskMapper.updateByTaskIds(skuApprTaskParamBO);
                        } else if (businessType.equals("12")) {
                            this.skuRegainOnShelveApprTaskMapper.updateByTaskIds(skuApprTaskParamBO);
                        } else if (businessType.equals("13")) {
                            this.skuChangeApprTaskMapper.updateByTaskIds(skuApprTaskParamBO);
                        }
                    }
                } else {
                    rsp.setSuccess(true);
                }
            }
        }
        catch (Exception e) {
            rsp.setSuccess(false);
            logger.error("\u53d8\u66f4\u5546\u54c1\u72b6\u6001\u6d88\u8d39\u8005\u7ec4\u5408\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u53d8\u66f4\u5546\u54c1\u72b6\u6001\u6d88\u8d39\u8005\u7ec4\u5408\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    public void setDoTaskCompleteBatchBusinService(DoTaskCompleteBatchBusinService doTaskCompleteBatchBusinService) {
        this.doTaskCompleteBatchBusinService = doTaskCompleteBatchBusinService;
    }
}

