/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.sku.web.impl;

import com.ohaotian.commodity.atom.picture.InitSkuPictureAtomService;
import com.ohaotian.commodity.atom.picture.bo.PictureBO;
import com.ohaotian.commodity.atom.price.InitSkuPriceAtomService;
import com.ohaotian.commodity.atom.price.bo.PriceBO;
import com.ohaotian.commodity.atom.sku.InitSkuAtomService;
import com.ohaotian.commodity.atom.sku.bo.InitSkuRspBO;
import com.ohaotian.commodity.atom.sku.bo.SkuBO;
import com.ohaotian.commodity.atom.spec.InitSkuSpecAtomService;
import com.ohaotian.commodity.atom.spec.bo.SpecBO;
import com.ohaotian.commodity.atom.spu.InitSpuAtomService;
import com.ohaotian.commodity.atom.spu.bo.InitSpuRspBO;
import com.ohaotian.commodity.busi.sku.web.CreateSkuBusiService;
import com.ohaotian.commodity.busi.sku.web.bo.CreateSkuBusiReqBO;
import com.ohaotian.commodity.busi.sku.web.bo.CreateSkuBusiRspBO;
import com.ohaotian.commodity.intfce.handshow.ElectronicPricePushBusiService;
import com.ohaotian.commodity.intfce.handshow.bo.QuerySkuAndPriceReqBO;
import com.ohaotian.commodity.intfce.handshow.bo.QuerySkuAndPriceRspBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="createSkuBusiService")
@Qualifier
public class CreateSkuBusiServiceImpl
implements CreateSkuBusiService {
    private static final Logger logger = LoggerFactory.getLogger(CreateSkuBusiServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private InitSpuAtomService initSpuAtomService;
    @Autowired
    private InitSkuAtomService initSkuAtomService;
    @Autowired
    private InitSkuPriceAtomService initSkuPriceAtomService;
    @Autowired
    private InitSkuPictureAtomService initSkuPictureAtomService;
    @Autowired
    private InitSkuSpecAtomService initSkuSpecAtomService;
    @Autowired
    private ElectronicPricePushBusiService electronicPricePushBusiService;

    public CreateSkuBusiRspBO createSku(CreateSkuBusiReqBO createSkuBusiReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)createSkuBusiReqBO.toString());
        }
        CreateSkuBusiRspBO createSkuBusiRspBO = new CreateSkuBusiRspBO();
        try {
            final InitSpuRspBO initSpuRspBO = this.initSpuAtomService.initSpu(createSkuBusiReqBO.getSpu());
            SkuBO skuBO = createSkuBusiReqBO.getSku();
            skuBO.setCommodityId(initSpuRspBO.getCommodityId());
            final InitSkuRspBO initSkuRspBO = this.initSkuAtomService.initSku(skuBO);
            PriceBO priceBO = createSkuBusiReqBO.getPrice();
            logger.error("\u5546\u54c1\u4ef7\u683cbo---------" + priceBO.toString());
            priceBO.setSkuId(initSkuRspBO.getSkuId());
            this.initSkuPriceAtomService.initSkuPrice(priceBO);
            List pictureBOList = createSkuBusiReqBO.getSkuPicture();
            pictureBOList.forEach(new Consumer<PictureBO>(){

                @Override
                public void accept(PictureBO pictureBO) {
                    pictureBO.setCommodityId(initSpuRspBO.getCommodityId());
                    pictureBO.setSkuId(initSkuRspBO.getSkuId());
                }
            });
            this.initSkuPictureAtomService.initSkuPicture(pictureBOList);
            List specBOList = createSkuBusiReqBO.getSkuSpec();
            if (CollectionUtils.isNotEmpty((Collection)specBOList)) {
                specBOList.forEach(new Consumer<SpecBO>(){

                    @Override
                    public void accept(SpecBO specBO) {
                        specBO.setCommodityId(initSpuRspBO.getCommodityId());
                        specBO.setSkuId(initSkuRspBO.getSkuId());
                    }
                });
                this.initSkuSpecAtomService.initSkuSpec(specBOList);
            }
            try {
                QuerySkuAndPriceReqBO pushReq = new QuerySkuAndPriceReqBO();
                pushReq.setSkuId(initSkuRspBO.getSkuId());
                pushReq.setSupplierId(initSkuRspBO.getSupplierId());
                QuerySkuAndPriceRspBO pushRsp = this.electronicPricePushBusiService.puhSku(pushReq);
                if (null == pushRsp || !"0000".equals(pushRsp.getCode())) {
                    logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519" + pushRsp.getMessage());
                    createSkuBusiRspBO.setRespCode("0000");
                    createSkuBusiRspBO.setRespDesc("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519");
                    return createSkuBusiRspBO;
                }
            }
            catch (Exception e) {
                logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519" + e);
                createSkuBusiRspBO.setRespCode("0000");
                createSkuBusiRspBO.setRespDesc("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519");
                return createSkuBusiRspBO;
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25.");
        }
        createSkuBusiRspBO.setRespCode("0000");
        createSkuBusiRspBO.setRespDesc("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.");
        return createSkuBusiRspBO;
    }
}

