/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryRegainOnShelvesSkuLogService;
import com.cgd.commodity.busi.bo.supply.QryRegainOnShelvesSkuLogReqBO;
import com.cgd.commodity.busi.bo.supply.QryRegainOnShelvesSkuLogRspBO;
import com.cgd.commodity.dao.CatalogCommodityTypeMapper;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.SkuRecoveOnShelveLogMapper;
import com.cgd.commodity.po.CatalogCommodityType;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QryRegainOnShelvesSkuLogServiceImpl
implements QryRegainOnShelvesSkuLogService {
    private static final Logger logger = LoggerFactory.getLogger(QryRegainOnShelvesSkuLogServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuRecoveOnShelveLogMapper skuRecoveOnShelveLogMapper;
    @Autowired
    private CatalogCommodityTypeMapper catalogCommodityTypeMapper;
    @Autowired
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;

    public RspPageBO<QryRegainOnShelvesSkuLogRspBO> qryRegainOnShelvesSkuLog(QryRegainOnShelvesSkuLogReqBO qryRegainOnShelvesSkuLogReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u6062\u590d\u4e0a\u67b6\u5546\u54c1\u8bb0\u5f55\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryRegainOnShelvesSkuLogReqBO.toString());
        }
        RspPageBO rsp = new RspPageBO();
        try {
            int indexOf;
            String skuName = qryRegainOnShelvesSkuLogReqBO.getSkuName();
            if (skuName != null && !"".equals(skuName) && (indexOf = skuName.indexOf(92)) != -1) {
                String name = skuName.replaceAll("\\\\", "\\\\\\\\");
                qryRegainOnShelvesSkuLogReqBO.setSkuName(name);
            }
            LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
            if (null != qryRegainOnShelvesSkuLogReqBO.getGuideCatalogId()) {
                List<CatalogCommodityType> catalogs = this.catalogCommodityTypeMapper.selectByCatalogId(qryRegainOnShelvesSkuLogReqBO.getGuideCatalogId());
                for (CatalogCommodityType catalogCommodityType : catalogs) {
                    commodityTypeIds.add(catalogCommodityType.getCommodityTypeId());
                }
            }
            Page page = new Page(qryRegainOnShelvesSkuLogReqBO.getPageNo(), qryRegainOnShelvesSkuLogReqBO.getPageSize());
            List<Object> results = new ArrayList();
            results = this.skuRecoveOnShelveLogMapper.selectRegainOnShelvesSku((Page<QryRegainOnShelvesSkuLogReqBO>)page, qryRegainOnShelvesSkuLogReqBO, commodityTypeIds);
            if (!results.isEmpty()) {
                LinkedList<Long> commodityTypeIds1 = new LinkedList<Long>();
                LinkedList<Long> skuIds = new LinkedList<Long>();
                for (QryRegainOnShelvesSkuLogRspBO qryRegainOnShelvesSkuLogRspBO : results) {
                    commodityTypeIds1.add(qryRegainOnShelvesSkuLogRspBO.getCommodityTypeId());
                    skuIds.add(qryRegainOnShelvesSkuLogRspBO.getSkuId());
                }
                List<Map<String, Object>> catalogMaps = this.commodityGuideCatalogMapper.selectCatalogNameBatByTypeIdAndLocation(commodityTypeIds1);
                for (QryRegainOnShelvesSkuLogRspBO qryRegainOnShelvesSkuLogRspBO : results) {
                    if (catalogMaps.isEmpty()) continue;
                    for (Map<String, Object> map : catalogMaps) {
                        if (!map.get("commodityTypeId").equals(qryRegainOnShelvesSkuLogRspBO.getCommodityTypeId())) continue;
                        qryRegainOnShelvesSkuLogRspBO.setFirstCatalogName((String)map.get("firstCatalogName"));
                        qryRegainOnShelvesSkuLogRspBO.setSecondCatalogName((String)map.get("secondCatalogName"));
                        qryRegainOnShelvesSkuLogRspBO.setThirdCatalogName((String)map.get("thirdCatalogName"));
                    }
                    if (qryRegainOnShelvesSkuLogRspBO.getMarketPrice() == null) continue;
                    qryRegainOnShelvesSkuLogRspBO.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)qryRegainOnShelvesSkuLogRspBO.getMarketPrice().longValue()));
                }
            }
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setTotal(page.getTotalPages());
            rsp.setRows(results);
            return rsp;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6062\u590d\u4e0a\u67b6\u5546\u54c1\u8bb0\u5f55\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u6062\u590d\u4e0a\u67b6\u5546\u54c1\u8bb0\u5f55\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    public void setSkuRecoveOnShelveLogMapper(SkuRecoveOnShelveLogMapper skuRecoveOnShelveLogMapper) {
        this.skuRecoveOnShelveLogMapper = skuRecoveOnShelveLogMapper;
    }

    public void setCatalogCommodityTypeMapper(CatalogCommodityTypeMapper catalogCommodityTypeMapper) {
        this.catalogCommodityTypeMapper = catalogCommodityTypeMapper;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }
}

