/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.commodity.atom.QryTokenAtomService;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.EEcommerceTokenMapper;
import com.cgd.commodity.po.EEcommerceToken;
import com.cgd.commodity.util.HttpUtils;
import com.cgd.commodity.util.MD5Util;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Deprecated
public class QryTokenAtomServiceImpl
implements QryTokenAtomService {
    private static final Logger logger = LoggerFactory.getLogger(QryTokenAtomServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private Properties prop;
    @Autowired
    private EEcommerceTokenMapper eEcommerceTokenMapper;

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    @Override
    public String qryToken() {
        String clientID = this.prop.getProperty("JD_TOKEN_CLIENTID");
        String clientSecret = this.prop.getProperty("JD_TOKEN_CLIENTSECRET");
        String userName = this.prop.getProperty("JD_TOKEN_USERNAME");
        String password = this.prop.getProperty("JD_TOKEN_PASSWORD");
        String tokenStr = null;
        try {
            JSONObject msgJson = JSONObject.parseObject((String)this.reqToken(clientSecret, clientID, userName, password));
            JSONObject resultJSON = msgJson.getJSONObject("result");
            tokenStr = resultJSON.getString("access_token");
            Integer expiresInStr = Integer.parseInt(resultJSON.getString("expires_in"));
            String refreshTokenStr = resultJSON.getString("refresh_token");
            String refreshTokenExpiresStr = resultJSON.getString("refresh_token_expires");
            EEcommerceToken tokenTable = this.getLocalToken(Constant.JDSupplierId);
            if (tokenTable == null) {
                tokenTable = new EEcommerceToken();
                tokenTable.setAccessToken(tokenStr);
                tokenTable.setExpiresIn(expiresInStr);
                tokenTable.setRefreshToken(refreshTokenStr);
                tokenTable.setRefreshTokenExpires(refreshTokenExpiresStr);
                tokenTable.setIsDelete(false);
                tokenTable.setSupplierId(Constant.JDSupplierId);
                this.eEcommerceTokenMapper.insert(tokenTable);
            } else {
                tokenTable.setAccessToken(tokenStr);
                this.eEcommerceTokenMapper.updateByPrimaryKeySelective(tokenTable);
            }
        }
        catch (IOException e) {
            if (this.isDebugEnabled) {
                logger.debug("\u83b7\u53d6Token\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            }
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u83b7\u53d6Token\u4e1a\u52a1\u670d\u52a1\u51fa\u9519-\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
        }
        return tokenStr;
    }

    public String reqToken(String clientSecret, String clientID, String userName, String password) throws IOException {
        String urlPath = this.prop.getProperty("JD_TOKEN_QRY_URL");
        String userNameUTF8 = userName;
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(userName);
        if (m.find()) {
            userNameUTF8 = URLEncoder.encode(userName, "utf-8");
        }
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowFormated = formatter.format(now);
        String passwordMD5 = MD5Util.getMD5Str(password).toLowerCase();
        String strForEncodeSign = clientSecret + "" + nowFormated + "" + clientID + "" + userName + "" + passwordMD5 + "access_token" + clientSecret;
        String signMD5 = MD5Util.getMD5Str(strForEncodeSign).toUpperCase();
        String param = "grant_type=access_token&client_id=" + clientID + "&scope=&username=" + userNameUTF8 + "&password=" + passwordMD5 + "&timestamp=" + nowFormated + "&sign=" + signMD5;
        String resStr = HttpUtils.getResByPOST(urlPath, param);
        return resStr;
    }

    public void main(String[] args) throws IOException {
        System.out.println(this.reqToken("mVkZQwEqfVltXusJfBdr", "PZjy68gK2eU2m6aoRSVM", "\u56fd\u7535\u7269\u6d41\u6709\u9650\u516c\u53f8\u6d4b\u8bd5", "gd1234"));
    }

    @Override
    public EEcommerceToken getLocalToken(Long supplierId) {
        EEcommerceToken token = this.eEcommerceTokenMapper.selectTokenBySupplierId(supplierId);
        if (token == null) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u83b7\u53d6Token\u4e1a\u52a1\u670d\u52a1\u51fa\u9519-\u672c\u5730\u6570\u636e\u5e93\u6ca1\u6709\u6570\u636e");
        }
        return token;
    }

    @Override
    public String getLocalTokenStr(Long supplierId) {
        String accessToken = this.getLocalToken(supplierId).getAccessToken();
        return accessToken;
    }
}

