/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryOnShelvesAndRejectRecService;
import com.cgd.commodity.busi.bo.QryOnShelvesAndRejectRecReqBO;
import com.cgd.commodity.busi.bo.QryOnShelvesAndRejectRecRspBO;
import com.cgd.commodity.dao.SkuApproveDetailLogMapper;
import com.cgd.commodity.dao.SkuApproveLogMapper;
import com.cgd.commodity.po.SkuApproveDetailLog;
import com.cgd.commodity.po.SkuApproveLog;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QryOnShelvesAndRejectRecServiceImpl
implements QryOnShelvesAndRejectRecService {
    private static final Logger logger = LoggerFactory.getLogger(QryOnShelvesAndRejectRecServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuApproveLogMapper skuApproveLogMapper;
    private SkuApproveDetailLogMapper skuApproveDetailLogMapper;

    public void setSkuApproveDetailLogMapper(SkuApproveDetailLogMapper skuApproveDetailLogMapper) {
        this.skuApproveDetailLogMapper = skuApproveDetailLogMapper;
    }

    public void setSkuApproveLogMapper(SkuApproveLogMapper skuApproveLogMapper) {
        this.skuApproveLogMapper = skuApproveLogMapper;
    }

    public RspPageBO<QryOnShelvesAndRejectRecRspBO> qryOnShelvesAndRejectRec(QryOnShelvesAndRejectRecReqBO qryOnShelvesAndRejectRecReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryOnShelvesAndRejectRecReqBO.toString());
        }
        try {
            if (!StringUtils.isEmpty((Object)qryOnShelvesAndRejectRecReqBO.getOperator())) {
                qryOnShelvesAndRejectRecReqBO.setOperator(qryOnShelvesAndRejectRecReqBO.getOperator().replaceAll(" ", ""));
            }
            Page page = new Page(qryOnShelvesAndRejectRecReqBO.getPageNo(), qryOnShelvesAndRejectRecReqBO.getPageSize());
            List<SkuApproveLog> approveLogs = null;
            if (null != qryOnShelvesAndRejectRecReqBO.getSkuId()) {
                List<SkuApproveDetailLog> approveDetailLogs = this.skuApproveDetailLogMapper.selectBySkuId(qryOnShelvesAndRejectRecReqBO.getSkuId());
                if (!approveDetailLogs.isEmpty()) {
                    LinkedList<Long> approveIds = new LinkedList<Long>();
                    for (SkuApproveDetailLog skuApproveDetailLog : approveDetailLogs) {
                        approveIds.add(skuApproveDetailLog.getApproveId());
                    }
                    approveLogs = this.skuApproveLogMapper.selectByOperator((Page<SkuApproveLog>)page, approveIds, qryOnShelvesAndRejectRecReqBO);
                }
            } else {
                approveLogs = this.skuApproveLogMapper.selectByOperator((Page<SkuApproveLog>)page, null, qryOnShelvesAndRejectRecReqBO);
            }
            List<QryOnShelvesAndRejectRecRspBO> qrySkuRejectRspBOs = this.resolveRsp(approveLogs, qryOnShelvesAndRejectRecReqBO);
            RspPageBO rspPageBO = new RspPageBO();
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setTotal(page.getTotalPages());
            rspPageBO.setPageNo(qryOnShelvesAndRejectRecReqBO.getPageNo());
            rspPageBO.setRows(qrySkuRejectRspBOs);
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<QryOnShelvesAndRejectRecRspBO> resolveRsp(List<SkuApproveLog> approveLogs, QryOnShelvesAndRejectRecReqBO qryOnShelvesAndRejectRecReqBO) {
        try {
            if (!approveLogs.isEmpty()) {
                ArrayList<QryOnShelvesAndRejectRecRspBO> qrySkuOnShelvesAndRejectRecRspBOs = new ArrayList<QryOnShelvesAndRejectRecRspBO>();
                for (SkuApproveLog skuApproveLog : approveLogs) {
                    QryOnShelvesAndRejectRecRspBO qrySkuOnShelvesAndRejectRecRspBO = new QryOnShelvesAndRejectRecRspBO();
                    qrySkuOnShelvesAndRejectRecRspBO.setApproveId(skuApproveLog.getApproveId());
                    qrySkuOnShelvesAndRejectRecRspBO.setApproveTime(skuApproveLog.getApproveTime());
                    qrySkuOnShelvesAndRejectRecRspBO.setApproveType(Integer.valueOf(skuApproveLog.getApproveType()));
                    qrySkuOnShelvesAndRejectRecRspBO.setOperatorId(skuApproveLog.getCreateLoginId());
                    qrySkuOnShelvesAndRejectRecRspBO.setOperatorName(skuApproveLog.getApprover());
                    if (null != qryOnShelvesAndRejectRecReqBO.getSkuId()) {
                        Integer skuNum = this.getSkuNum(skuApproveLog.getApproveId(), qryOnShelvesAndRejectRecReqBO.getSkuId());
                        qrySkuOnShelvesAndRejectRecRspBO.setSkuNumber(skuNum);
                    } else {
                        qrySkuOnShelvesAndRejectRecRspBO.setSkuNumber(skuApproveLog.getSkuNumber());
                    }
                    qrySkuOnShelvesAndRejectRecRspBOs.add(qrySkuOnShelvesAndRejectRecRspBO);
                }
                return qrySkuOnShelvesAndRejectRecRspBOs;
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5c01\u88c5\u54cd\u5e94\u6570\u636e\u5931\u8d25\uff1a" + e);
            return null;
        }
    }

    private Integer getSkuNum(Long approveId, Long skuId) {
        try {
            List<SkuApproveDetailLog> skuApproveDetailLogs = this.skuApproveDetailLogMapper.selectByApproveSkuId(approveId, skuId);
            if (!skuApproveDetailLogs.isEmpty()) {
                return skuApproveDetailLogs.size();
            }
            return 0;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u83b7\u53d6sku\u6570\u91cf\u5931\u8d25\uff1a" + e);
            return 0;
        }
    }
}

