/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.custom.search.impl;

import com.ohaotian.commodity.busi.bo.SearchBarEsRspInfo;
import com.ohaotian.commodity.custom.search.SearchEsResultService;
import com.ohaotian.commodity.custom.search.bo.SearchEsQueryRspBO;
import com.ohaotian.commodity.custom.search.bo.SearchEsResultRspBO;
import com.ohaotian.commodity.custom.search.bo.SearchEsRspInfoBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import java.util.ArrayList;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Qualifier
public class SearchEsResultServiceImpl
implements SearchEsResultService {
    private static final Logger logger = LoggerFactory.getLogger(SearchEsResultServiceImpl.class);

    public SearchEsResultRspBO searchResult(SearchEsQueryRspBO searchEsQueryRspBO) {
        SearchEsResultRspBO bo = new SearchEsResultRspBO();
        ArrayList<SearchEsRspInfoBO> rspInfos = new ArrayList<SearchEsRspInfoBO>();
        SearchBarEsRspInfo rspInfo = new SearchBarEsRspInfo();
        SearchResponse searchResponse = searchEsQueryRspBO.getSearchResponse();
        for (SearchHit hit : searchResponse.getHits()) {
            System.out.println("----skuid=" + hit.getSource().get("sku_id"));
            rspInfo = new SearchBarEsRspInfo();
            rspInfo.setSkuId(String.valueOf(hit.getSource().get("sku_id")));
            rspInfo.setExtSkuId(String.valueOf(hit.getSource().get("ext_sku_id")));
            if (null != hit.getSource().get("commodity_id")) {
                rspInfo.setCommodityId((Long)hit.getSource().get("commodity_id"));
            }
            if (null != hit.getSource().get("picture_url")) {
                rspInfo.setPriPicUrl(String.valueOf(hit.getSource().get("picture_url")));
            }
            if (null != hit.getSource().get("sale_area")) {
                rspInfo.setSaleArea(String.valueOf(hit.getSource().get("sale_area")));
            }
            if (null != hit.getSource().get("sku_long_name")) {
                rspInfo.setSkuName(String.valueOf(hit.getSource().get("sku_long_name")));
            }
            if (null != hit.getSource().get("sku_location")) {
                rspInfo.setSkuLocation(String.valueOf(hit.getSource().get("sku_location")));
            }
            rspInfo.setSupplierId(Long.valueOf(Long.parseLong(String.valueOf(hit.getSource().get("supplier_id")))));
            if (null != hit.getSource().get("supplier_name")) {
                rspInfo.setSupplierName(String.valueOf(hit.getSource().get("supplier_name")));
            }
            try {
                if (hit.getSource().get("market_price") != null) {
                    rspInfo.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(hit.getSource().get("market_price")))));
                }
                if (hit.getSource().get("sale_price") != null) {
                    rspInfo.setSalePrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(hit.getSource().get("sale_price")))));
                }
                if (hit.getSource().get("member_price") != null) {
                    rspInfo.setMemberPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(hit.getSource().get("member_price")))));
                }
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            }
            SearchEsRspInfoBO SearchBarEsRspInfoVO = new SearchEsRspInfoBO();
            BeanUtils.copyProperties((Object)rspInfo, (Object)SearchBarEsRspInfoVO);
            rspInfos.add(SearchBarEsRspInfoVO);
        }
        bo.setTotalCount(Long.valueOf(searchResponse.getHits().getTotalHits()));
        bo.setResult(rspInfos);
        return bo;
    }

    public SearchEsResultRspBO searchResultXls(SearchEsQueryRspBO searchEsQueryRspBO) {
        SearchEsResultRspBO bo = new SearchEsResultRspBO();
        ArrayList<SearchEsRspInfoBO> rspInfos = new ArrayList<SearchEsRspInfoBO>();
        SearchBarEsRspInfo rspInfo = new SearchBarEsRspInfo();
        SearchResponse searchResponse = searchEsQueryRspBO.getSearchResponse();
        ArrayList<Long> commodityIds = new ArrayList<Long>();
        for (SearchHit hit : searchResponse.getHits()) {
            commodityIds.add(Long.parseLong(String.valueOf(hit.getSource().get("commodity_id"))));
            SearchHit sh = ((SearchHits)hit.getInnerHits().get("bottom_price_sku")).getHits()[0];
            rspInfo = new SearchBarEsRspInfo();
            rspInfo.setCommodityId(Long.valueOf(Long.parseLong(String.valueOf(sh.getSource().get("commodity_id")))));
            rspInfo.setSkuId(String.valueOf(sh.getSource().get("sku_id")));
            rspInfo.setExtSkuId(String.valueOf(sh.getSource().get("ext_sku_id")));
            if (null != sh.getSource().get("picture_url")) {
                rspInfo.setPriPicUrl(String.valueOf(sh.getSource().get("picture_url")));
            }
            if (null != sh.getSource().get("sale_area")) {
                rspInfo.setSaleArea(String.valueOf(sh.getSource().get("sale_area")));
            }
            if (null != sh.getSource().get("sku_long_name")) {
                rspInfo.setSkuName(String.valueOf(sh.getSource().get("sku_long_name")));
            }
            if (null != sh.getSource().get("sku_location")) {
                rspInfo.setSkuLocation(String.valueOf(sh.getSource().get("sku_location")));
            }
            rspInfo.setSupplierId(Long.valueOf(Long.parseLong(String.valueOf(sh.getSource().get("supplier_id")))));
            if (null != sh.getSource().get("supplier_name")) {
                rspInfo.setSupplierName(String.valueOf(sh.getSource().get("supplier_name")));
            }
            try {
                if (sh.getSource().get("market_price") != null) {
                    rspInfo.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(sh.getSource().get("market_price")))));
                }
                if (sh.getSource().get("sale_price") != null) {
                    rspInfo.setSalePrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(sh.getSource().get("sale_price")))));
                }
                if (sh.getSource().get("member_price") != null) {
                    rspInfo.setMemberPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(sh.getSource().get("member_price")))));
                }
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            }
            SearchEsRspInfoBO SearchBarEsRspInfoVO = new SearchEsRspInfoBO();
            BeanUtils.copyProperties((Object)rspInfo, (Object)SearchBarEsRspInfoVO);
            rspInfos.add(SearchBarEsRspInfoVO);
        }
        bo.setCommodityIds(commodityIds);
        bo.setTotalCount(Long.valueOf(searchResponse.getHits().getTotalHits()));
        bo.setResult(rspInfos);
        return bo;
    }
}

