/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.commodity.busi.BusiAttributeChangeService;
import com.cgd.commodity.busi.bo.AttributeExtPropChangeVO;
import com.cgd.commodity.busi.bo.BusiAttributeChangeReqBO;
import com.cgd.commodity.busi.bo.BusiAttributeChangeRspBO;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.ExtCommodityPropDefMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuSpecMapper;
import com.cgd.commodity.intfce.bo.SkuSyncExceptionLogBO;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuSpec;
import com.cgd.commodity.po.SkuSyncExceptionLog;
import com.ohaotian.commodity.config.TopicConfig;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BusiAttributeChangeServiceImpl
implements BusiAttributeChangeService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAttributeChangeServiceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private SkuSpecMapper skuSpecMapper;
    private ExtCommodityPropDefMapper extCommodityPropDefMapper;
    @Resource
    private TopicConfig topicConfig;
    @Resource(name="skuSyncExceptionLogInstProducer")
    private ProxyMessageProducer producer;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setSkuSpecMapper(SkuSpecMapper skuSpecMapper) {
        this.skuSpecMapper = skuSpecMapper;
    }

    public void setExtCommodityPropDefMapper(ExtCommodityPropDefMapper extCommodityPropDefMapper) {
        this.extCommodityPropDefMapper = extCommodityPropDefMapper;
    }

    public BusiAttributeChangeRspBO updateAttributeChange(BusiAttributeChangeReqBO busiAttributeChangeReqBO) {
        if (isDebugEnabled) {
            logger.debug("\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiAttributeChangeReqBO.toString());
        }
        if (null == busiAttributeChangeReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5fc5\u586b\u53c2\u6570[supplierId]\u4e3a\u7a7a");
        }
        if (null == busiAttributeChangeReqBO.getExtSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5fc5\u586b\u53c2\u6570[extSkuId]\u4e3a\u7a7a");
        }
        try {
            Sku oldSku = this.skuMapper.selectByExtSkuIdAndSupplierId(busiAttributeChangeReqBO.getExtSkuId(), busiAttributeChangeReqBO.getSupplierId());
            if (null != oldSku) {
                this.updateSku(busiAttributeChangeReqBO, oldSku);
                this.updateSkuSpec(busiAttributeChangeReqBO, oldSku);
                BusiAttributeChangeRspBO busiAttributeChangeRspBO = new BusiAttributeChangeRspBO();
                busiAttributeChangeRspBO.setIsSuccess(Boolean.valueOf(true));
                return busiAttributeChangeRspBO;
            }
            if (isDebugEnabled) {
                logger.debug("\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u6839\u636eSKUID\u67e5\u8be2SKU\u4e0d\u5b58\u5728");
            }
            throw new BusinessException("RSP_CODE_SKU_NOT_EXIST", "\u6839\u636eSKUID\u67e5\u8be2SKU\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, "\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1" + e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private void updateSku(BusiAttributeChangeReqBO busiAttributeChangeReqBO, Sku oldSku) {
        try {
            Sku sku = new Sku();
            sku.setSkuId(oldSku.getSkuId());
            sku.setSupplierId(oldSku.getSupplierId());
            Boolean updateFlag = false;
            if (!StringUtils.isEmpty((Object)oldSku.getSkuName()) && !oldSku.getSkuName().equals(busiAttributeChangeReqBO.getSkuName())) {
                sku.setSkuName(busiAttributeChangeReqBO.getSkuName());
                updateFlag = true;
            }
            if (!StringUtils.isEmpty((Object)oldSku.getSkuMainPicUrl()) && !oldSku.getSkuMainPicUrl().equals(busiAttributeChangeReqBO.getSkuMainPicUrl())) {
                sku.setSkuMainPicUrl(busiAttributeChangeReqBO.getSkuMainPicUrl());
                updateFlag = true;
            }
            if (!StringUtils.isEmpty((Object)oldSku.getSkuDetail()) && !oldSku.getSkuDetail().equals(busiAttributeChangeReqBO.getSkuDetail())) {
                sku.setSkuDetail(busiAttributeChangeReqBO.getSkuDetail());
                updateFlag = true;
            }
            if (!StringUtils.isEmpty((Object)oldSku.getPackParam()) && !oldSku.getPackParam().equals(busiAttributeChangeReqBO.getPackParam())) {
                sku.setPackParam(busiAttributeChangeReqBO.getPackParam());
                updateFlag = true;
            }
            if (!StringUtils.isEmpty((Object)oldSku.getSkuDetailUrl()) && !oldSku.getSkuDetailUrl().equals(busiAttributeChangeReqBO.getSkuDetailUrl())) {
                sku.setSkuDetailUrl(busiAttributeChangeReqBO.getSkuDetailUrl());
                updateFlag = true;
            }
            if (!StringUtils.isEmpty((Object)oldSku.getStoreNumber()) && !oldSku.getStoreNumber().equals(busiAttributeChangeReqBO.getStoreNumber())) {
                sku.setStoreNumber(MoneyUtils.BigDecimal2Long((BigDecimal)busiAttributeChangeReqBO.getStoreNumber()));
                updateFlag = true;
            }
            if (!StringUtils.isEmpty((Object)oldSku.getBrandName()) && !oldSku.getBrandName().equals(busiAttributeChangeReqBO.getBrandName())) {
                sku.setBrandName(busiAttributeChangeReqBO.getBrandName());
                updateFlag = true;
            }
            if (!StringUtils.isEmpty((Object)oldSku.getMoq()) && !oldSku.getMoq().equals(busiAttributeChangeReqBO.getMoq())) {
                sku.setMoq(busiAttributeChangeReqBO.getMoq());
                updateFlag = true;
            }
            if (!StringUtils.isEmpty((Object)oldSku.getPreDeliverDay()) && !oldSku.getPreDeliverDay().equals(busiAttributeChangeReqBO.getPreDeliverDay())) {
                sku.setPreDeliverDay(busiAttributeChangeReqBO.getPreDeliverDay());
                updateFlag = true;
            }
            if (updateFlag.booleanValue()) {
                sku.setUpdateTime(new Date());
                this.skuMapper.updateByPrimaryKeySelective(sku, oldSku.getSupplierId());
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u4fe1\u606f\u5931\u8d25:" + e);
            throw new BusinessException(null, "\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void updateSkuSpec(BusiAttributeChangeReqBO busiAttributeChangeReqBO, Sku oldSku) {
        try {
            List<SkuSpec> oldSkuSpecs = this.skuSpecMapper.selectBySkuIdAndSupplierId(oldSku.getSkuId(), oldSku.getCommodityId(), oldSku.getSupplierId());
            if (null != busiAttributeChangeReqBO.getAttributeExtPropChanges() && null != oldSkuSpecs && !busiAttributeChangeReqBO.getAttributeExtPropChanges().isEmpty() && !oldSkuSpecs.isEmpty()) {
                ArrayList<SkuSpec> newSkuSpecs = new ArrayList<SkuSpec>();
                for (SkuSpec skuSpec : oldSkuSpecs) {
                    String extPropName = this.qryExtAttributeName(skuSpec.getCommoditySpecId(), skuSpec.getSupplierId());
                    String extPropValue = null;
                    if (!StringUtils.isEmpty((Object)extPropName)) {
                        for (AttributeExtPropChangeVO attributeExtPropChangeVO : busiAttributeChangeReqBO.getAttributeExtPropChanges()) {
                            if (!attributeExtPropChangeVO.getExtPropName().equals(extPropName)) continue;
                            extPropValue = attributeExtPropChangeVO.getExtPropValue();
                            break;
                        }
                        if (null == extPropValue || extPropValue.equals(skuSpec.getPropValue())) continue;
                        SkuSpec newSkuSpec = new SkuSpec();
                        newSkuSpec.setPropValue(extPropValue);
                        newSkuSpec.setSkuSpecId(skuSpec.getSkuSpecId());
                        newSkuSpec.setSupplierId(skuSpec.getSupplierId());
                        newSkuSpec.setSkuId(skuSpec.getSkuId());
                        newSkuSpec.setUpdateTime(new Date());
                        newSkuSpecs.add(newSkuSpec);
                        continue;
                    }
                    logger.info("\u5546\u54c1\u5c5e\u6027\u5bf9\u5e94\u5173\u7cfb\u4e0d\u5b58\u5728,\u5c5e\u6027ID\u4e3a[" + skuSpec.getCommoditySpecId() + "]");
                    String errorMsg = "\u5546\u54c1\u5c5e\u6027\u5bf9\u5e94\u5173\u7cfb\u4e0d\u5b58\u5728,\u5c5e\u6027ID\u4e3a[" + skuSpec.getCommoditySpecId() + "]";
                    this.sendMsgForSkuSyncExceptionLog(oldSku, errorMsg);
                }
                if (!newSkuSpecs.isEmpty()) {
                    this.skuSpecMapper.batchUpdate(newSkuSpecs);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5355\u54c1\u89c4\u683c\u53d8\u66f4\u5931\u8d25:" + e);
            throw new BusinessException(null, "\u5355\u54c1\u89c4\u683c\u53d8\u66f4\u5931\u8d25");
        }
    }

    private String qryExtAttributeName(Long commodityDefId, Long supplierId) {
        return this.extCommodityPropDefMapper.selectByCommodityDefId(commodityDefId, supplierId);
    }

    private void sendMsgForSkuSyncExceptionLog(Sku sku, String errorMsg) {
        SkuSyncExceptionLogBO skuSyncExceptionLogBO = new SkuSyncExceptionLogBO();
        try {
            SkuSyncExceptionLog skuSyncExceptionLog = new SkuSyncExceptionLog();
            skuSyncExceptionLog.setExtSkuId(sku.getExtSkuId());
            skuSyncExceptionLog.setSkuName(sku.getSkuName());
            skuSyncExceptionLog.setSkuLocation(sku.getSkuLocation());
            skuSyncExceptionLog.setSupplierId(sku.getSupplierId());
            skuSyncExceptionLog.setSkuCatalog(String.valueOf(sku.getCommodityTypeId()));
            skuSyncExceptionLog.setCreateTime(new Date());
            skuSyncExceptionLog.setIsDelete(Constant.IS_DELETE);
            skuSyncExceptionLog.setErrorMsg(errorMsg);
            BeanUtils.copyProperties((Object)skuSyncExceptionLogBO, (Object)skuSyncExceptionLog);
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u5931\u8d25");
        }
        try {
            this.producer.sendOneway(new ProxyMessage(this.topicConfig.getSkuSyncInsertTopicName(), this.topicConfig.getSkuSyncInsertTagName(), JSONObject.toJSONString((Object)skuSyncExceptionLogBO)));
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u6d88\u606f\u5931\u8d25" + e);
            throw new BusinessException(null, "\u53d1\u9001\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u6d88\u606f\u5931\u8d25");
        }
    }
}

