/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cgd.commodity.busi.BusiCreateExamineService;
import com.cgd.commodity.busi.bo.BusiCreateExamineReqBO;
import com.cgd.commodity.busi.bo.BusiCreateExamineReqInfo;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.intfce.bo.CreateApproveConsumerReqBO;
import com.cgd.commodity.intfce.vo.CreateApproveLogConsumerVO;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateApproveLogConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger logger = LoggerFactory.getLogger(CreateApproveLogConsumer.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private BusiCreateExamineService busiCreateExamineService;
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }

    public void setBusiCreateExamineService(BusiCreateExamineService busiCreateExamineService) {
        this.busiCreateExamineService = busiCreateExamineService;
    }

    private List<Map<String, Object>> getCatalogName(List<CreateApproveLogConsumerVO> skus) {
        try {
            ArrayList<Long> commodityTypeIds = new ArrayList<Long>();
            if (!skus.isEmpty()) {
                for (CreateApproveLogConsumerVO sku : skus) {
                    commodityTypeIds.add(sku.getCommodityTypeId());
                }
                return this.commodityGuideCatalogMapper.selectCatalogNameByTypeIds(commodityTypeIds);
            }
            return null;
        }
        catch (Exception e) {
            logger.debug("\u5355\u54c1\u72b6\u6001\u53d8\u66f4\u65e5\u5fd7\u6d88\u8d39\u8005\u7ec4\u5408\u670d\u52a1\u6839\u636e\u7c7b\u578bID\u6279\u91cf\u67e5\u8be2\u7c7b\u76ee\u540d\u79f0\u5931\u8d25:" + e);
            return null;
        }
    }

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        CreateApproveConsumerReqBO createApproveConsumerReqBO = (CreateApproveConsumerReqBO)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)proxyMessage.getContent()), CreateApproveConsumerReqBO.class);
        if (this.isDebugEnabled) {
            logger.debug("\u5ba1\u6279\u4fe1\u606f\u751f\u6210\u6d88\u8d39\u8005\u7ec4\u5408\u670d\u52a1\u5165\u53c2:" + createApproveConsumerReqBO.toString());
        }
        if (createApproveConsumerReqBO.getSku() != null) {
            try {
                BusiCreateExamineReqBO busiCreateExamineReqBO = new BusiCreateExamineReqBO();
                busiCreateExamineReqBO.setApprover(createApproveConsumerReqBO.getOperatorName());
                busiCreateExamineReqBO.setApproveType(createApproveConsumerReqBO.getOperateType());
                busiCreateExamineReqBO.setCreateLoginId(createApproveConsumerReqBO.getOperatorId());
                busiCreateExamineReqBO.setUpdateLoginId(createApproveConsumerReqBO.getOperatorId());
                busiCreateExamineReqBO.setSuggestContent(createApproveConsumerReqBO.getComment());
                busiCreateExamineReqBO.setRejectContent(createApproveConsumerReqBO.getRejectMsg());
                busiCreateExamineReqBO.setCreateTime(createApproveConsumerReqBO.getCreateTime());
                List<CreateApproveLogConsumerVO> skus = this.skuMapper.selectCatalogBySkuIds(createApproveConsumerReqBO.getSku().getSupplierId(), createApproveConsumerReqBO.getSku().getSkuIds());
                List<Map<String, Object>> catalogMaps = this.getCatalogName(skus);
                if (!skus.isEmpty()) {
                    busiCreateExamineReqBO.setSupplierId(createApproveConsumerReqBO.getSku().getSupplierId());
                    ArrayList<BusiCreateExamineReqInfo> busiCreateExamineSkuReqInfos = new ArrayList<BusiCreateExamineReqInfo>();
                    for (CreateApproveLogConsumerVO sku : skus) {
                        BusiCreateExamineReqInfo busiCreateExamineSkuReqInfo = new BusiCreateExamineReqInfo();
                        busiCreateExamineSkuReqInfo.setAgreementPrice(sku.getAgreementPrice());
                        busiCreateExamineSkuReqInfo.setMarketPrice(sku.getMarketPrice());
                        busiCreateExamineSkuReqInfo.setPubTime(sku.getPublishTime());
                        busiCreateExamineSkuReqInfo.setSkuId(sku.getSkuId());
                        busiCreateExamineSkuReqInfo.setSkuName(sku.getSkuName());
                        busiCreateExamineSkuReqInfo.setSupplierId(sku.getSupplierId());
                        busiCreateExamineSkuReqInfo.setSupplierName(sku.getSupplierName());
                        busiCreateExamineSkuReqInfo.setApproveType(createApproveConsumerReqBO.getOperateType());
                        busiCreateExamineSkuReqInfo.setSuccess(createApproveConsumerReqBO.getSuccess());
                        busiCreateExamineSkuReqInfo.setResultMsg(createApproveConsumerReqBO.getResultMsg());
                        busiCreateExamineSkuReqInfo.setBrandName(sku.getBrandName());
                        busiCreateExamineSkuReqInfo.setApproveSkuSate(createApproveConsumerReqBO.getApproveSkuState());
                        busiCreateExamineSkuReqInfo.setCreateTime(new Date());
                        if (!catalogMaps.isEmpty()) {
                            for (Map<String, Object> map : catalogMaps) {
                                if (!map.get("COMMODITY_TYPE_ID").equals(sku.getCommodityTypeId())) continue;
                                busiCreateExamineSkuReqInfo.setSkuCatalog((String)map.get("CATALOG_NAME"));
                            }
                        }
                        busiCreateExamineSkuReqInfos.add(busiCreateExamineSkuReqInfo);
                    }
                    busiCreateExamineReqBO.setCreateExamineInfos(busiCreateExamineSkuReqInfos);
                    this.busiCreateExamineService.createExamine(busiCreateExamineReqBO);
                }
            }
            catch (Exception e) {
                logger.error("\u5355\u54c1\u72b6\u6001\u53d8\u66f4\u65e5\u5fd7\u6d88\u8d39\u8005\u7ec4\u5408\u670d\u52a1\u5931\u8d25\uff1a" + e);
                return ProxyConsumerStatus.RECONSUME_LATER;
            }
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

