/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.commodity.busi.SkuHandOffShelfService;
import com.ohaotian.commodity.busi.bo.SkuHandOffShelfReqBO;
import com.ohaotian.commodity.busi.bo.SkuHandOffShelfRspBO;
import com.ohaotian.commodity.busi.constant.Constant;
import com.ohaotian.commodity.busi.intfce.bo.CreateApproveConsumerReqBO;
import com.ohaotian.commodity.busi.intfce.bo.SkuStatuChangeLogConsumerReqBO;
import com.ohaotian.commodity.busi.intfce.vo.CreateApproveConsumerReqVO;
import com.ohaotian.commodity.busi.intfce.vo.SkuStatuChangeLogConsumerVO;
import com.ohaotian.commodity.config.TopicConfig;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.util.RandomGUIDUtil;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkuHandOffShelfServiceImpl
implements SkuHandOffShelfService {
    private static final Logger logger = LoggerFactory.getLogger(SkuHandOffShelfServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    @Resource
    private TopicConfig topicConfig;
    @Resource(name="createApproveLogProducer")
    private ProxyMessageProducer createApproveLogProducer;
    @Resource(name="skuStateChangeLogProducer")
    private ProxyMessageProducer skuStateChangeLogProducer;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public SkuHandOffShelfRspBO skuHandOffShelf(SkuHandOffShelfReqBO skuHandOffShelfReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u624b\u52a8\u4e0b\u67b6\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + skuHandOffShelfReqBO.toString());
        }
        if (null == skuHandOffShelfReqBO.getOperatorId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u624b\u52a8\u4e0b\u67b6\u4e1a\u52a1\u670d\u52a1\u64cd\u4f5c\u4ebaID[operatorId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == skuHandOffShelfReqBO.getOperatorName()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u624b\u52a8\u4e0b\u67b6\u4e1a\u52a1\u670d\u52a1\u64cd\u4f5c\u4eba\u540d\u79f0[operatorName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == skuHandOffShelfReqBO.getSku()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u624b\u52a8\u4e0b\u67b6\u4e1a\u52a1\u670d\u52a1sku[sku]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Boolean result = this.updateSkuSate(skuHandOffShelfReqBO, Constant.SKU_STATUS_SUPPLIER_RACK);
            if (result.booleanValue()) {
                this.sendMsg(skuHandOffShelfReqBO, Constant.SKU_STATUS_SUPPLIER_RACK, true);
            } else {
                this.sendMsg(skuHandOffShelfReqBO, Constant.SKU_STATUS_SUPPLIER_RACK, false);
            }
            SkuHandOffShelfRspBO skuHandOffShelfRspBO = new SkuHandOffShelfRspBO();
            if (result.booleanValue()) {
                skuHandOffShelfRspBO.setIsSuccess(Boolean.valueOf(true));
            } else {
                skuHandOffShelfRspBO.setIsSuccess(Boolean.valueOf(false));
                skuHandOffShelfRspBO.setResultMsg("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u624b\u52a8\u4e0b\u67b6\u4e1a\u52a1\u670d\u52a1\u6267\u884csku\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
            }
            return skuHandOffShelfRspBO;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u624b\u52a8\u4e0b\u67b6\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u624b\u52a8\u4e0b\u67b6\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private Boolean updateSkuSate(SkuHandOffShelfReqBO skuHandOffShelfReqBO, Integer skuState) {
        try {
            this.skuMapper.updateSkuStateOffShelfBySkuId(skuState, skuHandOffShelfReqBO.getOperatorId(), skuHandOffShelfReqBO.getSku());
            return true;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u624b\u52a8\u4e0b\u67b6\u4e1a\u52a1\u670d\u52a1\u6279\u91cf\u66f4\u65b0sku\u72b6\u6001\u5931\u8d25" + e);
            return false;
        }
    }

    private void sendMsg(SkuHandOffShelfReqBO skuHandOffShelfReqBO, Integer skuState, Boolean flag) {
        ArrayList<Long> skuIds;
        try {
            SkuStatuChangeLogConsumerReqBO skuStatuChangeLogConsumerReqBO = new SkuStatuChangeLogConsumerReqBO();
            skuStatuChangeLogConsumerReqBO.setOperatorId(skuHandOffShelfReqBO.getOperatorId());
            skuStatuChangeLogConsumerReqBO.setPreState(Constant.SKU_STATUS_SHELVED);
            skuStatuChangeLogConsumerReqBO.setCreateTime(new Date());
            skuStatuChangeLogConsumerReqBO.setRandomStr(RandomGUIDUtil.getRandomGUID());
            if (flag.booleanValue()) {
                skuStatuChangeLogConsumerReqBO.setPostState(skuState);
                skuStatuChangeLogConsumerReqBO.setApproveComments("\u66f4\u65b0\u6210\u529f");
            } else {
                skuStatuChangeLogConsumerReqBO.setPostState(Constant.SKU_STATUS_SHELVED);
                skuStatuChangeLogConsumerReqBO.setApproveComments("\u66f4\u65b0\u5931\u8d25");
            }
            SkuStatuChangeLogConsumerVO skuStatuChangeLogConsumerVO = new SkuStatuChangeLogConsumerVO();
            skuIds = new ArrayList<Long>();
            for (Long skuId : skuHandOffShelfReqBO.getSku().getSkuIds()) {
                skuIds.add(skuId);
            }
            skuStatuChangeLogConsumerVO.setSkuIds(skuIds);
            skuStatuChangeLogConsumerVO.setSupplierId(skuHandOffShelfReqBO.getSku().getSupplierId());
            skuStatuChangeLogConsumerReqBO.setSku(skuStatuChangeLogConsumerVO);
            this.skuStateChangeLogProducer.sendOneway(new ProxyMessage(this.topicConfig.getSkuStateUpdateTopicName(), this.topicConfig.getSkuStateUpdateTagName(), JSONObject.toJSONString((Object)skuStatuChangeLogConsumerReqBO)));
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u624b\u52a8\u4e0b\u67b6\u4e1a\u52a1\u670d\u52a1\u53d1\u9001sku\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u5931\u8d25" + e);
        }
        try {
            CreateApproveConsumerReqBO createApproveConsumerReqBO = new CreateApproveConsumerReqBO();
            createApproveConsumerReqBO.setOperatorId(skuHandOffShelfReqBO.getOperatorId());
            createApproveConsumerReqBO.setOperateType(Integer.valueOf(2));
            createApproveConsumerReqBO.setApproveSkuState(Constant.SKU_STATUS_SUPPLIER_RACK);
            createApproveConsumerReqBO.setCreateTime(new Date());
            createApproveConsumerReqBO.setRandomStr(RandomGUIDUtil.getRandomGUID());
            CreateApproveConsumerReqVO createApproveConsumerReqVO = new CreateApproveConsumerReqVO();
            skuIds = new ArrayList();
            for (Long skuId : skuHandOffShelfReqBO.getSku().getSkuIds()) {
                skuIds.add(skuId);
            }
            createApproveConsumerReqVO.setSkuIds(skuIds);
            createApproveConsumerReqVO.setSupplierId(skuHandOffShelfReqBO.getSku().getSupplierId());
            createApproveConsumerReqBO.setSku(createApproveConsumerReqVO);
            createApproveConsumerReqBO.setOperatorName(skuHandOffShelfReqBO.getOperatorName());
            if (flag.booleanValue()) {
                createApproveConsumerReqBO.setSuccess(Integer.valueOf(1));
            } else {
                createApproveConsumerReqBO.setSuccess(Integer.valueOf(0));
            }
            this.createApproveLogProducer.sendOneway(new ProxyMessage(this.topicConfig.getSkuApproveTopicName(), this.topicConfig.getSkuApproveTagName(), JSONObject.toJSONString((Object)createApproveConsumerReqBO)));
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u624b\u52a8\u4e0b\u67b6\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u5ba1\u6279\u65e5\u5fd7\u65b0\u589e\u6d88\u606f\u5931\u8d25" + e);
        }
    }
}

