/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static final Logger logger = LoggerFactory.getLogger(ExcelUtil.class);
    private HSSFWorkbook workbook;
    private List<SheetInfo> sheets = new ArrayList<SheetInfo>();
    private Map<Integer, List<CellFormater>> sheetCellFormat = new HashMap<Integer, List<CellFormater>>();

    public ExcelUtil() {
        if (this.workbook == null) {
            this.workbook = new HSSFWorkbook();
        }
    }

    public ExcelUtil(InputStream is) {
        if (this.workbook == null) {
            try {
                this.workbook = new HSSFWorkbook(is);
                this.initOnLoad();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public ExcelUtil(String fileName) {
        if (this.workbook == null) {
            try {
                FileInputStream fis = new FileInputStream(fileName);
                this.workbook = new HSSFWorkbook((InputStream)fis);
                this.initOnLoad();
                fis.close();
            }
            catch (IOException e) {
                logger.error("Load excel file failed,file=" + fileName, (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    public boolean isReady() {
        return this.workbook != null;
    }

    private void initOnLoad() {
        if (this.workbook == null) {
            return;
        }
        int cnt = this.workbook.getNumberOfSheets();
        logger.info("Load excel successfully,Sheet count=" + cnt);
        for (int i = 0; i < cnt; ++i) {
            HSSFSheet sheet = this.workbook.getSheetAt(i);
            this.sheets.add(new SheetInfo(sheet));
            logger.info("--- Sheet:" + i + ") " + sheet.getSheetName() + ",rowCount=" + sheet.getLastRowNum());
        }
    }

    public HSSFSheet getSheet(int sheetIndex) {
        if (sheetIndex >= this.sheets.size()) {
            return null;
        }
        return this.sheets.get((int)sheetIndex).sheet;
    }

    public int getSheetCount() {
        return this.sheets.size();
    }

    public String getSheetName(int sheetIndex) {
        if (sheetIndex >= this.sheets.size()) {
            return null;
        }
        return this.sheets.get((int)sheetIndex).name;
    }

    public HSSFSheet createSheet(String sheetName) {
        HSSFSheet sheet = this.workbook.createSheet(sheetName);
        this.sheets.add(new SheetInfo(sheet));
        return sheet;
    }

    public void setMemo(int sheetIndex, int cellCol, int cellRow, String text) {
        if (sheetIndex >= this.sheets.size()) {
            return;
        }
        SheetInfo sheetInf = this.sheets.get(sheetIndex);
        if (sheetInf.patr == null) {
            sheetInf.patr = this.sheets.get((int)sheetIndex).sheet.createDrawingPatriarch();
        }
        HSSFComment comment = sheetInf.patr.createComment((HSSFAnchor)new HSSFClientAnchor(0, 0, 0, 0, (short)cellCol, cellRow, (short)(cellCol + 2), cellRow + 4));
        comment.setString((RichTextString)new HSSFRichTextString(text));
        sheetInf.sheet.getRow(cellRow).getCell(cellCol).setCellComment((Comment)comment);
    }

    public void setMemo(int sheetIndex, String cellColName, int cellRow, String text) {
        int colIdx = ExcelUtil.cellNameToIndex(cellColName);
        this.setMemo(sheetIndex, colIdx, cellRow, text);
    }

    public void setCellsFormat(int sheetIndex, String[] formats) {
        if (this.workbook == null) {
            return;
        }
        if (sheetIndex > this.sheets.size()) {
            return;
        }
        Integer shIndex = new Integer(sheetIndex);
        List<CellFormater> formatLs = this.sheetCellFormat.get(shIndex);
        if (formatLs != null) {
            formatLs.clear();
        } else {
            formatLs = new ArrayList<CellFormater>();
        }
        if (formats == null) {
            return;
        }
        for (int i = 0; i < formats.length; ++i) {
            String s = formats[i];
            CellFormater cf = new CellFormater();
            formatLs.add(cf);
            if (s == null || s.length() == 0) {
                cf.valid = false;
                continue;
            }
            String[] inf = s.split(",");
            cf.style = this.workbook.createCellStyle();
            if (inf.length > 0) {
                cf.type = inf[0];
                if (cf.type.equals("D")) {
                    HSSFDataFormat df = this.workbook.createDataFormat();
                    cf.style.setDataFormat(df.getFormat("0.00"));
                } else if (cf.type.equals("S")) {
                    HSSFDataFormat df = this.workbook.createDataFormat();
                    cf.style.setDataFormat(df.getFormat("@"));
                }
            }
            if (inf.length > 1) {
                if (inf[1].equals("L")) {
                    cf.style.setAlignment((short)1);
                } else if (inf[1].equals("R")) {
                    cf.style.setAlignment((short)3);
                } else if (inf[1].equals("C")) {
                    cf.style.setAlignment((short)2);
                }
            }
            if (inf.length > 2 && inf[2].length() > 0) {
                int v = Integer.valueOf(inf[2]);
                cf.style.setFillPattern((short)1);
                cf.style.setFillForegroundColor((short)v);
            }
            if (inf.length > 3 && inf[3].length() > 0) {
                String[] fontInf = inf[3].split(":");
                int v = 0;
                if (fontInf.length > 1) {
                    v = Integer.valueOf(fontInf[1]);
                }
                HSSFFont font = this.workbook.createFont();
                if (v > 0) {
                    font.setFontHeightInPoints((short)v);
                }
                font.setFontName(fontInf[0]);
                cf.style.setFont(font);
            }
            cf.valid = true;
        }
        this.sheetCellFormat.put(shIndex, formatLs);
    }

    public void addRow(int sheetIndex, Object[] cellsValue, int rowHeight) {
        if (this.workbook == null) {
            return;
        }
        if (sheetIndex > this.sheets.size()) {
            return;
        }
        SheetInfo sheetInf = this.sheets.get(sheetIndex);
        HSSFSheet sheet = sheetInf.sheet;
        List<CellFormater> formatLs = this.sheetCellFormat.get(new Integer(sheetIndex));
        int rowIdx = sheet.getLastRowNum() + 1;
        if (!sheetInf.hasRow) {
            sheetInf.hasRow = true;
            rowIdx = sheet.getLastRowNum();
        }
        HSSFRow row = sheet.createRow(rowIdx);
        row.setHeightInPoints((float)rowHeight);
        for (int i = 0; i < cellsValue.length; ++i) {
            HSSFCell cell = row.createCell(i);
            Object cellValue = cellsValue[i];
            CellFormater cf = null;
            if (formatLs != null && i < formatLs.size()) {
                cf = formatLs.get(i);
            }
            try {
                if (cellValue == null) {
                    cellValue = "";
                    if (cf.valid) {
                        if (cf.type.equals("N")) {
                            cellValue = new Integer(0);
                        } else if (cf.type.equals("D")) {
                            cellValue = BigDecimal.ZERO;
                        }
                    }
                } else if (cellValue instanceof String && cf.valid && ((String)cellValue).length() > 0) {
                    if (cf.type.equals("N")) {
                        BigDecimal parse = new BigDecimal((String)cellValue);
                        cellValue = new Integer(parse.intValue());
                    } else if (cf.type.equals("D")) {
                        cellValue = new BigDecimal((String)cellValue);
                    }
                }
            }
            catch (Exception e) {
                logger.error("---Excel\u6570\u636e\u8f6c\u6362\u5931\u8d25,\u5355\u5143\u683c[r=" + rowIdx + ",c=" + i + "(" + ExcelUtil.indexToCellName(i) + ")],\u6570\u636e=[" + cellValue + "],\u8f6c\u7c7b\u578b=" + cf.type);
                cellValue = "";
            }
            if (cellValue instanceof BigDecimal || cellValue instanceof Integer) {
                double dv = 0.0;
                dv = cellValue instanceof Integer ? ((Integer)cellValue).doubleValue() : ((BigDecimal)cellValue).doubleValue();
                cell.setCellValue(dv);
                cell.setCellType(0);
            } else {
                cell.setCellValue("" + cellValue);
                cell.setCellType(1);
            }
            sheet.autoSizeColumn(i);
            if (cf == null || !cf.valid) continue;
            cell.setCellStyle(cf.style);
        }
    }

    public List<String[]> readRows(int sheetIndex, int fromRowIndex, int toRowIndex) {
        if (this.workbook == null) {
            return null;
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (sheetIndex >= this.sheets.size()) {
            return list;
        }
        SheetInfo sheetInf = this.sheets.get(sheetIndex);
        int rowCnt = sheetInf.sheet.getLastRowNum();
        for (int i = 0; i <= rowCnt; ++i) {
            String[] data = this.readRow(sheetIndex, i);
            list.add(data);
        }
        return list;
    }

    public String[] readRow(int sheetIndex, int rowIndex) {
        if (this.workbook == null) {
            return null;
        }
        if (sheetIndex >= this.sheets.size()) {
            return new String[0];
        }
        SheetInfo sheetInf = this.sheets.get(sheetIndex);
        HSSFRow row = sheetInf.sheet.getRow(rowIndex);
        int cellCnt = row.getLastCellNum();
        logger.debug("Read excel sheet [" + sheetInf.name + "] row,row=" + rowIndex + " cellCnt=" + cellCnt);
        String[] fields = new String[cellCnt];
        for (int i = 0; i < cellCnt; ++i) {
            HSSFCell cell = row.getCell(i);
            String v = "";
            v = cell.getCellType() == 4 ? String.valueOf(cell.getBooleanCellValue()) : (cell.getCellType() == 0 ? String.valueOf(cell.getNumericCellValue()) : (cell.getCellType() == 1 ? String.valueOf(cell.getStringCellValue()) : String.valueOf(cell.getStringCellValue())));
            fields[i] = v;
        }
        return fields;
    }

    public void setArrayValue(Object[] ary, String value, int ... aryIdxs) {
        if (ary == null) {
            return;
        }
        if (aryIdxs == null || aryIdxs.length == 0) {
            for (int i = 0; i < ary.length; ++i) {
                ary[i] = value;
            }
        } else {
            for (int i : aryIdxs) {
                ary[i] = value;
            }
        }
    }

    public void setArrayValueByNames(Object[] ary, String value, String ... cellNames) {
        if (ary == null) {
            return;
        }
        if (cellNames == null || cellNames.length == 0) {
            for (int i = 0; i < ary.length; ++i) {
                ary[i] = value;
            }
            return;
        }
        for (int i = 0; i < cellNames.length; ++i) {
            String n = cellNames[i].toUpperCase();
            int idx = ExcelUtil.cellNameToIndex(n);
            ary[idx] = value;
        }
    }

    public static String indexToCellName(int aryIndex) {
        if (aryIndex < 0) {
            return "";
        }
        int dv = aryIndex / 26;
        int mv = aryIndex % 26;
        if (dv == 0) {
            return String.valueOf((char)(mv + 65));
        }
        return String.valueOf((char)(mv + 65)) + ExcelUtil.indexToCellName(dv);
    }

    public static int cellNameToIndex(String name) {
        int idx = 0;
        name = name.toUpperCase();
        int len = name.length();
        for (int j = 0; j < len; ++j) {
            idx = idx + (name.charAt(len - j - 1) - 65) + j * 26;
        }
        return idx;
    }

    public void close() {
        if (this.workbook != null) {
            try {
                this.workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveAsFile(String fileName) {
        if (this.workbook == null) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(new File(fileName));
            this.workbook.write((OutputStream)fos);
            this.workbook.close();
            fos.close();
        }
        catch (Exception e) {
            logger.error("Save excel to file failed,file=" + fileName, (Throwable)e);
            e.printStackTrace();
        }
    }

    public void saveAsOutStream(OutputStream out) {
        if (this.workbook == null) {
            return;
        }
        try {
            this.workbook.write(out);
            this.workbook.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String saveAsHexString() {
        if (this.workbook == null) {
            return "";
        }
        String s = "";
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        try {
            this.workbook.write((OutputStream)bao);
            this.workbook.close();
            byte[] buf = bao.toByteArray();
            bao.close();
            logger.info("Excel save to HEX string,excel size=" + buf.length);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < buf.length; ++i) {
                int v = buf[i] & 0xFF;
                if (v < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(v));
            }
            s = sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static void main(String[] args) {
        System.out.println(ExcelUtil.cellNameToIndex("AA"));
        System.out.println(ExcelUtil.indexToCellName(0));
    }

    class SheetInfo {
        public HSSFSheet sheet;
        public HSSFPatriarch patr;
        public boolean hasRow;
        public String name;

        public SheetInfo(HSSFSheet sheet) {
            this.sheet = sheet;
            this.hasRow = false;
            this.name = sheet.getSheetName();
        }
    }

    class CellFormater {
        public boolean valid = false;
        public String type = "";
        public HSSFCellStyle style = null;

        CellFormater() {
        }
    }
}

