/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QrySKUImageService;
import com.cgd.commodity.busi.bo.QrySkuImageReqBO;
import com.cgd.commodity.busi.bo.QrySkuImageRspBO;
import com.cgd.commodity.busi.vo.QrySkuImageRspVO;
import com.cgd.commodity.busi.vo.QrySkuImageVO;
import com.cgd.commodity.dao.SkuPicMapper;
import com.cgd.commodity.po.SkuPic;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrySKUImageServiceImpl
implements QrySKUImageService {
    private static final Logger logger = LoggerFactory.getLogger(QrySKUImageServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuPicMapper skuPicMapper;

    public void setSkuPicMapper(SkuPicMapper skuPicMapper) {
        this.skuPicMapper = skuPicMapper;
    }

    public QrySkuImageRspBO qrySkuImage(QrySkuImageReqBO qrySkuImageReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qrySkuImageReqBO.toString());
        }
        if (null == qrySkuImageReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u4e1a\u52a1\u670d\u52a1\u94fa\u8d27\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (qrySkuImageReqBO.getSkuIds().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u4e1a\u52a1\u670d\u52a1SKUID\u96c6\u5408[skuIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            List<SkuPic> skuPics = this.skuPicMapper.selectBySkuIdsAndSupplierId(qrySkuImageReqBO.getSkuIds(), qrySkuImageReqBO.getSupplierId());
            ArrayList<QrySkuImageRspVO> skus = new ArrayList<QrySkuImageRspVO>();
            for (Long skuId : qrySkuImageReqBO.getSkuIds()) {
                ArrayList<QrySkuImageVO> skuImages = new ArrayList<QrySkuImageVO>();
                if (!skuPics.isEmpty()) {
                    for (SkuPic skuPic : skuPics) {
                        if (!skuId.equals(skuPic.getSkuId())) continue;
                        QrySkuImageVO qrySkuImageVO = new QrySkuImageVO();
                        qrySkuImageVO.setIsPrimary(skuPic.getIsPrimary());
                        qrySkuImageVO.setPicOrder(skuPic.getPicOrder());
                        qrySkuImageVO.setSkuPicId(skuPic.getSkuPicId());
                        qrySkuImageVO.setSkuPicUrl(skuPic.getSkuPicUrl());
                        qrySkuImageVO.setCreatedTime(skuPic.getCreateTime());
                        qrySkuImageVO.setUpdateTime(skuPic.getUpdateTime());
                        skuImages.add(qrySkuImageVO);
                    }
                }
                QrySkuImageRspVO qrySkuImageRspVO = new QrySkuImageRspVO();
                qrySkuImageRspVO.setSkuId(skuId);
                qrySkuImageRspVO.setSupplierId(qrySkuImageReqBO.getSupplierId());
                qrySkuImageRspVO.setSkuImages(skuImages);
                skus.add(qrySkuImageRspVO);
            }
            QrySkuImageRspBO qrySkuImageRspBO = new QrySkuImageRspBO();
            qrySkuImageRspBO.setSkus(skus);
            return qrySkuImageRspBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }
}

