/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QrySkuOffShelfedService;
import com.cgd.commodity.busi.bo.QrySkuOffShelfedReqBO;
import com.cgd.commodity.busi.bo.QrySkuOffShelfedRspBO;
import com.cgd.commodity.dao.SkuApproveLogMapper;
import com.cgd.commodity.po.SkuApproveLog;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QrySkuOffShelfedServiceImpl
implements QrySkuOffShelfedService {
    private static final Logger logger = LoggerFactory.getLogger(QrySkuOffShelfedServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuApproveLogMapper skuApproveLogMapper;

    public void setSkuApproveLogMapper(SkuApproveLogMapper skuApproveLogMapper) {
        this.skuApproveLogMapper = skuApproveLogMapper;
    }

    public RspPageBO<QrySkuOffShelfedRspBO> qrySkuOffShelfed(QrySkuOffShelfedReqBO qrySkuOffShelfedReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qrySkuOffShelfedReqBO.toString());
        }
        try {
            if (!StringUtils.isEmpty((Object)qrySkuOffShelfedReqBO.getOperator())) {
                qrySkuOffShelfedReqBO.setOperator(qrySkuOffShelfedReqBO.getOperator().replaceAll(" ", ""));
            }
            Page page = new Page(qrySkuOffShelfedReqBO.getPageNo(), qrySkuOffShelfedReqBO.getPageSize());
            List<SkuApproveLog> approveLogs = this.skuApproveLogMapper.selectByOperatorAndTime((Page<SkuApproveLog>)page, qrySkuOffShelfedReqBO);
            List<QrySkuOffShelfedRspBO> qrySkuOffShelfedRspBOs = this.resolveRsp(approveLogs);
            RspPageBO rspPageBO = new RspPageBO();
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setTotal(page.getTotalPages());
            rspPageBO.setPageNo(qrySkuOffShelfedReqBO.getPageNo());
            rspPageBO.setRows(qrySkuOffShelfedRspBOs);
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<QrySkuOffShelfedRspBO> resolveRsp(List<SkuApproveLog> approveLogs) {
        try {
            if (!approveLogs.isEmpty()) {
                ArrayList<QrySkuOffShelfedRspBO> qrySkuOffShelfedRspBOs = new ArrayList<QrySkuOffShelfedRspBO>();
                for (SkuApproveLog skuApproveLog : approveLogs) {
                    QrySkuOffShelfedRspBO qrySkuOffShelfedRspBO = new QrySkuOffShelfedRspBO();
                    qrySkuOffShelfedRspBO.setApproveId(skuApproveLog.getApproveId());
                    qrySkuOffShelfedRspBO.setApproveTime(skuApproveLog.getApproveTime());
                    qrySkuOffShelfedRspBO.setApproveType(Integer.valueOf(skuApproveLog.getApproveType()));
                    qrySkuOffShelfedRspBO.setOperatorId(skuApproveLog.getCreateLoginId());
                    qrySkuOffShelfedRspBO.setOperatorName(skuApproveLog.getApprover());
                    qrySkuOffShelfedRspBO.setSkuNumber(skuApproveLog.getSkuNumber());
                    qrySkuOffShelfedRspBOs.add(qrySkuOffShelfedRspBO);
                }
                return qrySkuOffShelfedRspBOs;
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5c01\u88c5\u54cd\u5e94\u6570\u636e\u5931\u8d25\uff1a" + e);
            return null;
        }
    }
}

