/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.CreateSkuCommentService;
import com.cgd.commodity.busi.bo.BusiCreateCommentReqBO;
import com.cgd.commodity.busi.bo.BusiCreateCommentRspBO;
import com.cgd.commodity.dao.CommodityCommentMapper;
import com.cgd.commodity.po.CommodityComment;
import com.ohaotian.plugin.base.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSkuCommentServiceImpl
implements CreateSkuCommentService {
    private static final Logger logger = LoggerFactory.getLogger(CreateSkuCommentServiceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    private CommodityCommentMapper commodityCommentMapper;

    public void setCommodityCommentMapper(CommodityCommentMapper commodityCommentMapper) {
        this.commodityCommentMapper = commodityCommentMapper;
    }

    public BusiCreateCommentRspBO createSkuComment(BusiCreateCommentReqBO busiCreateCommentReqBO) {
        if (isDebugEnabled) {
            logger.debug("\u6dfb\u52a0\u5546\u54c1\u8bc4\u4ef7\u4e1a\u52a1\u670d\u52a1\uff1a" + busiCreateCommentReqBO.toString());
        }
        if (null == busiCreateCommentReqBO.getSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6dfb\u52a0\u5546\u54c1\u8bc4\u4ef7\u4e1a\u52a1\u670d\u52a1Sku Id[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiCreateCommentReqBO.getComment()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6dfb\u52a0\u5546\u54c1\u8bc4\u4ef7\u4e1a\u52a1\u670d\u52a1\u8bc4\u4ef7\u5185\u5bb9[comment]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiCreateCommentReqBO.getCommentRate()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6dfb\u52a0\u5546\u54c1\u8bc4\u4ef7\u4e1a\u52a1\u670d\u52a1\u8bc4\u4ef7\u7b49\u7ea7[commentRate]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CommodityComment record = new CommodityComment();
        record.setSkuId(busiCreateCommentReqBO.getSkuId());
        record.setComment(busiCreateCommentReqBO.getComment());
        record.setCommentRate(busiCreateCommentReqBO.getCommentRate());
        BusiCreateCommentRspBO rspBO = new BusiCreateCommentRspBO();
        try {
            int success = this.commodityCommentMapper.insert(record);
            if (success > 0) {
                rspBO.setIsSuccess(Boolean.valueOf(true));
            }
            rspBO.setIsSuccess(Boolean.valueOf(false));
        }
        catch (Exception e) {
            rspBO.setIsSuccess(Boolean.valueOf(false));
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6dfb\u52a0\u5546\u54c1\u8bc4\u4ef7\u4e1a\u52a1\u670d\u52a1\u8bc4\u4ef7\u7b49\u7ea7\u5931\u8d25");
        }
        return rspBO;
    }
}

