/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.sku.impl;

import com.ohaotian.commodity.busi.constant.Constant;
import com.ohaotian.commodity.busi.picture.QuerySkuPicBusiService;
import com.ohaotian.commodity.busi.picture.bo.QuerySkuPicReqBO;
import com.ohaotian.commodity.busi.picture.bo.QuerySkuPicRspBO;
import com.ohaotian.commodity.busi.price.BatchQuerySkuPriceBusiService;
import com.ohaotian.commodity.busi.price.bo.BatchQuerySkuPriceReqBO;
import com.ohaotian.commodity.busi.price.bo.BatchQuerySkuPriceRspBO;
import com.ohaotian.commodity.busi.sku.QuerySkuDetailBusiService;
import com.ohaotian.commodity.busi.sku.bo.AttachSkuBusiBO;
import com.ohaotian.commodity.busi.sku.bo.QuerySkuDetailReqBO;
import com.ohaotian.commodity.busi.sku.bo.QuerySkuDetailRspBO;
import com.ohaotian.commodity.busi.sku.bo.QuerySkuWithAttachDetailRspBO;
import com.ohaotian.commodity.busi.sku.bo.SkuBusiBO;
import com.ohaotian.commodity.busi.sku.bo.SkuPriceRspBO;
import com.ohaotian.commodity.busi.sku.bo.SkuSpecBO;
import com.ohaotian.commodity.busi.spec.QuerySkuSpecBusiService;
import com.ohaotian.commodity.busi.spec.bo.QuerySkuSpecReqBO;
import com.ohaotian.commodity.busi.spec.bo.QuerySkuSpecRspBO;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service(value="querySkuDetailBusiService")
@Qualifier
public class QuerySkuDetailBusiServiceImpl
implements QuerySkuDetailBusiService {
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuDetailBusiServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private BatchQuerySkuPriceBusiService batchQuerySkuPriceBusiService;
    @Autowired
    private QuerySkuSpecBusiService querySkuSpecBusiService;
    @Autowired
    private QuerySkuPicBusiService querySkuPicBusiService;

    public QuerySkuDetailRspBO querySkuDetail(QuerySkuDetailReqBO querySkuDetailReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + querySkuDetailReqBO.toString());
        }
        if (querySkuDetailReqBO.getSkuId() == null && StringUtils.isBlank((String)querySkuDetailReqBO.getExtSkuId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5355\u54c1Id[skuId]\u548c\u5916\u90e8\u5355\u54c1Id[extSkuId]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (null == querySkuDetailReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u95e8\u5e97ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QuerySkuDetailRspBO rspBO = new QuerySkuDetailRspBO();
        try {
            Sku sku = new Sku();
            if (querySkuDetailReqBO.getSkuId() != null) {
                Sku sku1 = new Sku();
                sku1.setSkuId(querySkuDetailReqBO.getSkuId());
                sku1.setSupplierId(querySkuDetailReqBO.getSupplierId());
                if (null != querySkuDetailReqBO.getSkuStatus()) {
                    sku1.setSkuStatus(querySkuDetailReqBO.getSkuStatus());
                }
                sku = this.skuMapper.selectBySkuIdAndSupplierAndstatus(sku1);
            } else {
                sku = this.skuMapper.qryBySupplierIdAndExtSkuId(querySkuDetailReqBO.getSupplierId(), querySkuDetailReqBO.getExtSkuId());
            }
            if (!ObjectUtils.isEmpty((Object)sku)) {
                List specs;
                BeanUtils.copyProperties((Object)sku, (Object)rspBO);
                BatchQuerySkuPriceReqBO batchQuerySkuPriceReqBO = new BatchQuerySkuPriceReqBO();
                batchQuerySkuPriceReqBO.setSkuIds(Arrays.asList(sku.getSkuId()));
                batchQuerySkuPriceReqBO.setSupplierId(sku.getSupplierId());
                BatchQuerySkuPriceRspBO batchQuerySkuPriceRspBO = this.batchQuerySkuPriceBusiService.batchQuerySkuPrice(batchQuerySkuPriceReqBO);
                if (null != batchQuerySkuPriceRspBO && null != batchQuerySkuPriceRspBO.getPrices() && batchQuerySkuPriceRspBO.getPrices().size() > 0) {
                    rspBO.setPrice((SkuPriceRspBO)batchQuerySkuPriceRspBO.getPrices().get(0));
                }
                QuerySkuSpecReqBO querySkuSpecReqBO = new QuerySkuSpecReqBO();
                querySkuSpecReqBO.setSkuId(sku.getSkuId());
                querySkuSpecReqBO.setSupplierId(sku.getSupplierId());
                QuerySkuSpecRspBO querySkuSpecRspBO = this.querySkuSpecBusiService.querySkuSpec(querySkuSpecReqBO);
                ArrayList<SkuSpecBO> specs1 = new ArrayList<SkuSpecBO>();
                ArrayList<SkuSpecBO> specs2 = new ArrayList<SkuSpecBO>();
                if (null != querySkuSpecRspBO && null != querySkuSpecRspBO.getSpecs() && CollectionUtils.isNotEmpty((Collection)(specs = querySkuSpecRspBO.getSpecs()))) {
                    for (SkuSpecBO skuSpecBO : specs) {
                        if (skuSpecBO.getCommodityPropGrpId() == 900991231L) {
                            specs1.add(skuSpecBO);
                            continue;
                        }
                        if (skuSpecBO.getCommodityPropGrpId() == 900991232L) {
                            specs1.add(skuSpecBO);
                            continue;
                        }
                        if (skuSpecBO.getCommodityPropGrpId() == 900991233L) {
                            specs1.add(skuSpecBO);
                            continue;
                        }
                        if (skuSpecBO.getCommodityPropGrpId() == 900991234L) {
                            specs1.add(skuSpecBO);
                            continue;
                        }
                        if (skuSpecBO.getPropValueListId() == null) continue;
                        specs2.add(skuSpecBO);
                    }
                }
                rspBO.setSpecs(specs1);
                rspBO.setDimensions(specs2);
                QuerySkuPicReqBO querySkuPicReqBO = new QuerySkuPicReqBO();
                querySkuPicReqBO.setSkuId(sku.getSkuId());
                querySkuPicReqBO.setSupplierId(sku.getSupplierId());
                QuerySkuPicRspBO querySkuPicRspBO = this.querySkuPicBusiService.querySkuPic(querySkuPicReqBO);
                if (null != querySkuPicRspBO && null != querySkuPicRspBO.getPictures()) {
                    rspBO.setPictures(querySkuPicRspBO.getPictures());
                }
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u6ca1\u6709\u8fd9\u4e2a\u5546\u54c1");
            }
        }
        catch (Exception e) {
            logger.error("\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1" + e.getMessage());
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        logger.info("\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2\uff1a" + rspBO.toString());
        return rspBO;
    }

    public QuerySkuWithAttachDetailRspBO querySkuAndAttachDetail(QuerySkuDetailReqBO querySkuDetailReqBO) {
        QuerySkuWithAttachDetailRspBO result = new QuerySkuWithAttachDetailRspBO();
        if (this.isDebugEnabled) {
            logger.debug("\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + querySkuDetailReqBO.toString());
        }
        if (null == querySkuDetailReqBO.getSkuPrice() && querySkuDetailReqBO.getSkuId() == null && StringUtils.isBlank((String)querySkuDetailReqBO.getExtSkuId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5355\u54c1Id[skuId]\u548c\u5916\u90e8\u5355\u54c1Id[extSkuId]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (querySkuDetailReqBO.getSupplierId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u95e8\u5e97Id[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Sku sku = new Sku();
            sku = querySkuDetailReqBO.getSkuId() != null ? this.skuMapper.selectBySkuIdAndSupplier(querySkuDetailReqBO.getSkuId()) : this.skuMapper.qryBySupplierIdAndExtSkuId(querySkuDetailReqBO.getSupplierId(), querySkuDetailReqBO.getExtSkuId());
            if (null == sku.getSkuId()) {
                result.setRespCode("0000");
                result.setRespDesc("\u6210\u529f");
                return result;
            }
            BeanUtils.copyProperties((Object)sku, (Object)result);
            if ("1".equals(sku.getAttachFlag())) {
                if (null != sku.getSkuPrice()) {
                    result.setSkuPrice(MoneyUtils.Long2BigDecimal((Long)sku.getSkuPrice()));
                }
                result.setRespCode("0000");
                result.setRespDesc("\u6210\u529f");
                return result;
            }
            BatchQuerySkuPriceReqBO batchQuerySkuPriceReqBO = new BatchQuerySkuPriceReqBO();
            batchQuerySkuPriceReqBO.setSkuIds(Arrays.asList(sku.getSkuId()));
            batchQuerySkuPriceReqBO.setSupplierId(sku.getSupplierId());
            BatchQuerySkuPriceRspBO batchQuerySkuPriceRspBO = this.batchQuerySkuPriceBusiService.batchQuerySkuPrice(batchQuerySkuPriceReqBO);
            if (null != batchQuerySkuPriceRspBO && null != batchQuerySkuPriceRspBO.getPrices() && batchQuerySkuPriceRspBO.getPrices().size() > 0) {
                result.setPrice((SkuPriceRspBO)batchQuerySkuPriceRspBO.getPrices().get(0));
            }
            QuerySkuSpecReqBO querySkuSpecReqBO = new QuerySkuSpecReqBO();
            querySkuSpecReqBO.setSkuId(sku.getSkuId());
            querySkuSpecReqBO.setSupplierId(sku.getSupplierId());
            QuerySkuSpecRspBO querySkuSpecRspBO = this.querySkuSpecBusiService.querySkuSpec(querySkuSpecReqBO);
            if (null != querySkuSpecRspBO && null != querySkuSpecRspBO.getSpecs()) {
                result.setSpecs(querySkuSpecRspBO.getSpecs());
            }
            QuerySkuPicReqBO querySkuPicReqBO = new QuerySkuPicReqBO();
            querySkuPicReqBO.setSkuId(sku.getSkuId());
            querySkuPicReqBO.setSupplierId(sku.getSupplierId());
            QuerySkuPicRspBO querySkuPicRspBO = this.querySkuPicBusiService.querySkuPic(querySkuPicReqBO);
            if (null != querySkuPicRspBO && null != querySkuPicRspBO.getPictures()) {
                result.setPictures(querySkuPicRspBO.getPictures());
            }
            QuerySkuDetailReqBO queryAttach = new QuerySkuDetailReqBO();
            if (null != querySkuDetailReqBO.getSkuPrice()) {
                if (null != sku.getBrandName() && "\u82f9\u679c".equals(sku.getBrandName())) {
                    queryAttach.setSkuPriceLong(Constant.ATTACH_SKU_PRICE_158);
                } else if (QuerySkuDetailBusiServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "0.000") > 0 && QuerySkuDetailBusiServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "1000.000") <= 0) {
                    queryAttach.setSkuPriceLong(Constant.ATTACH_SKU_PRICE_30);
                } else if (QuerySkuDetailBusiServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "1000.000") > 0 && QuerySkuDetailBusiServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "2000.000") <= 0) {
                    queryAttach.setSkuPriceLong(Constant.ATTACH_SKU_PRICE_34);
                } else if (QuerySkuDetailBusiServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "2000.000") > 0 && QuerySkuDetailBusiServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "3000.000") <= 0) {
                    queryAttach.setSkuPriceLong(Constant.ATTACH_SKU_PRICE_49);
                } else if (QuerySkuDetailBusiServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "3000.000") > 0 && QuerySkuDetailBusiServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "4000.000") <= 0) {
                    queryAttach.setSkuPriceLong(Constant.ATTACH_SKU_PRICE_64);
                } else if (QuerySkuDetailBusiServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "4000.000") > 0 && QuerySkuDetailBusiServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "100000.000") <= 0) {
                    queryAttach.setSkuPriceLong(Constant.ATTACH_SKU_PRICE_79);
                }
            }
            queryAttach.setSkuId(sku.getSkuId());
            queryAttach.setSupplierId(sku.getSupplierId());
            List<AttachSkuBusiBO> attach = this.queryAttachSku(queryAttach);
            result.setAttachedSkus(attach);
        }
        catch (Exception e) {
            logger.error("\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    private static int compareDecimal(String str1, String str2) {
        BigDecimal bigDecimal1 = new BigDecimal(str1);
        BigDecimal bigDecimal2 = new BigDecimal(str2);
        int i = bigDecimal1.compareTo(bigDecimal2);
        return i;
    }

    private List<AttachSkuBusiBO> queryAttachSku(QuerySkuDetailReqBO querySkuDetailReqBO) {
        logger.info("\u67e5\u8be2\u9644\u5c5e\u5355\u54c1\u4fe1\u606f\u5165\u53c2\uff1a" + querySkuDetailReqBO.toString());
        if (querySkuDetailReqBO.getSkuId() == null || querySkuDetailReqBO.getSupplierId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9644\u5c5e\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u4e3b\u5355\u54c1Id[skuId]\u548c\u95e8\u5e97Id[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<AttachSkuBusiBO> rspList = new ArrayList<AttachSkuBusiBO>();
        try {
            List<Object> skuBOList = new ArrayList();
            Sku reqSku = new Sku();
            reqSku.setSupplierId(querySkuDetailReqBO.getSupplierId());
            if (null != querySkuDetailReqBO.getSkuPriceLong()) {
                reqSku.setAttachFlag("1");
                reqSku.setAttachType("01");
                reqSku.setSkuPrice(querySkuDetailReqBO.getSkuPriceLong());
                skuBOList = this.skuMapper.qryAttachSkuByRecord(reqSku);
            } else {
                reqSku.setSkuId(querySkuDetailReqBO.getSkuId());
                skuBOList = this.skuMapper.qrySkuByMainSkuId(reqSku);
            }
            HashMap map = new HashMap();
            if (null != skuBOList) {
                for (SkuBusiBO skuBusiBO : skuBOList) {
                    if (null != skuBusiBO.getSkuPrice()) {
                        skuBusiBO.setSkuPriceDecimal(MoneyUtils.Long2BigDecimal((Long)skuBusiBO.getSkuPrice()));
                    }
                    if (map.containsKey(skuBusiBO.getAttachType())) {
                        ((List)map.get(skuBusiBO.getAttachType())).add(skuBusiBO);
                        continue;
                    }
                    ArrayList<SkuBusiBO> boList = new ArrayList<SkuBusiBO>();
                    boList.add(skuBusiBO);
                    map.put(skuBusiBO.getAttachType(), boList);
                }
            }
            if (null != map) {
                for (Map.Entry entry : map.entrySet()) {
                    AttachSkuBusiBO attachBusi = new AttachSkuBusiBO();
                    attachBusi.setAttachedType((String)entry.getKey());
                    attachBusi.setAttachedSkuList((List)entry.getValue());
                    if ("01".equals(entry.getKey())) {
                        attachBusi.setAttachedTypeName("\u788e\u5c4f\u4fdd");
                    } else if ("02".equals(entry.getKey())) {
                        attachBusi.setAttachedTypeName("\u5ef6\u4fdd");
                    }
                    rspList.add(attachBusi);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u9644\u5c5e\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519", (Throwable)e);
            throw new BusinessException("\u9644\u5c5e\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519", e.getMessage());
        }
        return rspList;
    }
}

