/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.spec.impl;

import com.ohaotian.commodity.busi.sku.bo.SkuSpecBO;
import com.ohaotian.commodity.busi.spec.QuerySkuSpecBusiService;
import com.ohaotian.commodity.busi.spec.bo.QuerySkuSpecReqBO;
import com.ohaotian.commodity.busi.spec.bo.QuerySkuSpecRspBO;
import com.ohaotian.commodity.dao.SkuSpecMapper;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="querySkuSpecBusiService")
@Qualifier
public class QuerySkuSpecBusiServiceImpl
implements QuerySkuSpecBusiService {
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuSpecBusiServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuSpecMapper skuSpecMapper;

    public QuerySkuSpecRspBO querySkuSpec(QuerySkuSpecReqBO querySkuSpecReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5355\u54c1\u89c4\u683c\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)querySkuSpecReqBO.toString());
        }
        QuerySkuSpecRspBO querySkuSpecRspBO = new QuerySkuSpecRspBO();
        try {
            HashMap<String, Object> skuIdAndSupplierId = new HashMap<String, Object>();
            skuIdAndSupplierId.put("skuId", querySkuSpecReqBO.getSkuId());
            skuIdAndSupplierId.put("supplierId", querySkuSpecReqBO.getSupplierId());
            List<Object> skuSpecs = new ArrayList();
            skuSpecs = this.skuSpecMapper.selectSpecBySkuIdAndSupplierId(skuIdAndSupplierId);
            ArrayList skuSpecBOS = new ArrayList();
            if (CollectionUtils.isNotEmpty(skuSpecs)) {
                skuSpecs.forEach(item -> {
                    SkuSpecBO skuSpecBO = new SkuSpecBO();
                    BeanUtils.copyProperties((Object)item, (Object)skuSpecBO);
                    skuSpecBOS.add(skuSpecBO);
                });
            }
            querySkuSpecRspBO.setSpecs(skuSpecBOS);
        }
        catch (Exception e) {
            logger.error("\u5355\u54c1\u89c4\u683c\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5355\u54c1\u89c4\u683c\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        return querySkuSpecRspBO;
    }
}

