/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.web.Impl;

import com.ohaotian.commodity.busi.manage.market.extend.QueryCatalogNameService;
import com.ohaotian.commodity.busi.measure.impl.QueryMeasureServiceImpl;
import com.ohaotian.commodity.busi.web.QueryOnOffShelveElecSkuService;
import com.ohaotian.commodity.busi.web.bo.QueryOnOffShelveElecSkuReqBO;
import com.ohaotian.commodity.busi.web.bo.QueryOnOffShelveElecSkuRspBO;
import com.ohaotian.commodity.dao.CommodityTypeMapper;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="queryOnOffShelveElecSkuService")
public class QueryOnOffShelveElecSkuServiceImpl
implements QueryOnOffShelveElecSkuService {
    private static final Logger logger = LoggerFactory.getLogger(QueryMeasureServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private CommodityTypeMapper commodityTypeMapper;
    @Autowired
    private QueryCatalogNameService queryCatalogNameService;

    public RspPageBO<QueryOnOffShelveElecSkuRspBO> queryOnOffShelveElecSku(QueryOnOffShelveElecSkuReqBO qsReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u7535\u5b50\u8d85\u5e02\u5df2\u4e0a\u67b6\u5546\u54c1\u5217\u8868\u5165\u53c2\uff1a" + qsReqBO.toString());
        }
        RspPageBO rspPageBO = new RspPageBO();
        ArrayList<QueryOnOffShelveElecSkuRspBO> qsRspBO = new ArrayList<QueryOnOffShelveElecSkuRspBO>();
        List<Long> commodityTypeids = null;
        Page page = new Page(qsReqBO.getPageNo(), qsReqBO.getPageSize());
        try {
            Long catalogId = qsReqBO.getCatalogId();
            if (catalogId != null) {
                commodityTypeids = this.commodityTypeMapper.selectCommodityType((long)catalogId);
            }
            qsReqBO.setCommodityTypeids(commodityTypeids);
            List<Sku> skuList = this.skuMapper.queryOnOffShelveElecSku((Page<Sku>)page, qsReqBO);
            ArrayList<Long> catalogIdList = new ArrayList<Long>();
            if (skuList != null && skuList.size() > 0) {
                for (Sku sku : skuList) {
                    catalogIdList.add(sku.getCommodityTypeId());
                }
                Map<Long, String> typeName = this.queryCatalogNameService.queryMdmCatalogMapByCommodityTypeId(catalogIdList);
                for (Sku sku : skuList) {
                    QueryOnOffShelveElecSkuRspBO bo = new QueryOnOffShelveElecSkuRspBO();
                    String str = typeName.get(sku.getCommodityTypeId());
                    bo.setCommodityTypeName(str);
                    bo.setSkuName(sku.getSkuName());
                    if (catalogId != null) {
                        bo.setCatalogId(catalogId);
                    }
                    bo.setBrandName(sku.getBrandName());
                    bo.setSupplierName(sku.getSupplierName());
                    bo.setSkuStatus(sku.getSkuStatus());
                    bo.setSkuId(sku.getSkuId());
                    bo.setExtSkuId(sku.getExtSkuId());
                    bo.setDiscountRate(sku.getDiscountRate());
                    bo.setSupplierId(sku.getSupplierId());
                    if (qsReqBO.getSkuStatus() != null) {
                        if (qsReqBO.getSkuStatus() == 2) {
                            bo.setOnApproveTime(sku.getUpdateTime());
                        }
                        if (qsReqBO.getSkuStatus() == 4 || qsReqBO.getSkuStatus() == 5) {
                            bo.setOffApproveTime(sku.getUpdateTime());
                        }
                    }
                    if (sku.getMarketPrice() != null) {
                        bo.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)sku.getMarketPrice()));
                    }
                    if (sku.getAgreementPrice() != null) {
                        bo.setAgrPrice(MoneyUtils.Long2BigDecimal((Long)sku.getAgreementPrice()));
                    }
                    bo.setCreateTime(sku.getCreateTime());
                    qsRspBO.add(bo);
                }
                rspPageBO.setRespCode("0000");
                rspPageBO.setRespDesc("\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7535\u5b50\u8d85\u5e02\u5df2\u4e0a\u67b6\u5546\u54c1\u5217\u8868\u670d\u52a1\u51fa\u9519", (Throwable)e);
            rspPageBO.setRespCode("8888");
            rspPageBO.setRespDesc("\u5931\u8d25");
        }
        rspPageBO.setPageNo(qsReqBO.getPageNo());
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setRows(qsRspBO);
        rspPageBO.setTotal(page.getTotalPages());
        return rspPageBO;
    }
}

