/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.measure.impl;

import com.gd.commodity.dao.CommodityMeasureMapper;
import com.gd.commodity.po.CommodityMeasure;
import com.ohaotian.commodity.busi.measure.bo.QueryMeasureReqBO;
import com.ohaotian.commodity.busi.measure.bo.QueryMeasureRspBO;
import com.ohaotian.commodity.busi.measure.web.QueryMeasureService;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="queryMeasureService")
public class QueryMeasureServiceImpl
implements QueryMeasureService {
    private static final Logger logger = LoggerFactory.getLogger(QueryMeasureServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private CommodityMeasureMapper commodityMeasureMapper;

    public RspPageBO<QueryMeasureRspBO> queryMeasures(QueryMeasureReqBO queryMeasureReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5206\u9875\u67e5\u8be2\u8ba1\u91cf\u5355\u4f4d\u5165\u53c2\uff1a" + queryMeasureReqBO.toString());
        }
        RspPageBO rspPage = new RspPageBO();
        ArrayList<QueryMeasureRspBO> commodityMeasureBo = new ArrayList<QueryMeasureRspBO>();
        if (null == queryMeasureReqBO.getPageNo()) {
            queryMeasureReqBO.setPageNo(Integer.valueOf(1));
        }
        if (null == queryMeasureReqBO.getPageSize()) {
            queryMeasureReqBO.setPageSize(Integer.valueOf(10));
        }
        Page page = new Page(queryMeasureReqBO.getPageNo().intValue(), queryMeasureReqBO.getPageSize().intValue());
        try {
            List<CommodityMeasure> commodityMeasureList = this.commodityMeasureMapper.qryCommodityMeasureByPage((Page<CommodityMeasure>)page, queryMeasureReqBO.getQryText());
            for (CommodityMeasure value : commodityMeasureList) {
                QueryMeasureRspBO bo = new QueryMeasureRspBO();
                bo.setMeasureId(value.getMeasureId());
                bo.setConvertRatio(value.getConvertRatio());
                bo.setMeasureName(value.getMeasureName());
                bo.setSubMeasureId(value.getCreateLoginId());
                bo.setMeasureType(value.getMeasureType().intValue());
                commodityMeasureBo.add(bo);
            }
            rspPage.setRespCode("0000");
            rspPage.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u5206\u9875\u67e5\u8be2\u8ba1\u91cf\u5355\u4f4d\u51fa\u9519", (Throwable)e);
            rspPage.setRespCode("8888");
            rspPage.setRespDesc("\u5931\u8d25");
        }
        rspPage.setPageNo(queryMeasureReqBO.getPageNo().intValue());
        rspPage.setRecordsTotal(page.getTotalCount());
        rspPage.setRows(commodityMeasureBo);
        rspPage.setTotal(page.getTotalPages());
        return rspPage;
    }
}

