/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.intfce.handshow.impl;

import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.util.HttpRequestUtils;
import com.cgd.common.exception.BusinessException;
import com.ohaotian.commodity.busi.sku.bo.SkuAndPriceBO;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.commodity.intfce.handshow.ElectronicPricePushBusiService;
import com.ohaotian.commodity.intfce.handshow.bo.HandShowGoodBO;
import com.ohaotian.commodity.intfce.handshow.bo.QuerySkuAndPriceReqBO;
import com.ohaotian.commodity.intfce.handshow.bo.QuerySkuAndPriceRspBO;
import com.ohaotian.plugin.common.util.MoneyUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="electronicPricePushBusiService")
public class ElectronicPricePushBusiServiceImpl
implements ElectronicPricePushBusiService {
    private static final Logger logger = LoggerFactory.getLogger(ElectronicPricePushBusiServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private Properties prop;
    @Autowired
    private SkuMapper skuMapper;

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public QuerySkuAndPriceRspBO electronicPricePush(List<SkuAndPriceBO> skuList) {
        QuerySkuAndPriceRspBO result = new QuerySkuAndPriceRspBO();
        if (this.isDebugEnabled) {
            logger.error("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u5bf9\u63a5\u6761\u6570\uff1a" + skuList.size());
        }
        try {
            HashMap supplierMap = new HashMap();
            for (SkuAndPriceBO skuAndPriceBO : skuList) {
                HandShowGoodBO good = this.skuToGood(skuAndPriceBO);
                good.setQrCode(this.prop.getProperty("qrcode.prefix") + "supplierId=" + skuAndPriceBO.getSupplierId() + "&skuId=" + skuAndPriceBO.getSkuId() + "&deviceSource=" + Constant.ELEC_DEVICE_SOURCE);
                if (supplierMap.containsKey(skuAndPriceBO.getSupplierId())) {
                    ((List)supplierMap.get(skuAndPriceBO.getSupplierId())).add(good);
                    continue;
                }
                ArrayList<HandShowGoodBO> list = new ArrayList<HandShowGoodBO>();
                list.add(good);
                supplierMap.put(skuAndPriceBO.getSupplierId(), list);
            }
            logger.error("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u5bf9\u63a5\u95e8\u5e97\uff1a" + supplierMap);
            for (Map.Entry entry : supplierMap.entrySet()) {
                List items = (List)entry.getValue();
                if (null == items || items.size() <= 0) continue;
                int pointsDataLimit = 10000;
                Integer size = items.size();
                if (pointsDataLimit < size) {
                    boolean flag = false;
                    int part = size / pointsDataLimit;
                    for (int i = 0; i < part; ++i) {
                        List<HandShowGoodBO> listPage = items.subList(0, pointsDataLimit);
                        JSONObject rsp = this.integration((Long)entry.getKey(), listPage);
                        if (rsp != null && "1".equals(rsp.getString("resultCode")) && "no permission".equals(rsp.getString("message"))) {
                            flag = true;
                            logger.debug("\u7535\u5b50\u4ef7\u7b7e\u4e0b\u6ca1\u6709\u8be5\u95e8\u5e97----" + entry.getKey());
                            continue;
                        }
                        if (null == rsp || !"0".equals(rsp.getString("resultCode")) && !"1".equals(rsp.getString("resultCode"))) {
                            logger.error("\u95e8\u5e97" + entry.getKey() + "\u7b2c" + i + "\u6279\u540c\u6b65\u5931\u8d25");
                            throw new BusinessException("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u51fa\u9519" + rsp);
                        }
                        items.subList(0, pointsDataLimit).clear();
                    }
                    if (flag || items.isEmpty()) continue;
                    JSONObject rsp = this.integration((Long)entry.getKey(), items);
                    if (rsp != null && "1".equals(rsp.getString("resultCode")) && "no permission".equals(rsp.getString("message"))) {
                        logger.debug("\u7535\u5b50\u4ef7\u7b7e\u4e0b\u6ca1\u6709\u8be5\u95e8\u5e97----" + entry.getKey());
                        continue;
                    }
                    if (null != rsp && ("0".equals(rsp.getString("resultCode")) || "1".equals(rsp.getString("resultCode")))) continue;
                    logger.error("\u95e8\u5e97" + entry.getKey() + "\u6279\u540c\u6b65\u5931\u8d25");
                    throw new BusinessException("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u51fa\u9519" + rsp);
                }
                JSONObject rsp = this.integration((Long)entry.getKey(), items);
                if (rsp != null && "1".equals(rsp.getString("resultCode")) && "no permission".equals(rsp.getString("message"))) {
                    logger.debug("\u7535\u5b50\u4ef7\u7b7e\u4e0b\u6ca1\u6709\u8be5\u95e8\u5e97----" + entry.getKey());
                    continue;
                }
                if (null != rsp && ("0".equals(rsp.getString("resultCode")) || "1".equals(rsp.getString("resultCode")))) continue;
                logger.error("\u95e8\u5e97" + entry.getKey() + "\u540c\u6b65\u5931\u8d25");
                throw new BusinessException("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u51fa\u9519" + rsp);
            }
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u51fa\u9519" + e);
            throw new BusinessException("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u51fa\u9519", (Throwable)e);
        }
        result.setCode("0000");
        result.setMessage("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public JSONObject integration(Long supplierId, List<HandShowGoodBO> goodList) {
        JSONObject rspJson = new JSONObject();
        try {
            logger.error("\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u5f00\u59cb");
            JSONObject param = new JSONObject();
            param.put((Object)"storeCode", (Object)supplierId);
            param.put((Object)"customerStoreCode", (Object)supplierId);
            param.put((Object)"batchSize", (Object)goodList.size());
            String batchNo = "newretail" + System.currentTimeMillis() + (int)((Math.random() * 9.0 + 1.0) * 10000.0);
            param.put((Object)"batchNo", (Object)batchNo);
            JSONArray array = JSONArray.fromObject(goodList);
            param.put((Object)"items", (Object)array);
            String postUrl = this.prop.getProperty("electronic.price.integration");
            logger.error("\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3url:" + postUrl);
            logger.error("\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3param:" + param.toString());
            String postStr = HttpRequestUtils.httpPost(postUrl.toString(), param);
            logger.error("\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u8fd4\u56de:" + postStr);
            rspJson = JSONObject.fromObject((Object)postStr.toString());
        }
        catch (Exception e) {
            throw new BusinessException("\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u9519\u8bef", (Throwable)e);
        }
        return rspJson;
    }

    public QuerySkuAndPriceRspBO puhSku(QuerySkuAndPriceReqBO reqBO) {
        QuerySkuAndPriceRspBO result = new QuerySkuAndPriceRspBO();
        logger.error("\u6839\u636e\u6761\u4ef6\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u5165\u53c2\uff1a" + reqBO.toString());
        try {
            Sku reqSku = new Sku();
            reqSku.setSkuName(reqBO.getSkuName());
            reqSku.setSupplierId(reqBO.getSupplierId());
            ArrayList<Long> skuIds = new ArrayList<Long>();
            if (null != reqBO.getSkuIds() && reqBO.getSkuIds().size() > 0) {
                skuIds = reqBO.getSkuIds();
            } else if (null != reqBO.getSkuId()) {
                skuIds.add(reqBO.getSkuId());
            }
            List<Object> skuAndPriceBOList = new ArrayList();
            try {
                skuAndPriceBOList = this.skuMapper.qrySkuAndPriceByRecord(reqSku, skuIds);
            }
            catch (Exception e) {
                logger.error("\u6839\u636e\u6761\u4ef6\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519\uff1a\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u51fa\u9519" + e.getMessage());
                throw new BusinessException("\u6839\u636e\u6761\u4ef6\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519\uff1a\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u51fa\u9519", (Throwable)e);
            }
            if (null != skuAndPriceBOList && skuAndPriceBOList.size() > 0) {
                this.electronicPricePush(skuAndPriceBOList);
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u6761\u4ef6\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519\uff1a" + e.getMessage());
            throw new BusinessException("\u6839\u636e\u6761\u4ef6\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519\uff1a", (Throwable)e);
        }
        result.setCode("0000");
        result.setMessage("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    private HandShowGoodBO skuToGood(SkuAndPriceBO sku) {
        HandShowGoodBO good = new HandShowGoodBO();
        good.setSku(String.valueOf(sku.getSkuId()));
        good.setCustomerStoreCode(String.valueOf(sku.getSupplierId()));
        good.setItemName(sku.getSkuLongName());
        if (null != sku.getSkuPriceTagName()) {
            good.setItemShortName(sku.getSkuPriceTagName());
        } else {
            good.setItemShortName(sku.getSkuName());
        }
        try {
            if (null != sku.getSalePrice()) {
                good.setPrice1(MoneyUtils.Long2BigDecimal((Long)sku.getSalePrice()));
            }
            if (null != sku.getAgreementPrice()) {
                good.setPrice4(MoneyUtils.Long2BigDecimal((Long)sku.getAgreementPrice()));
                good.setPrice4Description("\u534f\u8bae\u4ef7");
            }
            if (null != sku.getMemberPrice()) {
                good.setPrice3(MoneyUtils.Long2BigDecimal((Long)sku.getMemberPrice()));
                good.setPrice3Description("\u4f1a\u5458\u4ef7");
            }
            if (null != sku.getMarketPrice()) {
                good.setPrice5(MoneyUtils.Long2BigDecimal((Long)sku.getMarketPrice()));
                good.setPrice5Description("\u5e02\u573a\u4ef7");
            }
        }
        catch (Exception e) {
            logger.error("\u5355\u54c1\u4ef7\u683c\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", new String[]{"\u5355\u54c1\u4ef7\u683c\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25"});
        }
        good.setEan(String.valueOf(sku.getSkuId()));
        good.setBrand(sku.getBrandName());
        good.setDescription(sku.getRemark());
        good.setSupprlierCode(String.valueOf(sku.getVendorId()));
        good.setSupplierName(sku.getVendorName());
        good.setRsrvTxt1(sku.getPriceTagTemp());
        return good;
    }
}

