/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.price.impl;

import com.ohaotian.commodity.busi.price.BatchQuerySkuPriceBusiService;
import com.ohaotian.commodity.busi.price.bo.BatchQuerySkuPriceReqBO;
import com.ohaotian.commodity.busi.price.bo.BatchQuerySkuPriceRspBO;
import com.ohaotian.commodity.busi.sku.bo.SkuPriceRspBO;
import com.ohaotian.commodity.dao.SkuPriceMapper;
import com.ohaotian.commodity.dao.po.SkuPrice;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="batchQuerySkuPriceBusiService")
@Qualifier
public class BatchQuerySkuPriceBusiServiceImpl
implements BatchQuerySkuPriceBusiService {
    private static final Logger logger = LoggerFactory.getLogger(BatchQuerySkuPriceBusiServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private final SkuPriceMapper skuPriceMapper;

    @Autowired
    public BatchQuerySkuPriceBusiServiceImpl(SkuPriceMapper skuPriceMapper) {
        Assert.notNull((Object)skuPriceMapper, (String)"SkuPriceMapper\u4e0d\u80fd\u4e3a\u7a7a");
        this.skuPriceMapper = skuPriceMapper;
    }

    public BatchQuerySkuPriceRspBO batchQuerySkuPrice(BatchQuerySkuPriceReqBO batchQuerySkuPriceReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5355\u54c1\u4ef7\u683c\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + batchQuerySkuPriceReqBO.toString());
        }
        BatchQuerySkuPriceRspBO rspBO = new BatchQuerySkuPriceRspBO();
        try {
            List<SkuPrice> skuPrices = this.skuPriceMapper.selectBySkuIdsAndSupplierId(batchQuerySkuPriceReqBO.getSkuIds(), batchQuerySkuPriceReqBO.getSupplierId());
            ArrayList<SkuPriceRspBO> skuPriceBOS = new ArrayList<SkuPriceRspBO>();
            for (SkuPrice price : skuPrices) {
                SkuPriceRspBO skuPriceBO = new SkuPriceRspBO();
                logger.debug("\u67e5\u8be2\u4ef7\u683c\u7ed3\u679c" + price);
                BeanUtils.copyProperties((Object)price, (Object)skuPriceBO);
                if (price.getMarketPrice() != null) {
                    skuPriceBO.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)price.getMarketPrice()));
                }
                if (price.getCostPrice() != null) {
                    skuPriceBO.setCostPrice(MoneyUtils.Long2BigDecimal((Long)price.getCostPrice()));
                }
                if (price.getAgreementPrice() != null) {
                    skuPriceBO.setAgreementPrice(MoneyUtils.Long2BigDecimal((Long)price.getAgreementPrice()));
                }
                if (price.getCostPrice() != null) {
                    skuPriceBO.setAgreementPrice(MoneyUtils.Long2BigDecimal((Long)price.getCostPrice()));
                }
                if (price.getMemberPrice() != null) {
                    skuPriceBO.setMemberPrice(MoneyUtils.Long2BigDecimal((Long)price.getMemberPrice()));
                }
                if (price.getSalePrice() != null) {
                    skuPriceBO.setSalePriceL(price.getSalePrice());
                    skuPriceBO.setSalePrice(MoneyUtils.Long2BigDecimal((Long)price.getSalePrice()));
                }
                if (price.getSparePrice1() != null) {
                    skuPriceBO.setSparePrice1(MoneyUtils.Long2BigDecimal((Long)price.getSparePrice1()));
                }
                if (price.getSparePrice2() != null) {
                    skuPriceBO.setSparePrice2(MoneyUtils.Long2BigDecimal((Long)price.getSparePrice2()));
                }
                if (price.getAssessmentPrice() != null) {
                    skuPriceBO.setAssessmentPrice(MoneyUtils.Long2BigDecimal((Long)price.getAssessmentPrice()));
                }
                if (price.getPurchasePrice() != null) {
                    skuPriceBO.setPurchasePriceL(price.getPurchasePrice());
                    skuPriceBO.setPurchasePrice(MoneyUtils.Long2BigDecimal((Long)price.getPurchasePrice()));
                }
                if (price.getMemberLadderPrice1() != null) {
                    skuPriceBO.setMemberLadderPrice1(MoneyUtils.Long2BigDecimal((Long)price.getMemberLadderPrice1()));
                }
                if (price.getMemberLadderPrice2() != null) {
                    skuPriceBO.setMemberLadderPrice2(MoneyUtils.Long2BigDecimal((Long)price.getMemberLadderPrice2()));
                }
                if (price.getMemberLadderPrice3() != null) {
                    skuPriceBO.setMemberLadderPrice3(MoneyUtils.Long2BigDecimal((Long)price.getMemberLadderPrice3()));
                }
                if (price.getMemberLadderPrice4() != null) {
                    skuPriceBO.setMemberLadderPrice4(MoneyUtils.Long2BigDecimal((Long)price.getMemberLadderPrice4()));
                }
                if (price.getMemberLadderPrice5() != null) {
                    skuPriceBO.setMemberLadderPrice5(MoneyUtils.Long2BigDecimal((Long)price.getMemberLadderPrice5()));
                }
                skuPriceBOS.add(skuPriceBO);
            }
            rspBO.setPrices(skuPriceBOS);
        }
        catch (Exception e) {
            logger.error("\u5355\u54c1\u4ef7\u683c\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5355\u54c1\u4ef7\u683c\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        return rspBO;
    }
}

