/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.commodity.busi.OnShelfOrRejectSkuService;
import com.cgd.commodity.busi.bo.BusiOnShelfOrRejectSkuReqBO;
import com.cgd.commodity.busi.bo.BusiOnShelfOrRejectSkuRspBO;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.intfce.bo.CreateApproveConsumerReqBO;
import com.cgd.commodity.intfce.bo.SkuStatuChangeLogConsumerReqBO;
import com.cgd.commodity.intfce.vo.CreateApproveConsumerReqVO;
import com.cgd.commodity.intfce.vo.SkuStatuChangeLogConsumerVO;
import com.cgd.commodity.util.RandomGUIDUtil;
import com.ohaotian.commodity.config.TopicConfig;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnShelfOrRejectSkuServiceImpl
implements OnShelfOrRejectSkuService {
    private static final Logger logger = LoggerFactory.getLogger(OnShelfOrRejectSkuServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    @Resource
    private TopicConfig topicConfig;
    @Resource(name="createApproveLogProducer")
    private ProxyMessageProducer createApproveLogProducer;
    @Resource(name="skuStateChangeLogProducer")
    private ProxyMessageProducer skuStateChangeLogProducer;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public BusiOnShelfOrRejectSkuRspBO updateSkuOnShelfOrReject(BusiOnShelfOrRejectSkuReqBO busiOnShelfOrRejectSkuReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiOnShelfOrRejectSkuReqBO.toString());
        }
        if (null == busiOnShelfOrRejectSkuReqBO.getOperatorId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u64cd\u4f5c\u4ebaID[operatorId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiOnShelfOrRejectSkuReqBO.getOperateType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u64cd\u4f5c\u7c7b\u578b[operateType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiOnShelfOrRejectSkuReqBO.getOperatorName()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u64cd\u4f5c\u4eba\u540d\u79f0[operatorName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiOnShelfOrRejectSkuReqBO.getSku()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u4e1a\u52a1\u670d\u52a1sku\u96c6\u5408[skus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Boolean result = false;
            if (Constant.SKU_ONSHELF.equals(busiOnShelfOrRejectSkuReqBO.getOperateType())) {
                result = this.updateSkuSate(busiOnShelfOrRejectSkuReqBO, Constant.SKU_STATUS_SHELVED, Constant.SKU_ONSHELF);
                if (result.booleanValue()) {
                    this.sendMsg(busiOnShelfOrRejectSkuReqBO, Constant.SKU_STATUS_SHELVED, true);
                } else {
                    this.sendMsg(busiOnShelfOrRejectSkuReqBO, Constant.SKU_STATUS_SHELVED, false);
                }
            }
            if (Constant.SKU_REJECT.equals(busiOnShelfOrRejectSkuReqBO.getOperateType())) {
                result = this.updateSkuSate(busiOnShelfOrRejectSkuReqBO, Constant.SKU_STATUS_BACKED, Constant.SKU_REJECT);
                if (result.booleanValue()) {
                    this.sendMsg(busiOnShelfOrRejectSkuReqBO, Constant.SKU_STATUS_BACKED, true);
                } else {
                    this.sendMsg(busiOnShelfOrRejectSkuReqBO, Constant.SKU_STATUS_BACKED, false);
                }
            }
            BusiOnShelfOrRejectSkuRspBO busiOnShelfOrRejectSkuRspBO = new BusiOnShelfOrRejectSkuRspBO();
            if (result.booleanValue()) {
                busiOnShelfOrRejectSkuRspBO.setIsSuccess(Boolean.valueOf(true));
            } else {
                busiOnShelfOrRejectSkuRspBO.setIsSuccess(Boolean.valueOf(false));
                busiOnShelfOrRejectSkuRspBO.setResultMsg("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u6267\u884csku\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
            }
            return busiOnShelfOrRejectSkuRspBO;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private Boolean updateSkuSate(BusiOnShelfOrRejectSkuReqBO busiOnShelfOrRejectSkuReqBO, Integer skuState, Integer flag) {
        try {
            this.skuMapper.updateSkuStateBatchBySkuId(skuState, flag, busiOnShelfOrRejectSkuReqBO.getOperatorId(), busiOnShelfOrRejectSkuReqBO.getSku());
            return true;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u6279\u91cf\u66f4\u65b0sku\u72b6\u6001\u5931\u8d25" + e);
            return false;
        }
    }

    private void sendMsg(BusiOnShelfOrRejectSkuReqBO busiOnShelfOrRejectSkuReqBO, Integer skuState, Boolean flag) {
        ArrayList<Long> skuIds;
        try {
            SkuStatuChangeLogConsumerReqBO skuStatuChangeLogConsumerReqBO = new SkuStatuChangeLogConsumerReqBO();
            skuStatuChangeLogConsumerReqBO.setOperatorId(busiOnShelfOrRejectSkuReqBO.getOperatorId());
            skuStatuChangeLogConsumerReqBO.setPreState(Constant.SKU_STATUS_SHELVEING);
            skuStatuChangeLogConsumerReqBO.setCreateTime(new Date());
            skuStatuChangeLogConsumerReqBO.setRandomStr(RandomGUIDUtil.getRandomGUID());
            if (flag.booleanValue()) {
                skuStatuChangeLogConsumerReqBO.setPostState(skuState);
                skuStatuChangeLogConsumerReqBO.setApproveComments("\u66f4\u65b0\u6210\u529f");
            } else {
                skuStatuChangeLogConsumerReqBO.setPostState(Constant.SKU_STATUS_SHELVEING);
                skuStatuChangeLogConsumerReqBO.setApproveComments("\u66f4\u65b0\u5931\u8d25");
            }
            SkuStatuChangeLogConsumerVO skuStatuChangeLogConsumerVO = new SkuStatuChangeLogConsumerVO();
            skuIds = new ArrayList<Long>();
            for (Long skuId : busiOnShelfOrRejectSkuReqBO.getSku().getSkuIds()) {
                skuIds.add(skuId);
            }
            skuStatuChangeLogConsumerVO.setSkuIds(skuIds);
            skuStatuChangeLogConsumerVO.setSupplierId(busiOnShelfOrRejectSkuReqBO.getSku().getSupplierId());
            skuStatuChangeLogConsumerReqBO.setSku(skuStatuChangeLogConsumerVO);
            this.skuStateChangeLogProducer.sendOneway(new ProxyMessage(this.topicConfig.getSkuStateUpdateTopicName(), this.topicConfig.getSkuStateUpdateTagName(), JSONObject.toJSONString((Object)skuStatuChangeLogConsumerReqBO)));
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u53d1\u9001sku\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u5931\u8d25" + e);
        }
        try {
            CreateApproveConsumerReqBO createApproveConsumerReqBO = new CreateApproveConsumerReqBO();
            createApproveConsumerReqBO.setOperatorId(busiOnShelfOrRejectSkuReqBO.getOperatorId());
            createApproveConsumerReqBO.setComment(busiOnShelfOrRejectSkuReqBO.getComment());
            createApproveConsumerReqBO.setOperateType(busiOnShelfOrRejectSkuReqBO.getOperateType());
            createApproveConsumerReqBO.setRejectMsg(busiOnShelfOrRejectSkuReqBO.getRejectMsg());
            createApproveConsumerReqBO.setApproveSkuState(skuState);
            createApproveConsumerReqBO.setCreateTime(new Date());
            createApproveConsumerReqBO.setRandomStr(RandomGUIDUtil.getRandomGUID());
            CreateApproveConsumerReqVO createApproveConsumerReqVO = new CreateApproveConsumerReqVO();
            skuIds = new ArrayList();
            for (Long skuId : busiOnShelfOrRejectSkuReqBO.getSku().getSkuIds()) {
                skuIds.add(skuId);
            }
            createApproveConsumerReqVO.setSkuIds(skuIds);
            createApproveConsumerReqVO.setSupplierId(busiOnShelfOrRejectSkuReqBO.getSku().getSupplierId());
            createApproveConsumerReqBO.setSku(createApproveConsumerReqVO);
            createApproveConsumerReqBO.setResultMsg(busiOnShelfOrRejectSkuReqBO.getRejectMsg());
            createApproveConsumerReqBO.setOperatorName(busiOnShelfOrRejectSkuReqBO.getOperatorName());
            if (flag.booleanValue()) {
                createApproveConsumerReqBO.setSuccess(Integer.valueOf(1));
            } else {
                createApproveConsumerReqBO.setSuccess(Integer.valueOf(0));
            }
            this.createApproveLogProducer.sendOneway(new ProxyMessage(this.topicConfig.getSkuApproveTopicName(), this.topicConfig.getSkuApproveTagName(), JSONObject.toJSONString((Object)createApproveConsumerReqBO)));
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u5ba1\u6279\u65e5\u5fd7\u65b0\u589e\u6d88\u606f\u5931\u8d25" + e);
        }
    }
}

