/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.manage.market.impl;

import com.ohaotian.commodity.busi.manage.market.ElecSkuStartWorkFlowService;
import com.ohaotian.commodity.busi.manage.market.bo.ElecSkuStartWorkFlowReqBO;
import com.ohaotian.commodity.busi.manage.market.impl.ElecSkuAuditServiceImpl;
import com.ohaotian.commodity.busi.manage.market.web.ElecSkuOffOrOnShelveService;
import com.ohaotian.commodity.busi.manage.market.web.bo.ElecSkuOffOrOnShelveReqBO;
import com.ohaotian.commodity.busi.manage.market.web.bo.ElecSkuOffOrOnShelveRspBO;
import com.ohaotian.commodity.common.exception.BusinessException;
import com.ohaotian.commodity.dao.CommodityTypeLevelMapper;
import com.ohaotian.commodity.dao.ElecSkuApproveLogMapper;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.po.ElecSkuApproveLogPO;
import com.ohaotian.commodity.dao.po.Sku;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="elecSkuOffOrOnShelveService")
public class ElecSkuOffOrOnShelveServiceImpl
implements ElecSkuOffOrOnShelveService {
    private static final Logger logger = LoggerFactory.getLogger(ElecSkuAuditServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private ElecSkuApproveLogMapper celecSkuApproveLogMapper;
    @Autowired
    private ElecSkuStartWorkFlowService elecSkuStartWorkFlowService;
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private CommodityTypeLevelMapper commodityTypeLevelMapper;

    public ElecSkuOffOrOnShelveRspBO skuOffOrOnShelve(ElecSkuOffOrOnShelveReqBO elecSkuOffOrOnShelveReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u4e0b\u67b6\u6216\u6062\u590d\u4e0a\u67b6\u670d\u52a1\u5165\u53c2:" + elecSkuOffOrOnShelveReqBO.toString());
        }
        if (elecSkuOffOrOnShelveReqBO.getOperateType() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53c2\u6570\u3010operateType\u3011\u5fc5\u586b");
        }
        if (elecSkuOffOrOnShelveReqBO.getSkuIds() == null || elecSkuOffOrOnShelveReqBO.getSkuIds().size() == 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53c2\u6570\u3010skuIds\u3011\u5fc5\u586b");
        }
        if (elecSkuOffOrOnShelveReqBO.getOperateContent() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u64cd\u4f5c\u539f\u56e0\u3010operateContent\u3011\u5fc5\u586b");
        }
        int skuStatus = -1;
        int approveType = -1;
        if (elecSkuOffOrOnShelveReqBO.getOperateType() == 0) {
            skuStatus = 2;
            approveType = 6;
        } else if (elecSkuOffOrOnShelveReqBO.getOperateType() == 1) {
            skuStatus = 5;
            approveType = 4;
        } else if (elecSkuOffOrOnShelveReqBO.getOperateType() == 2) {
            skuStatus = 1;
            approveType = 5;
        }
        this.skuMapper.updateSkuStateBatchByIds(elecSkuOffOrOnShelveReqBO.getSkuIds(), elecSkuOffOrOnShelveReqBO.getSupplierId(), 0L, skuStatus);
        List skuIds = elecSkuOffOrOnShelveReqBO.getSkuIds();
        ElecSkuOffOrOnShelveRspBO elecSkuOffOrOnShelveRspBO = new ElecSkuOffOrOnShelveRspBO();
        for (Long skuId : skuIds) {
            Object commodityTypeId;
            ElecSkuApproveLogPO celecSkuApproveLogPO = new ElecSkuApproveLogPO();
            celecSkuApproveLogPO.setCreateTime(new Date());
            celecSkuApproveLogPO.setSkuId(skuId);
            celecSkuApproveLogPO.setCreateLoginId(elecSkuOffOrOnShelveReqBO.getUserId());
            celecSkuApproveLogPO.setSupplierId(elecSkuOffOrOnShelveReqBO.getSupplierId());
            celecSkuApproveLogPO.setIsDelete(0);
            celecSkuApproveLogPO.setUpdateLoginId(elecSkuOffOrOnShelveReqBO.getUserId());
            celecSkuApproveLogPO.setUpdateTime(new Date());
            celecSkuApproveLogPO.setApprover(elecSkuOffOrOnShelveReqBO.getUserName());
            celecSkuApproveLogPO.setApproveType(approveType);
            celecSkuApproveLogPO.setOperateContent(elecSkuOffOrOnShelveReqBO.getOperateContent());
            if (null != elecSkuOffOrOnShelveReqBO.getAttachment()) {
                celecSkuApproveLogPO.setAttachment(elecSkuOffOrOnShelveReqBO.getAttachment());
            }
            this.celecSkuApproveLogMapper.insert(celecSkuApproveLogPO);
            if (elecSkuOffOrOnShelveReqBO.getOperateType() != 2) continue;
            List<Sku> skuList = this.skuMapper.querycommodityTypeBySkuid(skuIds);
            ArrayList<Long> listType = new ArrayList<Long>();
            for (Sku sku : skuList) {
                commodityTypeId = sku.getCommodityTypeId();
                listType.add((Long)commodityTypeId);
            }
            List<Integer> auditLevelList = this.commodityTypeLevelMapper.selectByCommodityTypeIds(listType);
            int i = 0;
            if (auditLevelList != null) {
                commodityTypeId = auditLevelList.iterator();
                while (commodityTypeId.hasNext()) {
                    int auditLevel = (Integer)commodityTypeId.next();
                    if (auditLevel != 2) continue;
                    i = 2;
                }
            }
            if (i != 2) {
                ElecSkuStartWorkFlowReqBO elecSkuStartWorkFlowReqBO = new ElecSkuStartWorkFlowReqBO();
                elecSkuStartWorkFlowReqBO.setAttachment(elecSkuOffOrOnShelveReqBO.getAttachment());
                elecSkuStartWorkFlowReqBO.setOperateContent(elecSkuOffOrOnShelveReqBO.getOperateContent());
                elecSkuStartWorkFlowReqBO.setOperType(elecSkuOffOrOnShelveReqBO.getOperateType());
                elecSkuStartWorkFlowReqBO.setSkuId(skuId);
                elecSkuStartWorkFlowReqBO.setUserId(elecSkuOffOrOnShelveReqBO.getUserId());
                elecSkuStartWorkFlowReqBO.setUserName(elecSkuOffOrOnShelveReqBO.getUserName());
                elecSkuStartWorkFlowReqBO.setSupplierId(elecSkuOffOrOnShelveReqBO.getSupplierId());
                this.elecSkuStartWorkFlowService.elecSkuStartWorkFlow(elecSkuStartWorkFlowReqBO);
                continue;
            }
            elecSkuOffOrOnShelveRspBO.setRespDesc("\u5546\u54c1\u5217\u8868\u4e2d\u542b\u6709\u5546\u54c1\u7c7b\u578b\u7b49\u7ea7\u4e3a\u3010\u4e0d\u53ef\u4ee5\u4e0a\u3011\u7684\u5546\u54c1");
            elecSkuOffOrOnShelveRspBO.setRespCode("8888");
            return elecSkuOffOrOnShelveRspBO;
        }
        elecSkuOffOrOnShelveRspBO.setRespCode("0000");
        elecSkuOffOrOnShelveRspBO.setRespDesc("\u6210\u529f");
        return elecSkuOffOrOnShelveRspBO;
    }
}

