/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.atom.spec.impl;

import com.ohaotian.commodity.atom.GenerateSkuSpecSeqService;
import com.ohaotian.commodity.atom.bo.GenerateSkuSpecSeqRspBO;
import com.ohaotian.commodity.atom.spec.InitSkuSpecAtomService;
import com.ohaotian.commodity.atom.spec.bo.SpecBO;
import com.ohaotian.commodity.busi.constant.Constant;
import com.ohaotian.commodity.dao.SkuSpecMapper;
import com.ohaotian.commodity.dao.po.SkuSpec;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Qualifier
public class InitSpecAtomServiceImpl
implements InitSkuSpecAtomService {
    private static final Logger logger = LoggerFactory.getLogger(InitSpecAtomServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private GenerateSkuSpecSeqService generateSkuSpecSeqService;
    @Autowired
    private SkuSpecMapper skuSpecMapper;

    public boolean initSkuSpec(List<SpecBO> specBOList) {
        Boolean success = false;
        try {
            if (!specBOList.isEmpty()) {
                ArrayList<SkuSpec> skuSpecs = new ArrayList<SkuSpec>();
                for (SpecBO specBO : specBOList) {
                    GenerateSkuSpecSeqRspBO generateSkuSpecRspBo = this.generateSkuSpecSeqService.generateSkuSpecSeq();
                    SkuSpec skuSpec = new SkuSpec();
                    BeanUtils.copyProperties((Object)specBO, (Object)skuSpec);
                    skuSpec.setSkuSpecId(generateSkuSpecRspBo.getSkuSpecId());
                    skuSpec.setCreateTime(new Date());
                    skuSpec.setIsDelete(Constant.IS_DELETE);
                    skuSpecs.add(skuSpec);
                }
                if (skuSpecs != null && skuSpecs.size() > 0) {
                    this.skuSpecMapper.insertSkuSpecBatch(skuSpecs);
                    success = true;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u5355\u54c1\u89c4\u683c\u539f\u5b50\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5355\u54c1\u89c4\u683c\u539f\u5b50\u670d\u52a1");
        }
        return success;
    }

    public boolean delSkuSpec(List<Long> skuIdList) {
        Boolean success = false;
        try {
            if (CollectionUtils.isNotEmpty(skuIdList)) {
                this.skuSpecMapper.delBySkuIdList(skuIdList);
                success = true;
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5355\u54c1\u89c4\u683c\u539f\u5b50\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException(null, "\u5220\u9664\u5355\u54c1\u89c4\u683c\u539f\u5b50\u670d\u52a1");
        }
        return success;
    }
}

