/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryOthLevelCommodityCatalogService;
import com.cgd.commodity.busi.bo.CatalogInfo;
import com.cgd.commodity.busi.bo.catalog.BusiQryCommodityCatalogReqBO;
import com.cgd.commodity.busi.bo.catalog.BusiQryCommodityCatalogRspBO;
import com.cgd.commodity.busi.bo.catalog.QryOthLevelCommodityCatalogRspBO;
import com.cgd.commodity.busi.impl.QryCommodityTypeServiceImpl;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class QryOthLevelCommodityCatalogServiceImpl
implements QryOthLevelCommodityCatalogService {
    private static final Logger logger = LoggerFactory.getLogger(QryCommodityTypeServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;
    @Value(value="${catalog.cache.enabled:1}")
    private int cacheEnabled;
    private static Map<String, RspPageBO<QryOthLevelCommodityCatalogRspBO>> map = new HashMap<String, RspPageBO<QryOthLevelCommodityCatalogRspBO>>();

    public RspPageBO<QryOthLevelCommodityCatalogRspBO> qryOthLevelBusiCommodityCatalog(BusiQryCommodityCatalogReqBO busiQryCommodityCatalogReqBO) {
        if (this.isDebugEnabled) {
            // empty if block
        }
        RspPageBO rsp = new RspPageBO();
        if (this.cacheEnabled == 1) {
            try {
                RspPageBO value;
                rsp = value = map.get(busiQryCommodityCatalogReqBO.getChannelId().toString() + "_" + busiQryCommodityCatalogReqBO.getUpperCatalogId().toString());
            }
            catch (Exception e) {
                logger.error(" \u7c7b\u76ee\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", " \u7c7b\u76ee\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
            }
        }
        try {
            RspPageBO value = new RspPageBO();
            List<CatalogInfo> catalogInfos = this.commodityGuideCatalogMapper.selectByUpperCatalogIdAndChannelId(busiQryCommodityCatalogReqBO.getUpperCatalogId(), busiQryCommodityCatalogReqBO.getChannelId());
            ArrayList<BusiQryCommodityCatalogRspBO> commodityCatalogRspBOS = new ArrayList<BusiQryCommodityCatalogRspBO>();
            for (CatalogInfo catalogInfo : catalogInfos) {
                BusiQryCommodityCatalogRspBO busiQryCommodityCatalogRspBO = new BusiQryCommodityCatalogRspBO();
                BeanUtils.copyProperties((Object)catalogInfo, (Object)busiQryCommodityCatalogRspBO);
                commodityCatalogRspBOS.add(busiQryCommodityCatalogRspBO);
            }
            ArrayList<QryOthLevelCommodityCatalogRspBO> qryOthLevelCommodityCatalogRspBOS = new ArrayList<QryOthLevelCommodityCatalogRspBO>();
            QryOthLevelCommodityCatalogRspBO qryOthLevelCommodityCatalogRspBO = new QryOthLevelCommodityCatalogRspBO();
            qryOthLevelCommodityCatalogRspBO.setRows(commodityCatalogRspBOS);
            qryOthLevelCommodityCatalogRspBOS.add(qryOthLevelCommodityCatalogRspBO);
            value.setRows(qryOthLevelCommodityCatalogRspBOS);
            rsp = value;
        }
        catch (Exception e) {
            logger.error(" \u7c7b\u76ee\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", " \u7c7b\u76ee\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    public Map<String, RspPageBO<QryOthLevelCommodityCatalogRspBO>> getMap() {
        return map;
    }

    public void setMap(Map<String, RspPageBO<QryOthLevelCommodityCatalogRspBO>> map) {
        QryOthLevelCommodityCatalogServiceImpl.map = map;
    }
}

