/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.custom.search.impl;

import com.ohaotian.commodity.custom.search.SearchEsQueryXlsService;
import com.ohaotian.commodity.custom.search.bo.SearchEsQueryRspBO;
import com.ohaotian.commodity.custom.search.bo.SearchEsSQLXlsRspBO;
import javax.annotation.Resource;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Qualifier
public class SearchEsQueryXlsServiceImpl
implements SearchEsQueryXlsService {
    private static final Logger logger = LoggerFactory.getLogger(SearchEsQueryXlsServiceImpl.class);
    @Resource
    private TransportClient client;
    @Value(value="${es.sku.index.name}")
    private String skuIndexName;
    @Value(value="${es.sku.type.name}")
    private String skuTypeName;

    public SearchEsQueryRspBO executeSQLXls(SearchEsSQLXlsRspBO searchEsSQLXlsRspBO) {
        SearchEsQueryRspBO searchBarEsQueryRspVO = null;
        try {
            searchBarEsQueryRspVO = new SearchEsQueryRspBO();
            Integer pageNo = 0;
            Integer pageSize = 10;
            if (searchEsSQLXlsRspBO.getPageNo() != null && searchEsSQLXlsRspBO.getPageNo() > 0) {
                pageNo = searchEsSQLXlsRspBO.getPageNo() - 1;
            }
            if (searchEsSQLXlsRspBO.getPageSize() != null && searchEsSQLXlsRspBO.getPageSize() > 0) {
                pageSize = searchEsSQLXlsRspBO.getPageSize();
            }
            if (searchEsSQLXlsRspBO.getSortQuery() != null) {
                SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{this.skuIndexName}).setTypes(new String[]{this.skuTypeName}).setQuery((QueryBuilder)searchEsSQLXlsRspBO.getBoolQueryBuilder()).highlighter(searchEsSQLXlsRspBO.getHighlightBuilder()).setCollapse(searchEsSQLXlsRspBO.getCollapseBuilder()).addSort((SortBuilder)searchEsSQLXlsRspBO.getSortQuery()).setFrom(pageNo * pageSize).setSize(pageSize.intValue()).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"groupby").field("material_id")).size(100).subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)"material").sort("create_time", SortOrder.DESC).size(1))).addAggregation((AggregationBuilder)AggregationBuilders.terms((String)"group_by_supplier_id_name").field("supplier_id_name")).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_brand_id_name").field("brand_id_name")).size(2000)).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_l3_category_id_name").field("l3_category_id_name")).size(2000)).get();
                logger.debug(searchResponse.toString());
                searchBarEsQueryRspVO.setSearchResponse(searchResponse);
            } else {
                SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{this.skuIndexName}).setTypes(new String[]{this.skuTypeName}).setQuery((QueryBuilder)searchEsSQLXlsRspBO.getBoolQueryBuilder()).highlighter(searchEsSQLXlsRspBO.getHighlightBuilder()).setCollapse(searchEsSQLXlsRspBO.getCollapseBuilder()).setFrom(pageNo * pageSize).setSize(pageSize.intValue()).addAggregation((AggregationBuilder)AggregationBuilders.terms((String)"group_by_supplier_id_name").field("supplier_id_name")).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_brand_id_name").field("brand_id_name")).size(2000)).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_l3_category_id_name").field("l3_category_id_name")).size(2000)).get();
                logger.debug(searchResponse.toString());
                searchBarEsQueryRspVO.setSearchResponse(searchResponse);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return searchBarEsQueryRspVO;
    }
}

