/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.intfce.impl;

import com.cgd.commodity.busi.OnShelfOrRejectSkuService;
import com.cgd.commodity.busi.bo.BusiOnShelfOrRejectSkuReqBO;
import com.cgd.commodity.busi.bo.BusiOnShelfOrRejectSkuRspBO;
import com.cgd.commodity.busi.vo.OnShelfOrRejectSkuReqVO;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.intfce.OnShelfOrRejectSkuBatchService;
import com.cgd.commodity.intfce.bo.OnShelfOrRejectSkuBatchReqBO;
import com.cgd.commodity.intfce.bo.OnShelfOrRejectSkuBatchRspBO;
import com.cgd.commodity.po.Sku;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnShelfOrRejectSkuBatchServiceImpl
implements OnShelfOrRejectSkuBatchService {
    private static final Logger logger = LoggerFactory.getLogger(OnShelfOrRejectSkuBatchServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private static final int BATCH_NUM = 200;
    private static final String SUPPLIER_FLAG = "SUPPLIER_";
    private OnShelfOrRejectSkuService onShelfOrRejectSkuService;
    private SkuMapper skuMapper;

    public void setOnShelfOrRejectSkuService(OnShelfOrRejectSkuService onShelfOrRejectSkuService) {
        this.onShelfOrRejectSkuService = onShelfOrRejectSkuService;
    }

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public OnShelfOrRejectSkuBatchRspBO onShelfOrRejectBatchSku(OnShelfOrRejectSkuBatchReqBO onShelfOrRejectSkuBatchReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u63a5\u53e3\u670d\u52a1\u5165\u53c2\uff1a" + onShelfOrRejectSkuBatchReqBO.toString());
        }
        if (null == onShelfOrRejectSkuBatchReqBO.getOperateType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u63a5\u53e3\u670d\u52a1\u64cd\u4f5c\u7c7b\u578b[operateType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (onShelfOrRejectSkuBatchReqBO.getSkus().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u63a5\u53e3\u670d\u52a1sku\u96c6\u5408[skus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int totalCount = 0;
        int successCount = 0;
        int errorCount = 0;
        if (!onShelfOrRejectSkuBatchReqBO.getSkus().isEmpty()) {
            Map<String, OnShelfOrRejectSkuReqVO> onShelfOrRejectSkuReqVOMap = this.splitReqList(onShelfOrRejectSkuBatchReqBO);
            Boolean stateResult = this.isHasNotMatchState(onShelfOrRejectSkuReqVOMap);
            if (!stateResult.booleanValue()) {
                throw new BusinessException("RSP_CODE_SKU_STATE_ERROR", "\u6240\u9009\u5546\u54c1\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8bf7\u8fd4\u56de\u91cd\u65b0\u9009\u62e9");
            }
            try {
                for (Map.Entry<String, OnShelfOrRejectSkuReqVO> map : onShelfOrRejectSkuReqVOMap.entrySet()) {
                    totalCount += map.getValue().getSkuIds().size();
                    try {
                        Boolean result = this.callOnShelfOrRejectSkuService(onShelfOrRejectSkuBatchReqBO, map.getValue());
                        if (result.booleanValue()) {
                            successCount += map.getValue().getSkuIds().size();
                            continue;
                        }
                        errorCount += map.getValue().getSkuIds().size();
                    }
                    catch (Exception e) {
                        logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u63a5\u53e3\u670d\u52a1\u6267\u884c\u5546\u54c1\u72b6\u6001\u53d8\u66f4\u51fa\u9519\uff1a" + e);
                        errorCount += map.getValue().getSkuIds().size();
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u63a5\u53e3\u670d\u52a1\u5931\u8d25:" + e);
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u63a5\u53e3\u670d\u52a1\u5931\u8d25");
            }
        }
        OnShelfOrRejectSkuBatchRspBO onShelfOrRejectSkuBatchRspBO = new OnShelfOrRejectSkuBatchRspBO();
        onShelfOrRejectSkuBatchRspBO.setTotalCount(Integer.valueOf(totalCount));
        onShelfOrRejectSkuBatchRspBO.setSuccessCount(Integer.valueOf(successCount));
        onShelfOrRejectSkuBatchRspBO.setErrorCount(Integer.valueOf(errorCount));
        return onShelfOrRejectSkuBatchRspBO;
    }

    private Map<String, OnShelfOrRejectSkuReqVO> splitReqList(OnShelfOrRejectSkuBatchReqBO onShelfOrRejectSkuBatchReqBO) {
        HashMap<String, OnShelfOrRejectSkuReqVO> onShelfOrRejectSkuReqVOMap = new HashMap<String, OnShelfOrRejectSkuReqVO>();
        List skus = onShelfOrRejectSkuBatchReqBO.getSkus();
        for (OnShelfOrRejectSkuReqVO sku : skus) {
            int skuIdSize = sku.getSkuIds().size();
            if (skuIdSize <= 200) {
                onShelfOrRejectSkuReqVOMap.put(SUPPLIER_FLAG + sku.getSupplierId(), sku);
                continue;
            }
            int listCount = 0;
            for (int i = 0; i < skuIdSize; i += 200) {
                OnShelfOrRejectSkuReqVO newSku;
                List newSkuIds;
                if (i + 200 < skuIdSize) {
                    newSkuIds = sku.getSkuIds().subList(i, i + 200);
                    newSku = new OnShelfOrRejectSkuReqVO();
                    newSku.setSkuIds(newSkuIds);
                    newSku.setSupplierId(sku.getSupplierId());
                    onShelfOrRejectSkuReqVOMap.put(SUPPLIER_FLAG + sku.getSupplierId() + "_" + listCount, newSku);
                } else {
                    newSkuIds = sku.getSkuIds().subList(i, skuIdSize);
                    newSku = new OnShelfOrRejectSkuReqVO();
                    newSku.setSkuIds(newSkuIds);
                    newSku.setSupplierId(sku.getSupplierId());
                    onShelfOrRejectSkuReqVOMap.put(SUPPLIER_FLAG + sku.getSupplierId() + "_" + listCount, newSku);
                }
                ++listCount;
            }
        }
        return onShelfOrRejectSkuReqVOMap;
    }

    private Boolean callOnShelfOrRejectSkuService(OnShelfOrRejectSkuBatchReqBO onShelfOrRejectSkuBatchReqBO, OnShelfOrRejectSkuReqVO onShelfOrRejectSkuReqVO) {
        BusiOnShelfOrRejectSkuReqBO busiOnShelfOrRejectSkuReqBO = new BusiOnShelfOrRejectSkuReqBO();
        busiOnShelfOrRejectSkuReqBO.setOperatorId(onShelfOrRejectSkuBatchReqBO.getUserId());
        busiOnShelfOrRejectSkuReqBO.setOperateType(onShelfOrRejectSkuBatchReqBO.getOperateType());
        busiOnShelfOrRejectSkuReqBO.setRejectMsg(onShelfOrRejectSkuBatchReqBO.getRejectMsg());
        busiOnShelfOrRejectSkuReqBO.setComment(onShelfOrRejectSkuBatchReqBO.getComment());
        busiOnShelfOrRejectSkuReqBO.setSku(onShelfOrRejectSkuReqVO);
        busiOnShelfOrRejectSkuReqBO.setOperatorName(onShelfOrRejectSkuBatchReqBO.getUserName());
        BusiOnShelfOrRejectSkuRspBO busiOnShelfOrRejectSkuRspBO = this.onShelfOrRejectSkuService.updateSkuOnShelfOrReject(busiOnShelfOrRejectSkuReqBO);
        if ("0000".equals(busiOnShelfOrRejectSkuRspBO.getRespCode())) {
            if (busiOnShelfOrRejectSkuRspBO.getIsSuccess().booleanValue()) {
                return true;
            }
            return false;
        }
        if (this.isDebugEnabled) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u63a5\u53e3\u670d\u52a1\u8c03\u7528\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + busiOnShelfOrRejectSkuRspBO.getRespDesc());
        }
        throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u63a5\u53e3\u670d\u52a1\u8c03\u7528\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
    }

    private Boolean isHasNotMatchState(Map<String, OnShelfOrRejectSkuReqVO> onShelfOrRejectSkuReqVOMap) {
        ArrayList<Sku> skus = new ArrayList<Sku>();
        int count = 0;
        for (Map.Entry<String, OnShelfOrRejectSkuReqVO> map : onShelfOrRejectSkuReqVOMap.entrySet()) {
            count += map.getValue().getSkuIds().size();
            try {
                skus.addAll(this.skuMapper.selectByIdAndState(map.getValue().getSupplierId(), Constant.SKU_STATUS_SHELVEING, map.getValue().getSkuIds()));
            }
            catch (Exception e) {
                logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u63a5\u53e3\u670d\u52a1\u67e5\u8be2\u7b26\u5408\u72b6\u6001\u8981\u6c42\u7684\u5355\u54c1\u51fa\u9519\uff1a" + e);
                return false;
            }
        }
        if (count == skus.size()) {
            return true;
        }
        return false;
    }
}

