/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.atom.picture.impl;

import com.ohaotian.commodity.atom.GenerateSkuPicSeqService;
import com.ohaotian.commodity.atom.bo.GenerateSkuPicSeqRspBO;
import com.ohaotian.commodity.atom.picture.InitSkuPictureAtomService;
import com.ohaotian.commodity.atom.picture.bo.PictureBO;
import com.ohaotian.commodity.busi.constant.Constant;
import com.ohaotian.commodity.dao.SkuPicMapper;
import com.ohaotian.commodity.dao.po.SkuPic;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Qualifier
public class InitSkuPictureAtomServiceImpl
implements InitSkuPictureAtomService {
    private static final Logger logger = LoggerFactory.getLogger(InitSkuPictureAtomServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private GenerateSkuPicSeqService generateSkuPicSeqService;
    @Autowired
    private SkuPicMapper skuPicMapper;

    public boolean initSkuPicture(List<PictureBO> pictureBOList) {
        if (this.isDebugEnabled) {
            logger.debug("\u521d\u59cb\u5316\u5355\u54c1\u56fe\u7247\u539f\u5b50\u670d\u52a1\u6267\u884c");
        }
        boolean success = false;
        try {
            if (!pictureBOList.isEmpty()) {
                ArrayList<SkuPic> skuPics = new ArrayList<SkuPic>();
                for (PictureBO pictureBO : pictureBOList) {
                    GenerateSkuPicSeqRspBO generateSkuPicSeqRspBO = this.generateSkuPicSeqService.generateSkuPicSeq();
                    SkuPic skuPic = new SkuPic();
                    BeanUtils.copyProperties((Object)pictureBO, (Object)skuPic);
                    skuPic.setSkuPicId(generateSkuPicSeqRspBO.getSkuPicId());
                    skuPic.setCreateTime(new Date());
                    skuPic.setIsDelete(Constant.IS_DELETE);
                    skuPics.add(skuPic);
                    if (null == skuPic.getPicOrder()) {
                        skuPic.setPicOrder(0);
                    }
                    if (null != skuPic.getIsPrimary()) continue;
                    skuPic.setIsPrimary(0);
                }
                if (skuPics != null) {
                    this.skuPicMapper.insertSkuPicBatch(skuPics);
                    success = true;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u5355\u54c1\u56fe\u7247\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u521d\u59cb\u5316\u5355\u54c1\u56fe\u7247\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
        }
        return success;
    }
}

