/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.qghb.lyhzq.webtier;

import com.chinaunicom.qghb.lyhzq.webtier.InvokeInfo;
import com.chinaunicom.qghb.lyhzq.webtier.ParamInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.haotian.remote.ProxyXmlWebApplicationContext;
import com.haotian.remote.RemoteInvokeService;
import com.haotian.remote.RemoteInvokeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/"})
public class RestController
implements ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, InvokeInfo> beanStore = new HashMap<String, InvokeInfo>();
    private final ThreadLocal<ObjectMapper> objectMapperThreadLocal = new ThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            return new ObjectMapper();
        }
    };
    private RemoteInvokeService remoteInvokeService;

    private boolean isPrimitiveWrapper(Class<?> paramType) {
        if (this.isVoidType(paramType)) {
            return true;
        }
        if (this.isShortType(paramType)) {
            return true;
        }
        if (this.isIntegerType(paramType)) {
            return true;
        }
        if (this.isLongType(paramType)) {
            return true;
        }
        if (this.isBooleanType(paramType)) {
            return true;
        }
        if (this.isFloatType(paramType)) {
            return true;
        }
        if (this.isDoubleType(paramType)) {
            return true;
        }
        return this.isStringType(paramType);
    }

    private boolean isStringType(Class<?> paramType) {
        return String.class == paramType;
    }

    private boolean isDoubleType(Class<?> paramType) {
        return Double.class == paramType || Double.class.getSimpleName().equalsIgnoreCase(paramType.getName());
    }

    private boolean isFloatType(Class<?> paramType) {
        return Float.class == paramType || Float.class.getSimpleName().equalsIgnoreCase(paramType.getName());
    }

    private boolean isBooleanType(Class<?> paramType) {
        return Boolean.class == paramType || Boolean.class.getSimpleName().equalsIgnoreCase(paramType.getName());
    }

    private boolean isLongType(Class<?> paramType) {
        return Long.class == paramType || Long.class.getSimpleName().equalsIgnoreCase(paramType.getName());
    }

    private boolean isIntegerType(Class<?> paramType) {
        return Integer.class == paramType || "int".equals(paramType.getName());
    }

    private boolean isShortType(Class<?> paramType) {
        return Short.class == paramType || Short.class.getSimpleName().equalsIgnoreCase(paramType.getName());
    }

    private boolean isVoidType(Class<?> paramType) {
        return Void.class == paramType || Void.class.getSimpleName().equalsIgnoreCase(paramType.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"invoke"})
    @ResponseBody
    public Object invoke(HttpServletRequest request, String service) {
        ParamInfo paramInfo;
        int i;
        String[] parameterNames;
        Object result = null;
        InvokeInfo invokeInfo = this.beanStore.get(service);
        Method method = invokeInfo.getMethod();
        if (!invokeInfo.isParsed() && (parameterNames = this.remoteInvokeService.getParameterNames(invokeInfo.getRemoteInvokeKey())) != null && parameterNames.length == invokeInfo.getParamInfoList().size()) {
            List<ParamInfo> paramInfoList = invokeInfo.getParamInfoList();
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (i = 0; i < parameterNames.length; ++i) {
                paramInfo = paramInfoList.get(i);
                paramInfo.setParamName(parameterNames[i]);
                paramInfo.setParamType(parameterTypes[i]);
            }
            invokeInfo.setParsed(true);
        }
        List<ParamInfo> paramInfoList = invokeInfo.getParamInfoList();
        Object[] commands = new Object[paramInfoList.size()];
        boolean isJson = "application/json".equals(request.getContentType()) || "text/json".equals(request.getContentType());
        for (i = 0; i < commands.length; ++i) {
            paramInfo = paramInfoList.get(i);
            Object command = null;
            Class<?> paramType = paramInfo.getParamType();
            if (this.isPrimitiveWrapper(paramType)) {
                if (isJson) {
                    throw new IllegalArgumentException("Unsupported json invoke for primitive for[" + this.getInvokeTargetName(invokeInfo) + "]");
                }
                String value = request.getParameter(paramInfo.getParamName());
                if (this.isIntegerType(paramType)) {
                    command = Integer.valueOf(value);
                } else if (this.isBooleanType(paramType)) {
                    command = Boolean.valueOf(value);
                } else if (this.isLongType(paramType)) {
                    command = Long.valueOf(value);
                } else if (this.isDoubleType(paramType)) {
                    command = Double.valueOf(value);
                } else if (this.isVoidType(paramType)) {
                    command = null;
                } else if (this.isFloatType(paramType)) {
                    command = Float.valueOf(value);
                } else if (this.isShortType(paramType)) {
                    command = Short.valueOf(value);
                } else {
                    if (!this.isStringType(paramType)) throw new IllegalArgumentException("Unsupported parameterType[" + paramType.getName() + "] for [" + this.getInvokeTargetName(invokeInfo) + "]");
                    command = value;
                }
            } else {
                if (isJson) {
                    ServletInputStream jsonInputStream = null;
                    try {
                        jsonInputStream = request.getInputStream();
                        command = this.objectMapperThreadLocal.get().readValue((InputStream)jsonInputStream, paramType);
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException("Bind param[" + paramType.getName() + "] for [" + this.getInvokeTargetName(invokeInfo) + "] error", e);
                    }
                    finally {
                        if (jsonInputStream != null) {
                            try {
                                jsonInputStream.close();
                            }
                            catch (IOException e) {
                                this.logger.error("Close bind inputstream for param[" + paramType.getName() + "] for [" + this.getInvokeTargetName(invokeInfo) + "] error", (Throwable)e);
                            }
                        }
                    }
                }
                try {
                    command = paramType.newInstance();
                }
                catch (Throwable e) {
                    throw new UnsupportedOperationException("Init parameterType[" + paramType.getName() + "] for [" + this.getInvokeTargetName(invokeInfo) + "] error", e);
                }
                ServletRequestDataBinder binder = new ServletRequestDataBinder(command);
                binder.bind((ServletRequest)request);
                command = binder.getTarget();
            }
            commands[i] = command;
        }
        try {
            return method.invoke(invokeInfo.getBean(), commands);
        }
        catch (Throwable e) {
            throw new RuntimeException("Invoke [" + this.getInvokeTargetName(invokeInfo) + "] error", e);
        }
    }

    private String getInvokeTargetName(InvokeInfo invokeInfo) {
        return invokeInfo.getBean().getClass().getName() + "." + invokeInfo.getMethod().getName();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        HashMap<String, Object> consumerStore = new HashMap<String, Object>();
        try {
            Resource[] resources;
            for (Resource resource : resources = applicationContext.getResources("classpath*:proxy-remote-consumer.xml")) {
                SAXReader reader = new SAXReader();
                InputStream ins = resource.getInputStream();
                Document document = reader.read(ins);
                ins.close();
                String consumerName = ProxyXmlWebApplicationContext.getRemoteStrategy().equals("DUBBO") ? "reference" : "consumer";
                List consumers = document.getRootElement().elements(consumerName);
                for (Object consumer : consumers) {
                    String consumerId = consumer.attributeValue("id");
                    String consumerInterface = consumer.attributeValue("interface");
                    Method[] consumerGroup = consumer.attributeValue("group");
                    String consumerVersion = consumer.attributeValue("version");
                    Object consumerBean = applicationContext.getBean(consumerId);
                    if (consumerBean == null) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("find spring bean[" + consumerInterface + ":" + (String)consumerGroup + ":" + consumerVersion + "]");
                    }
                    consumerStore.put(consumerInterface + ":" + (String)consumerGroup + ":" + consumerVersion, consumerBean);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("init consumer invoke error:", e);
        }
        Resource resource = applicationContext.getResource("classpath:/init.json");
        ObjectMapper om = new ObjectMapper();
        try {
            InputStream ins = resource.getInputStream();
            JsonNode initJson = om.readTree(ins);
            Iterator beanList = initJson.elements();
            while (beanList.hasNext()) {
                Object consumer;
                JsonNode bean = (JsonNode)beanList.next();
                String service = bean.get("service").asText();
                String consumerInterface = bean.get("service_name").asText();
                String consumerVersion = bean.get("service_version").asText();
                String consumerGroup = bean.get("group_name").asText();
                String consumerMethod = bean.get("method_name").asText();
                consumer = consumerStore.get(consumerInterface + ":" + consumerGroup + ":" + consumerVersion);
                if (consumer == null) {
                    throw new IllegalStateException("required invoke bean[" + consumerInterface + ":" + consumerGroup + ":" + consumerVersion + "] required method[" + consumerMethod + "]");
                }
                Method[] methods = Class.forName(consumerInterface).getMethods();
                Method targetMethod = null;
                for (Method method : methods) {
                    if (!method.getName().equals(consumerMethod)) continue;
                    targetMethod = method;
                    break;
                }
                if (targetMethod == null) {
                    throw new IllegalStateException("invoke bean[" + consumerInterface + ":" + consumerGroup + ":" + consumerVersion + "] required method[" + consumerMethod + "]");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("find invoke bean[" + consumerInterface + ":" + consumerGroup + ":" + consumerVersion + "]");
                }
                InvokeInfo invokeInfo = new InvokeInfo();
                invokeInfo.setBean(consumer);
                invokeInfo.setMethod(targetMethod);
                Class<?>[] parameterTypes = targetMethod.getParameterTypes();
                ArrayList<ParamInfo> paramInfoList = new ArrayList<ParamInfo>();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    ParamInfo paramInfo = new ParamInfo();
                    paramInfo.setParamType(parameterTypes[i]);
                    paramInfoList.add(paramInfo);
                }
                invokeInfo.setParamInfoList(paramInfoList);
                invokeInfo.setRemoteInvokeKey(RemoteInvokeUtils.getRemoteKey((String)consumerInterface, (String)consumerMethod, (String)consumerGroup, (String)consumerVersion));
                this.beanStore.put(service, invokeInfo);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("init consumer service error:", e);
        }
    }

    public void setRemoteInvokeService(RemoteInvokeService remoteInvokeService) {
        this.remoteInvokeService = remoteInvokeService;
    }
}

