/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.atom.api.AgrApproveCreationAtomService;
import com.tydic.agreement.atom.api.AgrCheckAgreementExistAndStatusAtomService;
import com.tydic.agreement.atom.bo.AgrApproveCreationAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCheckAgreementExistAndStatusAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCheckAgreementExistAndStatusAtomRspBO;
import com.tydic.agreement.busi.api.AgrAgreementSubmitBusiService;
import com.tydic.agreement.busi.api.AgrGeneralBusiRuleExecService;
import com.tydic.agreement.busi.bo.AgrAgreementSubmitBusiReqBO;
import com.tydic.agreement.busi.bo.AgrAgreementSubmitBusiRspBO;
import com.tydic.agreement.busi.bo.AgrGeneralBusiRuleExecReqBO;
import com.tydic.agreement.busi.bo.AgrGeneralBusiRuleExecRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.consumer.bo.AgrPushAddBO;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.cfc.ability.api.CfcQryCommodityAtuoMappingAbilityService;
import com.tydic.cfc.ability.bo.CfcQryCommodityAtuoMappingAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryCommodityAtuoMappingAbilityRspBO;
import com.tydic.commodity.common.ability.api.UccEbsMaterialAddAbilityService;
import com.tydic.commodity.common.ability.api.UccEbsMaterialEditAbilityService;
import com.tydic.commodity.common.ability.api.UccEbsMaterialListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialAddAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialAddAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialEditAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialEditAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialListQryAbilityRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="agrAgreementSubmitBusiService")
public class AgrAgreementSubmitBusiServiceImpl
implements AgrAgreementSubmitBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgreementSubmitBusiServiceImpl.class);
    private static final String CFC_AUTO_MAPPING_STATUS = "1";
    private static final Integer UCC_MATERIAL_RELATED = 1;
    private static final Integer UCC_MATERIAL_NOT_RELATED = 0;
    @Autowired
    private CfcQryCommodityAtuoMappingAbilityService cfcQryCommodityAtuoMappingAbilityService;
    @Autowired
    private UccEbsMaterialListQryAbilityService uccEbsMaterialListQryAbilityService;
    @Autowired
    private UccEbsMaterialAddAbilityService uccEbsMaterialAddAbilityService;
    @Autowired
    private UccEbsMaterialEditAbilityService uccEbsMaterialEditAbilityService;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgrCheckAgreementExistAndStatusAtomService agrCheckAgreementExistAndStatusAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Value(value="${AGR_PLATFORM_CREATE_AUDIT_FLOW:AGR_PLATFORM_CREATE_AUDIT_FLOW}")
    private String platformProcess;
    @Value(value="${AGR_UNIT_CREATE_AUDIT_FLOW:AGR_UNIT_CREATE_AUDIT_FLOW}")
    private String unitProcess;
    @Value(value="${SERVICE_CODE:AGR001}")
    private String SERVICE_CODE;
    @Value(value="${DEFAULT_VENDOR_NAME:\u96c6\u91c7\u5b9a\u5546\u4f9b\u5e94\u5546}")
    private String defaultVendorName;
    @Resource
    private AgrApproveCreationAtomService agrApproveCreationAtomService;
    @Autowired
    private AgrGeneralBusiRuleExecService agrGeneralBusiRuleExecService;
    @Value(value="${AUTO_CONFIRM_TOPIC:AUTO_CONFIRM_TOPIC}")
    private String autoConfirmMqTopic;
    @Value(value="${AUTO_CONFIRM_TAG:*}")
    private String autoConfirmMqTag;
    @Resource(name="autoConfirmMqServiceProvider")
    private ProxyMessageProducer autoConfirmMqServiceProvider;

    @Override
    public AgrAgreementSubmitBusiRspBO submitAgreementInfo(AgrAgreementSubmitBusiReqBO busiReqBO) {
        AgreementPO po;
        AgrAgreementSubmitBusiRspBO busiRspBO = new AgrAgreementSubmitBusiRspBO();
        AgrCheckAgreementExistAndStatusAtomReqBO atomReqBO = new AgrCheckAgreementExistAndStatusAtomReqBO();
        atomReqBO.setAgreementId(busiReqBO.getAgreementId());
        atomReqBO.setSupplierId(busiReqBO.getSupplierId());
        AgrCheckAgreementExistAndStatusAtomRspBO atomRspBO = this.agrCheckAgreementExistAndStatusAtomService.checkAgreementExistAndStatus(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            BeanUtils.copyProperties((Object)((Object)atomRspBO), (Object)((Object)busiRspBO));
            return busiRspBO;
        }
        if (AgrCommConstant.AgrSaveOrSubmit.SUBMIT.equals(busiReqBO.getOperType())) {
            po = new AgreementPO();
            po.setSubmissionTime(new Date());
            po.setAgreementStatus(AgrCommConstant.AgreementStatus.TO_CONFIRM);
            this.createAuditNew(atomRspBO, busiReqBO);
            po.setAgreementId(busiReqBO.getAgreementId());
            po.setSupplierId(busiReqBO.getSupplierId());
            int count = this.agreementMapper.updateByCondition(po);
            if (count < 1) {
                throw new com.tydic.uac.exception.BusinessException("22005", "\u66f4\u65b0\u534f\u8bae\u72b6\u6001\u5931\u8d25");
            }
            AgreementPO agreementQryPo = new AgreementPO();
            agreementQryPo.setAgreementId(busiReqBO.getAgreementId());
            agreementQryPo.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            AgreementPO agreement = this.agreementMapper.getModelBy(agreementQryPo);
            if (this.defaultVendorName.equals(agreement.getVendorName())) {
                AgrPushAddBO agrPushAddBO = new AgrPushAddBO();
                agrPushAddBO.setId(agreement.getAgreementId());
                String content = JSON.toJSONString((Object)agrPushAddBO);
                log.info("\u53d1\u6d88\u606f\u96c6\u91c7\u4f9b\u5e94\u5546\u81ea\u52a8\u786e\u8ba4\u5165\u53c2\u4e3a" + JSON.toJSONString((Object)content));
                this.autoConfirmMqServiceProvider.send(new ProxyMessage(this.autoConfirmMqTopic, this.autoConfirmMqTag, content));
            }
        } else {
            po = new AgreementPO();
            po.setAgreementId(busiReqBO.getAgreementId());
            po.setAgreementStatus(AgrCommConstant.AgreementStatus.DRAFT);
            po.setSupplierId(busiReqBO.getSupplierId());
            po.setSubmissionTime(new Date());
            int n = this.agreementMapper.updateByCondition(po);
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u534f\u8bae\u63d0\u4ea4\u4fdd\u5b58\u6210\u529f");
        try {
            this.buildMaterialMapping(busiReqBO.getAgreementId());
        }
        catch (Exception e) {
            log.error("\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5efa\u7acb\u7269\u6599\u6620\u5c04\u5173\u7cfb\u4fe1\u606f\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return busiRspBO;
    }

    private void buildMaterialMapping(Long agreementId) {
        AgreementPO agreementQryPo = new AgreementPO();
        agreementQryPo.setAgreementId(agreementId);
        agreementQryPo.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementQryPo);
        if (agreement == null) {
            log.error("\u534f\u8bae\u4e0d\u5b58\u5728");
            return;
        }
        if (AgrCommConstant.agreementMode.UNIT_AGREEMENT.equals(agreement.getAgreementMode()) && ObjectUtil.isNotEmpty((Object)agreement.getAgreementBelongsId())) {
            CfcQryCommodityAtuoMappingAbilityReqBO cfcAutoMappingReqBO = new CfcQryCommodityAtuoMappingAbilityReqBO();
            cfcAutoMappingReqBO.setSysTenantId(agreement.getSysTenantId());
            cfcAutoMappingReqBO.setSecondId(Long.valueOf(agreement.getAgreementBelongsId()));
            CfcQryCommodityAtuoMappingAbilityRspBO cfcAutoMappingRspBO = this.cfcQryCommodityAtuoMappingAbilityService.qryCommodityAtuoMapping(cfcAutoMappingReqBO);
            log.info("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3{}\u81ea\u52a8\u6620\u5c04\u914d\u7f6e\u8fd4\u56de\uff1a{}", (Object)agreement.getAgreementBelongsId(), (Object)JSON.toJSONString((Object)cfcAutoMappingRspBO));
            if (!"0000".equals(cfcAutoMappingRspBO.getRespCode())) {
                log.warn("\u67e5\u8be2SP25\u534f\u8bae\u5546\u54c1\u81ea\u52a8\u6620\u5c04\u8bbe\u7f6e\u5931\u8d25");
                return;
            }
            if (!CFC_AUTO_MAPPING_STATUS.equals(cfcAutoMappingRspBO.getStatus())) {
                log.info("SP25\u534f\u8bae\u5546\u54c1\u81ea\u52a8\u6620\u5c04\u8bbe\u7f6e\u4e3a\u5173\u95ed\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u5efa\u7acb\u7269\u6599\u6620\u5c04\u5173\u7cfb\u4fe1\u606f\u3002");
                return;
            }
            AgreementSkuPO qrySkuPo = new AgreementSkuPO();
            qrySkuPo.setAgreementId(agreementId);
            List<AgreementSkuPO> agreementSkuPOs = this.agreementSkuMapper.getList(qrySkuPo);
            if (CollectionUtil.isEmpty(agreementSkuPOs)) {
                log.info("\u534f\u8bae\u660e\u7ec6\u4e3a\u7a7a\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u5efa\u7acb\u7269\u6599\u6620\u5c04\u5173\u7cfb\u4fe1\u606f\u3002");
                return;
            }
            if (CollectionUtil.isEmpty(agreementSkuPOs = agreementSkuPOs.stream().filter(bo -> StrUtil.isNotBlank((CharSequence)bo.getEbsMaterialCode())).collect(Collectors.toList()))) {
                log.info("\u8fc7\u6ee4\u534f\u8bae\u660e\u7ec6\u884c\u7684\u201c\u4e1a\u52a1\u5355\u4f4d\u7269\u8d44\u7f16\u7801\u201d\u5b57\u6bb5\u4e3a\u7a7a\u540e\uff0c\u534f\u8bae\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u5efa\u7acb\u7269\u6599\u6620\u5c04\u5173\u7cfb\u4fe1\u606f\u3002");
                return;
            }
            UccEbsMaterialListQryAbilityReqBO uccEbsMaterialQryReqBo = new UccEbsMaterialListQryAbilityReqBO();
            for (AgreementSkuPO agrSkuPo : agreementSkuPOs) {
                uccEbsMaterialQryReqBo.setEbsMaterialCode(agrSkuPo.getEbsMaterialCode());
                UccEbsMaterialListQryAbilityRspBO uccEbsMaterialQryRspBo = this.uccEbsMaterialListQryAbilityService.ebsMaterialQryList(uccEbsMaterialQryReqBo);
                if ("0000".equals(uccEbsMaterialQryRspBo.getRespCode())) {
                    if (uccEbsMaterialQryRspBo.getRecordsTotal() > 0) {
                        log.info("\u534f\u8bae\u660e\u7ec6\u4e2d\u7684\u201c\u4e1a\u52a1\u5355\u4f4d\u7269\u8d44\u7f16\u7801\u201d\u5b57\u6bb5\u5728\u7269\u6599\u5173\u7cfb\u6620\u5c04\u4fe1\u606f\u4e2d\u5df2\u5b58\u5728\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u5efa\u7acb\u7269\u6599\u6620\u5c04\u5173\u7cfb\u4fe1\u606f\u3002");
                        continue;
                    }
                    UccEbsMaterialAddAbilityReqBO uccEbsMaterialAddReqBo = new UccEbsMaterialAddAbilityReqBO();
                    UccEbsMaterialEditAbilityReqBO uccEbsMaterialEditReqBo = new UccEbsMaterialEditAbilityReqBO();
                    uccEbsMaterialAddReqBo.setEbsMaterialCode(agrSkuPo.getEbsMaterialCode());
                    uccEbsMaterialAddReqBo.setEbsMeasure(agrSkuPo.getMeasureName());
                    uccEbsMaterialAddReqBo.setEbsMaterialName(agrSkuPo.getMaterialName());
                    uccEbsMaterialAddReqBo.setEbsLongDesc(agrSkuPo.getMaterialName());
                    uccEbsMaterialAddReqBo.setEbsModel(agrSkuPo.getSpec() + "/" + agrSkuPo.getModel());
                    uccEbsMaterialAddReqBo.setBrandName(agrSkuPo.getBrandName());
                    uccEbsMaterialAddReqBo.setEbsInvalid("N");
                    uccEbsMaterialAddReqBo.setSysCode(agreement.getAgreementBelongsCode());
                    log.info("\u65b0\u589e\u7269\u6599\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uccEbsMaterialAddReqBo));
                    UccEbsMaterialAddAbilityRspBO uccEbsMaterialAddRspBo = this.uccEbsMaterialAddAbilityService.dealAddMaterialEdit(uccEbsMaterialAddReqBo);
                    log.info("\u65b0\u589e\u7269\u6599\u63a5\u53e3\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)uccEbsMaterialAddRspBo));
                    if (!"0000".equals(uccEbsMaterialAddRspBo.getRespCode())) {
                        log.warn("\u65b0\u589e\u5173\u8054\u7269\u6599[{}]\u5931\u8d25\uff1a{}", (Object)agrSkuPo.getEbsMaterialCode(), (Object)uccEbsMaterialAddRspBo.getRespDesc());
                        continue;
                    }
                    uccEbsMaterialEditReqBo.setEbsMaterialId(uccEbsMaterialAddRspBo.getEsbMaterialId());
                    uccEbsMaterialEditReqBo.setMaterialId(Long.valueOf(agrSkuPo.getMaterialId()));
                    uccEbsMaterialEditReqBo.setIsOut(Integer.valueOf(1));
                    log.info("\u5173\u8054\u7269\u6599\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uccEbsMaterialEditReqBo));
                    UccEbsMaterialEditAbilityRspBO uccEbsMaterialEditRspBO = this.uccEbsMaterialEditAbilityService.dealEbsMaterialEdit(uccEbsMaterialEditReqBo);
                    log.info("\u5173\u8054\u7269\u6599\u63a5\u53e3\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)uccEbsMaterialEditRspBO));
                    if (!"0000".equals(uccEbsMaterialEditRspBO.getRespCode())) {
                        log.warn("\u5173\u8054\u7269\u6599\u5173\u7cfb\u5931\u8d25\uff1a{}", (Object)uccEbsMaterialEditRspBO.getRespDesc());
                    }
                    log.info("\u7269\u6599{}-{}\u5173\u8054\u6210\u529f\u3002", (Object)agrSkuPo.getEbsMaterialCode(), (Object)agrSkuPo.getMaterialCode());
                    continue;
                }
                log.warn("\u8c03\u7528\u201c\u7269\u6599\u6620\u5c04\u5173\u7cfb\u7ef4\u62a4\u5217\u8868\u67e5\u8be2API\u201d\u5931\u8d25\uff0c\u65e0\u6cd5\u5224\u65ad\u4e1a\u52a1\u5355\u4f4d\u7684\u7269\u8d44\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u8fdb\u884c\u7269\u6599\u7f16\u7801\u6620\u5c04\u521b\u5efa\u3002");
            }
        } else {
            log.info("\u975e\u5355\u4f4d\u534f\u8bae\u6216\u534f\u8bae\u6240\u5c5eID\u4e3a\u7a7a\uff0c\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u4e0d\u6267\u884c\u5efa\u7acb\u7269\u6599\u6620\u5c04\u5173\u7cfb\u4fe1\u606f\u3002");
        }
    }

    private void createProcess(Long agreementId, AgrAgreementBO agrAgreementBO) {
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        approvalObjBO.setObjId(agreementId.toString());
        approvalObjInfo.add(approvalObjBO);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> uacNoTaskAuditCreateInfoReqBOs = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        uacNoTaskAuditCreateInfoReqBO.setObjNum(CFC_AUTO_MAPPING_STATUS);
        uacNoTaskAuditCreateInfoReqBO.setOrderId(agreementId);
        uacNoTaskAuditCreateInfoReqBO.setRemark("\u534f\u8bae\u65b0\u589e\u5ba1\u6279");
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateInfoReqBOs.add(uacNoTaskAuditCreateInfoReqBO);
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        if (AgrCommConstant.agreementMode.PLAT_AGREEMENT.equals(agrAgreementBO.getAgreementMode())) {
            uacNoTaskAuditCreateReqBO.setProcDefKey("agreementPlatAudit");
        } else if (AgrCommConstant.agreementMode.UNIT_AGREEMENT.equals(agrAgreementBO.getAgreementMode())) {
            uacNoTaskAuditCreateReqBO.setProcDefKey("agreementPurchaseAudit");
        }
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setCreateOperDept(agrAgreementBO.getVendorDepartmentName());
        uacNoTaskAuditCreateReqBO.setCreateOperId(agrAgreementBO.getProducerId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(agrAgreementBO.getProducerName());
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(uacNoTaskAuditCreateInfoReqBOs);
        log.error("\u5f00\u59cb\u8c03\u7528\u5ba1\u6279-----");
        log.error("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.error("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new com.tydic.uac.exception.BusinessException(uacNoTaskAuditCreateRspBO.getRespCode(), uacNoTaskAuditCreateRspBO.getRespDesc());
        }
    }

    public void createAuditNew(AgrCheckAgreementExistAndStatusAtomRspBO atomRspBO, AgrAgreementSubmitBusiReqBO busiReqBO) {
        AgrGeneralBusiRuleExecReqBO agrGeneralBusiRuleExecReqBO = new AgrGeneralBusiRuleExecReqBO();
        agrGeneralBusiRuleExecReqBO.setServiceCode(this.SERVICE_CODE);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("orgId", busiReqBO.getOrgId().toString());
        paramMap.put("approvalType", CFC_AUTO_MAPPING_STATUS);
        if (AgrCommConstant.agreementMode.PLAT_AGREEMENT.equals(atomRspBO.getAgrAgreementBO().getAgreementMode())) {
            paramMap.put("agreementMode", CFC_AUTO_MAPPING_STATUS);
        } else {
            paramMap.put("agreementMode", "2");
        }
        agrGeneralBusiRuleExecReqBO.setParamMap(paramMap);
        AgrGeneralBusiRuleExecRspBO agrGeneralBusiRuleExecRspBO = this.agrGeneralBusiRuleExecService.generalBusiRuleExec(agrGeneralBusiRuleExecReqBO);
        if (!"0000".equals(agrGeneralBusiRuleExecRspBO.getRespCode())) {
            throw new BusinessException("8888", agrGeneralBusiRuleExecRspBO.getRespDesc());
        }
        if (StringUtils.isEmpty((Object)agrGeneralBusiRuleExecRspBO.getBusiRuleExecResult())) {
            throw new BusinessException("8888", "\u89c4\u5219\u5f15\u64ce\u51fa\u53c2\u8fd4\u56de\u4e3a\u7a7a");
        }
        Map resultMap = (Map)JSON.parseObject((String)agrGeneralBusiRuleExecRspBO.getBusiRuleExecResult(), Map.class);
        if (!resultMap.containsKey("processKey") || StringUtils.isEmpty(resultMap.get("processKey"))) {
            throw new BusinessException("8888", "\u89c4\u5219\u5f15\u64ce\u51fa\u53c2\u8fd4\u56deprocessKey\u4e3a\u7a7a");
        }
        log.info("\u8fd4\u56de\u540e\u7684\u6d41\u7a0bkey" + (String)resultMap.get("processKey"));
        AgrApproveCreationAtomReqBO approveCreationAtomReqBO = new AgrApproveCreationAtomReqBO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)((Object)approveCreationAtomReqBO));
        approveCreationAtomReqBO.setMenuId((String)resultMap.get("processKey"));
        approveCreationAtomReqBO.setObjId(Collections.singletonList(atomRspBO.getAgrAgreementBO().getAgreementId()));
        approveCreationAtomReqBO.setSysTenantId(busiReqBO.getSysTenantId());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("sysTenantId", busiReqBO.getSysTenantId());
        approveCreationAtomReqBO.setVariables(variables);
        try {
            this.agrApproveCreationAtomService.createApprove(approveCreationAtomReqBO);
        }
        catch (Exception e) {
            log.error("\u8ba1\u5212\u4e2d\u5fc3\u5f00\u542f\u5ba1\u6279\u6355\u83b7\u5230\u5f02\u5e38");
            throw new com.tydic.uac.exception.BusinessException("11201", e.getMessage());
        }
    }
}

