/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementDictionaryCodeBO;
import com.tydic.agreement.ability.bo.AgrChangeSkuBO;
import com.tydic.agreement.busi.api.AgrBatchAddImportLogBusiService;
import com.tydic.agreement.busi.bo.AgrBatchAddImportLogBusiReqBO;
import com.tydic.agreement.busi.bo.AgrBatchAddImportLogBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementSkuImportFileMapper;
import com.tydic.agreement.dao.AgrAgreementSkuImportLogMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.po.AgrAgreementSkuImportFilePO;
import com.tydic.agreement.po.AgrAgreementSkuImportLogPO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.commodity.common.ability.api.UccAgrSkuImportCheckNewAbilityService;
import com.tydic.commodity.common.ability.api.UccSkuManagementListQryAbilityService;
import com.tydic.commodity.common.ability.api.UccSpuTypeQryByNameAbilityService;
import com.tydic.commodity.common.ability.bo.UccAgrSkuImportCheckNewAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccAgrSkuImportCheckNewAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccAgrSkuImportCheckNewBO;
import com.tydic.commodity.common.ability.bo.UccCommodityTypeDropDownBO;
import com.tydic.commodity.common.ability.bo.UccSpuTypeQryByNameAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuTypeQryByNameAbilityRspBO;
import com.tydic.fsc.base.FscRspPageBaseBO;
import com.tydic.fsc.bo.FscDicDictionaryReqBO;
import com.tydic.fsc.common.ability.api.FscDictionaryAbilityService;
import com.tydic.fsc.common.ability.bo.FscDictionaryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscQueryDictionaryAbilityReqBO;
import com.tydic.ppc.ability.api.PpcPurchaseDemandQryListAbilityService;
import com.tydic.ppc.ability.bo.PpcPurchaseDemandQryPageAbilityReqBO;
import com.tydic.ppc.ability.bo.PpcPurchaseDemandQryPageAbilityRspBO;
import com.tydic.uac.exception.BusinessException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrBatchAddImportLogBusiServiceImpl
implements AgrBatchAddImportLogBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrBatchAddImportLogBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgrAgreementSkuImportFileMapper agrAgreementSkuImportFileMapper;
    @Autowired
    private AgrAgreementSkuImportLogMapper agrAgreementSkuImportLogMapper;
    @Autowired
    private PpcPurchaseDemandQryListAbilityService ppcPurchaseDemandQryListAbilityService;
    @Autowired
    private FscDictionaryAbilityService fscDictionaryAbilityService;
    @Autowired
    private UccAgrSkuImportCheckNewAbilityService uccAgrSkuImportCheckNewAbilityService;
    @Autowired
    private UccSpuTypeQryByNameAbilityService uccSpuTypeQryByNameAbilityService;
    @Autowired
    private UccSkuManagementListQryAbilityService uccSkuManagementListQryAbilityService;
    @Value(value="${HK.sysTenantId:1104853665419067393}")
    private Long sysTenantIdHK;
    public static final String DICTIONARY_KEY_PREFIX = "PES_DIC_";
    public static final int DICTIONARY_KEY_EXPIRE = 3600;
    @Autowired
    private CacheClient cacheClient;

    @Override
    public AgrBatchAddImportLogBusiRspBO dealBatchAddImportLog(AgrBatchAddImportLogBusiReqBO busiReqBO) {
        AgrBatchAddImportLogBusiRspBO rspBO = new AgrBatchAddImportLogBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        Map<String, List<AgrAgreementDictionaryCodeBO>> dictMapList = busiReqBO.getData();
        log.info("\u7a0e\u7387\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u503c:{}", dictMapList);
        List<AgrAgreementDictionaryCodeBO> taxRatePcodeList = dictMapList.get("AGR_TAX_RATE_PCODE");
        ArrayList<Byte> taxList = new ArrayList<Byte>();
        for (AgrAgreementDictionaryCodeBO bo : taxRatePcodeList) {
            taxList.add(Byte.valueOf(bo.getCode()));
        }
        List<AgrAgreementDictionaryCodeBO> taxCatCodeList = dictMapList.get("ucc_tax_cat_code_value");
        ArrayList<String> taxCatList = new ArrayList<String>();
        for (AgrAgreementDictionaryCodeBO bo : taxCatCodeList) {
            taxCatList.add(bo.getCode());
        }
        ArrayList<String> addTaxCatList = new ArrayList<String>();
        ArrayList<AgrAgreementSkuImportLogPO> agrAgreementSkuImportLogPOList = new ArrayList<AgrAgreementSkuImportLogPO>();
        Long importFileId = Sequence.getInstance().nextId();
        for (AgrChangeSkuBO agrChangeSkuBO : busiReqBO.getAgrChangeSkuBOs()) {
            AgrAgreementSkuImportLogPO agrAgreementSkuImportLogPO = new AgrAgreementSkuImportLogPO();
            agrAgreementSkuImportLogPO.setImportStatus("1");
            agrAgreementSkuImportLogPO.setFailReason("\u6210\u529f");
            StringBuilder failReason = new StringBuilder();
            if (agrChangeSkuBO.getAgreementSkuId() == null) {
                failReason.append("\u5fc5\u586b\u9879\u3010\u534f\u8bae\u660e\u7ec6\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)agrChangeSkuBO.getCommodityTypeName())) {
                failReason.append("\u5fc5\u586b\u9879\u3010\u5546\u54c1\u7c7b\u578b\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)agrChangeSkuBO.getVendorMaterialCode())) {
                failReason.append("\u5fc5\u586b\u9879\u3010\u4f9b\u5e94\u5546\u5546\u54c1\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)agrChangeSkuBO.getBrandName())) {
                failReason.append("\u5fc5\u586b\u9879\u3010\u54c1\u724c\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)agrChangeSkuBO.getMeasureName())) {
                failReason.append("\u5fc5\u586b\u9879\u3010\u8ba1\u91cf\u5355\u4f4d\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)agrChangeSkuBO.getTaxCatalog())) {
                if (!this.sysTenantIdHK.equals(busiReqBO.getSysTenantId())) {
                    failReason.append("\u5fc5\u586b\u9879\u3010\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
                }
                if (!taxCatList.contains(agrChangeSkuBO.getTaxCatalog())) {
                    addTaxCatList.add(agrChangeSkuBO.getTaxCatalog());
                    taxCatList.add(agrChangeSkuBO.getTaxCatalog());
                }
            }
            if (agrChangeSkuBO.getSupplyCycle() == null) {
                failReason.append("\u5fc5\u586b\u9879\u3010\u4f9b\u8d27\u5468\u671f\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            if (agrChangeSkuBO.getBuyNumber() == null) {
                failReason.append("\u5fc5\u586b\u9879\u3010\u6570\u91cf\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
            } else {
                try {
                    int number = Integer.parseInt(agrChangeSkuBO.getBuyNumber().toString());
                    if (number <= 0) {
                        failReason.append("\u3010\u6570\u91cf\u3011\u4ec5\u5141\u8bb8\u8f93\u5165\uff1e0\u7684\u6574\u6570;");
                    }
                }
                catch (NumberFormatException e) {
                    failReason.append("\u3010\u6570\u91cf\u3011\u4ec5\u5141\u8bb8\u8f93\u5165\uff1e0\u7684\u6574\u6570;");
                }
            }
            if (null == agrChangeSkuBO.getSalePrice()) {
                failReason.append("\u5fc5\u586b\u9879\u3010\u9500\u552e\u5355\u4ef7\uff08\u5143\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
            } else if (!AgrBatchAddImportLogBusiServiceImpl.isValidTwoDecimals(agrChangeSkuBO.getSalePrice().toString())) {
                failReason.append("\u3010\u9500\u552e\u5355\u4ef7\uff08\u5143\uff09\u3011\u4ec5\u5141\u8bb8\u8f93\u5165\uff1e0.00\uff0c\u6700\u591a\u8f93\u5165\u4e24\u4f4d\u5c0f\u6570;");
            }
            if (null == agrChangeSkuBO.getTaxRate()) {
                failReason.append("\u5fc5\u586b\u9879\u3010\u7a0e\u7387\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
            } else {
                BigDecimal taxRate;
                if (!AgrBatchAddImportLogBusiServiceImpl.isValidTwoDecimals(agrChangeSkuBO.getTaxRate().toString())) {
                    failReason.append("\u7a0e\u7387\u683c\u5f0f\u6709\u8bef;");
                }
                if (!taxList.contains((taxRate = new BigDecimal(agrChangeSkuBO.getTaxRate().toString())).multiply(new BigDecimal(100)).byteValue())) {
                    failReason.append("\u7a0e\u7387\u53ea\u80fd\u4e3a\u5546\u57ce\u5b58\u5728\u7684\u7a0e\u7387;");
                }
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)agrChangeSkuBO.getXcCategory())) {
                agrChangeSkuBO.setXcCategory("\u5426");
            } else if ("1".equals(agrChangeSkuBO.getXcCategory())) {
                agrChangeSkuBO.setXcCategory("\u662f");
            } else {
                agrChangeSkuBO.setXcCategory("\u5426");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)agrChangeSkuBO.getXcSku())) {
                agrChangeSkuBO.setXcSku("\u5426");
            } else if ("1".equals(agrChangeSkuBO.getXcSku())) {
                agrChangeSkuBO.setXcSku("\u662f");
            } else {
                agrChangeSkuBO.setXcSku("\u5426");
            }
            if (null != agrChangeSkuBO.getBuyPrice() && !AgrBatchAddImportLogBusiServiceImpl.isValidTwoDecimals(agrChangeSkuBO.getBuyPrice().toString())) {
                failReason.append("\u3010\u91c7\u8d2d\u5355\u4ef7\u3011\u4ec5\u5141\u8bb8\u8f93\u5165\uff1e0.00\uff0c\u6700\u591a\u8f93\u5165\u4e24\u4f4d\u5c0f\u6570;");
            }
            if (agrChangeSkuBO.getMarkupRate() != null && !AgrBatchAddImportLogBusiServiceImpl.isValidTwoDecimals(String.valueOf(agrChangeSkuBO.getMarkupRate()))) {
                failReason.append("\u3010\u52a0\u4ef7\u6bd4\u7387\u3011\u4ec5\u5141\u8bb8\u8f93\u5165\uff1e0.00\uff0c\u6700\u591a\u8f93\u5165\u4e24\u4f4d\u5c0f\u6570;");
                continue;
            }
            if (null != agrChangeSkuBO.getMarkupAmount() && !AgrBatchAddImportLogBusiServiceImpl.isValidTwoDecimals(agrChangeSkuBO.getMarkupAmount().toString())) {
                failReason.append("\u3010\u52a0\u4ef7\u91d1\u989d\u3011\u4ec5\u5141\u8bb8\u8f93\u5165\uff1e0.00\uff0c\u6700\u591a\u8f93\u5165\u4e24\u4f4d\u5c0f\u6570;");
            }
            if (null != agrChangeSkuBO.getExtField6() && !AgrBatchAddImportLogBusiServiceImpl.isValidTwoDecimals(agrChangeSkuBO.getExtField6().toString())) {
                failReason.append("\u3010\u534f\u8bae\u4ef7\u4e0a\u9650\u3011\u4ec5\u5141\u8bb8\u8f93\u5165\uff1e0.00\uff0c\u6700\u591a\u8f93\u5165\u4e24\u4f4d\u5c0f\u6570;");
            }
            if (null != agrChangeSkuBO.getExtField7() && !AgrBatchAddImportLogBusiServiceImpl.isValidTwoDecimals(agrChangeSkuBO.getExtField7().toString())) {
                failReason.append("\u3010\u534f\u8bae\u4ef7\u4e0b\u9650\u3011\u4ec5\u5141\u8bb8\u8f93\u5165\uff1e0.00\uff0c\u6700\u591a\u8f93\u5165\u4e24\u4f4d\u5c0f\u6570;");
            }
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)agrChangeSkuBO.getPurchaseDemandOrderNo())) {
                PpcPurchaseDemandQryPageAbilityReqBO ppcPurchaseDemandQryPageAbilityReqBO = new PpcPurchaseDemandQryPageAbilityReqBO();
                ppcPurchaseDemandQryPageAbilityReqBO.setUserId(Long.valueOf(1L));
                ppcPurchaseDemandQryPageAbilityReqBO.setPurchaseDemandNoAccurate(agrChangeSkuBO.getPurchaseDemandOrderNo());
                PpcPurchaseDemandQryPageAbilityRspBO ppcPurchaseDemandQryPageAbilityRspBO = this.ppcPurchaseDemandQryListAbilityService.queryPurchaseDemandPage(ppcPurchaseDemandQryPageAbilityReqBO);
                if ("0000".equals(ppcPurchaseDemandQryPageAbilityRspBO.getRespCode()) && ppcPurchaseDemandQryPageAbilityRspBO.getRecordsTotal() == 0) {
                    failReason.append("\u201ce\u8d2d\u91c7\u8d2d\u9700\u6c42\u7f16\u53f7\u201d\u8f93\u5165\u6709\u8bef;");
                }
            }
            BeanUtils.copyProperties((Object)agrChangeSkuBO, (Object)agrAgreementSkuImportLogPO);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)failReason.toString())) {
                agrAgreementSkuImportLogPO.setVerifyStatus("2");
                continue;
            }
            agrAgreementSkuImportLogPO.setVerifyStatus("1");
        }
        if (!CollectionUtils.isEmpty(addTaxCatList)) {
            for (String addTaxCat : addTaxCatList) {
                FscDicDictionaryReqBO reqBO = new FscDicDictionaryReqBO();
                reqBO.setCode(addTaxCat);
                reqBO.setTitle(addTaxCat);
                reqBO.setDescrip("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801");
                reqBO.setPCode("FSC_TAX_CAT_CODE_VALUE");
                reqBO.setSysTenantId(busiReqBO.getSysTenantId());
                reqBO.setSysTenantName(busiReqBO.getSysTenantName());
                FscDictionaryAbilityRspBO addRspBO = this.fscDictionaryAbilityService.addDicDictionary(reqBO);
                if ("0000".equals(addRspBO.getRespCode())) continue;
                throw new BusinessException("8888", "\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165,\u65b0\u589e\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5931\u8d25" + addRspBO.getRespDesc());
            }
            this.refreshCodeList("ucc_tax_cat_code_value");
        }
        if (!CollectionUtils.isEmpty(agrAgreementSkuImportLogPOList)) {
            this.agrAgreementSkuImportLogMapper.insertBatch(agrAgreementSkuImportLogPOList);
        }
        ArrayList<UccAgrSkuImportCheckNewBO> rows = new ArrayList<UccAgrSkuImportCheckNewBO>();
        for (int i = 0; i < agrAgreementSkuImportLogPOList.size(); ++i) {
            UccAgrSkuImportCheckNewBO bo = new UccAgrSkuImportCheckNewBO();
            bo.setSerialNumber(Integer.valueOf(i));
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((AgrAgreementSkuImportLogPO)agrAgreementSkuImportLogPOList.get(i)).getBrandName())) {
                bo.setBrandName(((AgrAgreementSkuImportLogPO)agrAgreementSkuImportLogPOList.get(i)).getBrandName());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((AgrAgreementSkuImportLogPO)agrAgreementSkuImportLogPOList.get(i)).getMeasureName())) {
                bo.setMeasureName(((AgrAgreementSkuImportLogPO)agrAgreementSkuImportLogPOList.get(i)).getMeasureName());
            }
            rows.add(bo);
        }
        UccAgrSkuImportCheckNewAbilityReqBO uccAgrSkuImportCheckAbilityReqBO = new UccAgrSkuImportCheckNewAbilityReqBO();
        uccAgrSkuImportCheckAbilityReqBO.setRows(rows);
        log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6821\u9a8c\u670d\u52a1\u5165\u53c2 \uff1a" + JSONObject.toJSONString((Object)uccAgrSkuImportCheckAbilityReqBO));
        UccAgrSkuImportCheckNewAbilityRspBO uccAgrSkuImportCheckAbilityRspBO = this.uccAgrSkuImportCheckNewAbilityService.checkInfo(uccAgrSkuImportCheckAbilityReqBO);
        log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6821\u9a8c\u670d\u52a1\u51fa\u53c2 \uff1a" + JSONObject.toJSONString((Object)uccAgrSkuImportCheckAbilityRspBO));
        if ("0000".equals(uccAgrSkuImportCheckAbilityRspBO.getRespCode())) {
            Map uccRspMap = uccAgrSkuImportCheckAbilityRspBO.getRows().stream().collect(Collectors.toMap(UccAgrSkuImportCheckNewBO::getSerialNumber, Function.identity()));
            for (int i = 0; i < agrAgreementSkuImportLogPOList.size(); ++i) {
                if (!((UccAgrSkuImportCheckNewBO)uccRspMap.get(i)).isPass()) {
                    throw new BusinessException("8888", "\u7b2c" + i + "\u884c" + ((UccAgrSkuImportCheckNewBO)uccRspMap.get(i)).getReson());
                }
                ((AgrAgreementSkuImportLogPO)agrAgreementSkuImportLogPOList.get(i)).setMeasureId(((UccAgrSkuImportCheckNewBO)uccRspMap.get(i)).getMeasureId());
                ((AgrAgreementSkuImportLogPO)agrAgreementSkuImportLogPOList.get(i)).setMeasureName(((UccAgrSkuImportCheckNewBO)uccRspMap.get(i)).getMeasureName().toString());
                ((AgrAgreementSkuImportLogPO)agrAgreementSkuImportLogPOList.get(i)).setBrandId(((UccAgrSkuImportCheckNewBO)uccRspMap.get(i)).getBrandId());
                ((AgrAgreementSkuImportLogPO)agrAgreementSkuImportLogPOList.get(i)).setBrandName(((UccAgrSkuImportCheckNewBO)uccRspMap.get(i)).getBrandName());
            }
        } else {
            throw new BusinessException("8888", "\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165" + uccAgrSkuImportCheckAbilityRspBO.getRespDesc());
        }
        List typeNameList = agrAgreementSkuImportLogPOList.stream().filter(a -> !StringUtils.isEmpty((Object)a.getCommodityTypeName())).map(AgrAgreementSkuImportLogPO::getCommodityTypeName).collect(Collectors.toList());
        Map<Object, Object> spuTypeMap = new HashMap();
        if (!CollectionUtils.isEmpty(typeNameList)) {
            UccSpuTypeQryByNameAbilityReqBO uccSpuTypeQryByNameAbilityReqBO = new UccSpuTypeQryByNameAbilityReqBO();
            uccSpuTypeQryByNameAbilityReqBO.setCommdityNameList(typeNameList);
            log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6821\u9a8c\u670d\u52a1\u5165\u53c2 \uff1a" + JSONObject.toJSONString((Object)uccSpuTypeQryByNameAbilityReqBO));
            UccSpuTypeQryByNameAbilityRspBO abilityRspBO = this.uccSpuTypeQryByNameAbilityService.spuTypeQryByName(uccSpuTypeQryByNameAbilityReqBO);
            log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6821\u9a8c\u670d\u52a1\u5165\u53c2 \uff1a" + JSONObject.toJSONString((Object)abilityRspBO));
            if (!CollectionUtils.isEmpty((Collection)abilityRspBO.getData())) {
                spuTypeMap = abilityRspBO.getData().stream().collect(Collectors.toMap(UccCommodityTypeDropDownBO::getCatalogName, Function.identity(), (oldValue, newValue) -> newValue));
            }
        }
        for (AgrAgreementSkuImportLogPO agreementSkuImportLogPO : agrAgreementSkuImportLogPOList) {
            StringBuilder sb = new StringBuilder();
            sb.append(agreementSkuImportLogPO.getFailReason());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sb.toString())) {
                agreementSkuImportLogPO.setVerifyStatus("2");
            } else {
                agreementSkuImportLogPO.setVerifyStatus("1");
            }
            if (agreement.getTradeMode() == 2) {
                agreementSkuImportLogPO.setBuyPrice(agreementSkuImportLogPO.getSalePrice());
            }
            agreementSkuImportLogPO.setImportFileId(importFileId);
            agreementSkuImportLogPO.setId(Sequence.getInstance().nextId());
            if (agreement.getTradeMode() == 2) {
                if (agreementSkuImportLogPO.getSalePrice() != null && agreementSkuImportLogPO.getSalePrice().compareTo(agreementSkuImportLogPO.getBuyPrice()) != 0) {
                    agreementSkuImportLogPO.setVerifyStatus("2");
                    sb.append("\u91c7\u8d2d\u5355\u4ef7\u548c\u9500\u552e\u5355\u4ef7\u5e94\u76f8\u540c;");
                }
            } else {
                if (agreementSkuImportLogPO.getMarkupRate() == null && agreementSkuImportLogPO.getMarkupAmount() == null) {
                    agreementSkuImportLogPO.setVerifyStatus("2");
                    sb.append("\u8d38\u6613\u6a21\u5f0f\u52a0\u4ef7\u91d1\u989d\u548c\u52a0\u4ef7\u6bd4\u7387\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a;");
                } else if (agreementSkuImportLogPO.getMarkupRate() == null) {
                    if (agreementSkuImportLogPO.getBuyPrice() != null && agreementSkuImportLogPO.getMarkupAmount() != null && agreementSkuImportLogPO.getSalePrice() != null) {
                        log.info("buyPrice:" + agreementSkuImportLogPO.getBuyPrice().add(agreementSkuImportLogPO.getMarkupAmount()) + "salePrice:" + agreementSkuImportLogPO.getSalePrice());
                        if (agreementSkuImportLogPO.getBuyPrice().add(agreementSkuImportLogPO.getMarkupAmount()).compareTo(agreementSkuImportLogPO.getSalePrice()) != 0) {
                            agreementSkuImportLogPO.setVerifyStatus("2");
                            sb.append("\u8d38\u6613\u6a21\u5f0f\u52a0\u4ef7\u6bd4\u7387\u4e3a\u7a7a\u65f6\u201c\u9500\u552e\u5355\u4ef7\u201d = \u201c\u91c7\u8d2d\u5355\u4ef7\u201d + \u201c\u52a0\u4ef7\u91d1\u989d\u201d;");
                        }
                    }
                } else if (agreementSkuImportLogPO.getBuyPrice() != null && agreementSkuImportLogPO.getMarkupRate() != null && agreementSkuImportLogPO.getSalePrice() != null) {
                    BigDecimal markupRate = new BigDecimal(agreementSkuImportLogPO.getMarkupRate());
                    agreementSkuImportLogPO.setMarkupRate(markupRate.multiply(new BigDecimal(100)).doubleValue());
                    BigDecimal markupRateDecimal = new BigDecimal(agreementSkuImportLogPO.getMarkupRate()).divide(new BigDecimal("100"));
                    BigDecimal salesPrice = agreementSkuImportLogPO.getBuyPrice().multiply(markupRateDecimal.add(BigDecimal.ONE));
                    BigDecimal salePriceWithMarkup = salesPrice.setScale(2, RoundingMode.HALF_UP);
                    log.info("salePriceWithMarkup:" + salePriceWithMarkup);
                    log.info("SalePrice:" + agreementSkuImportLogPO.getSalePrice());
                    if (salePriceWithMarkup != agreementSkuImportLogPO.getSalePrice()) {
                        agreementSkuImportLogPO.setVerifyStatus("2");
                        sb.append("\u8d38\u6613\u6a21\u5f0f\u52a0\u4ef7\u6bd4\u7387\u4e3a\u4e0d\u7a7a\u65f6\u201d\u9500\u552e\u5355\u4ef7\u201d = \u201c\u91c7\u8d2d\u5355\u4ef7\u201d * \uff081 + \u201c\u52a0\u4ef7\u6bd4\u7387\u201d\uff09\uff0c\u56db\u820d\u4e94\u5165\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570;");
                    }
                }
                boolean isValid = true;
                if (agreementSkuImportLogPO.getExtField6() != null && agreementSkuImportLogPO.getSalePrice() != null && agreementSkuImportLogPO.getSalePrice().compareTo(agreementSkuImportLogPO.getExtField6()) > 0) {
                    agreementSkuImportLogPO.setVerifyStatus("2");
                    sb.append("\u8d38\u6613\u6a21\u5f0f\u201c\u534f\u8bae\u4ef7\u4e0a\u9650\uff08\u5143\uff09\u201d \u2265 \u201c\u9500\u552e\u5355\u4ef7\u201d \u2265 \u201c\u534f\u8bae\u4ef7\u4e0b\u9650\uff08\u5143\uff09\u201d;");
                    isValid = false;
                }
                if (agreementSkuImportLogPO.getExtField7() != null && isValid && agreementSkuImportLogPO.getSalePrice() != null && agreementSkuImportLogPO.getSalePrice().compareTo(agreementSkuImportLogPO.getExtField7()) < 0) {
                    agreementSkuImportLogPO.setVerifyStatus("2");
                    sb.append("\u8d38\u6613\u6a21\u5f0f\u201c\u534f\u8bae\u4ef7\u4e0a\u9650\uff08\u5143\uff09\u201d \u2265 \u201c\u9500\u552e\u5355\u4ef7\u201d \u2265 \u201c\u534f\u8bae\u4ef7\u4e0b\u9650\uff08\u5143\uff09\u201d;");
                }
            }
            if (spuTypeMap.isEmpty() || !spuTypeMap.containsKey(agreementSkuImportLogPO.getCommodityTypeName())) {
                agreementSkuImportLogPO.setVerifyStatus("2");
                sb.append("\u5546\u54c1\u7c7b\u578b\u4e0d\u5b58\u5728;");
            } else {
                agreementSkuImportLogPO.setCommodityTypeId(((UccCommodityTypeDropDownBO)spuTypeMap.get(agreementSkuImportLogPO.getCommodityTypeName())).getCatalogId());
                agreementSkuImportLogPO.setCommodityTypeName(((UccCommodityTypeDropDownBO)spuTypeMap.get(agreementSkuImportLogPO.getCommodityTypeName())).getCatalogName());
                agreementSkuImportLogPO.setCatalogId(((UccCommodityTypeDropDownBO)spuTypeMap.get(agreementSkuImportLogPO.getCommodityTypeName())).getCatalogId().toString());
                agreementSkuImportLogPO.setCatalogName(((UccCommodityTypeDropDownBO)spuTypeMap.get(agreementSkuImportLogPO.getCommodityTypeName())).getCatalogName());
            }
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            agreementSkuPO.setAgreementId(busiReqBO.getAgreementId());
            agreementSkuPO.setNotAgreementSkuId(agreementSkuImportLogPO.getAgreementSkuId());
            List<AgreementSkuPO> agreementSkuPOS = this.agreementSkuMapper.getList(agreementSkuPO);
            if (!CollectionUtils.isEmpty(agreementSkuPOS)) {
                agreementSkuImportLogPO.setVerifyStatus("2");
                sb.append("\u201c\u4f9b\u5e94\u5546\u5546\u54c1\u7f16\u7801\u201d\u4e0d\u5141\u8bb8\u91cd\u590d;");
            }
            if ("2".equals(agreementSkuImportLogPO.getVerifyStatus())) {
                log.info("\u65b0\u589e\u7269\u6599\u4fe1\u606f\u5931\u8d25,\u539f\u56e0:" + sb.toString());
                agreementSkuImportLogPO.setFailReason(sb.toString());
            }
            if ("null".equals(agreementSkuImportLogPO.getSpec())) {
                agreementSkuImportLogPO.setSpec(null);
            }
            if ("null".equals(agreementSkuImportLogPO.getModel())) {
                agreementSkuImportLogPO.setModel(null);
            }
            if (!"null".equals(agreementSkuImportLogPO.getPurchaseDemandOrderNo())) continue;
            agreementSkuImportLogPO.setPurchaseDemandOrderNo(null);
        }
        AgrAgreementSkuImportFilePO agrAgreementSkuImportFilePo = new AgrAgreementSkuImportFilePO();
        agrAgreementSkuImportFilePo.setImportFileId(importFileId);
        agrAgreementSkuImportFilePo.setAgreementId(busiReqBO.getAgreementId());
        agrAgreementSkuImportFilePo.setImportType("2");
        agrAgreementSkuImportFilePo.setCreateOperId(busiReqBO.getUserId());
        agrAgreementSkuImportFilePo.setCreateOperName(busiReqBO.getName());
        agrAgreementSkuImportFilePo.setCreateOrgId(busiReqBO.getOrgId());
        agrAgreementSkuImportFilePo.setCreateOrgName(busiReqBO.getOrgName());
        agrAgreementSkuImportFilePo.setCreateTimt(new Date());
        this.agrAgreementSkuImportFileMapper.insert(agrAgreementSkuImportFilePo);
        if (!CollectionUtils.isEmpty(agrAgreementSkuImportLogPOList)) {
            this.agrAgreementSkuImportLogMapper.insertBatch(agrAgreementSkuImportLogPOList);
        }
        rspBO.setImportFileId(importFileId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public static boolean isValidTwoDecimals(String input) {
        String regex = "^\\d+(\\.\\d{1,2})?$";
        if (input.matches(regex)) {
            try {
                double number = Double.parseDouble(input);
                return number > 0.0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public void refreshCodeList(String key) {
        this.cacheClient.delete(DICTIONARY_KEY_PREFIX + key);
        FscQueryDictionaryAbilityReqBO reqBO = new FscQueryDictionaryAbilityReqBO();
        reqBO.setPcode("FSC_TAX_CAT_CODE_VALUE");
        FscRspPageBaseBO qryRspBO = this.fscDictionaryAbilityService.queryBypCodeBackPo(reqBO);
        if ("0000".equals(qryRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)qryRspBO.getRows())) {
            this.cacheClient.set(DICTIONARY_KEY_PREFIX + key, (Object)qryRspBO.getRows(), AgrBatchAddImportLogBusiServiceImpl.getExpireSeconds(3600, 10));
        }
    }

    public static int getExpireSeconds(int radix, int range) {
        return radix * (new Random().nextInt(range) + 1);
    }
}

