/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementSkuChangeBO;
import com.tydic.agreement.ability.bo.AgrAgreementSkuPurchaseDemandBO;
import com.tydic.agreement.busi.api.AgrCreateAgreementSkuChangeBusiService;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuChangeBusiReqBO;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuChangeBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementSkuPriceChangeMapper;
import com.tydic.agreement.dao.AgreementChangeMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuChangeMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrAgreementSkuPriceChangePO;
import com.tydic.agreement.po.AgreementChangePO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuChangePO;
import com.tydic.agreement.po.AgreementSkuPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrCreateAgreementSkuChangeBusiServiceImpl
implements AgrCreateAgreementSkuChangeBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrCreateAgreementSkuChangeBusiServiceImpl.class);
    @Autowired
    private AgreementSkuChangeMapper agreementSkuChangeMapper;
    @Autowired
    private AgreementChangeMapper agreementChangeMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgrAgreementSkuPriceChangeMapper agrAgreementSkuPriceChangeMapper;

    @Override
    public AgrCreateAgreementSkuChangeBusiRspBO createAgreementSkuChange(AgrCreateAgreementSkuChangeBusiReqBO busiReqBO) {
        int isInsert;
        AgrCreateAgreementSkuChangeBusiRspBO rsp = new AgrCreateAgreementSkuChangeBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        AgreementChangePO agreementChangePO = new AgreementChangePO();
        agreementChangePO.setChangeCode(busiReqBO.getChangeCode());
        agreementChangePO.setAgreementId(busiReqBO.getAgreementId());
        agreementChangePO.setSupplierId(busiReqBO.getSupplierId());
        AgreementChangePO daoRsp = this.agreementChangeMapper.getModelBy(agreementChangePO);
        if (!(null == daoRsp || AgrCommConstant.ChangeApplyStatus.DRAFT.equals(daoRsp.getStatus()) || AgrCommConstant.ChangeApplyStatus.NO_PASS.equals(daoRsp.getStatus()) || AgrCommConstant.ChangeApplyStatus.NO_CONFIRM.equals(daoRsp.getStatus()))) {
            throw new BusinessException("22002", "\u53ea\u6709\u8349\u7a3f\u4e2d\u548c\u9a73\u56de\u72b6\u6001\u7684\u534f\u8bae\u53d8\u66f4\u53ef\u4ee5\u521b\u5efa\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\uff01");
        }
        if (CollectionUtils.isEmpty(busiReqBO.getAgrAgreementSkuChangeBOs())) {
            throw new BusinessException("22002", "\u65b0\u589e\u53d8\u66f4\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (AgrAgreementSkuChangeBO each : busiReqBO.getAgrAgreementSkuChangeBOs()) {
            List<AgreementSkuPO> agreementSkuPOList;
            log.info("\u534f\u8bae\u8c03\u4ef7-\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u53c2\u6570\uff1a{}", (Object)each);
            if (each.getChangeType() != 1) continue;
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            agreementSkuPO.setAgreementId(busiReqBO.getAgreementId());
            agreementSkuPO.setMaterialCode(each.getMaterialCode().toString());
            if ("1".equals(busiReqBO.getSkuChangeType()) && !CollectionUtils.isEmpty(agreementSkuPOList = this.agreementSkuMapper.getList(agreementSkuPO))) {
                throw new BusinessException("22002", "\u65b0\u589e\u7269\u6599\u4e0d\u80fd\u5df2\u7ecf\u5b58\u5728\uff01" + each.getMaterialCode() + "\u4e0d\u80fd\u91cd\u590d\u65b0\u589e");
            }
            AgreementSkuChangePO agreementSkuChangePO = new AgreementSkuChangePO();
            agreementSkuChangePO.setAgreementId(busiReqBO.getAgreementId());
            agreementSkuChangePO.setMaterialCode(each.getMaterialCode().toString());
            agreementSkuChangePO.setChangeCode(busiReqBO.getChangeCode());
            List<AgreementSkuChangePO> agreementSkuChangePOList = this.agreementSkuChangeMapper.getList(agreementSkuChangePO);
            if (!CollectionUtils.isEmpty(agreementSkuChangePOList)) {
                throw new BusinessException("22002", "\u7269\u6599\u53ea\u80fd\u65b0\u589e\u4e00\u6b21\uff0c\u4e14\u539f\u534f\u8bae\u4e2d\u5df2\u6709\u7684\u7269\u6599\u4e0d\u80fd\u518d\u88ab\u6dfb\u52a0\uff01" + each.getMaterialCode() + "\u4e0d\u80fd\u91cd\u590d\u65b0\u589e");
            }
            if (!agreement.getTradeMode().equals((byte)2)) continue;
            each.setBuyPrice(each.getSalePrice());
            each.setBuyPriceSum(each.getSalePriceSum());
        }
        ArrayList<Long> agreementSkuIds = new ArrayList<Long>();
        ArrayList<AgrAgreementSkuPurchaseDemandBO> agrAgreementSkuPurchaseDemandBOS = new ArrayList<AgrAgreementSkuPurchaseDemandBO>();
        ArrayList<AgreementSkuChangePO> agreementSkuChangePOs = new ArrayList<AgreementSkuChangePO>();
        for (AgrAgreementSkuChangeBO bo : busiReqBO.getAgrAgreementSkuChangeBOs()) {
            if (null != bo.getAgreementSkuId()) {
                agreementSkuIds.add(bo.getAgreementSkuId());
            }
            AgreementSkuChangePO agreementSkuChangePO = new AgreementSkuChangePO();
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuChangePO);
            agreementSkuChangePO.setSkuChangeId(Sequence.getInstance().nextId());
            agreementSkuChangePO.setAgreementVersion(agreement.getAgreementVersion());
            agreementSkuChangePO.setAgreementId(busiReqBO.getAgreementId());
            agreementSkuChangePO.setSupplierId(agreement.getSupplierId());
            agreementSkuChangePO.setChangeCode(busiReqBO.getChangeCode());
            agreementSkuChangePO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuChangePO.setCreateLoginId(busiReqBO.getMemIdIn());
            agreementSkuChangePO.setCreateName(busiReqBO.getUserName());
            agreementSkuChangePO.setCreateTime(new Date());
            agreementSkuChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            if (bo.getPurchaseDemandId() != null) {
                agreementSkuChangePO.setAgreementSkuId(Sequence.getInstance().nextId());
                AgrAgreementSkuPurchaseDemandBO agrAgreementSkuPurchaseDemandBO = new AgrAgreementSkuPurchaseDemandBO();
                agrAgreementSkuPurchaseDemandBO.setAgreementSkuId(agreementSkuChangePO.getAgreementSkuId());
                agrAgreementSkuPurchaseDemandBO.setPurchaseDemandId(bo.getPurchaseDemandId());
                agrAgreementSkuPurchaseDemandBOS.add(agrAgreementSkuPurchaseDemandBO);
            }
            agreementSkuChangePO.setSysTenantId(busiReqBO.getSysTenantId());
            agreementSkuChangePO.setSysTenantName(busiReqBO.getSysTenantName());
            if (StringUtils.isBlank((CharSequence)bo.getCatalogId()) && null != bo.getCommodityTypeId()) {
                agreementSkuChangePO.setCatalogId(bo.getCommodityTypeId().toString());
                agreementSkuChangePO.setCatalogName(bo.getCommodityTypeName());
            }
            agreementSkuChangePOs.add(agreementSkuChangePO);
        }
        if (!CollectionUtils.isEmpty(agreementSkuIds)) {
            AgreementSkuChangePO agreementSkuChangePO1 = new AgreementSkuChangePO();
            agreementSkuChangePO1.setAgreementId(busiReqBO.getAgreementId());
            agreementSkuChangePO1.setSupplierId(agreement.getSupplierId());
            agreementSkuChangePO1.setChangeCode(busiReqBO.getChangeCode());
            agreementSkuChangePO1.setAgreementSkuIds(agreementSkuIds);
            this.agreementSkuChangeMapper.deleteBy(agreementSkuChangePO1);
        }
        if ((isInsert = this.agreementSkuChangeMapper.insertBatch(agreementSkuChangePOs)) != agreementSkuChangePOs.size()) {
            throw new BusinessException("22003", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u8868\u65b0\u589e\u5931\u8d25\uff01");
        }
        ArrayList<Long> insertIds = new ArrayList<Long>();
        if ("2".equals(busiReqBO.getSkuChangeType())) {
            AgrAgreementSkuPriceChangePO agrAgreementSkuPriceChangePo = new AgrAgreementSkuPriceChangePO();
            agrAgreementSkuPriceChangePo.setChangeCode(busiReqBO.getChangeCode());
            List<Long> agreementSkuIdss = this.agrAgreementSkuPriceChangeMapper.getListId(agrAgreementSkuPriceChangePo);
            for (AgrAgreementSkuChangeBO agrAgreementSkuChangeBO : busiReqBO.getAgrAgreementSkuChangeBOs()) {
                if (agreementSkuIdss.contains(agrAgreementSkuChangeBO.getAgreementSkuId())) continue;
                insertIds.add(agrAgreementSkuChangeBO.getAgreementSkuId());
            }
            AgreementSkuPO temp = new AgreementSkuPO();
            temp.setAgreementId(busiReqBO.getAgreementId());
            temp.setIsDelete((byte)0);
            temp.setAgreementSkuIds(insertIds);
            List<AgreementSkuPO> list = this.agreementSkuMapper.getList(temp);
            List<AgrAgreementSkuPriceChangePO> result = list.stream().map(ags -> {
                AgrAgreementSkuPriceChangePO aapcp = new AgrAgreementSkuPriceChangePO();
                aapcp.setId(Sequence.getInstance().nextId());
                aapcp.setChangeCode(busiReqBO.getChangeCode());
                BeanUtils.copyProperties((Object)ags, (Object)aapcp);
                aapcp.setIsDelete(0);
                return aapcp;
            }).collect(Collectors.toList());
            this.agrAgreementSkuPriceChangeMapper.insertBatch(result);
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u65b0\u589e\u6210\u529f\uff01");
        rsp.setAgrAgreementSkuPurchaseDemandBOS(agrAgreementSkuPurchaseDemandBOS);
        return rsp;
    }
}

