/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementAttachBO;
import com.tydic.agreement.ability.bo.AgrAgreementScopeBO;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.ability.bo.AgrAgreementSkuPurchaseDemandBO;
import com.tydic.agreement.ability.bo.AgrAgreementSupplierBO;
import com.tydic.agreement.atom.api.AgrCreateAgreementOtherAtomService;
import com.tydic.agreement.atom.api.AgrCreateAgreementSettlementAtomService;
import com.tydic.agreement.atom.bo.AgrCreateAgreementOtherAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementOtherAtomRspBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSettlementAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSettlementAtomRspBO;
import com.tydic.agreement.busi.api.CrcAddAgreementPushBusiService;
import com.tydic.agreement.busi.bo.CrcAddAgreementPushBusiReqBO;
import com.tydic.agreement.busi.bo.CrcAddAgreementPushBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementAttachLogMapper;
import com.tydic.agreement.dao.AgrAgreementSupplierMapper;
import com.tydic.agreement.dao.AgreementAttachMapper;
import com.tydic.agreement.dao.AgreementLogMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementScopeLogMapper;
import com.tydic.agreement.dao.AgreementScopeMapper;
import com.tydic.agreement.dao.AgreementSettlementLogMapper;
import com.tydic.agreement.dao.AgreementSettlementMapper;
import com.tydic.agreement.dao.AgreementSkuLogMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrAgreementAttachLogPO;
import com.tydic.agreement.po.AgrAgreementSupplierPO;
import com.tydic.agreement.po.AgreementAttachPO;
import com.tydic.agreement.po.AgreementLogPO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementScopeLogPO;
import com.tydic.agreement.po.AgreementScopePO;
import com.tydic.agreement.po.AgreementSettlementLogPO;
import com.tydic.agreement.po.AgreementSettlementPO;
import com.tydic.agreement.po.AgreementSkuLogPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CrcAddAgreementPushBusiServiceImpl
implements CrcAddAgreementPushBusiService {
    private static final Logger log = LoggerFactory.getLogger(CrcAddAgreementPushBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private AgrCreateAgreementSettlementAtomService agrCreateAgreementSettlementAtomService;
    @Autowired
    private AgrCreateAgreementOtherAtomService agrCreateAgreementOtherAtomService;
    @Autowired
    private AgrAgreementSupplierMapper agrAgreementSupplierMapper;
    @Autowired
    private AgreementLogMapper agreementLogMapper;
    @Autowired
    private AgreementAttachMapper agreementAttachMapper;
    @Autowired
    private AgreementScopeLogMapper agreementScopeLogMapper;
    @Autowired
    private AgrAgreementAttachLogMapper agrAgreementAttachLogMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private AgreementSettlementLogMapper agreementSettlementLogMapper;
    @Autowired
    private AgreementSettlementMapper agreementSettlementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementSkuLogMapper agreementSkuLogMapper;

    @Override
    public CrcAddAgreementPushBusiRspBO addAgreementPush(CrcAddAgreementPushBusiReqBO reqBO) {
        List<AgrAgreementSkuPurchaseDemandBO> agrAgreementSkuPurchaseDemandBOS;
        CrcAddAgreementPushBusiRspBO rspBO = new CrcAddAgreementPushBusiRspBO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getEntAgreementCode())) {
            this.validPlaAgreementCode(reqBO);
        }
        String plaAgreementCode = this.createAgreementCode(reqBO);
        log.info("\u534f\u8bae\u7f16\u53f7\u4e3a:{}", (Object)plaAgreementCode);
        if (StringUtils.isBlank((CharSequence)plaAgreementCode)) {
            throw new BusinessException("8888", "\u534f\u8bae\u7f16\u53f7\u751f\u6210\u5931\u8d25\uff01");
        }
        Long agreementId = Sequence.getInstance().nextId();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < reqBO.getAgrAgreementSkuBOS().size(); ++i) {
            if (i == 0) {
                sb.append(reqBO.getAgrAgreementSkuBOS().get(i).getCommodityTypeName());
                continue;
            }
            if (i > 0 && i <= 2) {
                sb.append("\u3001");
                sb.append(reqBO.getAgrAgreementSkuBOS().get(i).getCommodityTypeName());
                continue;
            }
            sb.append("\u7b49");
            break;
        }
        AgreementPO agreementPO = this.insertAgreement(reqBO, agreementId, plaAgreementCode, sb);
        if (!CollectionUtils.isEmpty(reqBO.getAgrAgreementSkuBOS()) && !CollectionUtils.isEmpty(agrAgreementSkuPurchaseDemandBOS = this.insertAgreementSku(reqBO, agreementId))) {
            rspBO.setAgrAgreementSkuPurchaseDemandBOS(agrAgreementSkuPurchaseDemandBOS);
        }
        this.insertAgreementSettlement(reqBO, agreementId);
        this.insertAgreementOther(reqBO, agreementPO);
        ArrayList<AgrAgreementSupplierBO> distribution = new ArrayList<AgrAgreementSupplierBO>();
        if (reqBO.getAgreementMode() == 1 && reqBO.getSupplierMode() != null) {
            AgrAgreementSupplierBO agrAgreementSupplierBO = new AgrAgreementSupplierBO();
            agrAgreementSupplierBO.setAgreementId(agreementId);
            agrAgreementSupplierBO.setSupplierMode(Integer.valueOf(reqBO.getSupplierMode().intValue()));
            agrAgreementSupplierBO.setSupplierId(agreementPO.getVendorDepartmentId());
            agrAgreementSupplierBO.setSupplierName(agreementPO.getVendorDepartmentName());
            distribution.add(agrAgreementSupplierBO);
            reqBO.setDistribution(distribution);
        }
        if (!CollectionUtils.isEmpty(reqBO.getDistribution())) {
            this.insertAgreementSupplier(reqBO, agreementId);
        }
        Long agreementLogId = Sequence.getInstance().nextId();
        try {
            AgreementLogPO agreementLogPO = new AgreementLogPO();
            BeanUtils.copyProperties((Object)agreementPO, (Object)agreementLogPO);
            agreementLogPO.setAgreementLogId(agreementLogId);
            agreementLogPO.setLogStatus("2");
            agreementLogPO.setChangeType(new Byte("99"));
            agreementLogPO.setChangeTime(new Date());
            this.agreementLogMapper.insert(agreementLogPO);
            HashSet<Long> agreementIds = new HashSet<Long>();
            agreementIds.add(agreementId);
            this.insertAgreementScopeLog(agreementIds, agreementPO.getSupplierId(), agreementLogId, reqBO);
            this.insertAgreementAttachLog(agreementIds, agreementPO.getSupplierId(), agreementLogId);
            this.insertAgreementSettlementLog(agreementIds, agreementPO.getSupplierId(), agreementLogId);
        }
        catch (Exception e) {
            throw new BusinessException("0101", "\u751f\u6210\u534f\u8bae\u7248\u672c\u5f02\u5e38\uff01\uff01" + e);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u534f\u8bae\u63a8\u9001\u6210\u529f\uff01");
        rspBO.setAgreementId(agreementId);
        rspBO.setPlaAgreementCode(plaAgreementCode);
        return rspBO;
    }

    private void validPlaAgreementCode(CrcAddAgreementPushBusiReqBO busiReqBO) {
        AgreementPO checkAgreementPO = new AgreementPO();
        checkAgreementPO.setEntAgreementCode(busiReqBO.getEntAgreementCode());
        AgreementPO checkAgreement = this.agreementMapper.getModelBy(checkAgreementPO);
        if (null != checkAgreement) {
            throw new BusinessException("22053", "\u534f\u8bae\u7f16\u53f7\u3010" + checkAgreement.getEntAgreementCode() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
    }

    public String createAgreementCode(CrcAddAgreementPushBusiReqBO reqBO) {
        List serialNoList;
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("AGR");
        encodedSerialGetServiceReqBO.setRelType("org");
        encodedSerialGetServiceReqBO.setExtendFlag("1");
        if (null != reqBO.getAgreementClassification() && reqBO.getAgreementClassification() == 4) {
            encodedSerialGetServiceReqBO.setEncodedRuleCode("PRICE_AGREEMENT_CODE");
        } else {
            encodedSerialGetServiceReqBO.setEncodedRuleCode("ARG_AGREEMENT_CODE");
        }
        if (reqBO.getSysTenantId() != null) {
            encodedSerialGetServiceReqBO.setSysTenantId(reqBO.getSysTenantId());
        } else {
            encodedSerialGetServiceReqBO.setSysTenantId(Long.valueOf(305775845729763327L));
        }
        String rspString = JSONObject.toJSONString((Object)encodedSerialGetServiceReqBO);
        log.info("\u83b7\u53d6\u534f\u8bae\u7f16\u7801\u5165\u53c2=" + rspString);
        CfcEncodedSerialGetServiceRspBO encodedSerial = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        String plaAgreementCode = "";
        if (encodedSerial != null && !CollectionUtils.isEmpty((Collection)(serialNoList = encodedSerial.getSerialNoList()))) {
            plaAgreementCode = (String)serialNoList.get(0);
            return plaAgreementCode;
        }
        return null;
    }

    private AgreementPO insertAgreement(CrcAddAgreementPushBusiReqBO busiReqBO, Long agreementId, String plaAgreementCode, StringBuilder sb) {
        int isInsert;
        Date date = new Date();
        AgreementPO agreementPO = new AgreementPO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)agreementPO);
        agreementPO.setPlaAgreementCode(plaAgreementCode);
        String agreementVersion = "V1";
        agreementPO.setAgreementId(agreementId);
        agreementPO.setAgreementVersion(agreementVersion);
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.DRAFT);
        agreementPO.setAssignStatus(AgrCommConstant.AssignStatus.BE_ASSIGN);
        agreementPO.setProducerId(busiReqBO.getProducerId());
        agreementPO.setProduceTime(date);
        agreementPO.setSupplierMode((byte)2);
        if (agreementPO.getCurrency() == null) {
            agreementPO.setCurrency((byte)0);
        }
        agreementPO.setVendorDepartmentId(agreementPO.getVendorId());
        agreementPO.setVendorDepartmentName(agreementPO.getVendorName());
        agreementPO.setUnitAccountId(agreementPO.getVendorId());
        agreementPO.setUnitAccountName(agreementPO.getVendorName());
        agreementPO.setSupplierId(agreementPO.getVendorId());
        agreementPO.setSupplierName(agreementPO.getVendorName());
        agreementPO.setCurrency((byte)0);
        agreementPO.setSignTime(date);
        agreementPO.setExtField1(busiReqBO.getSbuId());
        if (busiReqBO.getScopeType() == null) {
            agreementPO.setScopeType((byte)0);
        }
        agreementPO.setSubmissionTime(agreementPO.getProduceTime());
        agreementPO.setAdjustPrice((byte)1);
        agreementPO.setMatterName(sb.toString());
        agreementPO.setAgreementSrcCode(busiReqBO.getPurchaseEnquiryOrderNo());
        agreementPO.setAgreementSrcName(busiReqBO.getPurchaseCompareOrderNo());
        if (null != busiReqBO.getSysTenantId()) {
            agreementPO.setSysTenantId(busiReqBO.getSysTenantId());
            agreementPO.setSysTenantName(busiReqBO.getSysTenantName());
        } else {
            agreementPO.setSysTenantId(305775845729763327L);
            agreementPO.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
        }
        if (null == agreementPO.getIsDispatch()) {
            agreementPO.setIsDispatch(AgrCommConstant.IsDispatch.YES);
        }
        if (null == agreementPO.getInstandOrder()) {
            agreementPO.setInstandOrder(0);
        }
        if (null == agreementPO.getAgreementPurpose()) {
            agreementPO.setAgreementPurpose(1);
        }
        if (agreementPO.getAgreementClassification() == 4) {
            agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
        }
        if ((isInsert = this.agreementMapper.insert(agreementPO)) < 1) {
            throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u8868\u5931\u8d25\uff01");
        }
        return agreementPO;
    }

    private void insertAgreementSettlement(CrcAddAgreementPushBusiReqBO busiReqBO, Long agreementId) {
        AgrCreateAgreementSettlementAtomReqBO atomReqBO = new AgrCreateAgreementSettlementAtomReqBO();
        atomReqBO.setSettlementObject("1");
        atomReqBO.setSettlementType("2");
        atomReqBO.setPayMethod("2");
        atomReqBO.setAgreementId(agreementId);
        atomReqBO.setSettlementDate(busiReqBO.getPaymentDays());
        atomReqBO.setAssign("2");
        AgrCreateAgreementSettlementAtomRspBO agreementSettlementInfo = this.agrCreateAgreementSettlementAtomService.createAgreementSettlementInfo(atomReqBO);
        if (!"0000".equals(agreementSettlementInfo.getRespCode())) {
            throw new BusinessException(agreementSettlementInfo.getRespCode(), agreementSettlementInfo.getRespDesc());
        }
        if (busiReqBO.getTradeMode() == 1) {
            AgrCreateAgreementSettlementAtomReqBO atomReqBO1 = new AgrCreateAgreementSettlementAtomReqBO();
            atomReqBO1.setSettlementObject("2");
            atomReqBO1.setSettlementType("2");
            atomReqBO1.setPayMethod("2");
            atomReqBO1.setAgreementId(agreementId);
            atomReqBO1.setSettlementDate(busiReqBO.getPaymentDays());
            atomReqBO1.setAssign("2");
            AgrCreateAgreementSettlementAtomRspBO agreementSettlementInfo1 = this.agrCreateAgreementSettlementAtomService.createAgreementSettlementInfo(atomReqBO);
            if (!"0000".equals(agreementSettlementInfo1.getRespCode())) {
                throw new BusinessException(agreementSettlementInfo.getRespCode(), agreementSettlementInfo.getRespDesc());
            }
        }
    }

    private void insertAgreementOther(CrcAddAgreementPushBusiReqBO busiReqBO, AgreementPO agreementPO) {
        AgrCreateAgreementOtherAtomReqBO atomReqBO = new AgrCreateAgreementOtherAtomReqBO();
        atomReqBO.setMemIdIn(busiReqBO.getProducerId());
        atomReqBO.setSupplierId(agreementPO.getSupplierId());
        atomReqBO.setUserName(busiReqBO.getProducerName());
        atomReqBO.setAgreementId(agreementPO.getAgreementId());
        atomReqBO.setAgreementVersion(agreementPO.getAgreementVersion());
        if (!CollectionUtils.isEmpty(busiReqBO.getAttach())) {
            for (AgrAgreementAttachBO attach : busiReqBO.getAttach()) {
                attach.setAttachmentType(Byte.valueOf((byte)1));
            }
        }
        atomReqBO.setAgrAgreementAttachBOs(busiReqBO.getAttach());
        ArrayList<AgrAgreementScopeBO> agrAgreementScopeBOs = new ArrayList<AgrAgreementScopeBO>();
        AgrAgreementScopeBO agrAgreementScopeBO = new AgrAgreementScopeBO();
        if (busiReqBO.getSysTenantId() != null) {
            agrAgreementScopeBO.setScopeCode(busiReqBO.getSysTenantId());
        } else {
            agrAgreementScopeBO.setScopeCode(Long.valueOf(305775845729763327L));
        }
        agrAgreementScopeBO.setScopeName("\u5168\u56fd");
        agrAgreementScopeBOs.add(agrAgreementScopeBO);
        atomReqBO.setAgrAgreementScopeBOs(agrAgreementScopeBOs);
        atomReqBO.setScopeType((byte)0);
        atomReqBO.setOperType("add");
        AgrCreateAgreementOtherAtomRspBO atomRspBO = this.agrCreateAgreementOtherAtomService.createAgreementOtherInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
    }

    private void insertAgreementSupplier(CrcAddAgreementPushBusiReqBO busiReqBO, Long agreementId) {
        ArrayList<AgrAgreementSupplierPO> list = new ArrayList<AgrAgreementSupplierPO>();
        for (AgrAgreementSupplierBO agrAgreementSupplierBO : busiReqBO.getDistribution()) {
            AgrAgreementSupplierPO agrAgreementSupplierPO = new AgrAgreementSupplierPO();
            Long id = Sequence.getInstance().nextId();
            BeanUtils.copyProperties((Object)agrAgreementSupplierBO, (Object)agrAgreementSupplierPO);
            agrAgreementSupplierPO.setId(id);
            agrAgreementSupplierPO.setAgreementId(agreementId);
            agrAgreementSupplierPO.setIsDelete("0");
            list.add(agrAgreementSupplierPO);
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.agrAgreementSupplierMapper.insertBatch(list);
        }
    }

    private void insertAgreementScopeLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId, CrcAddAgreementPushBusiReqBO reqBO) {
        int count;
        AgreementScopePO agreementScopePO = new AgreementScopePO();
        agreementScopePO.setSupplierId(supplierId);
        agreementScopePO.setAgreementIds(agreementIds);
        agreementScopePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        agreementScopePO.setSysTenantId(reqBO.getSysTenantId());
        agreementScopePO.setSysTenantName(reqBO.getSysTenantName());
        List<AgreementScopePO> agreementScopeList = this.agreementScopeMapper.getList(agreementScopePO);
        ArrayList<AgreementScopeLogPO> agreementScopeLogPOList = new ArrayList<AgreementScopeLogPO>();
        for (AgreementScopePO agreementScopePO1 : agreementScopeList) {
            AgreementScopeLogPO agreementScopeLogPO = new AgreementScopeLogPO();
            BeanUtils.copyProperties((Object)agreementScopePO1, (Object)agreementScopeLogPO);
            agreementScopeLogPO.setAgreementLogId(agreementLogId);
            agreementScopeLogPOList.add(agreementScopeLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementScopeLogPOList) && (count = this.agreementScopeLogMapper.insertBatch(agreementScopeLogPOList)) != agreementScopeLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u8303\u56f4\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementAttachLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId) {
        int count;
        AgreementAttachPO agreementAttachPO = new AgreementAttachPO();
        agreementAttachPO.setSupplierId(supplierId);
        agreementAttachPO.setAgreementIds(agreementIds);
        agreementAttachPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementAttachPO> agreementAttachList = this.agreementAttachMapper.getList(agreementAttachPO);
        ArrayList<AgrAgreementAttachLogPO> agrAgreementAttachLogPOList = new ArrayList<AgrAgreementAttachLogPO>();
        for (AgreementAttachPO agreementAttachPO1 : agreementAttachList) {
            AgrAgreementAttachLogPO agrAgreementAttachLogPO = new AgrAgreementAttachLogPO();
            BeanUtils.copyProperties((Object)agreementAttachPO1, (Object)agrAgreementAttachLogPO);
            agrAgreementAttachLogPO.setAgreementLogId(agreementLogId);
            agrAgreementAttachLogPOList.add(agrAgreementAttachLogPO);
        }
        if (!CollectionUtils.isEmpty(agrAgreementAttachLogPOList) && (count = this.agrAgreementAttachLogMapper.insertBatch(agrAgreementAttachLogPOList)) != agrAgreementAttachLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u9644\u4ef6\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementSettlementLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId) {
        AgreementSettlementPO agreementSettlementPO = new AgreementSettlementPO();
        agreementSettlementPO.setAgreementIds(agreementIds);
        List<AgreementSettlementPO> list = this.agreementSettlementMapper.getList(agreementSettlementPO);
        ArrayList<AgreementSettlementLogPO> agreementSettlementLogPOList = new ArrayList<AgreementSettlementLogPO>();
        for (AgreementSettlementPO as : list) {
            AgreementSettlementLogPO agreementSettlementLogPO = new AgreementSettlementLogPO();
            BeanUtils.copyProperties((Object)as, (Object)agreementSettlementLogPO);
            Long settleMentLogId = Sequence.getInstance().nextId();
            agreementSettlementLogPO.setAgreementLogId(agreementLogId);
            agreementSettlementLogPO.setSettlementLogId(settleMentLogId);
            agreementSettlementLogPOList.add(agreementSettlementLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementSettlementLogPOList)) {
            log.info("\u534f\u8bae\u4ed8\u6b3e\u65b9\u5f0f\u5199\u5165\u5165\u53c2==========================================" + agreementSettlementLogPOList);
            int count = this.agreementSettlementLogMapper.insertBatch(agreementSettlementLogPOList);
            if (count != agreementSettlementLogPOList.size()) {
                throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u65e5\u5fd7\u8868\u5931\u8d25");
            }
        }
    }

    private List<AgrAgreementSkuPurchaseDemandBO> insertAgreementSku(CrcAddAgreementPushBusiReqBO busiReqBO, Long agreementId) {
        ArrayList<AgreementSkuPO> agreementSkuPOS = new ArrayList<AgreementSkuPO>();
        ArrayList<AgrAgreementSkuPurchaseDemandBO> agrAgreementSkuPurchaseDemandBOS = new ArrayList<AgrAgreementSkuPurchaseDemandBO>();
        for (AgrAgreementSkuBO bo : busiReqBO.getAgrAgreementSkuBOS()) {
            BigDecimal bigDecimal3;
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuPO);
            agreementSkuPO.setAgreementId(agreementId);
            agreementSkuPO.setAgreementSkuId(Sequence.getInstance().nextId());
            agreementSkuPO.setIsDelete((byte)0);
            DecimalFormat df = new DecimalFormat("0.0000");
            if (StringUtils.isNotBlank((CharSequence)bo.getBuyPriceStr())) {
                BigDecimal bigDecimal2 = new BigDecimal(bo.getBuyPriceStr());
                String buyPrice = df.format(bigDecimal2);
                agreementSkuPO.setBuyPrice(new BigDecimal(buyPrice).multiply(new BigDecimal(10000)).longValue());
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getBuyPriceSumStr())) {
                bigDecimal3 = new BigDecimal(bo.getBuyPriceSumStr());
                String buyPriceSum = df.format(bigDecimal3);
                agreementSkuPO.setBuyPriceSum(new BigDecimal(buyPriceSum).multiply(new BigDecimal(10000)).longValue());
            }
            if (busiReqBO.getAgreementClassification() == 4) {
                bigDecimal3 = new BigDecimal(bo.getSalePriceStr());
                String salePrice = df.format(bigDecimal3);
                agreementSkuPO.setSalePrice(new BigDecimal(salePrice).multiply(new BigDecimal(10000)).longValue());
                agreementSkuPO.setSalePriceSum(new BigDecimal(agreementSkuPO.getSalePrice()).multiply(agreementSkuPO.getBuyNumber()).longValue());
            } else if (busiReqBO.getTradeMode() == 2) {
                agreementSkuPO.setSalePrice(agreementSkuPO.getBuyPrice());
                agreementSkuPO.setSalePriceSum(agreementSkuPO.getBuyPriceSum());
            } else {
                agreementSkuPO.setSalePrice(agreementSkuPO.getBuyPrice());
                agreementSkuPO.setSalePriceSum(agreementSkuPO.getBuyPriceSum());
                agreementSkuPO.setMarkupRule((byte)1);
                agreementSkuPO.setMarkupRate(0.0);
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getMarkupAmountStr())) {
                bigDecimal3 = new BigDecimal(bo.getMarkupAmountStr());
                String markupAmount = df.format(bigDecimal3);
                agreementSkuPO.setMarkupAmount(new BigDecimal(markupAmount).multiply(new BigDecimal(10000)).longValue());
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getExtField6Str())) {
                bigDecimal3 = new BigDecimal(bo.getExtField6Str());
                String extField6 = df.format(bigDecimal3);
                agreementSkuPO.setExtField6(new BigDecimal(extField6).multiply(new BigDecimal(10000)).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getExtField7Str())) {
                bigDecimal3 = new BigDecimal(bo.getExtField7Str());
                String extField7 = df.format(bigDecimal3);
                agreementSkuPO.setExtField7(new BigDecimal(extField7).multiply(new BigDecimal(10000)).toString());
            }
            agreementSkuPO.setBuyNumber(null == bo.getBuyNumber() ? null : bo.getBuyNumber());
            agreementSkuPO.setCreateName(bo.getCreateName());
            agreementSkuPO.setCreateTime(new Date());
            agreementSkuPO.setAgreementVersion("V1");
            agreementSkuPO.setSkuStatus((byte)20);
            if (null == bo.getIsOil()) {
                agreementSkuPO.setIsOil((byte)0);
            }
            if (null != bo.getPurchaseDemandId()) {
                agreementSkuPO.setExtField4(bo.getPurchaseDemandId().toString());
                AgrAgreementSkuPurchaseDemandBO agreementSkuPurchaseDemandBO = new AgrAgreementSkuPurchaseDemandBO();
                agreementSkuPurchaseDemandBO.setAgreementSkuId(agreementSkuPO.getAgreementSkuId());
                agreementSkuPurchaseDemandBO.setPurchaseDemandId(bo.getPurchaseDemandId());
                agrAgreementSkuPurchaseDemandBOS.add(agreementSkuPurchaseDemandBO);
            }
            if (StringUtils.isBlank((CharSequence)agreementSkuPO.getCatalogName())) {
                agreementSkuPO.setCatalogName(agreementSkuPO.getCommodityTypeName());
            }
            agreementSkuPO.setRemark("\u6bd4\u4ef7\u5355\u63a8\u9001");
            agreementSkuPOS.add(agreementSkuPO);
        }
        if (!CollectionUtils.isEmpty(agreementSkuPOS)) {
            int count;
            this.agreementSkuMapper.insertBatch(agreementSkuPOS);
            AgreementLogPO agreementLogPO = new AgreementLogPO();
            agreementLogPO.setLogStatus("2");
            agreementLogPO.setAgreementId(agreementId);
            AgreementLogPO alo = this.agreementLogMapper.getModelBy(agreementLogPO);
            ArrayList<AgreementSkuLogPO> agreementSkuLogPOList = new ArrayList<AgreementSkuLogPO>();
            for (AgreementSkuPO agreementSkuPO1 : agreementSkuPOS) {
                AgreementSkuLogPO agreementSkuLogPO = new AgreementSkuLogPO();
                BeanUtils.copyProperties((Object)agreementSkuPO1, (Object)agreementSkuLogPO);
                agreementSkuLogPO.setMarkupRate(0.0);
                agreementSkuLogPOList.add(agreementSkuLogPO);
            }
            if (!CollectionUtils.isEmpty(agreementSkuLogPOList) && (count = this.agreementSkuLogMapper.insertBatch(agreementSkuLogPOList)) != agreementSkuLogPOList.size()) {
                throw new com.tydic.uac.exception.BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u65e5\u5fd7\u8868\u5931\u8d25");
            }
        }
        return agrAgreementSkuPurchaseDemandBOS;
    }
}

