/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.agreement.ability.api.AgrQryCorporationListByScopeAbilityService;
import com.tydic.agreement.ability.bo.AgrCorPorationBO;
import com.tydic.agreement.ability.bo.AgrQryCorporationListByScopeAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryCorporationListByScopeAbilityRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementScopeMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementScopePO;
import com.tydic.umc.general.ability.api.UmcQryMemLegalOrgInfoAbilityService;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceReqBO;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceRspBO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrQryCorporationListByScopeAbilityService"})
public class AgrQryCorporationListByScopeAbilityServiceImpl
implements AgrQryCorporationListByScopeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrQryCorporationListByScopeAbilityServiceImpl.class);
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private UmcQryMemLegalOrgInfoAbilityService umcQryMemLegalOrgInfoAbilityService;

    @PostMapping(value={"qryCorporationListByScope"})
    public AgrQryCorporationListByScopeAbilityRspBO qryCorporationListByScope(@RequestBody AgrQryCorporationListByScopeAbilityReqBO reqBO) {
        AgrQryCorporationListByScopeAbilityRspBO rspBO = new AgrQryCorporationListByScopeAbilityRspBO();
        ArrayList<AgrCorPorationBO> corPorationBOList = new ArrayList<AgrCorPorationBO>();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(reqBO.getAgreementId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new com.tydic.uac.exception.BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        UmcQryMemLegalOrgInfoAbilityServiceReqBO umcQryMemLegalOrgInfoAbilityServiceReqBO = new UmcQryMemLegalOrgInfoAbilityServiceReqBO();
        umcQryMemLegalOrgInfoAbilityServiceReqBO.setMemId(reqBO.getUserId());
        umcQryMemLegalOrgInfoAbilityServiceReqBO.setSysTenantId(reqBO.getSysTenantId());
        log.info("\u901a\u8fc7ldap\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)umcQryMemLegalOrgInfoAbilityServiceReqBO));
        UmcQryMemLegalOrgInfoAbilityServiceRspBO umcQryMemLegalOrgInfoAbilityServiceRspBO = this.umcQryMemLegalOrgInfoAbilityService.qryMemLegalOrgInfo(umcQryMemLegalOrgInfoAbilityServiceReqBO);
        log.info("\u901a\u8fc7ldap\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)umcQryMemLegalOrgInfoAbilityServiceRspBO));
        if (!"0000".equals(umcQryMemLegalOrgInfoAbilityServiceRspBO.getRespCode())) {
            throw new BusinessException("0101", umcQryMemLegalOrgInfoAbilityServiceRspBO.getRespDesc());
        }
        for (AgrCorPorationBO agrCorPorationBO : reqBO.getCorPorationBOList()) {
            if (!this.getStatus(agreement, agrCorPorationBO.getCorporationId(), umcQryMemLegalOrgInfoAbilityServiceRspBO).booleanValue()) continue;
            corPorationBOList.add(agrCorPorationBO);
        }
        rspBO.setCorPorationBOList(corPorationBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Boolean getStatus(AgreementPO supPO, Long corporationId, UmcQryMemLegalOrgInfoAbilityServiceRspBO umcQryMemLegalOrgInfoAbilityServiceRspBO) {
        Boolean status = false;
        AgreementScopePO agreementScopePO = new AgreementScopePO();
        agreementScopePO.setAgreementId(supPO.getAgreementId());
        agreementScopePO.setIsDelete((byte)0);
        List<AgreementScopePO> agreementScopePOList = this.agreementScopeMapper.getList(agreementScopePO);
        block0 : switch (supPO.getScopeType()) {
            case 0: {
                if (!umcQryMemLegalOrgInfoAbilityServiceRspBO.getMemInformation().getSysTenantId().equals(agreementScopePOList.get(0).getScopeCode())) break;
                status = true;
                break;
            }
            case 2: {
                if (!umcQryMemLegalOrgInfoAbilityServiceRspBO.getTwoLevelOrgInfo().getOrgId().equals(agreementScopePOList.get(0).getScopeCode())) break;
                status = true;
                break;
            }
            case 5: {
                for (AgreementScopePO scopePO : agreementScopePOList) {
                    if (!corporationId.equals(scopePO.getScopeCode())) continue;
                    status = true;
                    break block0;
                }
                break;
            }
            case 7: {
                for (AgreementScopePO scopePO : agreementScopePOList) {
                    if (!umcQryMemLegalOrgInfoAbilityServiceRspBO.getMemInformation().getSysTenantId().equals(scopePO.getScopeCode())) continue;
                    status = true;
                    break block0;
                }
                break;
            }
            case 8: {
                status = true;
                break;
            }
            case 9: {
                for (AgreementScopePO scopePO : agreementScopePOList) {
                    if (1 == scopePO.getIncludeSubOrg()) {
                        if (!umcQryMemLegalOrgInfoAbilityServiceRspBO.getMemInformation().getOrgTreePath().contains(scopePO.getScopeCode().toString())) continue;
                        status = true;
                        break block0;
                    }
                    if (!umcQryMemLegalOrgInfoAbilityServiceRspBO.getMemInformation().getOrgId().equals(scopePO.getScopeCode())) continue;
                    status = true;
                    break block0;
                }
                break;
            }
        }
        return status;
    }
}

