/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.agreement.ability.bo.AgrAgreementDictionaryCodeBO;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.ability.bo.AgrImoprtTemplateBO;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.bo.AgrExternalImportResultLogAtomReqBO;
import com.tydic.agreement.atom.bo.AgrExternalImportResultLogAtomRspBO;
import com.tydic.agreement.atom.impl.CnncAgrExternalImportResultLogServiceHolder;
import com.tydic.agreement.busi.api.AgrBatchImportAgreementSkuBusiService;
import com.tydic.agreement.busi.api.AgrCnncAgrExportImportResultsBusiService;
import com.tydic.agreement.busi.bo.AgrBatchImportAgreementSkuBusiReqBO;
import com.tydic.agreement.busi.bo.AgrBatchImportAgreementSkuBusiRspBO;
import com.tydic.agreement.busi.bo.AgrExportImportResultsBusiReqBO;
import com.tydic.agreement.busi.bo.AgrExportImportResultsBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.constants.AgrExtCommonConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.agreement.utils.ExcelUtils;
import com.tydic.agreement.utils.HttpUtil;
import com.tydic.commodity.zone.ability.api.UccAgrSkuImportCheckAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckBO;
import com.tydic.fsc.base.FscRspPageBaseBO;
import com.tydic.fsc.bo.FscDicDictionaryReqBO;
import com.tydic.fsc.common.ability.api.FscDictionaryAbilityService;
import com.tydic.fsc.common.ability.bo.FscDictionaryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscQueryDictionaryAbilityReqBO;
import com.tydic.umc.general.ability.api.UmcPesDicQryListByConfigKeysAbilityService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AgrBatchImportAgreementSkuBusiServiceImpl
implements AgrBatchImportAgreementSkuBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrBatchImportAgreementSkuBusiServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private UccAgrSkuImportCheckAbilityService uccAgrSkuImportCheckAbilityService;
    @Autowired
    private UmcPesDicQryListByConfigKeysAbilityService umcPesDicQryListByConfigKeysAbilityService;
    @Autowired
    private CnncAgrExternalImportResultLogServiceHolder cnncAgrExternalImportResultLogServiceHolder;
    @Autowired
    private AgrCnncAgrExportImportResultsBusiService cnncAgrExportImportResultsBusiService;
    @Autowired
    private FscDictionaryAbilityService fscDictionaryAbilityService;
    public static final String DICTIONARY_KEY_PREFIX = "PES_DIC_";
    public static final int DICTIONARY_KEY_EXPIRE = 3600;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${HK.sysTenantId:1104853665419067393}")
    private Long sysTenantIdHK;

    @Override
    public AgrBatchImportAgreementSkuBusiRspBO dealAgrDetailedBatchImportAgreement(AgrBatchImportAgreementSkuBusiReqBO busiReqBO) {
        Iterator uccRspMap;
        List agreementSkuPOs;
        AgrBatchImportAgreementSkuBusiRspBO rsp = new AgrBatchImportAgreementSkuBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new com.tydic.uac.exception.BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        if (!(AgrCommConstant.AgreementStatus.DRAFT.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.REJECT.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.NO_ASS.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.NO_CONFIRM.equals(agreement.getAgreementStatus()))) {
            throw new com.tydic.uac.exception.BusinessException("22002", "\u53ea\u6709\u8349\u7a3f\u4e2d,\u672a\u5b8c\u6210,\u672a\u63a5\u53d7\u548c\u9a73\u56de\u72b6\u6001\u7684\u534f\u8bae\u53ef\u4ee5\u521b\u5efa\u534f\u8bae\u660e\u7ec6\uff01");
        }
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            HttpUtil.deleteFile("temporaryfile/content.xlsx");
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/content.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(busiReqBO.getUrl(), file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            this.getExcelDateByImport((MultipartFile)multipartFile, data, title, agreement);
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new com.tydic.uac.exception.BusinessException("22052", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new com.tydic.uac.exception.BusinessException("22052", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(data)) {
            throw new com.tydic.uac.exception.BusinessException("22052", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Integer> dateMapIndex = new HashMap<String, Integer>();
        String importTemplateStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IMPORT_TEMPLATE_PCODE", "1");
        List templateBOs = JSON.parseArray((String)importTemplateStr, AgrImoprtTemplateBO.class);
        block8: for (AgrImoprtTemplateBO bo : templateBOs) {
            for (int i = 0; i < title.size(); ++i) {
                if (!((String)title.get(i)).equals(bo.getFieldName())) continue;
                dateMapIndex.put(bo.getFieldNameEng(), i);
                continue block8;
            }
        }
        ArrayList importDataMaps = new ArrayList();
        ArrayList<String> materialCodes = new ArrayList<String>();
        ArrayList dateMaps = new ArrayList();
        Map<String, List<AgrAgreementDictionaryCodeBO>> dictMapList = busiReqBO.getData();
        log.info("\u7a0e\u7387\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u503c:{}", dictMapList);
        ArrayList<String> importVendorMaterialCodeList = new ArrayList<String>();
        ArrayList<String> importMaterialCodeList = new ArrayList<String>();
        List<AgrAgreementDictionaryCodeBO> taxRatePcodeList = dictMapList.get("AGR_TAX_RATE_PCODE");
        ArrayList<Byte> taxList = new ArrayList<Byte>();
        for (AgrAgreementDictionaryCodeBO bo : taxRatePcodeList) {
            taxList.add(Byte.valueOf(bo.getCode()));
        }
        List<AgrAgreementDictionaryCodeBO> taxCatCodeList = dictMapList.get("ucc_tax_cat_code_value");
        ArrayList<String> taxCatList = new ArrayList<String>();
        for (AgrAgreementDictionaryCodeBO bo : taxCatCodeList) {
            taxCatList.add(bo.getCode());
        }
        ArrayList<String> addTaxCatList = new ArrayList<String>();
        String errorMessage = "";
        try {
            int i = 1;
            for (List list : data) {
                boolean importErrMsgFlag = false;
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                StringBuilder importRemark = new StringBuilder();
                for (AgrImoprtTemplateBO bo : templateBOs) {
                    String markupAmount;
                    String extField7;
                    String extField6;
                    String salePrice;
                    String buyPrice;
                    Integer sheetKey = (Integer)dateMapIndex.get(bo.getFieldNameEng());
                    if (null == sheetKey) {
                        if (this.sysTenantIdHK.equals(busiReqBO.getSysTenantId()) && ("\u7a0e\u7387".equals(bo.getFieldName()) || "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801".equals(bo.getFieldName()))) continue;
                        importErrMsgFlag = true;
                        importRemark.setLength(0);
                        importRemark.append("\u7b2c" + i + "\u884c\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6570\u636e\u5e93\u6a21\u7248\u914d\u7f6e\u7684\u3010").append(bo.getFieldNameEng()).append("\u3011\u4e3a\u7a7a\uff01");
                        continue;
                    }
                    if (sheetKey >= list.size()) continue;
                    Object content = list.get(sheetKey);
                    if (bo.getIsMustFill().booleanValue()) {
                        if (agreement.getTradeMode() == 2) {
                            if (!("buyPrice".equals(bo.getFieldNameEng()) || this.sysTenantIdHK.equals(busiReqBO.getSysTenantId()) && ("\u7a0e\u7387".equals(bo.getFieldName()) || "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801".equals(bo.getFieldName())) || null != content && !"".equals(content) && !"null".equals(content))) {
                                importErrMsgFlag = true;
                                importRemark.setLength(0);
                                importRemark.append("\u7b2c" + i + "\u884c\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u3010").append(bo.getFieldName()).append("\u3011\u5fc5\u586b\uff01");
                                continue;
                            }
                        } else if (!("markupRate".equals(bo.getFieldNameEng()) || "markupAmount".equals(bo.getFieldNameEng()) || "extField6".equals(bo.getFieldNameEng()) || "extField7".equals(bo.getFieldNameEng()) || this.sysTenantIdHK.equals(busiReqBO.getSysTenantId()) && ("\u7a0e\u7387".equals(bo.getFieldName()) || "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801".equals(bo.getFieldName())) || null != content && !"".equals(content) && !"null".equals(content))) {
                            importErrMsgFlag = true;
                            importRemark.setLength(0);
                            importRemark.append("\u7b2c" + i + "\u884c\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u3010").append(bo.getFieldName()).append("\u3011\u5fc5\u586b\uff01");
                            continue;
                        }
                    } else if ("null".equals(content)) {
                        content = "";
                    }
                    if ("markupRate".equals(bo.getFieldNameEng())) {
                        String markupRate = (String)content;
                        if (StringUtils.isEmpty((Object)markupRate) || "null".equals(markupRate)) {
                            markupRate = "0";
                        }
                        if (agreement.getTradeMode() == 2 && !markupRate.equals("0")) {
                            importErrMsgFlag = true;
                            importRemark.setLength(0);
                            importRemark.append("\u7b2c" + i + "\u884c\u534f\u8bae\u7684\u4ea4\u6613\u6a21\u5f0f\u4e3a\u64ae\u5408\u6a21\u5f0f\u65f6\u52a0\u4ef7\u6bd4\u7387\u5fc5\u987b\u4e3a0");
                            continue;
                        }
                        content = markupRate;
                    }
                    if ("buyPrice".equals(bo.getFieldNameEng()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(buyPrice = (String)content))) {
                        String string = content = (buyPrice = new BigDecimal(buyPrice).multiply(new BigDecimal(10000)).toString()).endsWith(".00") ? buyPrice.substring(0, buyPrice.lastIndexOf(".00")) : buyPrice;
                    }
                    if ("salePrice".equals(bo.getFieldNameEng()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(salePrice = (String)content))) {
                        String string = content = (salePrice = new BigDecimal(salePrice).multiply(new BigDecimal(10000)).toString()).endsWith(".00") ? salePrice.substring(0, salePrice.lastIndexOf(".00")) : salePrice;
                    }
                    if ("materialCode".equals(bo.getFieldNameEng())) {
                        String materialCode = (String)content;
                        if (importMaterialCodeList.contains(materialCode) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)materialCode)) {
                            importErrMsgFlag = true;
                            importRemark.setLength(0);
                            importRemark.append("\u7b2c" + i + "\u884c\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u7684\u4f9b\u5e94\u5546\u7269\u6599\u7f16\u7801\u3010").append(materialCode).append("\u3011\u5728excel\u4e2d\u5b58\u5728\u4e24\u6b21\u4ee5\u4e0a\uff01");
                            continue;
                        }
                        importMaterialCodeList.add(materialCode);
                    }
                    if ("vendorMaterialCode".equals(bo.getFieldNameEng())) {
                        String vendorMaterialCode = (String)content;
                        if (importVendorMaterialCodeList.contains(vendorMaterialCode) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vendorMaterialCode)) {
                            importErrMsgFlag = true;
                            importRemark.setLength(0);
                            importRemark.append("\u7b2c" + i + "\u884c\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u7684\u4f9b\u5e94\u5546\u7269\u6599\u7f16\u7801\u3010").append(vendorMaterialCode).append("\u3011\u5728excel\u4e2d\u5b58\u5728\u4e24\u6b21\u4ee5\u4e0a\uff01");
                            continue;
                        }
                        importVendorMaterialCodeList.add(vendorMaterialCode);
                    }
                    if ("extField6".equals(bo.getFieldNameEng()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(extField6 = (String)content))) {
                        String string = content = (extField6 = new BigDecimal(extField6).multiply(new BigDecimal(10000)).toString()).endsWith(".00") ? extField6.substring(0, extField6.lastIndexOf(".00")) : extField6;
                    }
                    if ("extField7".equals(bo.getFieldNameEng()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(extField7 = (String)content))) {
                        String string = content = (extField7 = new BigDecimal(extField7).multiply(new BigDecimal(10000)).toString()).endsWith(".00") ? extField7.substring(0, extField7.lastIndexOf(".00")) : extField7;
                    }
                    if ("markupAmount".equals(bo.getFieldNameEng()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(markupAmount = (String)content))) {
                        content = (markupAmount = new BigDecimal(markupAmount).multiply(new BigDecimal(10000)).toString()).endsWith(".00") ? markupAmount.substring(0, markupAmount.lastIndexOf(".00")) : markupAmount;
                    }
                    dataMap.put(bo.getFieldNameEng(), content);
                }
                if (importErrMsgFlag) {
                    dataMap.put("impResult", AgrExtCommonConstant.ImportResult.FAILED);
                    dataMap.put("impRemark", importRemark.toString());
                    errorMessage = importRemark.toString();
                    throw new com.tydic.uac.exception.BusinessException("8888", importRemark.toString());
                }
                dataMap.put("impRemark", "\u6210\u529f");
                dataMap.put("impResult", AgrExtCommonConstant.ImportResult.SUCCESS);
                dataMap.putIfAbsent("taxRate", 0);
                try {
                    if (Double.valueOf(dataMap.get("taxRate").toString()) < 1.0) {
                        Double taxRate = Double.valueOf(dataMap.get("taxRate").toString()) * 100.0;
                        dataMap.put("taxRate", taxRate.byteValue());
                    }
                    if (null != dataMap.get("markupRate") && Double.valueOf(dataMap.get("markupRate").toString()) < 1.0) {
                        Double markupRate = Double.valueOf(dataMap.get("markupRate").toString()) * 100.0;
                        dataMap.put("markupRate", markupRate.byteValue());
                    }
                }
                catch (Exception e) {
                    throw new com.tydic.uac.exception.BusinessException("22052", "\u6587\u4ef6\u6570\u636e\u89e3\u6790\u9519\u8bef\uff01");
                }
                log.info("\u53c2\u6570:{}", dataMap);
                if (!taxList.contains(dataMap.get("taxRate")) && !this.sysTenantIdHK.equals(busiReqBO.getSysTenantId())) {
                    errorMessage = "\u7b2c" + i + "\u884c\u7a0e\u7387\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303!";
                    throw new com.tydic.uac.exception.BusinessException("8888", "\u7a0e\u7387\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303");
                }
                if (!taxCatList.contains(dataMap.get("taxCatalog").toString())) {
                    addTaxCatList.add(dataMap.get("taxCatalog").toString());
                    taxCatList.add(dataMap.get("taxCatalog").toString());
                }
                importDataMaps.add(dataMap);
                materialCodes.add(dataMap.get("materialCode").toString());
            }
            ++i;
        }
        catch (com.tydic.uac.exception.BusinessException e) {
            throw new com.tydic.uac.exception.BusinessException("8888", ObjectUtils.isEmpty((Object)errorMessage) ? "\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01" : errorMessage);
        }
        AgreementSkuPO agreementSkuVerifyPO = new AgreementSkuPO();
        agreementSkuVerifyPO.setMaterialCodes(materialCodes);
        agreementSkuVerifyPO.setAgreementId(agreement.getAgreementId());
        agreementSkuVerifyPO.setAgreementVersion(agreement.getAgreementVersion());
        agreementSkuVerifyPO.setIsDelete(Byte.valueOf("0"));
        log.info("\u591a\u6b21\u5bfc\u5165\u6821\u9a8c\u53c2\u6570:{}", (Object)agreementSkuVerifyPO);
        List<AgreementSkuPO> agreementSkuPOList = this.agreementSkuMapper.getList(agreementSkuVerifyPO);
        if (!ObjectUtils.isEmpty(agreementSkuPOList)) {
            throw new com.tydic.uac.exception.BusinessException("8888", "\u7269\u6599\u7f16\u7801:" + agreementSkuPOList.get(0).getMaterialCode() + "\u5df2\u5b58\u5728");
        }
        String string = JSON.toJSONString(importDataMaps);
        log.info("\u83b7\u53d6\u5230\u7684\u6570\u636e\u5bf9\u8c61\uff1a" + string);
        try {
            agreementSkuPOs = JSON.parseArray((String)string, AgreementSkuPO.class);
        }
        catch (Exception e) {
            throw new com.tydic.uac.exception.BusinessException("22052", "\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
        }
        if (agreementSkuPOs.size() > 3000) {
            throw new com.tydic.uac.exception.BusinessException("0002", "\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u4e0d\u80fd\u8d85\u8fc7 3000\u6761\uff01");
        }
        ArrayList<UccAgrSkuImportCheckBO> rows = new ArrayList<UccAgrSkuImportCheckBO>();
        log.info("\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u89e3\u6790\u6570\u636e \uff1a" + JSONObject.toJSONString(agreementSkuPOs.get(0)));
        for (int i = 0; i < agreementSkuPOs.size(); ++i) {
            UccAgrSkuImportCheckBO bo = new UccAgrSkuImportCheckBO();
            bo.setSerialNumber(Integer.valueOf(i));
            bo.setCommodityTypeName(((AgreementSkuPO)agreementSkuPOs.get(i)).getCommodityTypeName());
            bo.setMaterialCode(((AgreementSkuPO)agreementSkuPOs.get(i)).getMaterialCode().toString());
            bo.setMeasureName(((AgreementSkuPO)agreementSkuPOs.get(i)).getMeasureName().toString());
            rows.add(bo);
        }
        UccAgrSkuImportCheckAbilityReqBO uccAgrSkuImportCheckAbilityReqBO = new UccAgrSkuImportCheckAbilityReqBO();
        uccAgrSkuImportCheckAbilityReqBO.setRows(rows);
        log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6821\u9a8c\u670d\u52a1\u5165\u53c2 \uff1a" + JSONObject.toJSONString((Object)uccAgrSkuImportCheckAbilityReqBO));
        UccAgrSkuImportCheckAbilityRspBO uccAgrSkuImportCheckAbilityRspBO = this.uccAgrSkuImportCheckAbilityService.checkInfo(uccAgrSkuImportCheckAbilityReqBO);
        log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6821\u9a8c\u670d\u52a1\u51fa\u53c2 \uff1a" + JSONObject.toJSONString((Object)uccAgrSkuImportCheckAbilityRspBO));
        if ("0000".equals(uccAgrSkuImportCheckAbilityRspBO.getRespCode())) {
            uccRspMap = uccAgrSkuImportCheckAbilityRspBO.getRows().stream().collect(Collectors.toMap(UccAgrSkuImportCheckBO::getSerialNumber, Function.identity()));
            for (int i = 0; i < agreementSkuPOs.size(); ++i) {
                if (!((UccAgrSkuImportCheckBO)uccRspMap.get(i)).isPass()) {
                    ((AgreementSkuPO)agreementSkuPOs.get(i)).setImpRemark(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getReson());
                    ((AgreementSkuPO)agreementSkuPOs.get(i)).setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    throw new com.tydic.uac.exception.BusinessException("8888", "\u7b2c" + i + "\u884c" + ((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getReson());
                }
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setMeasureId(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getMeasureId());
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setMaterialId(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getMaterialId().toString());
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setMaterialCode(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getMaterialCode());
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setMaterialName(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getMaterialName());
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setCatalogId(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getCatalogId().toString());
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setCatalogName(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getCatalogName());
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setCommodityTypeId(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getCommodityTypeId());
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setCommodityTypeName(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getCommodityTypeName());
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setModel(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getModel());
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setSpec(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getSpec());
            }
        } else {
            uccRspMap = agreementSkuPOs.iterator();
            if (uccRspMap.hasNext()) {
                AgreementSkuPO agreementSkuPO = (AgreementSkuPO)uccRspMap.next();
                agreementSkuPO.setImpRemark("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165" + uccAgrSkuImportCheckAbilityRspBO.getRespDesc());
                agreementSkuPO.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                throw new com.tydic.uac.exception.BusinessException("8888", "\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165" + uccAgrSkuImportCheckAbilityRspBO.getRespDesc());
            }
        }
        ArrayList<AgreementSkuPO> insertSkuPoList = new ArrayList<AgreementSkuPO>();
        int i = 1;
        for (AgreementSkuPO po : agreementSkuPOs) {
            if (po.getMarkupRate() == null) {
                po.setMarkupRate(new BigDecimal("0").divide(new BigDecimal(100)).doubleValue());
            }
            po.setAgreementSkuId(Sequence.getInstance().nextId());
            po.setAgreementId(agreement.getAgreementId());
            po.setSupplierId(agreement.getSupplierId());
            po.setAgreementVersion(agreement.getAgreementVersion());
            po.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            po.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            po.setCreateLoginId(busiReqBO.getMemIdIn());
            po.setCreateName(busiReqBO.getUserName());
            po.setCreateTime(new Date());
            if (agreement.getTradeMode() == 1) {
                po.setBuyPriceSum(new BigDecimal(po.getBuyPrice()).multiply(po.getBuyNumber()).longValue());
            }
            if (agreement.getTradeMode() == 1) {
                Long sale = 0L;
                if (null != po.getMarkupRate() && po.getMarkupRate() != 0.0) {
                    sale = new BigDecimal(po.getBuyPrice()).add(new BigDecimal(po.getBuyPrice()).multiply(new BigDecimal(po.getMarkupRate().toString())).divide(new BigDecimal(100))).longValue();
                    po.setMarkupRule((byte)1);
                } else if (null != po.getMarkupAmount()) {
                    sale = new BigDecimal(po.getBuyPrice()).add(new BigDecimal(po.getMarkupAmount())).longValue();
                    po.setMarkupRule((byte)2);
                } else {
                    throw new com.tydic.uac.exception.BusinessException("8888", "\u7b2c" + i + "\u884c\u52a0\u4ef7\u6bd4\u7387\u548c\u52a0\u4ef7\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a)\uff01");
                }
                if (!sale.equals(po.getSalePrice())) {
                    throw new com.tydic.uac.exception.BusinessException("8888", "\u7b2c" + i + "\u884c\u9500\u552e\u5355\u4ef7\u586b\u5199\u6709\u8bef\uff0c\u9500\u552e\u5355\u4ef7 = \u91c7\u8d2d\u5355\u4ef7 + (\u91c7\u8d2d\u5355\u4ef7*\u52a0\u4ef7\u6bd4\u7387)\u6216\u8005\u9500\u552e\u5355\u4ef7 = \u91c7\u8d2d\u5355\u4ef7 + \u52a0\u4ef7\u91d1\u989d)\uff01");
                }
                po.setSalePrice(sale);
            }
            po.setSalePriceSum(new BigDecimal(po.getSalePrice()).multiply(po.getBuyNumber()).longValue());
            if (agreement.getTradeMode() == 2) {
                po.setBuyPrice(po.getSalePrice());
                po.setBuyPriceSum(po.getSalePriceSum());
            }
            if (agreement.getTradeMode() == 1) {
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)po.getExtField6()) && !"0".equals(po.getExtField6())) {
                    if (null == po.getBuyPrice()) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.buyPrice\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (null == po.getBuyPriceSum()) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.buyPriceSum\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (Long.parseLong(po.getExtField6()) < po.getSalePrice() || Long.parseLong(po.getExtField6()) < po.getBuyPrice()) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u534f\u8bae\u4ef7\u4e0a\u9650\u9700\u6ee1\u8db3\uff1a\u534f\u8bae\u4ef7\u4e0a\u9650\u2265\u9500\u552e\u5355\u4ef7\u2265\u534f\u8bae\u4ef7\u4e0b\u9650\u2265\u91c7\u8d2d\u5355\u4ef7");
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)po.getExtField7()) && Long.parseLong(po.getExtField6()) < Long.parseLong(po.getExtField7())) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u534f\u8bae\u4ef7\u4e0a\u9650\u9700\u6ee1\u8db3\uff1a\u534f\u8bae\u4ef7\u4e0a\u9650\u2265\u9500\u552e\u5355\u4ef7\u2265\u534f\u8bae\u4ef7\u4e0b\u9650\u2265\u91c7\u8d2d\u5355\u4ef7");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)po.getExtField7()) && !"0".equals(po.getExtField7())) {
                    if (null == po.getBuyPrice()) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.buyPrice\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (null == po.getBuyPriceSum()) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.buyPriceSum\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (Long.parseLong(po.getExtField7()) < po.getBuyPrice() || Long.parseLong(po.getExtField7()) > po.getSalePrice()) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u534f\u8bae\u4ef7\u4e0b\u9650\u9700\u6ee1\u8db3\uff1a\u534f\u8bae\u4ef7\u4e0a\u9650\u2265\u9500\u552e\u5355\u4ef7\u2265\u534f\u8bae\u4ef7\u4e0b\u9650\u2265\u91c7\u8d2d\u5355\u4ef7");
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)po.getExtField6()) && Long.parseLong(po.getExtField6()) < Long.parseLong(po.getExtField7())) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u534f\u8bae\u4ef7\u4e0b\u9650\u9700\u6ee1\u8db3\uff1a\u534f\u8bae\u4ef7\u4e0a\u9650\u2265\u9500\u552e\u5355\u4ef7\u2265\u534f\u8bae\u4ef7\u4e0b\u9650\u2265\u91c7\u8d2d\u5355\u4ef7");
                    }
                }
            }
            po.setSysTenantId(agreement.getSysTenantId());
            po.setSysTenantName(agreement.getSysTenantName());
            if (po.getImpResult().equals(AgrExtCommonConstant.ImportResult.SUCCESS)) {
                insertSkuPoList.add(po);
            }
            ++i;
        }
        List agrAgreementSkuBOList = JSON.parseArray((String)JSON.toJSONString((Object)agreementSkuPOs), AgrAgreementSkuBO.class);
        AgrExportImportResultsBusiReqBO importResultsBusiReqBO = new AgrExportImportResultsBusiReqBO();
        importResultsBusiReqBO.setImportSkuList(agrAgreementSkuBOList);
        importResultsBusiReqBO.setTradeMode(agreement.getTradeMode());
        log.error("\u8c03\u7528\u5bfc\u51fa\u6587\u4ef6\u5165\u53c2:" + JSON.toJSONString((Object)importResultsBusiReqBO));
        AgrExportImportResultsBusiRspBO importResultsBusiRspBO = this.cnncAgrExportImportResultsBusiService.exportImportResults(importResultsBusiReqBO);
        log.error("\u8c03\u7528\u5bfc\u51fa\u6587\u4ef6\u51fa\u53c2:" + JSON.toJSONString((Object)((Object)importResultsBusiRspBO)));
        if (!importResultsBusiRspBO.getRespCode().equals("0000")) {
            rsp.setRespCode("8888");
            rsp.setRespCode(importResultsBusiRspBO.getRespCode());
            return rsp;
        }
        Long failedImportCounts = 0L;
        Long sucessImportCounts = 0L;
        for (AgreementSkuPO agreementSkuPO : agreementSkuPOs) {
            Long l;
            Long l2;
            if (agreementSkuPO.getImpResult().equals(AgrExtCommonConstant.ImportResult.FAILED)) {
                l2 = failedImportCounts;
                l = failedImportCounts = Long.valueOf(failedImportCounts + 1L);
                continue;
            }
            if (!agreementSkuPO.getImpResult().equals(AgrExtCommonConstant.ImportResult.SUCCESS)) continue;
            l2 = sucessImportCounts;
            l = sucessImportCounts = Long.valueOf(sucessImportCounts + 1L);
        }
        AgrExternalImportResultLogAtomReqBO agrExternalImportResultLogServiceReqBO = new AgrExternalImportResultLogAtomReqBO();
        agrExternalImportResultLogServiceReqBO.setExportData(importResultsBusiRspBO.getExportData());
        agrExternalImportResultLogServiceReqBO.setFileName(importResultsBusiRspBO.getFilePath());
        agrExternalImportResultLogServiceReqBO.setFileUrl(importResultsBusiRspBO.getFullFilePath());
        agrExternalImportResultLogServiceReqBO.setSuccessCount(sucessImportCounts);
        agrExternalImportResultLogServiceReqBO.setFailureCount(failedImportCounts);
        agrExternalImportResultLogServiceReqBO.setMemId(busiReqBO.getMemIdIn());
        agrExternalImportResultLogServiceReqBO.setImpRemark("");
        agrExternalImportResultLogServiceReqBO.setImpResult(0);
        agrExternalImportResultLogServiceReqBO.setIsSkuChange(0);
        agrExternalImportResultLogServiceReqBO.setAgreementId(busiReqBO.getAgreementId());
        agrExternalImportResultLogServiceReqBO.setSysTenantId(agreement.getSysTenantId());
        agrExternalImportResultLogServiceReqBO.setSysTenantName(agreement.getSysTenantName());
        log.error("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)agrExternalImportResultLogServiceReqBO));
        AgrExternalImportResultLogAtomRspBO agrExternalImportResultLogServiceRspBO = this.cnncAgrExternalImportResultLogServiceHolder.getAgrExternalImportResultLogService().importLog(agrExternalImportResultLogServiceReqBO);
        log.error("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)((Object)agrExternalImportResultLogServiceRspBO)));
        if (insertSkuPoList.size() > 0) {
            int isInsert = this.agreementSkuMapper.insertBatch(insertSkuPoList);
            rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6210\u529f!\u603b\u5171\u3010" + data.size() + "\u3011\u6761\u6570\u636e\uff0c\u5bfc\u5165\u6210\u529f\u3010" + isInsert + "\u3011\u6761");
        }
        if (!CollectionUtils.isEmpty(addTaxCatList)) {
            for (String addTaxCat : addTaxCatList) {
                if (StringUtils.isEmpty((Object)addTaxCat)) continue;
                FscDicDictionaryReqBO reqBO = new FscDicDictionaryReqBO();
                reqBO.setCode(addTaxCat);
                reqBO.setTitle(addTaxCat);
                reqBO.setDescrip("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801");
                reqBO.setPCode("FSC_TAX_CAT_CODE_VALUE");
                reqBO.setSysTenantId(busiReqBO.getSysTenantId());
                reqBO.setSysTenantName(busiReqBO.getSysTenantName());
                FscDictionaryAbilityRspBO addRspBO = this.fscDictionaryAbilityService.addDicDictionary(reqBO);
                if ("0000".equals(addRspBO.getRespCode())) continue;
                throw new com.tydic.uac.exception.BusinessException("8888", "\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165,\u65b0\u589e\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5931\u8d25" + addRspBO.getRespDesc());
            }
            this.refreshCodeList("ucc_tax_cat_code_value");
        }
        rsp.setRespCode("0000");
        return rsp;
    }

    private void validateParam(List<AgreementSkuPO> agreementSkuPOs) {
        for (AgreementSkuPO po : agreementSkuPOs) {
            if (!StringUtils.isEmpty((Object)po.getSpec()) || !StringUtils.isEmpty((Object)po.getFigure())) continue;
            throw new com.tydic.uac.exception.BusinessException("0001", "\u89c4\u683c/\u578b\u53f7\u548c\u56fe\u53f7/\u5382\u5bb6\u96f6\u4ef6\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
    }

    private void getExcelDateByImport(MultipartFile multipartFile, List<List<String>> data, List<String> title, AgreementPO agreement) {
        try {
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            int count = 0;
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                if (count < 9) {
                    ++count;
                    continue;
                }
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                if (row.getCell(0) != null && "".equals(row.getCell(0).toString())) continue;
                for (int i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i);
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ExcelUtils.getValue(cell);
                    if (count == 9) {
                        String titleName = String.valueOf(obj).trim();
                        if (titleName.startsWith("*")) {
                            titleName = titleName.substring(1);
                        }
                        title.add(titleName);
                        continue;
                    }
                    if (count < 10) continue;
                    c.add(String.valueOf(obj).trim());
                }
                if (end < title.size()) {
                    int distance = title.size() - end;
                    for (int i = 0; i < distance; ++i) {
                        c.add("");
                    }
                }
                ++count;
                if (c.size() <= 0) continue;
                ArrayList<String> d = new ArrayList<String>();
                for (String str : c) {
                    if (str.endsWith(".00")) {
                        str = str.substring(0, str.length() - 3);
                    }
                    d.add(str);
                }
                data.add(d);
            }
        }
        catch (Exception e) {
            throw new com.tydic.uac.exception.BusinessException("22052", e.getMessage());
        }
    }

    public void refreshCodeList(String key) {
        this.cacheClient.delete(DICTIONARY_KEY_PREFIX + key);
        FscQueryDictionaryAbilityReqBO reqBO = new FscQueryDictionaryAbilityReqBO();
        reqBO.setPcode("FSC_TAX_CAT_CODE_VALUE");
        FscRspPageBaseBO qryRspBO = this.fscDictionaryAbilityService.queryBypCodeBackPo(reqBO);
        if ("0000".equals(qryRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)qryRspBO.getRows())) {
            this.cacheClient.set(DICTIONARY_KEY_PREFIX + key, (Object)qryRspBO.getRows(), AgrBatchImportAgreementSkuBusiServiceImpl.getExpireSeconds(3600, 10));
        }
    }

    public static int getExpireSeconds(int radix, int range) {
        return radix * (new Random().nextInt(range) + 1);
    }
}

