/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgrAgreementSupplierBO;
import com.tydic.agreement.ability.bo.AgrAgreementVendorBO;
import com.tydic.agreement.ability.bo.AgreementSettlementBO;
import com.tydic.agreement.atom.api.AgrCreateAgreementOtherAtomService;
import com.tydic.agreement.atom.api.AgrCreateAgreementSettlementAtomService;
import com.tydic.agreement.atom.api.AgrCreateAgreementSkuAtomService;
import com.tydic.agreement.atom.api.AgrCreateCodeAtomService;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.bo.AgrCreateAgreementOtherAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementOtherAtomRspBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSettlementAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSettlementAtomRspBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSkuAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSkuAtomRspBO;
import com.tydic.agreement.busi.api.AgrCreateAgreementSubjectBusiService;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSubjectBusiReqBO;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSubjectBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementAttachLogMapper;
import com.tydic.agreement.dao.AgrAgreementCodeRelaMapper;
import com.tydic.agreement.dao.AgrAgreementSupplierMapper;
import com.tydic.agreement.dao.AgrAgreementVendorMapper;
import com.tydic.agreement.dao.AgreementAttachMapper;
import com.tydic.agreement.dao.AgreementLogMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementScopeLogMapper;
import com.tydic.agreement.dao.AgreementScopeMapper;
import com.tydic.agreement.dao.AgreementSettlementLogMapper;
import com.tydic.agreement.dao.AgreementSettlementMapper;
import com.tydic.agreement.dao.AgreementSkuLogMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrAgreementAttachLogPO;
import com.tydic.agreement.po.AgrAgreementCodeRelaPO;
import com.tydic.agreement.po.AgrAgreementSupplierPO;
import com.tydic.agreement.po.AgrAgreementVendorPO;
import com.tydic.agreement.po.AgreementAttachPO;
import com.tydic.agreement.po.AgreementLogPO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementScopeLogPO;
import com.tydic.agreement.po.AgreementScopePO;
import com.tydic.agreement.po.AgreementSettlementLogPO;
import com.tydic.agreement.po.AgreementSettlementPO;
import com.tydic.agreement.po.AgreementSkuLogPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.umc.general.ability.api.UmcQryMemLegalOrgInfoAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceReqBO;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrCreateAgreementSubjectBusiServiceImpl
implements AgrCreateAgreementSubjectBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrCreateAgreementSubjectBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementLogMapper agreementLogMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private AgreementScopeLogMapper agreementScopeLogMapper;
    @Autowired
    private AgreementAttachMapper agreementAttachMapper;
    @Autowired
    private AgrAgreementAttachLogMapper agrAgreementAttachLogMapper;
    @Autowired
    private AgreementSkuLogMapper agreementSkuLogMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementSettlementMapper agreementSettlementMapper;
    @Autowired
    private AgreementSettlementLogMapper agreementSettlementLogMapper;
    @Autowired
    private AgrAgreementVendorMapper agrAgreementVendorMapper;
    @Autowired
    private AgrAgreementCodeRelaMapper agrAgreementCodeRelaMapper;
    @Autowired
    private AgrCreateAgreementSkuAtomService agrCreateAgreementSkuAtomService;
    @Autowired
    private AgrCreateAgreementOtherAtomService agrCreateAgreementOtherAtomService;
    @Autowired
    private AgrCreateCodeAtomService agrCreateCodeAtomService;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgrCreateAgreementSettlementAtomService agrCreateAgreementSettlementAtomService;
    @Autowired
    private AgrAgreementSupplierMapper agrAgreementSupplierMapper;
    @Autowired
    private UmcQryMemLegalOrgInfoAbilityService umcQryMemLegalOrgInfoAbilityService;

    @Override
    public AgrCreateAgreementSubjectBusiRspBO createAgreementSubjectInfo(AgrCreateAgreementSubjectBusiReqBO busiReqBO) {
        if (busiReqBO.getAgrAgreementBO().getServiceFeeMode() == null) {
            throw new ZTBusinessException("\u534f\u8bae\u670d\u52a1\u8d39\u7387\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (busiReqBO.getAgrAgreementBO().getServiceFeeMode().equals(AgrCommConstant.ServiceFeeMode.SERVICE_FEE_MODE_CUSTOM) && busiReqBO.getAgrAgreementBO().getTenantServiceRate() == null) {
            throw new ZTBusinessException("\u81ea\u5b9a\u4e49\u534f\u8bae\u670d\u52a1\u8d39\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (busiReqBO.getSysTenantId() == null) {
            throw new ZTBusinessException("\u7cfb\u7edf\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AgrCreateAgreementSubjectBusiRspBO rsp = new AgrCreateAgreementSubjectBusiRspBO();
        if (!StringUtils.isEmpty((CharSequence)busiReqBO.getAgrAgreementBO().getEntAgreementCode())) {
            AgreementPO agreementPO = new AgreementPO();
            agreementPO.setCreateOrgId(busiReqBO.getOrgId());
            agreementPO.setEntAgreementCode(busiReqBO.getAgrAgreementBO().getEntAgreementCode());
            List<AgreementPO> count = this.agreementMapper.getCount(agreementPO);
            if (!CollectionUtils.isEmpty(count)) {
                throw new BusinessException("0001", "\u4e1a\u52a1\u5355\u4f4d\u5408\u540c\u7f16\u53f7\u5df2\u5b58\u5728\uff01");
            }
        }
        this.validPlaAgreementCode(busiReqBO);
        Long agreementId = Sequence.getInstance().nextId();
        AgreementPO agreementPO = this.insertAgreement(busiReqBO, agreementId);
        this.insertAgreementSettlement(busiReqBO, agreementId);
        log.info(JSON.toJSONString((Object)agreementPO));
        if (!CollectionUtils.isEmpty(busiReqBO.getAgrAgreementAttachBOs()) || !CollectionUtils.isEmpty((Collection)busiReqBO.getAgrAgreementBO().getAgrAgreementScopeBOs())) {
            this.insertAgreementOther(busiReqBO, agreementPO);
        }
        if (!CollectionUtils.isEmpty(busiReqBO.getAgrAgreementSkuBOs())) {
            this.insertAgreementSku(busiReqBO, agreementPO);
        }
        if ("1".equals(busiReqBO.getAgrAgreementBO().getAgreementMode())) {
            ArrayList<AgrAgreementSupplierBO> distribution = new ArrayList<AgrAgreementSupplierBO>();
            AgrAgreementSupplierBO agrAgreementSupplierBO = new AgrAgreementSupplierBO();
            agrAgreementSupplierBO.setAgreementId(agreementId);
            agrAgreementSupplierBO.setSupplierMode(Integer.valueOf(busiReqBO.getAgrAgreementBO().getSupplierMode().intValue()));
            agrAgreementSupplierBO.setSupplierId(agreementPO.getVendorDepartmentId());
            agrAgreementSupplierBO.setSupplierName(agreementPO.getVendorDepartmentName());
            distribution.add(agrAgreementSupplierBO);
            busiReqBO.setDistribution(distribution);
        }
        if (!CollectionUtils.isEmpty(busiReqBO.getDistribution())) {
            this.insertAgreementSupplier(busiReqBO, agreementId);
        }
        Long agreementLogId = Sequence.getInstance().nextId();
        try {
            AgreementLogPO agreementLogPO = new AgreementLogPO();
            BeanUtils.copyProperties((Object)agreementPO, (Object)agreementLogPO);
            agreementLogPO.setAgreementLogId(agreementLogId);
            agreementLogPO.setLogStatus("2");
            agreementLogPO.setChangeType(new Byte("99"));
            agreementLogPO.setChangeTime(new Date());
            this.agreementLogMapper.insert(agreementLogPO);
            HashSet<Long> agreementIds = new HashSet<Long>();
            agreementIds.add(agreementId);
            this.insertAgreementSkuLog(agreementIds, agreementPO.getSupplierId(), agreementLogId, busiReqBO);
            this.insertAgreementScopeLog(agreementIds, agreementPO.getSupplierId(), agreementLogId, busiReqBO);
            this.insertAgreementAttachLog(agreementIds, agreementPO.getSupplierId(), agreementLogId, busiReqBO);
            this.insertAgreementSettlementLog(agreementIds, agreementPO.getSupplierId(), agreementLogId, busiReqBO);
        }
        catch (Exception e) {
            throw new BusinessException("0101", "\u751f\u6210\u534f\u8bae\u7248\u672c\u5f02\u5e38\uff01\uff01" + e);
        }
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getAgrAgreementBO().getVendorList())) {
            ArrayList<AgrAgreementVendorPO> list = new ArrayList<AgrAgreementVendorPO>();
            for (AgrAgreementVendorBO agrAgreementVendorBO : busiReqBO.getAgrAgreementBO().getVendorList()) {
                AgrAgreementVendorPO agrAgreementVendorPO = new AgrAgreementVendorPO();
                BeanUtils.copyProperties((Object)agrAgreementVendorBO, (Object)agrAgreementVendorPO);
                agrAgreementVendorPO.setSysTenantId(agreementPO.getSysTenantId());
                agrAgreementVendorPO.setSysTenantName(agreementPO.getSysTenantName());
                agrAgreementVendorPO.setId(Sequence.getInstance().nextId());
                list.add(agrAgreementVendorPO);
            }
            this.agrAgreementVendorMapper.insertBatch(list);
        }
        if (agreementPO.getSignType() != null && agreementPO.getSignType() == 4) {
            AgrAgreementCodeRelaPO agrAgreementCodeRelaPO = new AgrAgreementCodeRelaPO();
            agrAgreementCodeRelaPO.setSysTenantId(agreementPO.getSysTenantId());
            agrAgreementCodeRelaPO.setSysTenantName(agreementPO.getSysTenantName());
            agrAgreementCodeRelaPO.setId(Sequence.getInstance().nextId());
            agrAgreementCodeRelaPO.setAgreementId(busiReqBO.getAgrAgreementBO().getOriginalAgreementId());
            agrAgreementCodeRelaPO.setCodeType("3");
            agrAgreementCodeRelaPO.setAgreementCode(agreementPO.getPlaAgreementCode());
            this.agrAgreementCodeRelaMapper.insert(agrAgreementCodeRelaPO);
            AgreementPO agreementPO1 = new AgreementPO();
            agreementPO1.setAgreementId(busiReqBO.getAgrAgreementBO().getOriginalAgreementId());
            AgreementPO masterAgreementPO = this.agreementMapper.getModelBy(agreementPO1);
            if (null != masterAgreementPO && StringUtils.isNotBlank((CharSequence)masterAgreementPO.getMasterNegotiationAgreementCode())) {
                AgreementPO agreementPO2 = new AgreementPO();
                agreementPO2.setPlaAgreementCode(masterAgreementPO.getMasterNegotiationAgreementCode());
                AgreementPO masterNegotiationAgreementPO = this.agreementMapper.getModelBy(agreementPO2);
                AgrAgreementCodeRelaPO agrAgreementCodeRelaPO1 = new AgrAgreementCodeRelaPO();
                agrAgreementCodeRelaPO1.setSysTenantId(agreementPO.getSysTenantId());
                agrAgreementCodeRelaPO1.setSysTenantName(agreementPO.getSysTenantName());
                agrAgreementCodeRelaPO1.setId(Sequence.getInstance().nextId());
                agrAgreementCodeRelaPO1.setAgreementId(masterNegotiationAgreementPO.getAgreementId());
                agrAgreementCodeRelaPO1.setCodeType("3");
                agrAgreementCodeRelaPO1.setAgreementCode(agreementPO.getPlaAgreementCode());
                this.agrAgreementCodeRelaMapper.insert(agrAgreementCodeRelaPO1);
            }
        }
        rsp.setAgreementId(agreementId);
        rsp.setAgreementLogId(agreementLogId);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u4e3b\u4f53\u521b\u5efa\u6210\u529f\uff01");
        return rsp;
    }

    private AgreementPO insertAgreement(AgrCreateAgreementSubjectBusiReqBO busiReqBO, Long agreementId) {
        int isInsert;
        AgreementPO agreementPO = new AgreementPO();
        BeanUtils.copyProperties((Object)busiReqBO.getAgrAgreementBO(), (Object)agreementPO);
        if (agreementPO.getSupplierMode() == 2) {
            agreementPO.setVendorDepartmentId(agreementPO.getVendorId());
            agreementPO.setVendorDepartmentName(agreementPO.getVendorName());
            agreementPO.setUnitAccountId(agreementPO.getVendorId());
            agreementPO.setUnitAccountName(agreementPO.getVendorName());
        } else {
            agreementPO.setVendorDepartmentId(busiReqBO.getOrgId());
            agreementPO.setVendorDepartmentName(busiReqBO.getOrgName());
            agreementPO.setUnitAccountId(busiReqBO.getOrgId());
            agreementPO.setUnitAccountName(busiReqBO.getOrgName());
        }
        String agreementVersion = "V1";
        agreementPO.setAgreementId(agreementId);
        agreementPO.setAgreementVersion(agreementVersion);
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setSupplierName(busiReqBO.getSupplierName());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.NO_ASS);
        agreementPO.setAssignStatus(AgrCommConstant.AssignStatus.BE_ASSIGN);
        agreementPO.setProducerId(busiReqBO.getMemIdIn());
        agreementPO.setProducerName(busiReqBO.getName());
        agreementPO.setAssignStatus(AgrCommConstant.AssignStatus.BE_ASSIGN);
        agreementPO.setProduceTime(new Date());
        agreementPO.setCreateOrgId(busiReqBO.getAgrAgreementBO().getCreateOrgId());
        agreementPO.setCreateOrgName(busiReqBO.getAgrAgreementBO().getCreateOrgName());
        Long userId = busiReqBO.getUserId();
        UmcQryMemLegalOrgInfoAbilityServiceReqBO reqBO = new UmcQryMemLegalOrgInfoAbilityServiceReqBO();
        reqBO.setMemId(userId);
        reqBO.setSysTenantId(busiReqBO.getSysTenantId());
        UmcQryMemLegalOrgInfoAbilityServiceRspBO umcQryMemLegalOrgInfoAbilityServiceRspBO = this.umcQryMemLegalOrgInfoAbilityService.qryMemLegalOrgInfo(reqBO);
        UmcEnterpriseOrgBO twoLevelOrgInfo = umcQryMemLegalOrgInfoAbilityServiceRspBO.getTwoLevelOrgInfo();
        if (null != twoLevelOrgInfo) {
            agreementPO.setExtField1(String.valueOf(twoLevelOrgInfo.getOrgId()));
        }
        if (StringUtils.isBlank((CharSequence)busiReqBO.getAgrAgreementBO().getUpdateSelectData())) {
            agreementPO.setUpdateSelectData("0");
        }
        agreementPO.setSysTenantId(busiReqBO.getSysTenantId());
        agreementPO.setSysTenantName(busiReqBO.getSysTenantName());
        if (null == agreementPO.getInstandOrder()) {
            agreementPO.setInstandOrder(0);
        }
        if (null == agreementPO.getAgreementPurpose()) {
            agreementPO.setAgreementPurpose(1);
        }
        if ((isInsert = this.agreementMapper.insert(agreementPO)) < 1) {
            throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u8868\u5931\u8d25\uff01");
        }
        return agreementPO;
    }

    private void insertAgreementSkuLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId, AgrCreateAgreementSubjectBusiReqBO busiReqBO) {
        int count;
        AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
        agreementSkuPO.setSupplierId(supplierId);
        agreementSkuPO.setAgreementIds(agreementIds);
        agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        agreementSkuPO.setSysTenantId(busiReqBO.getSysTenantId());
        agreementSkuPO.setSysTenantName(busiReqBO.getSysTenantName());
        List<AgreementSkuPO> agreementSkuList = this.agreementSkuMapper.getList(agreementSkuPO);
        ArrayList<AgreementSkuLogPO> agreementSkuLogPOList = new ArrayList<AgreementSkuLogPO>();
        for (AgreementSkuPO agreementSkuPO1 : agreementSkuList) {
            AgreementSkuLogPO agreementSkuLogPO = new AgreementSkuLogPO();
            BeanUtils.copyProperties((Object)agreementSkuPO1, (Object)agreementSkuLogPO);
            agreementSkuLogPO.setAgreementLogId(agreementLogId);
            agreementSkuLogPO.setSysTenantId(busiReqBO.getSysTenantId());
            agreementSkuLogPO.setSysTenantName(busiReqBO.getSysTenantName());
            agreementSkuLogPOList.add(agreementSkuLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementSkuLogPOList) && (count = this.agreementSkuLogMapper.insertBatch(agreementSkuLogPOList)) != agreementSkuLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementSettlementLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId, AgrCreateAgreementSubjectBusiReqBO busiReqBO) {
        AgreementSettlementPO agreementSettlementPO = new AgreementSettlementPO();
        agreementSettlementPO.setAgreementIds(agreementIds);
        List<AgreementSettlementPO> list = this.agreementSettlementMapper.getList(agreementSettlementPO);
        ArrayList<AgreementSettlementLogPO> agreementSettlementLogPOList = new ArrayList<AgreementSettlementLogPO>();
        for (AgreementSettlementPO as : list) {
            AgreementSettlementLogPO agreementSettlementLogPO = new AgreementSettlementLogPO();
            BeanUtils.copyProperties((Object)as, (Object)agreementSettlementLogPO);
            Long settleMentLogId = Sequence.getInstance().nextId();
            agreementSettlementLogPO.setAgreementLogId(agreementLogId);
            agreementSettlementLogPO.setSettlementLogId(settleMentLogId);
            agreementSettlementLogPO.setSysTenantId(busiReqBO.getSysTenantId());
            agreementSettlementLogPO.setSysTenantName(busiReqBO.getSysTenantName());
            agreementSettlementLogPOList.add(agreementSettlementLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementSettlementLogPOList)) {
            log.info("\u534f\u8bae\u4ed8\u6b3e\u65b9\u5f0f\u5199\u5165\u5165\u53c2==========================================" + agreementSettlementLogPOList);
            int count = this.agreementSettlementLogMapper.insertBatch(agreementSettlementLogPOList);
            if (count != agreementSettlementLogPOList.size()) {
                throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u65e5\u5fd7\u8868\u5931\u8d25");
            }
        }
    }

    private void insertAgreementScopeLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId, AgrCreateAgreementSubjectBusiReqBO busiReqBO) {
        int count;
        AgreementScopePO agreementScopePO = new AgreementScopePO();
        agreementScopePO.setSupplierId(supplierId);
        agreementScopePO.setAgreementIds(agreementIds);
        agreementScopePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        agreementScopePO.setSysTenantId(busiReqBO.getSysTenantId());
        agreementScopePO.setSysTenantName(busiReqBO.getSysTenantName());
        List<AgreementScopePO> agreementScopeList = this.agreementScopeMapper.getList(agreementScopePO);
        ArrayList<AgreementScopeLogPO> agreementScopeLogPOList = new ArrayList<AgreementScopeLogPO>();
        for (AgreementScopePO agreementScopePO1 : agreementScopeList) {
            AgreementScopeLogPO agreementScopeLogPO = new AgreementScopeLogPO();
            BeanUtils.copyProperties((Object)agreementScopePO1, (Object)agreementScopeLogPO);
            agreementScopeLogPO.setAgreementLogId(agreementLogId);
            agreementScopeLogPOList.add(agreementScopeLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementScopeLogPOList) && (count = this.agreementScopeLogMapper.insertBatch(agreementScopeLogPOList)) != agreementScopeLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u8303\u56f4\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementAttachLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId, AgrCreateAgreementSubjectBusiReqBO busiReqBO) {
        int count;
        AgreementAttachPO agreementAttachPO = new AgreementAttachPO();
        agreementAttachPO.setSupplierId(supplierId);
        agreementAttachPO.setAgreementIds(agreementIds);
        agreementAttachPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementAttachPO> agreementAttachList = this.agreementAttachMapper.getList(agreementAttachPO);
        ArrayList<AgrAgreementAttachLogPO> agrAgreementAttachLogPOList = new ArrayList<AgrAgreementAttachLogPO>();
        for (AgreementAttachPO agreementAttachPO1 : agreementAttachList) {
            AgrAgreementAttachLogPO agrAgreementAttachLogPO = new AgrAgreementAttachLogPO();
            BeanUtils.copyProperties((Object)agreementAttachPO1, (Object)agrAgreementAttachLogPO);
            agrAgreementAttachLogPO.setAgreementLogId(agreementLogId);
            agrAgreementAttachLogPO.setSysTenantId(busiReqBO.getSysTenantId());
            agrAgreementAttachLogPO.setSysTenantName(busiReqBO.getSysTenantName());
            agrAgreementAttachLogPOList.add(agrAgreementAttachLogPO);
        }
        if (!CollectionUtils.isEmpty(agrAgreementAttachLogPOList) && (count = this.agrAgreementAttachLogMapper.insertBatch(agrAgreementAttachLogPOList)) != agrAgreementAttachLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u9644\u4ef6\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementOther(AgrCreateAgreementSubjectBusiReqBO busiReqBO, AgreementPO agreementPO) {
        AgrCreateAgreementOtherAtomReqBO atomReqBO = new AgrCreateAgreementOtherAtomReqBO();
        atomReqBO.setMemIdIn(busiReqBO.getMemIdIn());
        atomReqBO.setSysTenantId(busiReqBO.getSysTenantId());
        atomReqBO.setSysTenantName(busiReqBO.getSysTenantName());
        atomReqBO.setSupplierId(busiReqBO.getSupplierId());
        atomReqBO.setUserName(busiReqBO.getUserName());
        atomReqBO.setAgreementId(agreementPO.getAgreementId());
        atomReqBO.setAgreementVersion(agreementPO.getAgreementVersion());
        atomReqBO.setAgrAgreementAttachBOs(busiReqBO.getAgrAgreementAttachBOs());
        atomReqBO.setAgrAgreementScopeBOs(busiReqBO.getAgrAgreementBO().getAgrAgreementScopeBOs());
        atomReqBO.setScopeType(agreementPO.getScopeType());
        atomReqBO.setOperType("add");
        AgrCreateAgreementOtherAtomRspBO atomRspBO = this.agrCreateAgreementOtherAtomService.createAgreementOtherInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
    }

    private void insertAgreementSettlement(AgrCreateAgreementSubjectBusiReqBO busiReqBO, Long agreementId) {
        List<AgreementSettlementBO> paymentMethodList = busiReqBO.getPaymentMethod();
        log.error("paymentMethodList\u7684\u503c" + paymentMethodList);
        if (paymentMethodList == null) {
            throw new BusinessException("0101", "\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u7a7a");
        }
        for (AgreementSettlementBO asb : paymentMethodList) {
            AgrCreateAgreementSettlementAtomReqBO atomReqBO = new AgrCreateAgreementSettlementAtomReqBO();
            BeanUtils.copyProperties((Object)asb, (Object)((Object)atomReqBO));
            atomReqBO.setSysTenantId(busiReqBO.getSysTenantId());
            atomReqBO.setSysTenantName(busiReqBO.getSysTenantName());
            atomReqBO.setAgreementId(agreementId);
            AgrCreateAgreementSettlementAtomRspBO agreementSettlementInfo = this.agrCreateAgreementSettlementAtomService.createAgreementSettlementInfo(atomReqBO);
            if ("0000".equals(agreementSettlementInfo.getRespCode())) continue;
            throw new BusinessException(agreementSettlementInfo.getRespCode(), agreementSettlementInfo.getRespDesc());
        }
    }

    private void insertAgreementSku(AgrCreateAgreementSubjectBusiReqBO busiReqBO, AgreementPO agreementPO) {
        AgrCreateAgreementSkuAtomReqBO agrCreateAgreementSkuAtomReqBO = new AgrCreateAgreementSkuAtomReqBO();
        agrCreateAgreementSkuAtomReqBO.setSysTenantId(busiReqBO.getSysTenantId());
        agrCreateAgreementSkuAtomReqBO.setSysTenantName(busiReqBO.getSysTenantName());
        agrCreateAgreementSkuAtomReqBO.setAgrAgreementSkuBOs(busiReqBO.getAgrAgreementSkuBOs());
        agrCreateAgreementSkuAtomReqBO.setSupplierId(busiReqBO.getSupplierId());
        agrCreateAgreementSkuAtomReqBO.setAgreementVersion(agreementPO.getAgreementVersion());
        agrCreateAgreementSkuAtomReqBO.setAgreementId(agreementPO.getAgreementId());
        AgrCreateAgreementSkuAtomRspBO agrCreateAgreementSkuAtomRspBO = this.agrCreateAgreementSkuAtomService.createAgreementSku(agrCreateAgreementSkuAtomReqBO);
        if (!"0000".equals(agrCreateAgreementSkuAtomRspBO.getRespCode())) {
            throw new BusinessException(agrCreateAgreementSkuAtomRspBO.getRespCode(), agrCreateAgreementSkuAtomRspBO.getRespDesc());
        }
    }

    private void validPlaAgreementCode(AgrCreateAgreementSubjectBusiReqBO busiReqBO) {
        List<AgreementPO> list;
        AgreementPO agreementPO;
        String[] strArray;
        Matcher matcher;
        Pattern pattern;
        String str;
        AgrAgreementBO agrAgreementBO = busiReqBO.getAgrAgreementBO();
        AgreementPO checkAgreementPO = new AgreementPO();
        checkAgreementPO.setPlaAgreementCode(agrAgreementBO.getPlaAgreementCode());
        AgreementPO checkAgreement = this.agreementMapper.getModelBy(checkAgreementPO);
        if (null != checkAgreement) {
            throw new BusinessException("22053", "\u534f\u8bae\u7f16\u53f7\u3010" + checkAgreement.getPlaAgreementCode() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        if (StringUtils.isNotBlank((CharSequence)busiReqBO.getAgrAgreementBO().getOriginalAgreementCode())) {
            str = busiReqBO.getAgrAgreementBO().getOriginalAgreementCode();
            pattern = Pattern.compile("^[^,]+(,[^,]+)*$");
            matcher = pattern.matcher(str);
            if (!matcher.matches()) {
                throw new BusinessException("22053", "\u539fe\u8d2d\u534f\u8bae\u7f16\u53f7\u8f93\u5165\u683c\u5f0f\u6709\u8bef\uff0c\u8f93\u5165\u591a\u4e2a\u539fe\u8d2d\u534f\u8bae\u7f16\u53f7\uff0c\u4e2d\u95f4\u7528,\u9694\u5f00\uff01");
            }
            strArray = str.split(",");
            List<String> originalAgreementCodes = Arrays.asList(strArray);
            agreementPO = new AgreementPO();
            agreementPO.setOriginalAgreementCodes(originalAgreementCodes);
            list = this.agreementMapper.getList(agreementPO);
            if (CollectionUtils.isEmpty(list) || list.size() != originalAgreementCodes.size()) {
                throw new BusinessException("22053", "\u8f93\u5165\u7684\u539fe\u8d2d\u534f\u8bae\u7f16\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)busiReqBO.getAgrAgreementBO().getOriginalEntAgreementCode())) {
            str = busiReqBO.getAgrAgreementBO().getOriginalEntAgreementCode();
            pattern = Pattern.compile("^[^,]+(,[^,]+)*$");
            matcher = pattern.matcher(str);
            if (!matcher.matches()) {
                throw new BusinessException("22053", "\u539f\u4e1a\u52a1\u5355\u4f4d\u5408\u540c\u7f16\u53f7\u8f93\u5165\u683c\u5f0f\u6709\u8bef\uff0c\u8f93\u5165\u591a\u4e2a\u539fe\u8d2d\u534f\u8bae\u7f16\u53f7\uff0c\u4e2d\u95f4\u7528,\u9694\u5f00\uff01");
            }
            strArray = str.split(",");
            List<String> originalEntAgreementCodes = Arrays.asList(strArray);
            agreementPO = new AgreementPO();
            agreementPO.setOriginalEntAgreementCodes(originalEntAgreementCodes);
            list = this.agreementMapper.getList(agreementPO);
            if (CollectionUtils.isEmpty(list) || list.size() != originalEntAgreementCodes.size()) {
                throw new BusinessException("22053", "\u8f93\u5165\u7684\u539f\u4e1a\u52a1\u5355\u4f4d\u5408\u540c\u7f16\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
            }
        }
    }

    private void insertAgreementSupplier(AgrCreateAgreementSubjectBusiReqBO busiReqBO, Long agreementId) {
        ArrayList<AgrAgreementSupplierPO> list = new ArrayList<AgrAgreementSupplierPO>();
        for (AgrAgreementSupplierBO agrAgreementSupplierBO : busiReqBO.getDistribution()) {
            AgrAgreementSupplierPO agrAgreementSupplierPO = new AgrAgreementSupplierPO();
            Long id = Sequence.getInstance().nextId();
            BeanUtils.copyProperties((Object)agrAgreementSupplierBO, (Object)agrAgreementSupplierPO);
            agrAgreementSupplierPO.setAgreementId(agreementId);
            agrAgreementSupplierPO.setId(id);
            agrAgreementSupplierPO.setIsDelete("0");
            agrAgreementSupplierPO.setSysTenantId(busiReqBO.getSysTenantId());
            agrAgreementSupplierPO.setSysTenantName(busiReqBO.getSysTenantName());
            list.add(agrAgreementSupplierPO);
        }
        this.agrAgreementSupplierMapper.insertBatch(list);
    }
}

