/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.CrcAgrAgreementSkuBO;
import com.tydic.agreement.busi.api.CrcAddAgreementSkuBusiService;
import com.tydic.agreement.busi.bo.CrcAddAgreementSkuBusiReqBO;
import com.tydic.agreement.busi.bo.CrcAddAgreementSkuBusiRspBO;
import com.tydic.agreement.dao.AgreementLogMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuLogMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.po.AgreementLogPO;
import com.tydic.agreement.po.AgreementSkuLogPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.commodity.common.ability.api.UccQueryCatalogByMaterialAbilityService;
import com.tydic.commodity.common.ability.bo.UccQueryCatalogByMaterialAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccQueryCatalogByMaterialAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccQueryCatalogByMaterialBO;
import com.tydic.uac.exception.BusinessException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CrcAddAgreementSkuBusiServiceImpl
implements CrcAddAgreementSkuBusiService {
    private static final Logger log = LoggerFactory.getLogger(CrcAddAgreementSkuBusiServiceImpl.class);
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementLogMapper agreementLogMapper;
    @Autowired
    private AgreementSkuLogMapper agreementSkuLogMapper;
    @Autowired
    private UccQueryCatalogByMaterialAbilityService uccQueryCatalogByMaterialAbilityService;

    @Override
    public CrcAddAgreementSkuBusiRspBO addAgreementSku(CrcAddAgreementSkuBusiReqBO reqBO) {
        int count;
        CrcAddAgreementSkuBusiRspBO rspBO = new CrcAddAgreementSkuBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty(reqBO.getAgrAgreementSkuBOs())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u3010agrAgreementSkuBOs\u3011\u4e3a\u7a7a!");
            return rspBO;
        }
        List<CrcAgrAgreementSkuBO> agrAgreementSkuBOs = reqBO.getAgrAgreementSkuBOs();
        List<String> collect = agrAgreementSkuBOs.stream().map(CrcAgrAgreementSkuBO::getEntAgreementCode).distinct().collect(Collectors.toList());
        List materialCodeList = agrAgreementSkuBOs.stream().map(CrcAgrAgreementSkuBO::getMaterialCode).distinct().collect(Collectors.toList());
        List<AgrAgreementBO> agrAgreementBOS = this.agreementMapper.selectAgrIdsByCodes(collect);
        if (CollectionUtils.isEmpty(agrAgreementBOS)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8be5\u660e\u7ec6\u7684\u534f\u8bae\u4e3b\u4f53\u672a\u63a8\u9001");
            return rspBO;
        }
        Map<String, Long> map = agrAgreementBOS.stream().collect(Collectors.toMap(item -> item.getEntAgreementCode(), item -> item.getAgreementId(), (item1, item2) -> item1));
        Map<String, Long> supplierMap = agrAgreementBOS.stream().collect(Collectors.toMap(item -> item.getEntAgreementCode(), item -> item.getSupplierId(), (item1, item2) -> item1));
        for (CrcAgrAgreementSkuBO po : agrAgreementSkuBOs) {
            Object failReason = null;
            if (StringUtils.isEmpty((CharSequence)po.getEntAgreementCode())) {
                failReason = "\u3010entAgreementCode\u3011\u4e3a\u7a7a";
            } else if (StringUtils.isEmpty((CharSequence)po.getSysCode())) {
                failReason = "\u3010sysCode\u3011\u4e3a\u7a7a";
            } else if (StringUtils.isEmpty((CharSequence)po.getMaterialCode())) {
                failReason = "\u3010materialCode\u3011\u4e3a\u7a7a";
            } else if (StringUtils.isEmpty((CharSequence)po.getEbsMaterialCode())) {
                failReason = "\u3010ebsMaterialCode\u3011\u4e3a\u7a7a";
            } else if (null == po.getTaxRate()) {
                failReason = "\u3010taxRate\u3011\u4e3a\u7a7a";
            } else if (null == po.getBuyNumber()) {
                failReason = "\u3010buyNumber\u3011\u4e3a\u7a7a";
            } else if (StringUtils.isEmpty((CharSequence)po.getMeasureName())) {
                failReason = "\u3010measureName\u3011\u4e3a\u7a7a";
            } else if (StringUtils.isEmpty((CharSequence)po.getSalePrice())) {
                failReason = "\u3010salePrice\u3011\u4e3a\u7a7a";
            } else if (StringUtils.isEmpty((CharSequence)po.getSalePriceSum())) {
                failReason = "\u3010salePriceSum\u3011\u4e3a\u7a7a";
            } else if (StringUtils.isEmpty((CharSequence)po.getCreateName())) {
                po.setCreateName(reqBO.getName());
            } else if (StringUtils.isEmpty((CharSequence)po.getSerialNo())) {
                failReason = "\u3010serialNo\u3011\u4e3a\u7a7a";
            } else if (null == po.getCreateTime()) {
                failReason = "\u3010createTime\u3011\u4e3a\u7a7a";
            } else if (null == map.get(po.getEntAgreementCode())) {
                failReason = "\u4f01\u4e1a\u534f\u8bae\u7f16\u53f7\u201d" + po.getEntAgreementCode() + "\u201c\u4e0d\u5b58\u5728";
            }
            if (!StringUtils.isEmpty((CharSequence)failReason)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc((String)failReason);
                return rspBO;
            }
            po.setAgreementId(map.get(po.getEntAgreementCode()));
            po.setSupplierId(supplierMap.get(po.getEntAgreementCode()));
        }
        UccQueryCatalogByMaterialAbilityReqBO uccQueryCatalogByMaterialAbilityReqBO = new UccQueryCatalogByMaterialAbilityReqBO();
        ArrayList<UccQueryCatalogByMaterialBO> rows = new ArrayList<UccQueryCatalogByMaterialBO>();
        for (CrcAgrAgreementSkuBO agrAgreementSkuBO : agrAgreementSkuBOs) {
            agrAgreementSkuBO.setAgreementSkuId(Long.valueOf(Sequence.getInstance().nextId()));
            UccQueryCatalogByMaterialBO uccQueryCatalogByMaterialBO = new UccQueryCatalogByMaterialBO();
            uccQueryCatalogByMaterialBO.setAgreementDetailsId(agrAgreementSkuBO.getAgreementSkuId());
            uccQueryCatalogByMaterialBO.setMaterialCode(agrAgreementSkuBO.getMaterialCode());
            uccQueryCatalogByMaterialBO.setMeasureName(agrAgreementSkuBO.getMeasureName());
            uccQueryCatalogByMaterialBO.setBrandName(agrAgreementSkuBO.getBrandName());
            rows.add(uccQueryCatalogByMaterialBO);
        }
        uccQueryCatalogByMaterialAbilityReqBO.setMaterials(rows);
        log.info("\u5546\u54c1\u7c7b\u578b\u67e5\u8be2\u5165\u53c2uccAgrSkuImportCheckAbilityReqBO:" + JSON.toJSONString((Object)uccQueryCatalogByMaterialAbilityReqBO));
        UccQueryCatalogByMaterialAbilityRspBO uccQueryCatalogByMaterialAbilityRspBO = this.uccQueryCatalogByMaterialAbilityService.qryCatalog(uccQueryCatalogByMaterialAbilityReqBO);
        log.info("\u5546\u54c1\u7c7b\u578b\u67e5\u8be2\u5165\u53c2uccAgrSkuImportCheckAbilityRspBO:" + JSON.toJSONString((Object)uccQueryCatalogByMaterialAbilityRspBO));
        if (!"0000".equals(uccQueryCatalogByMaterialAbilityRspBO.getRespCode())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(uccQueryCatalogByMaterialAbilityRspBO.getRespDesc());
            return rspBO;
        }
        Map<Long, UccQueryCatalogByMaterialBO> commodityMap = uccQueryCatalogByMaterialAbilityRspBO.getMaterials().stream().collect(Collectors.toMap(item -> item.getAgreementDetailsId(), item -> item, (item1, item2) -> item1));
        ArrayList<AgreementSkuPO> agreementSkuPOS = new ArrayList<AgreementSkuPO>();
        for (CrcAgrAgreementSkuBO bo : agrAgreementSkuBOs) {
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuPO);
            UccQueryCatalogByMaterialBO uccQueryCatalogByMaterialBO = commodityMap.get(bo.getAgreementSkuId());
            if (null == uccQueryCatalogByMaterialBO.getMaterialId()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("e\u8d2d\u7269\u6599\u7f16\u7801" + bo.getMaterialCode() + "\u5728\u5546\u57ce\u91cc\u4e0d\u5b58\u5728");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)uccQueryCatalogByMaterialBO.getBrandName())) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("e\u8d2d\u7269\u6599\u7f16\u7801" + bo.getMaterialCode() + "\u7684\u54c1\u724c\u5728\u5546\u57ce\u91cc\u4e0d\u5b58\u5728");
                return rspBO;
            }
            log.info("uccAgrSkuImportCheckBO=>" + JSON.toJSONString((Object)uccQueryCatalogByMaterialBO));
            agreementSkuPO.setCommodityTypeId(uccQueryCatalogByMaterialBO.getCommodityTypeId());
            agreementSkuPO.setCommodityTypeName(uccQueryCatalogByMaterialBO.getCommodityTypeName());
            agreementSkuPO.setCatalogId(uccQueryCatalogByMaterialBO.getCatalogId());
            agreementSkuPO.setCatalogName(uccQueryCatalogByMaterialBO.getCatalogName());
            if (null != uccQueryCatalogByMaterialBO.getMaterialId()) {
                agreementSkuPO.setMaterialId(uccQueryCatalogByMaterialBO.getMaterialId().toString());
            }
            agreementSkuPO.setBrandId(uccQueryCatalogByMaterialBO.getBrandId());
            agreementSkuPO.setBrandName(uccQueryCatalogByMaterialBO.getBrandName());
            agreementSkuPO.setMeasureId(uccQueryCatalogByMaterialBO.getMeasureId());
            agreementSkuPO.setMeasureName(uccQueryCatalogByMaterialBO.getMeasureName());
            agreementSkuPO.setMaterialName(uccQueryCatalogByMaterialBO.getMaterialName());
            agreementSkuPO.setAgreementSkuId(Sequence.getInstance().nextId());
            agreementSkuPO.setIsDelete((byte)0);
            agreementSkuPO.setAgreementId(bo.getAgreementId());
            DecimalFormat df = new DecimalFormat("0.0000");
            BigDecimal bigDecimal = new BigDecimal(bo.getSalePrice());
            BigDecimal bigDecimal1 = new BigDecimal(bo.getSalePriceSum());
            String salePrice = df.format(bigDecimal);
            String salePriceSum = df.format(bigDecimal1);
            agreementSkuPO.setSalePrice(new BigDecimal(salePrice).multiply(new BigDecimal(10000)).longValue());
            agreementSkuPO.setSalePriceSum(new BigDecimal(salePriceSum).multiply(new BigDecimal(10000)).longValue());
            agreementSkuPO.setBuyPrice(agreementSkuPO.getSalePrice());
            agreementSkuPO.setBuyPriceSum(agreementSkuPO.getSalePriceSum());
            agreementSkuPO.setBuyNumber(null == bo.getBuyNumber() ? null : bo.getBuyNumber());
            agreementSkuPO.setMarkupRate(null == bo.getMarkupRate() ? null : bo.getMarkupRate());
            agreementSkuPO.setCreateName(bo.getCreateName());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date createTime = null;
            try {
                createTime = sdf1.parse(sdf.format(new Date(bo.getCreateTime())));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            agreementSkuPO.setCreateTime(createTime);
            agreementSkuPO.setEbsMaterialCode(bo.getEbsMaterialCode());
            agreementSkuPO.setMaterialCode(bo.getMaterialCode());
            agreementSkuPO.setVendorMaterialCode(bo.getVendorMaterialCode());
            agreementSkuPO.setVendorMaterialName(bo.getVendorMaterialName());
            agreementSkuPO.setAgreementVersion("V1");
            agreementSkuPO.setSkuStatus((byte)20);
            if (null == bo.getIsOil()) {
                agreementSkuPO.setIsOil((byte)0);
            }
            agreementSkuPO.setSysTenantId(305775845729763327L);
            agreementSkuPO.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
            agreementSkuPOS.add(agreementSkuPO);
        }
        this.agreementSkuMapper.insertBatch(agreementSkuPOS);
        AgreementLogPO agreementLogPO = new AgreementLogPO();
        agreementLogPO.setLogStatus("2");
        agreementLogPO.setAgreementId(agrAgreementBOS.get(0).getAgreementId());
        agreementLogPO.setChangeType(agrAgreementBOS.get(0).getChangeType());
        AgreementLogPO alo = this.agreementLogMapper.getModelBy(agreementLogPO);
        ArrayList<AgreementSkuLogPO> agreementSkuLogPOList = new ArrayList<AgreementSkuLogPO>();
        for (AgreementSkuPO agreementSkuPO1 : agreementSkuPOS) {
            AgreementSkuLogPO agreementSkuLogPO = new AgreementSkuLogPO();
            BeanUtils.copyProperties((Object)agreementSkuPO1, (Object)agreementSkuLogPO);
            agreementSkuLogPO.setAgreementLogId(alo.getAgreementLogId());
            agreementSkuLogPO.setMarkupRate(0.0);
            agreementSkuLogPOList.add(agreementSkuLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementSkuLogPOList) && (count = this.agreementSkuLogMapper.insertBatch(agreementSkuLogPOList)) != agreementSkuLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u65e5\u5fd7\u8868\u5931\u8d25");
        }
        return rspBO;
    }
}

