/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.agreement.ability.api.AgrBatchImportAgreementSkuChangeAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementDictionaryCodeBO;
import com.tydic.agreement.ability.bo.AgrAgreementSkuChangeBO;
import com.tydic.agreement.ability.bo.AgrBatchImportAgreementSkuChangeAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrBatchImportAgreementSkuChangeAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrImoprtTemplateBO;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.bo.AgrExternalImportResultLogAtomReqBO;
import com.tydic.agreement.atom.bo.AgrExternalImportResultLogAtomRspBO;
import com.tydic.agreement.atom.impl.CnncAgrExternalImportResultLogServiceHolder;
import com.tydic.agreement.busi.api.AgrCnncAgrExportImportResultsBusiService;
import com.tydic.agreement.busi.api.AgrCreateAgreementSkuChangeBusiService;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuChangeBusiReqBO;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuChangeBusiRspBO;
import com.tydic.agreement.busi.bo.AgrExportImportResultsBusiReqBO;
import com.tydic.agreement.busi.bo.AgrExportImportResultsBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.constants.AgrExtCommonConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.agreement.utils.ExcelUtils;
import com.tydic.agreement.utils.HttpUtil;
import com.tydic.commodity.zone.ability.api.UccAgrSkuImportCheckAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckBO;
import com.tydic.fsc.base.FscRspPageBaseBO;
import com.tydic.fsc.bo.FscDicDictionaryReqBO;
import com.tydic.fsc.common.ability.api.FscDictionaryAbilityService;
import com.tydic.fsc.common.ability.bo.FscDictionaryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscQueryDictionaryAbilityReqBO;
import com.tydic.ppc.ability.api.PpcPurchaseDemandQryListAbilityService;
import com.tydic.ppc.ability.bo.PpcPurchaseDemandQryPageAbilityReqBO;
import com.tydic.ppc.ability.bo.PpcPurchaseDemandQryPageAbilityRspBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrBatchImportAgreementSkuChangeAbilityService"})
public class AgrBatchImportAgreementSkuChangeAbilityServiceImpl
implements AgrBatchImportAgreementSkuChangeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrBatchImportAgreementSkuChangeAbilityServiceImpl.class);
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgrCreateAgreementSkuChangeBusiService agrCreateAgreementSkuChangeBusiService;
    @Autowired
    private CnncAgrExternalImportResultLogServiceHolder cnncAgrExternalImportResultLogServiceHolder;
    @Autowired
    private UccAgrSkuImportCheckAbilityService uccAgrSkuImportCheckAbilityService;
    @Autowired
    private AgrCnncAgrExportImportResultsBusiService cnncAgrExportImportResultsBusiService;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private FscDictionaryAbilityService fscDictionaryAbilityService;
    public static final String DICTIONARY_KEY_PREFIX = "PES_DIC_";
    public static final int DICTIONARY_KEY_EXPIRE = 3600;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${HK.sysTenantId:1104853665419067393}")
    private Long sysTenantIdHK;
    @Autowired
    private PpcPurchaseDemandQryListAbilityService ppcPurchaseDemandQryListAbilityService;

    @PostMapping(value={"dealBatchImportAgreementSkuChange"})
    public AgrBatchImportAgreementSkuChangeAbilityRspBO dealBatchImportAgreementSkuChange(@RequestBody AgrBatchImportAgreementSkuChangeAbilityReqBO abilityReqBO) {
        AgrBatchImportAgreementSkuChangeAbilityRspBO abilityRspBO = new AgrBatchImportAgreementSkuChangeAbilityRspBO();
        if (null == abilityReqBO.getAgreementId()) {
            throw new BusinessException("0001", "\u534f\u8bae\u53d8\u66f4\u660e\u7ec6\u6279\u91cf\u5bfc\u5165API\u5165\u53c2\u3010agreementId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)abilityReqBO.getUrl())) {
            throw new BusinessException("0001", "\u534f\u8bae\u53d8\u66f4\u660e\u7ec6\u6279\u91cf\u5bfc\u5165API\u5165\u53c2\u3010url\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getMemIdIn()) {
            throw new BusinessException("0001", "\u534f\u8bae\u53d8\u66f4\u660e\u7ec6\u6279\u91cf\u5bfc\u5165API\u5165\u53c2\u3010memIdIn\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)abilityReqBO.getChangeCode())) {
            throw new BusinessException("0001", "\u534f\u8bae\u53d8\u66f4\u660e\u7ec6\u6279\u91cf\u5bfc\u5165API\u5165\u53c2\u3010changeCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getSkuChangeType()) {
            throw new BusinessException("0001", "\u534f\u8bae\u53d8\u66f4\u660e\u7ec6\u6279\u91cf\u5bfc\u5165API\u5165\u53c2\u3010skuChangeType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(abilityReqBO.getAgreementId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new com.tydic.uac.exception.BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
        agreementSkuPO.setAgreementId(abilityReqBO.getAgreementId());
        agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementSkuPO> agreementSkuPOList = this.agreementSkuMapper.getList(agreementSkuPO);
        List<AgrAgreementSkuChangeBO> agrAgreementSkuChangeBOS = this.analysisFile(abilityReqBO, agreement, agreementSkuPOList);
        AgrCreateAgreementSkuChangeBusiReqBO busiReqBO = new AgrCreateAgreementSkuChangeBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)((Object)busiReqBO));
        busiReqBO.setAgrAgreementSkuChangeBOs(agrAgreementSkuChangeBOS);
        if (abilityReqBO.getSkuChangeType() == 0) {
            int i = 1;
            for (AgrAgreementSkuChangeBO agrAgreementSkuChangeBO : agrAgreementSkuChangeBOS) {
                for (AgreementSkuPO skuPO : agreementSkuPOList) {
                    if (!agrAgreementSkuChangeBO.getMaterialId().equals(skuPO.getMaterialId())) continue;
                    agrAgreementSkuChangeBO.setAgreementSkuId(skuPO.getAgreementSkuId());
                    agrAgreementSkuChangeBO.setTaxRate(skuPO.getTaxRate());
                    if (skuPO.getSupplyCycle() == null || agrAgreementSkuChangeBO.getSupplyCycle() != null && agrAgreementSkuChangeBO.getSupplyCycle() != 0) break;
                    throw new BusinessException("8888", "\u7b2c" + i + "\u884c\u534f\u8bae\u660e\u7ec6\u4f9b\u8d27\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                ++i;
            }
        }
        AgrCreateAgreementSkuChangeBusiRspBO busiRspBO = this.agrCreateAgreementSkuChangeBusiService.createAgreementSkuChange(busiReqBO);
        try {
            this.exportImportResults(busiReqBO, abilityReqBO, agreement);
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u8bb0\u5f55\u65b0\u589e\u51fa\u9519{}", (Object)e.getMessage());
        }
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)abilityRspBO);
        return abilityRspBO;
    }

    private List<AgrAgreementSkuChangeBO> analysisFile(AgrBatchImportAgreementSkuChangeAbilityReqBO abilityReqBO, AgreementPO agreement, List<AgreementSkuPO> agreementSkuPOList) {
        Iterator uccRspMap;
        List agrAgreementSkuChangeBOS;
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        List vendorMaterialCodeList = agreementSkuPOList.stream().map(AgreementSkuPO::getVendorMaterialCode).collect(Collectors.toList());
        List materialCodeList = agreementSkuPOList.stream().map(AgreementSkuPO::getMaterialCode).collect(Collectors.toList());
        log.info("vendorMaterialCodeList:{}", vendorMaterialCodeList);
        ArrayList<String> importVendorMaterialCodeList = new ArrayList<String>();
        ArrayList<String> importMaterialCodeList = new ArrayList<String>();
        try {
            HttpUtil.deleteFile("temporaryfile/content.xlsx");
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/content.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(abilityReqBO.getUrl(), file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            this.getExcelDateByImport((MultipartFile)multipartFile, data, title);
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new BusinessException("22052", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(data)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Integer> dateMapIndex = new HashMap<String, Integer>();
        String importTemplateStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IMPORT_TEMPLATE_PCODE", "1");
        List templateBOs = JSON.parseArray((String)importTemplateStr, AgrImoprtTemplateBO.class);
        block4: for (AgrImoprtTemplateBO bo : templateBOs) {
            for (int i = 0; i < title.size(); ++i) {
                if (!((String)title.get(i)).equals(bo.getFieldName())) continue;
                dateMapIndex.put(bo.getFieldNameEng(), i);
                continue block4;
            }
        }
        ArrayList dateMaps = new ArrayList();
        Map dictMapList = abilityReqBO.getData();
        log.info("\u7a0e\u7387\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u503c:{}", (Object)dictMapList);
        List taxRatePcodeList = (List)dictMapList.get("AGR_TAX_RATE_PCODE");
        ArrayList<Byte> taxList = new ArrayList<Byte>();
        for (AgrAgreementDictionaryCodeBO bo : taxRatePcodeList) {
            taxList.add(Byte.valueOf(bo.getCode()));
        }
        List taxCatCodeList = (List)dictMapList.get("ucc_tax_cat_code_value");
        ArrayList<String> taxCatList = new ArrayList<String>();
        for (AgrAgreementDictionaryCodeBO bo : taxCatCodeList) {
            taxCatList.add(bo.getCode());
        }
        ArrayList<String> addTaxCatList = new ArrayList<String>();
        String errorMessage = null;
        int i = 1;
        for (List list : data) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            boolean importErrMsgFlag = false;
            StringBuilder importRemark = new StringBuilder();
            for (AgrImoprtTemplateBO bo : templateBOs) {
                Integer sheetKey = (Integer)dateMapIndex.get(bo.getFieldNameEng());
                if (null != sheetKey) {
                    String markupAmount;
                    String extField7;
                    String extField6;
                    Object content = list.get(sheetKey);
                    if (bo.getIsMustFill().booleanValue()) {
                        if (agreement.getTradeMode() == 2) {
                            if (!("buyPrice".equals(bo.getFieldNameEng()) || "markupRate".equals(bo.getFieldNameEng()) || this.sysTenantIdHK.equals(abilityReqBO.getSysTenantId()) && ("\u7a0e\u7387".equals(bo.getFieldName()) || "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801".equals(bo.getFieldName())) || null != content && !"".equals(content) && !"null".equals(content))) {
                                importErrMsgFlag = true;
                                importRemark.setLength(0);
                                importRemark.append("\u7b2c" + i + "\u884c\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u3010").append(bo.getFieldName()).append("\u3011\u5fc5\u586b\uff01");
                                continue;
                            }
                        } else if (!("markupRate".equals(bo.getFieldNameEng()) || "markupAmount".equals(bo.getFieldNameEng()) || "extField6".equals(bo.getFieldNameEng()) || "extField7".equals(bo.getFieldNameEng()) || this.sysTenantIdHK.equals(abilityReqBO.getSysTenantId()) && ("\u7a0e\u7387".equals(bo.getFieldName()) || "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801".equals(bo.getFieldName())) || null != content && !"".equals(content) && !"null".equals(content))) {
                            importErrMsgFlag = true;
                            importRemark.setLength(0);
                            importRemark.append("\u7b2c" + i + "\u884c\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u3010").append(bo.getFieldName()).append("\u3011\u5fc5\u586b\uff01");
                            continue;
                        }
                    }
                    if (!"supplyCycle".equals(bo.getFieldNameEng()) || null == content || "".equals(content) || "null".equals(content)) {
                        // empty if block
                    }
                    if ("materialCode".equals(bo.getFieldNameEng())) {
                        boolean isExist = false;
                        for (AgreementSkuPO skuPO : agreementSkuPOList) {
                            if (!skuPO.getMaterialCode().equals(content)) continue;
                            isExist = true;
                            break;
                        }
                        if (0 == abilityReqBO.getSkuChangeType() && !isExist) {
                            importErrMsgFlag = true;
                            importRemark.setLength(0);
                            importRemark.append("\u7b2c" + i + "\u884c\u534f\u8bae\u660e\u7ec6\u8c03\u4ef7\u53d8\u66f4\u6279\u91cf\u5bfc\u5165\u6709\u4e0d\u5c5e\u4e8e\u539f\u534f\u8bae\u7684\u660e\u7ec6\uff01");
                        }
                    }
                    if ("markupRate".equals(bo.getFieldNameEng())) {
                        String markupRate = (String)content;
                        if (StringUtils.isEmpty((Object)markupRate) || "null".equals(markupRate)) {
                            markupRate = "0";
                        }
                        content = markupRate;
                    }
                    if ("buyPrice".equals(bo.getFieldNameEng())) {
                        String buyPrice = (String)content;
                        if ((buyPrice = new BigDecimal(buyPrice).multiply(new BigDecimal(10000)).toString()).endsWith(".00")) {
                            buyPrice = buyPrice.substring(0, buyPrice.lastIndexOf(".00"));
                        }
                        content = buyPrice;
                    }
                    if ("extField6".equals(bo.getFieldNameEng()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(extField6 = (String)content)) && !"null".equals(extField6)) {
                        String string = content = (extField6 = new BigDecimal(extField6).multiply(new BigDecimal(10000)).toString()).endsWith(".00") ? extField6.substring(0, extField6.lastIndexOf(".00")) : extField6;
                    }
                    if ("extField7".equals(bo.getFieldNameEng()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(extField7 = (String)content)) && !"null".equals(extField7)) {
                        String string = content = (extField7 = new BigDecimal(extField7).multiply(new BigDecimal(10000)).toString()).endsWith(".00") ? extField7.substring(0, extField7.lastIndexOf(".00")) : extField7;
                    }
                    if ("markupAmount".equals(bo.getFieldNameEng()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(markupAmount = (String)content)) && !"null".equals(markupAmount)) {
                        String string = content = (markupAmount = new BigDecimal(markupAmount).multiply(new BigDecimal(10000)).toString()).endsWith(".00") ? markupAmount.substring(0, markupAmount.lastIndexOf(".00")) : markupAmount;
                    }
                    if ("salePrice".equals(bo.getFieldNameEng())) {
                        String salePrice = (String)content;
                        if ((salePrice = new BigDecimal(salePrice).multiply(new BigDecimal(10000)).toString()).endsWith(".00")) {
                            salePrice = salePrice.substring(0, salePrice.lastIndexOf(".00"));
                        }
                        content = salePrice;
                    }
                    if ("materialCode".equals(bo.getFieldNameEng())) {
                        String materialCode = (String)content;
                        if (abilityReqBO.getSkuChangeType() == 1) {
                            if (materialCodeList.contains(materialCode) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)materialCode)) {
                                importErrMsgFlag = true;
                                importRemark.setLength(0);
                                importRemark.append("\u7b2c" + i + "\u884c\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u7684\u7269\u6599\u7f16\u7801\u3010").append(materialCode).append("\u3011\u5728\u539f\u534f\u8bae\u4e2d\u5b58\u5728\uff01");
                                continue;
                            }
                            if (importMaterialCodeList.contains(materialCode) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)materialCode)) {
                                importErrMsgFlag = true;
                                importRemark.setLength(0);
                                importRemark.append("\u7b2c" + i + "\u884c\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u7684\u4f9b\u5e94\u5546\u7269\u6599\u7f16\u7801\u3010").append(materialCode).append("\u3011\u5728excel\u4e2d\u5b58\u5728\u4e24\u6b21\u4ee5\u4e0a\uff01");
                                continue;
                            }
                        }
                        importMaterialCodeList.add(materialCode);
                    }
                    if ("vendorMaterialCode".equals(bo.getFieldNameEng())) {
                        String vendorMaterialCode = (String)content;
                        if (abilityReqBO.getSkuChangeType() == 1) {
                            if (vendorMaterialCodeList.contains(vendorMaterialCode) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vendorMaterialCode)) {
                                importErrMsgFlag = true;
                                importRemark.setLength(0);
                                importRemark.append("\u7b2c" + i + "\u884c\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u7684\u4f9b\u5e94\u5546\u7f16\u7801\u3010").append(vendorMaterialCode).append("\u3011\u5728\u539f\u534f\u8bae\u4e2d\u5b58\u5728\uff01");
                                continue;
                            }
                            if (importVendorMaterialCodeList.contains(vendorMaterialCode) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vendorMaterialCode)) {
                                importErrMsgFlag = true;
                                importRemark.setLength(0);
                                importRemark.append("\u7b2c" + i + "\u884c\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u7684\u4f9b\u5e94\u5546\u7269\u6599\u7f16\u7801\u3010").append(vendorMaterialCode).append("\u3011\u5728excel\u4e2d\u5b58\u5728\u4e24\u6b21\u4ee5\u4e0a\uff01");
                                continue;
                            }
                        }
                        importVendorMaterialCodeList.add(vendorMaterialCode);
                    }
                    if ("purchaseDemandOrderNo".equals(bo.getFieldNameEng()) && null != content && !"".equals(content) && !"null".equals(content)) {
                        PpcPurchaseDemandQryPageAbilityReqBO ppcPurchaseDemandQryPageAbilityReqBO = new PpcPurchaseDemandQryPageAbilityReqBO();
                        ppcPurchaseDemandQryPageAbilityReqBO.setUserId(Long.valueOf(1L));
                        ppcPurchaseDemandQryPageAbilityReqBO.setPurchaseDemandNoAccurate(content.toString());
                        PpcPurchaseDemandQryPageAbilityRspBO ppcPurchaseDemandQryPageAbilityRspBO = this.ppcPurchaseDemandQryListAbilityService.queryPurchaseDemandPage(ppcPurchaseDemandQryPageAbilityReqBO);
                        if ("0000".equals(ppcPurchaseDemandQryPageAbilityRspBO.getRespCode()) && ppcPurchaseDemandQryPageAbilityRspBO.getRecordsTotal() == 0) {
                            importErrMsgFlag = true;
                            importRemark.setLength(0);
                            importRemark.append("\u7b2c" + i + "\u884ce\u8d2d\u91c7\u8d2d\u9700\u6c42\u7f16\u53f7\u8f93\u5165\u6709\u8bef");
                            continue;
                        }
                    }
                    if ("buyNumber".equals(bo.getFieldNameEng())) {
                        String buyNumber = (String)content;
                        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)buyNumber)) {
                            buyNumber = buyNumber.replace(",", "");
                        }
                        content = buyNumber;
                    }
                    dataMap.put(bo.getFieldNameEng(), content);
                    continue;
                }
                if (this.sysTenantIdHK.equals(abilityReqBO.getSysTenantId()) && ("\u7a0e\u7387".equals(bo.getFieldName()) || "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801".equals(bo.getFieldName()))) continue;
                throw new BusinessException("0001", "\u7b2c" + i + "\u884c\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6570\u636e\u5e93\u6a21\u7248\u914d\u7f6e\u7684\u3010" + bo.getFieldNameEng() + "\u3011\u4e3a\u7a7a\uff01");
            }
            if (importErrMsgFlag) {
                dataMap.put("impResult", AgrExtCommonConstant.ImportResult.FAILED);
                dataMap.put("impRemark", importRemark.toString());
                errorMessage = importRemark.toString();
                throw new BusinessException("8888", importRemark.toString());
            }
            dataMap.put("impRemark", "\u6210\u529f");
            dataMap.put("impResult", AgrExtCommonConstant.ImportResult.SUCCESS);
            dataMap.putIfAbsent("taxRate", 0);
            if (Double.valueOf(dataMap.get("taxRate").toString()) < 1.0) {
                Double taxRate = Double.valueOf(dataMap.get("taxRate").toString()) * 100.0;
                dataMap.put("taxRate", taxRate.byteValue());
            }
            if (null != dataMap.get("markupRate") && Double.valueOf(dataMap.get("markupRate").toString()) < 1.0) {
                Double markupRate = Double.valueOf(dataMap.get("markupRate").toString()) * 100.0;
                dataMap.put("markupRate", markupRate.byteValue());
            }
            dateMaps.add(dataMap);
            log.info("\u5bfc\u5165\u6587\u4ef6\u89e3\u6790\u53c2\u6570:{}", dataMap);
            if (!taxList.contains(Byte.parseByte(dataMap.get("taxRate").toString())) && !this.sysTenantIdHK.equals(abilityReqBO.getSysTenantId())) {
                errorMessage = "\u7b2c" + i + "\u884c\u7a0e\u7387\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303!";
                throw new BusinessException("22052", errorMessage);
            }
            if (!taxCatList.contains(dataMap.get("taxCatalog").toString())) {
                addTaxCatList.add(dataMap.get("taxCatalog").toString());
                taxCatList.add(dataMap.get("taxCatalog").toString());
            }
            ++i;
        }
        String jsonStr = JSON.toJSONString(dateMaps);
        log.info("\u534f\u8bae\u8c03\u4ef7-\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\uff1a\u89e3\u6790\u540e\u6587\u4ef6\u503c\uff1a{}", (Object)jsonStr);
        try {
            agrAgreementSkuChangeBOS = JSON.parseArray((String)jsonStr, AgrAgreementSkuChangeBO.class);
        }
        catch (Exception exception) {
            log.error("\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01" + exception);
            throw new BusinessException("22052", "\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
        }
        ArrayList<UccAgrSkuImportCheckBO> arrayList = new ArrayList<UccAgrSkuImportCheckBO>();
        UccAgrSkuImportCheckAbilityReqBO uccAgrSkuImportCheckAbilityReqBO = new UccAgrSkuImportCheckAbilityReqBO();
        for (int j = 0; j < agrAgreementSkuChangeBOS.size(); ++j) {
            UccAgrSkuImportCheckBO bo = new UccAgrSkuImportCheckBO();
            bo.setSerialNumber(Integer.valueOf(j));
            bo.setCommodityTypeName(((AgrAgreementSkuChangeBO)agrAgreementSkuChangeBOS.get(j)).getCommodityTypeName());
            bo.setMaterialCode(((AgrAgreementSkuChangeBO)agrAgreementSkuChangeBOS.get(j)).getMaterialCode().toString());
            bo.setMeasureName(((AgrAgreementSkuChangeBO)agrAgreementSkuChangeBOS.get(j)).getMeasureName().toString());
            arrayList.add(bo);
        }
        uccAgrSkuImportCheckAbilityReqBO.setRows(arrayList);
        if (log.isDebugEnabled()) {
            log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6821\u9a8c\u670d\u52a1\u5165\u53c2 \uff1a" + JSONObject.toJSONString((Object)uccAgrSkuImportCheckAbilityReqBO));
        }
        UccAgrSkuImportCheckAbilityRspBO uccAgrSkuImportCheckAbilityRspBO = this.uccAgrSkuImportCheckAbilityService.checkInfo(uccAgrSkuImportCheckAbilityReqBO);
        if (log.isDebugEnabled()) {
            log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6821\u9a8c\u670d\u52a1\u51fa\u53c2 \uff1a" + JSONObject.toJSONString((Object)uccAgrSkuImportCheckAbilityRspBO));
        }
        Boolean marks = false;
        if ("0000".equals(uccAgrSkuImportCheckAbilityRspBO.getRespCode())) {
            uccRspMap = uccAgrSkuImportCheckAbilityRspBO.getRows().stream().collect(Collectors.toMap(UccAgrSkuImportCheckBO::getSerialNumber, Function.identity()));
            for (int k = 0; k < agrAgreementSkuChangeBOS.size(); ++k) {
                if (!((UccAgrSkuImportCheckBO)uccRspMap.get(k)).isPass()) {
                    ((AgrAgreementSkuChangeBO)agrAgreementSkuChangeBOS.get(k)).setImpRemark(((UccAgrSkuImportCheckBO)uccRspMap.get(k)).getReson());
                    ((AgrAgreementSkuChangeBO)agrAgreementSkuChangeBOS.get(k)).setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    throw new BusinessException("22052", "\u5bfc\u5165\u5931\u8d25:" + ((UccAgrSkuImportCheckBO)uccRspMap.get(k)).getReson());
                }
                ((AgrAgreementSkuChangeBO)agrAgreementSkuChangeBOS.get(k)).setMeasureId(((UccAgrSkuImportCheckBO)uccRspMap.get(k)).getMeasureId());
                ((AgrAgreementSkuChangeBO)agrAgreementSkuChangeBOS.get(k)).setMaterialId(((UccAgrSkuImportCheckBO)uccRspMap.get(k)).getMaterialId().toString());
                ((AgrAgreementSkuChangeBO)agrAgreementSkuChangeBOS.get(k)).setMaterialCode(((UccAgrSkuImportCheckBO)uccRspMap.get(k)).getMaterialCode());
                ((AgrAgreementSkuChangeBO)agrAgreementSkuChangeBOS.get(k)).setMaterialName(((UccAgrSkuImportCheckBO)uccRspMap.get(k)).getMaterialName());
                ((AgrAgreementSkuChangeBO)agrAgreementSkuChangeBOS.get(k)).setCatalogId(((UccAgrSkuImportCheckBO)uccRspMap.get(k)).getCatalogId().toString());
                ((AgrAgreementSkuChangeBO)agrAgreementSkuChangeBOS.get(k)).setCatalogName(((UccAgrSkuImportCheckBO)uccRspMap.get(k)).getCatalogName());
                ((AgrAgreementSkuChangeBO)agrAgreementSkuChangeBOS.get(k)).setCommodityTypeId(((UccAgrSkuImportCheckBO)uccRspMap.get(k)).getCommodityTypeId());
                ((AgrAgreementSkuChangeBO)agrAgreementSkuChangeBOS.get(k)).setCommodityTypeName(((UccAgrSkuImportCheckBO)uccRspMap.get(k)).getCommodityTypeName());
                ((AgrAgreementSkuChangeBO)agrAgreementSkuChangeBOS.get(k)).setModel(((UccAgrSkuImportCheckBO)uccRspMap.get(k)).getModel());
                ((AgrAgreementSkuChangeBO)agrAgreementSkuChangeBOS.get(k)).setSpec(((UccAgrSkuImportCheckBO)uccRspMap.get(k)).getSpec());
            }
        } else {
            uccRspMap = agrAgreementSkuChangeBOS.iterator();
            if (uccRspMap.hasNext()) {
                AgrAgreementSkuChangeBO agrAgreementSkuChangeBO = (AgrAgreementSkuChangeBO)uccRspMap.next();
                agrAgreementSkuChangeBO.setImpRemark("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165" + uccAgrSkuImportCheckAbilityRspBO.getRespDesc());
                agrAgreementSkuChangeBO.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                throw new BusinessException("22052", "\u5bfc\u5165\u5931\u8d25:" + uccAgrSkuImportCheckAbilityRspBO.getRespDesc());
            }
            marks = true;
        }
        List agrAgreementSkuChangeBOList = JSON.parseArray((String)JSON.toJSONString((Object)agrAgreementSkuChangeBOS), AgrAgreementSkuChangeBO.class);
        AgrExportImportResultsBusiReqBO importResultsBusiReqBO = new AgrExportImportResultsBusiReqBO();
        importResultsBusiReqBO.setImportSkuChangeList(agrAgreementSkuChangeBOList);
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(abilityReqBO.getAgreementId());
        log.info("\u83b7\u53d6\u6821\u9a8c\u6a21\u5f0f\u5165\u53c2:{}", (Object)agreementPO);
        importResultsBusiReqBO.setTradeMode(agreement.getTradeMode());
        log.error("\u8c03\u7528\u5bfc\u51fa\u6587\u4ef6\u5165\u53c2:" + JSON.toJSONString((Object)importResultsBusiReqBO));
        AgrExportImportResultsBusiRspBO importResultsBusiRspBO = this.cnncAgrExportImportResultsBusiService.exportImportResults(importResultsBusiReqBO);
        log.error("\u8c03\u7528\u5bfc\u51fa\u6587\u4ef6\u51fa\u53c2:" + JSON.toJSONString((Object)((Object)importResultsBusiRspBO)));
        if (!importResultsBusiRspBO.getRespCode().equals("0000")) {
            throw new BusinessException("22052", "\u5bfc\u5165\u5931\u8d25:\u5bfc\u5165\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
        }
        int ii = 1;
        for (AgrAgreementSkuChangeBO bo : agrAgreementSkuChangeBOS) {
            if (bo.getMarkupRate() == null) {
                bo.setMarkupRate(Double.valueOf(new BigDecimal("0").divide(new BigDecimal(100)).doubleValue()));
            }
            if (abilityReqBO.getSkuChangeType() == 1) {
                bo.setChangeType(AgrCommConstant.AgreementSkuChangeType.ADD);
            } else {
                bo.setChangeType(AgrCommConstant.AgreementSkuChangeType.UPDATE);
            }
            if (agreement.getTradeMode() == 1) {
                bo.setBuyPriceSum(Long.valueOf(new BigDecimal(bo.getBuyPrice()).multiply(bo.getBuyNumber()).longValue()));
            }
            if (agreement.getTradeMode() == 1) {
                Long sale = 0L;
                if (null != bo.getMarkupRate() && bo.getMarkupRate() != 0.0) {
                    sale = new BigDecimal(bo.getBuyPrice()).add(new BigDecimal(bo.getBuyPrice()).multiply(new BigDecimal(bo.getMarkupRate().toString())).divide(new BigDecimal(100))).longValue();
                    bo.setMarkupRule(Byte.valueOf((byte)1));
                } else if (null != bo.getMarkupAmount()) {
                    sale = new BigDecimal(bo.getBuyPrice()).add(new BigDecimal(bo.getMarkupAmount())).longValue();
                    bo.setMarkupRule(Byte.valueOf((byte)2));
                } else {
                    throw new com.tydic.uac.exception.BusinessException("8888", "\u7b2c" + ii + "\u884c\u52a0\u4ef7\u6bd4\u7387\u548c\u52a0\u4ef7\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a)\uff01");
                }
                if (!sale.equals(bo.getSalePrice())) {
                    throw new com.tydic.uac.exception.BusinessException("8888", "\u7b2c" + ii + "\u884c\u9500\u552e\u5355\u4ef7\u586b\u5199\u6709\u8bef\uff0c\u9500\u552e\u5355\u4ef7 = \u91c7\u8d2d\u5355\u4ef7 + (\u91c7\u8d2d\u5355\u4ef7*\u52a0\u4ef7\u6bd4\u7387)\u6216\u8005\u9500\u552e\u5355\u4ef7 = \u91c7\u8d2d\u5355\u4ef7 + \u52a0\u4ef7\u91d1\u989d)\uff01");
                }
                bo.setSalePrice(sale);
            }
            bo.setSalePriceSum(Long.valueOf(new BigDecimal(bo.getSalePrice()).multiply(bo.getBuyNumber()).longValue()));
            if (agreement.getTradeMode() == 2) {
                bo.setBuyPrice(bo.getSalePrice());
                bo.setBuyPriceSum(bo.getSalePriceSum());
            }
            if (agreement.getTradeMode() == 1) {
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bo.getExtField6()) && !"0".equals(bo.getExtField6())) {
                    if (null == bo.getBuyPrice()) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.buyPrice\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (null == bo.getBuyPriceSum()) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.buyPriceSum\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (Long.parseLong(bo.getExtField6()) < bo.getSalePrice() || Long.parseLong(bo.getExtField6()) < bo.getBuyPrice()) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u534f\u8bae\u4ef7\u4e0a\u9650\u9700\u6ee1\u8db3\uff1a\u534f\u8bae\u4ef7\u4e0a\u9650\u2265\u9500\u552e\u5355\u4ef7\u2265\u534f\u8bae\u4ef7\u4e0b\u9650\u2265\u91c7\u8d2d\u5355\u4ef7");
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bo.getExtField7()) && Long.parseLong(bo.getExtField6()) < Long.parseLong(bo.getExtField7())) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u534f\u8bae\u4ef7\u4e0a\u9650\u9700\u6ee1\u8db3\uff1a\u534f\u8bae\u4ef7\u4e0a\u9650\u2265\u9500\u552e\u5355\u4ef7\u2265\u534f\u8bae\u4ef7\u4e0b\u9650\u2265\u91c7\u8d2d\u5355\u4ef7");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bo.getExtField7()) && !"0".equals(bo.getExtField7())) {
                    if (null == bo.getBuyPrice()) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.buyPrice\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (null == bo.getBuyPriceSum()) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.buyPriceSum\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (Long.parseLong(bo.getExtField7()) < bo.getBuyPrice() || Long.parseLong(bo.getExtField7()) > bo.getSalePrice()) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u534f\u8bae\u4ef7\u4e0b\u9650\u9700\u6ee1\u8db3\uff1a\u534f\u8bae\u4ef7\u4e0a\u9650\u2265\u9500\u552e\u5355\u4ef7\u2265\u534f\u8bae\u4ef7\u4e0b\u9650\u2265\u91c7\u8d2d\u5355\u4ef7");
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bo.getExtField6()) && Long.parseLong(bo.getExtField6()) < Long.parseLong(bo.getExtField7())) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u534f\u8bae\u4ef7\u4e0b\u9650\u9700\u6ee1\u8db3\uff1a\u534f\u8bae\u4ef7\u4e0a\u9650\u2265\u9500\u552e\u5355\u4ef7\u2265\u534f\u8bae\u4ef7\u4e0b\u9650\u2265\u91c7\u8d2d\u5355\u4ef7");
                    }
                }
            }
            if ("null".equals(bo.getExtField6())) {
                bo.setExtField6(null);
            }
            if ("null".equals(bo.getExtField7())) {
                bo.setExtField7(null);
            }
            bo.setImpResult(Integer.valueOf(0));
            ++ii;
        }
        if (!CollectionUtils.isEmpty(addTaxCatList)) {
            for (String addTaxCat : addTaxCatList) {
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)addTaxCat)) continue;
                FscDicDictionaryReqBO reqBO = new FscDicDictionaryReqBO();
                reqBO.setCode(addTaxCat);
                reqBO.setTitle(addTaxCat);
                reqBO.setDescrip("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801");
                reqBO.setPCode("FSC_TAX_CAT_CODE_VALUE");
                reqBO.setSysTenantId(abilityReqBO.getSysTenantId());
                reqBO.setSysTenantName(abilityReqBO.getSysTenantName());
                FscDictionaryAbilityRspBO addRspBO = this.fscDictionaryAbilityService.addDicDictionary(reqBO);
                if ("0000".equals(addRspBO.getRespCode())) continue;
                throw new com.tydic.uac.exception.BusinessException("8888", "\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165,\u65b0\u589e\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5931\u8d25" + addRspBO.getRespDesc());
            }
            this.refreshCodeList("ucc_tax_cat_code_value");
        }
        return agrAgreementSkuChangeBOS;
    }

    private void getExcelDateByImport(MultipartFile multipartFile, List<List<String>> data, List<String> title) {
        try {
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            int count = 0;
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                if (count < 9) {
                    ++count;
                    continue;
                }
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                if ("".equals(row.getCell(0).toString())) continue;
                for (int i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i);
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ExcelUtils.getValue(cell);
                    if (count == 9) {
                        String titleName = String.valueOf(obj).trim();
                        if (titleName.startsWith("*")) {
                            titleName = titleName.substring(1);
                        }
                        title.add(titleName);
                        continue;
                    }
                    if (count < 10) continue;
                    c.add(String.valueOf(obj).trim());
                }
                if (end < title.size()) {
                    int distance = title.size() - end;
                    for (int i = 0; i < distance; ++i) {
                        c.add("");
                    }
                }
                ++count;
                if (c.size() <= 0) continue;
                ArrayList<String> d = new ArrayList<String>();
                for (String str : c) {
                    if (str.endsWith(".00")) {
                        str = str.substring(0, str.length() - 3);
                    }
                    d.add(str);
                }
                data.add(d);
            }
        }
        catch (Exception e) {
            throw new BusinessException("22052", e.getMessage());
        }
    }

    private void exportImportResults(AgrCreateAgreementSkuChangeBusiReqBO reqBO, AgrBatchImportAgreementSkuChangeAbilityReqBO abilityReqBO, AgreementPO agreement) {
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        Long successCount = 0L;
        Long failureCount = 0L;
        if (!CollectionUtils.isEmpty(reqBO.getAgrAgreementSkuChangeBOs())) {
            int index = 0;
            for (AgrAgreementSkuChangeBO skuPO : reqBO.getAgrAgreementSkuChangeBOs()) {
                LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
                item.put("\u5e8f\u53f7", ++index);
                item.put("\u7f16\u53f7", skuPO.getAgreementSkuId() != null ? skuPO.getAgreementSkuId() : "");
                item.put("\u5546\u54c1\u7c7b\u578b", skuPO.getCatalogName() != null ? skuPO.getCatalogName() : "");
                item.put("\u7269\u6599\u7f16\u7801", skuPO.getMaterialCode() != null ? skuPO.getMaterialCode() : "");
                item.put("\u578b\u53f7", skuPO.getModel() != null ? skuPO.getModel() : "");
                item.put("\u89c4\u683c", skuPO.getSpec() != null ? skuPO.getSpec() : "");
                item.put("\u54c1\u724c", skuPO.getBrandName() != null ? skuPO.getBrandName() : "");
                item.put("\u4f9b\u8d27\u5468\u671f", skuPO.getSupplyCycle() != null ? skuPO.getSupplyCycle() : "");
                item.put("\u8ba1\u91cf\u5355\u4f4d", skuPO.getMeasureName() != null ? skuPO.getMeasureName() : "");
                item.put("\u7a0e\u6536\u7f16\u7801", skuPO.getTaxCatalog() != null ? skuPO.getTaxCatalog() : "");
                if (skuPO.getIsOil() != null) {
                    if (skuPO.getIsOil().equals((byte)0)) {
                        item.put("\u662f\u5426\u6210\u54c1\u6cb9", "\u5426");
                    } else {
                        item.put("\u662f\u5426\u6210\u54c1\u6cb9", "\u662f");
                    }
                } else {
                    item.put("\u662f\u5426\u6210\u54c1\u6cb9", "");
                }
                item.put("\u6570\u91cf", skuPO.getBuyNumber() != null ? skuPO.getBuyNumber() : "");
                item.put("\u91c7\u8d2d\u5355\u4ef7", skuPO.getBuyPrice() != null ? new BigDecimal(skuPO.getBuyPrice()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                if (agreement.getTradeMode().equals((byte)1)) {
                    item.put("\u52a0\u4ef7\u6bd4\u7387", skuPO.getMarkupRate() != null ? skuPO.getMarkupRate() : "");
                    item.put("\u534f\u8bae\u4ef7\u4e0a\u9650", org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)skuPO.getExtField6()) ? new BigDecimal(skuPO.getExtField6()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                    item.put("\u534f\u8bae\u4ef7\u4e0b\u9650", org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)skuPO.getExtField7()) ? new BigDecimal(skuPO.getExtField7()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                    item.put("\u52a0\u4ef7\u91d1\u989d", null != skuPO.getMarkupAmount() ? new BigDecimal(skuPO.getMarkupAmount()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                    item.put("\u52a0\u4ef7\u89c4\u5219", null != skuPO.getMarkupAmount() ? 2 : 1);
                }
                item.put("\u91c7\u8d2d\u603b\u8ba1", skuPO.getBuyPriceSum() != null ? new BigDecimal(skuPO.getBuyPriceSum()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                item.put("\u9500\u552e\u5355\u4ef7", skuPO.getSalePrice() != null ? new BigDecimal(skuPO.getSalePrice()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                item.put("\u9500\u552e\u603b\u4ef7", skuPO.getSalePriceSum() != null ? new BigDecimal(skuPO.getSalePriceSum()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                if (skuPO.getImpResult() != null) {
                    Long l;
                    Long l2;
                    if (AgrExtCommonConstant.ImportResult.SUCCESS.equals(skuPO.getImpResult())) {
                        item.put("\u5bfc\u5165\u7ed3\u679c", "\u6210\u529f");
                        item.put("\u5931\u8d25\u539f\u56e0", "");
                        l2 = successCount;
                        l = successCount = Long.valueOf(successCount + 1L);
                    } else {
                        item.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                        item.put("\u5931\u8d25\u539f\u56e0", skuPO.getImpRemark() != null ? skuPO.getImpRemark() : "");
                        l2 = failureCount;
                        l = failureCount = Long.valueOf(failureCount + 1L);
                    }
                } else {
                    item.put("\u5bfc\u5165\u7ed3\u679c", "\u5bfc\u5165\u5f02\u5e38");
                }
                LinkedHashMap copyItem = new LinkedHashMap(item);
                exportData.add(item);
            }
        }
        AgrExternalImportResultLogAtomReqBO agrExternalImportResultLogServiceReqBO = new AgrExternalImportResultLogAtomReqBO();
        agrExternalImportResultLogServiceReqBO.setExportData(exportData);
        agrExternalImportResultLogServiceReqBO.setFileName("\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u5bfc\u51fa\u8bb0\u5f55");
        agrExternalImportResultLogServiceReqBO.setFileUrl(abilityReqBO.getUrl());
        agrExternalImportResultLogServiceReqBO.setSuccessCount(successCount);
        agrExternalImportResultLogServiceReqBO.setFailureCount(failureCount);
        agrExternalImportResultLogServiceReqBO.setMemId(abilityReqBO.getMemIdIn());
        agrExternalImportResultLogServiceReqBO.setImpRemark("");
        agrExternalImportResultLogServiceReqBO.setImpResult(0);
        agrExternalImportResultLogServiceReqBO.setIsSkuChange(0);
        agrExternalImportResultLogServiceReqBO.setAgreementId(abilityReqBO.getAgreementId());
        log.error("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)agrExternalImportResultLogServiceReqBO));
        AgrExternalImportResultLogAtomRspBO agrExternalImportResultLogServiceRspBO = this.cnncAgrExternalImportResultLogServiceHolder.getAgrExternalImportResultLogService().importLog(agrExternalImportResultLogServiceReqBO);
        log.error("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)((Object)agrExternalImportResultLogServiceRspBO)));
    }

    public void refreshCodeList(String key) {
        this.cacheClient.delete(DICTIONARY_KEY_PREFIX + key);
        FscQueryDictionaryAbilityReqBO reqBO = new FscQueryDictionaryAbilityReqBO();
        reqBO.setPcode("FSC_TAX_CAT_CODE_VALUE");
        FscRspPageBaseBO qryRspBO = this.fscDictionaryAbilityService.queryBypCodeBackPo(reqBO);
        if ("0000".equals(qryRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)qryRspBO.getRows())) {
            this.cacheClient.set(DICTIONARY_KEY_PREFIX + key, (Object)qryRspBO.getRows(), AgrBatchImportAgreementSkuChangeAbilityServiceImpl.getExpireSeconds(3600, 10));
        }
    }

    public static int getExpireSeconds(int radix, int range) {
        return radix * (new Random().nextInt(range) + 1);
    }
}

