/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.api.CrcAddAgreementSubjectAbilityService;
import com.tydic.agreement.ability.bo.CrcAddAgreementSubjectAbilityReqBO;
import com.tydic.agreement.ability.bo.CrcAddAgreementSubjectAbilityRspBO;
import com.tydic.agreement.ability.bo.CrcAgreementScopeBO;
import com.tydic.agreement.busi.api.CrcAddAgreementSubjectBusiService;
import com.tydic.agreement.busi.bo.CrcAddAgreementSubjectBusiReqBO;
import com.tydic.agreement.busi.bo.CrcAddAgreementSubjectBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrPushLogMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrPushLogPO;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.CrcAddAgreementSubjectAbilityService"})
public class CrcAddAgreementSubjectAbilityServiceImpl
implements CrcAddAgreementSubjectAbilityService {
    @Autowired
    private CrcAddAgreementSubjectBusiService crcAddAgreementSubjectBusiService;
    @Autowired
    private AgrPushLogMapper agrPushLogMapper;

    @PostMapping(value={"addAgreementSubject"})
    public CrcAddAgreementSubjectAbilityRspBO addAgreementSubject(@RequestBody CrcAddAgreementSubjectAbilityReqBO reqBO) {
        CrcAddAgreementSubjectAbilityRspBO rspBO = new CrcAddAgreementSubjectAbilityRspBO();
        AgrPushLogPO agrPushLogPO = new AgrPushLogPO();
        agrPushLogPO.setId(Sequence.getInstance().nextId());
        agrPushLogPO.setSysCode(reqBO.getSysCode());
        agrPushLogPO.setPushType("1");
        agrPushLogPO.setInContent(JSONObject.toJSONString((Object)reqBO));
        agrPushLogPO.setCreateTime(new Date());
        this.setDefaultValue(reqBO);
        this.validateParam(reqBO);
        CrcAddAgreementSubjectBusiReqBO busiReqBO = (CrcAddAgreementSubjectBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), CrcAddAgreementSubjectBusiReqBO.class));
        CrcAddAgreementSubjectBusiRspBO busiRspBO = this.crcAddAgreementSubjectBusiService.addAgreementSubject(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            agrPushLogPO.setIsFinish("0");
            agrPushLogPO.setFailReason(busiRspBO.getRespDesc());
            agrPushLogPO.setSysTenantId(305775845729763327L);
            agrPushLogPO.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
            this.agrPushLogMapper.insert(agrPushLogPO);
        }
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        return rspBO;
    }

    private void setDefaultValue(CrcAddAgreementSubjectAbilityReqBO reqBO) {
        if (null == reqBO.getWarantty()) {
            reqBO.setWarantty(AgrCommConstant.Warantty.TWELVE);
        }
        if (null == reqBO.getIsDispatch()) {
            reqBO.setIsDispatch(AgrCommConstant.IsDispatch.YES);
        }
        if (null == reqBO.getAdjustPrice()) {
            reqBO.setAdjustPrice(AgrCommConstant.AdjustPrice.NO_ADJUST_PRICE);
        }
        if (null == reqBO.getIsAdjustPriceFormula()) {
            reqBO.setIsAdjustPriceFormula(AgrCommConstant.IsAdjustPriceFormula.NO);
        }
        if (null == reqBO.getIsModifyBuyPrice()) {
            reqBO.setIsModifyBuyPrice(AgrCommConstant.IsModifyBuyPrice.NO);
        }
        if (null == reqBO.getSignTime()) {
            reqBO.setSignTime(new Date());
        }
        if (null == reqBO.getIsAddPrice()) {
            reqBO.setIsAddPrice(AgrCommConstant.IsAddPrice.NO);
        }
        if (null == reqBO.getIsPurchase()) {
            reqBO.setIsPurchase(AgrCommConstant.isPurchase.AVALIABLE_CONTRACT);
        }
        if (null == reqBO.getIsSale()) {
            reqBO.setIsSale(AgrCommConstant.isSale.AVALIABLE_CONTRACT);
        }
        if (null == reqBO.getAgreementType()) {
            reqBO.setAgreementType(Byte.valueOf((byte)0));
        }
    }

    private void validateParam(CrcAddAgreementSubjectAbilityReqBO abilityReqBO) {
        if (null == abilityReqBO) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getSysCode())) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010sysCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getCreateOrgId())) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010createOrgId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getProducerId())) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010producerId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getEntAgreementCode())) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010entAgreementCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getTradeMode()) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010tradeMode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getAgreementName())) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010agreementName\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getEffDate()) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010effDate\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getExpDate()) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010expDate\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getVendorId()) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010vendorId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getAgreementClassification()) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010agreementClassification\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getAgreementSignSupplier()) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010agreementSignSupplier\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getEntAgreementCode()) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010entAgreementCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getScope())) {
            for (CrcAgreementScopeBO bo : abilityReqBO.getScope()) {
                if (null == bo.getScopeCode()) {
                    throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementBO.getScope.scopeCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isBlank((CharSequence)bo.getScopeName())) continue;
                throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementBO.getScope.scopeName\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getAttach())) {
            for (CrcAgreementScopeBO bo : abilityReqBO.getAttach()) {
                if (StringUtils.isBlank((CharSequence)bo.getAttachmentName())) {
                    throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementBO.getAttach.attachmentName\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo.getAttachmentType()) {
                    throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementBO.getAttach.attachmentType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isBlank((CharSequence)bo.getAttachmentAddr())) continue;
                throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementBO.getAttach.attachmentAddr\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }
}

