/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.agreement.ability.bo.AgrApprovalLogBO;
import com.tydic.agreement.busi.api.AgrQryProcessInfoByPageBusiService;
import com.tydic.agreement.busi.bo.AgrQryProcessInfoByPageBusiReqBO;
import com.tydic.agreement.busi.bo.AgrQryProcessInfoByPageBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.UocOrdTaskMapper;
import com.tydic.agreement.po.UocOrdTaskPO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrQryProcessInfoByPageBusiServiceImpl
implements AgrQryProcessInfoByPageBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrQryProcessInfoByPageBusiServiceImpl.class);
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private UocOrdTaskMapper uocOrdTaskDAO;

    @Override
    public AgrQryProcessInfoByPageBusiRspBO qryProcessInfoByPage(AgrQryProcessInfoByPageBusiReqBO busiReqBO) {
        AgrQryProcessInfoByPageBusiRspBO rsp = new AgrQryProcessInfoByPageBusiRspBO();
        UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
        uacQryAuditLogReqBO.setPageNo(busiReqBO.getPageNo());
        uacQryAuditLogReqBO.setPageSize(busiReqBO.getPageSize());
        uacQryAuditLogReqBO.setOrderId(busiReqBO.getAgreementId());
        if (null == busiReqBO.getChangeId()) {
            uacQryAuditLogReqBO.setObjId(busiReqBO.getAgreementId().toString());
            uacQryAuditLogReqBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        } else {
            uacQryAuditLogReqBO.setObjId(busiReqBO.getChangeId().toString());
            uacQryAuditLogReqBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_ADD_AUDIT);
        }
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u5ba1\u6279\u65e5\u5fd7\u67e5\u8be2\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacQryAuditLogReqBO));
        UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLog(uacQryAuditLogReqBO);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u5ba1\u6279\u65e5\u5fd7\u67e5\u8be2\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacQryAuditLogRspBO));
        if (CollectionUtils.isEmpty((Collection)uacQryAuditLogRspBO.getRows())) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        ArrayList<AgrApprovalLogBO> rows = new ArrayList<AgrApprovalLogBO>();
        Date date = new Date();
        for (ApprovalLogBO bo : uacQryAuditLogRspBO.getRows()) {
            AgrApprovalLogBO agrApprovalLogBO = new AgrApprovalLogBO();
            BeanUtils.copyProperties((Object)bo, (Object)agrApprovalLogBO);
            if (agrApprovalLogBO.getNextStepId() != null) {
                agrApprovalLogBO.setAudit("\u63d0\u4ea4");
                agrApprovalLogBO.setDTime("");
                if (rows.size() == 1) {
                    ((AgrApprovalLogBO)rows.get(rows.size() - 1)).setDTime(AgrQryProcessInfoByPageBusiServiceImpl.getTime(date, agrApprovalLogBO.getDealTime()));
                } else {
                    date = agrApprovalLogBO.getDealTime();
                }
            }
            if (agrApprovalLogBO.getNextStepId() == null) {
                if (rows.size() >= 1) {
                    agrApprovalLogBO.setDTime(AgrQryProcessInfoByPageBusiServiceImpl.getTime(agrApprovalLogBO.getDealTime(), ((AgrApprovalLogBO)rows.get(rows.size() - 1)).getDealTime()));
                } else {
                    date = agrApprovalLogBO.getDealTime();
                }
            }
            if (agrApprovalLogBO.getAudit() == null) {
                agrApprovalLogBO.setAudit("\u9a73\u56de");
            }
            rows.add(agrApprovalLogBO);
        }
        UocOrdTaskPO uocOrdTaskPO = this.uocOrdTaskDAO.selectId(((AgrApprovalLogBO)rows.get(0)).getOrderId());
        if (uocOrdTaskPO != null) {
            rsp.setProcDefId(uocOrdTaskPO.getProcInstId());
            rsp.setTacheCode(uocOrdTaskPO.getTacheCode());
        }
        rsp.setAgrApprovalLogBOS(rows);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u8ba1\u5212\u6d41\u7a0b\u4fe1\u606f\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }

    public static String getTime(Date currentTime, Date firstTime) {
        long diff = currentTime.getTime() - firstTime.getTime();
        Calendar currentTimes = AgrQryProcessInfoByPageBusiServiceImpl.dataToCalendar(currentTime);
        Calendar firstTimes = AgrQryProcessInfoByPageBusiServiceImpl.dataToCalendar(firstTime);
        int year = currentTimes.get(1) - firstTimes.get(1);
        int month = currentTimes.get(2) - firstTimes.get(2);
        int day = currentTimes.get(5) - firstTimes.get(5);
        if (day < 0) {
            --month;
            currentTimes.add(2, -1);
            day += currentTimes.getActualMaximum(5);
        }
        if (month < 0) {
            month = (month + 12) % 12;
            --year;
        }
        long days = diff / 86400000L;
        long hours = (diff - days * 86400000L) / 3600000L;
        long minutes = (diff - days * 86400000L - hours * 3600000L) / 60000L;
        long s = diff / 1000L - days * 24L * 60L * 60L - hours * 60L * 60L - minutes * 60L;
        String CountTime = year + "\u5e74" + month + "\u6708" + day + "\u5929" + hours + "\u5c0f\u65f6" + minutes + "\u5206" + s + "\u79d2";
        if (year == 0) {
            CountTime = month + "\u6708" + day + "\u5929" + hours + "\u5c0f\u65f6" + minutes + "\u5206" + s + "\u79d2";
        }
        if (year == 0 && month == 0) {
            CountTime = day + "\u5929" + hours + "\u5c0f\u65f6" + minutes + "\u5206" + s + "\u79d2";
        }
        if (year == 0 && month == 0 && day == 0) {
            CountTime = hours + "\u5c0f\u65f6" + minutes + "\u5206" + s + "\u79d2";
        }
        if (year == 0 && month == 0 && day == 0 && hours == 0L) {
            CountTime = minutes + "\u5206" + s + "\u79d2";
        }
        if (year == 0 && month == 0 && day == 0 && hours == 0L && minutes == 0L) {
            CountTime = s + "\u79d2";
        }
        return CountTime;
    }

    public static Calendar dataToCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }
}

