/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.busi.api.AgrAssignAgreementBusiService;
import com.tydic.agreement.busi.bo.AgrAssignAgreementBusiReqBO;
import com.tydic.agreement.busi.bo.AgrAssignAgreementBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementAssignLogMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.po.AgreementAssignLogPO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.uac.exception.BusinessException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgrAssignAgreementBusiServiceImpl
implements AgrAssignAgreementBusiService {
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementAssignLogMapper agreementAssignLogMapper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AgrAssignAgreementBusiRspBO assignAgreement(AgrAssignAgreementBusiReqBO busiReqBO) {
        AgrAssignAgreementBusiRspBO rsp = new AgrAssignAgreementBusiRspBO();
        List<Long> agreementIds = busiReqBO.getAgreementIds();
        for (Long agreementId : agreementIds) {
            AgreementPO agreementPO = new AgreementPO();
            agreementPO.setAgreementId(agreementId);
            agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
            if (null == agreement) {
                throw new BusinessException("22001", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
            }
            AgrAssignAgreementBusiReqBO abq = new AgrAssignAgreementBusiReqBO();
            BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)((Object)abq));
            abq.setAgreementId(agreementId);
            if (AgrCommConstant.AgreementStatus.ENABLE.equals(agreement.getAgreementStatus())) {
                this.assign(abq);
            } else if (AgrCommConstant.AgreementStatus.SUSPEND.equals(agreement.getAgreementStatus())) {
                this.assign(abq);
            } else if (AgrCommConstant.AgreementStatus.FROZEN.equals(agreement.getAgreementStatus())) {
                this.assign(abq);
            } else {
                if (!AgrCommConstant.AgreementStatus.BE_OVERDUE.equals(agreement.getAgreementStatus())) throw new BusinessException("22002", "\u8be5\u534f\u8bae\u72b6\u6001\u4e0d\u53ef\u88ab\u5206\u914d\uff01");
                Calendar rightNow = Calendar.getInstance();
                Calendar expTime = Calendar.getInstance();
                expTime.setTime(agreement.getExpDate());
                expTime.add(2, 3);
                if (rightNow.compareTo(expTime) > 0) throw new BusinessException("22002", "\u8be5\u534f\u8bae\u5df2\u8fc7\u671f\u8d85\u8fc73\u4e2a\u6708\uff01");
                this.assign(abq);
            }
            AgreementAssignLogPO agreementAssignLogPO = new AgreementAssignLogPO();
            agreementAssignLogPO.setAgreementAssignId(Sequence.getInstance().nextId());
            agreementAssignLogPO.setAgreementId(agreement.getAgreementId());
            agreementAssignLogPO.setAgreementName(agreement.getAgreementName());
            agreementAssignLogPO.setSupplierId(agreement.getSupplierId());
            agreementAssignLogPO.setSupplierName(agreement.getSupplierName());
            agreementAssignLogPO.setPreProducerId(agreement.getProducerId());
            agreementAssignLogPO.setPreProducerName(agreement.getProducerName());
            agreementAssignLogPO.setPostProducerId(abq.getPostProducerId());
            agreementAssignLogPO.setPostProducerName(abq.getPostProducerName());
            agreementAssignLogPO.setOperater(abq.getName());
            agreementAssignLogPO.setOperateTime(new Date());
            agreementAssignLogPO.setSysTenantId(busiReqBO.getSysTenantId());
            agreementAssignLogPO.setSysTenantName(busiReqBO.getSysTenantName());
            int isInsert = this.agreementAssignLogMapper.insert(agreementAssignLogPO);
            if (isInsert >= 1) continue;
            throw new BusinessException("22003", "\u63d2\u5165\u6846\u67b6\u534f\u8bae\u914d\u7f6e\u8bb0\u5f55\u8868\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u5206\u914d\u6210\u529f\uff01");
        return rsp;
    }

    private void assign(AgrAssignAgreementBusiReqBO busiReqBO) {
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setProducerId(busiReqBO.getPostProducerId());
        agreementPO.setProducerName(busiReqBO.getPostProducerName());
        agreementPO.setAssignStatus(AgrCommConstant.AssignStatus.BE_ASSIGN);
        agreementPO.setUpdateLoginId(busiReqBO.getMemIdIn());
        agreementPO.setUpdateName(busiReqBO.getUserName());
        agreementPO.setUpdateTime(new Date());
        int isUpdate = this.agreementMapper.updateByCondition(agreementPO);
        if (isUpdate < 1) {
            throw new BusinessException("22005", "\u534f\u8bae\u8868\u66f4\u65b0\u5931\u8d25\uff01");
        }
    }
}

