/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.busi.api.AgrImportSkuAddBusiService;
import com.tydic.agreement.busi.bo.AgrImportSkuAddBusiReqBO;
import com.tydic.agreement.busi.bo.AgrImportSkuAddBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementSkuImportLogMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.po.AgrAgreementSkuImportLogPO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.uac.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgrImportSkuAddBusiServiceImpl
implements AgrImportSkuAddBusiService {
    @Autowired
    private AgrAgreementSkuImportLogMapper agrAgreementSkuImportLogMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementMapper agreementMapper;

    @Override
    public AgrImportSkuAddBusiRspBO importSkuAdd(AgrImportSkuAddBusiReqBO reqBO) {
        AgrImportSkuAddBusiRspBO rspBO = new AgrImportSkuAddBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("0000");
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(reqBO.getAgreementId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        AgrAgreementSkuImportLogPO agrAgreementSkuImportLogPo = new AgrAgreementSkuImportLogPO();
        agrAgreementSkuImportLogPo.setImportFileId(reqBO.getImportFileId());
        agrAgreementSkuImportLogPo.setVerifyStatus("1");
        List<AgrAgreementSkuImportLogPO> agrAgreementSkuImportLogPOList = this.agrAgreementSkuImportLogMapper.getList(agrAgreementSkuImportLogPo);
        ArrayList<AgreementSkuPO> insertSkuPoList = new ArrayList<AgreementSkuPO>();
        for (AgrAgreementSkuImportLogPO po : agrAgreementSkuImportLogPOList) {
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            BeanUtils.copyProperties((Object)po, (Object)agreementSkuPO);
            agreementSkuPO.setBuyPrice(po.getBuyPrice().multiply(new BigDecimal(10000)).longValue());
            agreementSkuPO.setBuyPriceSum(po.getBuyPrice().multiply(new BigDecimal(10000)).multiply(po.getBuyNumber()).longValue());
            agreementSkuPO.setSalePrice(po.getSalePrice().multiply(new BigDecimal(10000)).longValue());
            agreementSkuPO.setSalePriceSum(po.getSalePrice().multiply(new BigDecimal(10000)).multiply(po.getBuyNumber()).longValue());
            if (po.getMarkupAmount() != null) {
                agreementSkuPO.setMarkupAmount(po.getMarkupAmount().multiply(new BigDecimal(10000)).longValue());
            }
            if (po.getExtField6() != null) {
                agreementSkuPO.setExtField6(String.valueOf(po.getExtField6().multiply(new BigDecimal(10000)).longValue()));
            }
            if (po.getExtField7() != null) {
                agreementSkuPO.setExtField7(String.valueOf(po.getExtField7().multiply(new BigDecimal(10000)).longValue()));
            }
            if (po.getMarkupRate() != null) {
                agreementSkuPO.setMarkupRule((byte)1);
            } else {
                agreementSkuPO.setMarkupRule((byte)2);
            }
            agreementSkuPO.setAgreementSkuId(Sequence.getInstance().nextId());
            agreementSkuPO.setAgreementId(agreement.getAgreementId());
            agreementSkuPO.setSupplierId(agreement.getSupplierId());
            agreementSkuPO.setAgreementVersion(agreement.getAgreementVersion());
            agreementSkuPO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            agreementSkuPO.setCreateLoginId(reqBO.getMemIdIn());
            agreementSkuPO.setCreateName(reqBO.getUserName());
            agreementSkuPO.setCreateTime(new Date());
            insertSkuPoList.add(agreementSkuPO);
        }
        this.agreementSkuMapper.insertBatch(insertSkuPoList);
        return rspBO;
    }
}

