/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAdjustPriceBO;
import com.tydic.agreement.ability.bo.AgrScopeSyncBO;
import com.tydic.agreement.ability.bo.AgrskuChangeDetailBO;
import com.tydic.agreement.ability.bo.AgrskuChangePriceBO;
import com.tydic.agreement.atom.api.AgrAgreementStatusChangeAtomService;
import com.tydic.agreement.atom.api.AgrSyncSkuStatusToCommidityAtomService;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomReqBO;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomRspBO;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomReqBO;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomRspBO;
import com.tydic.agreement.busi.api.AgrNotApproveTaskSyncBusiService;
import com.tydic.agreement.busi.bo.AgrAgreementChangeApplyApprovalBusiReqBO;
import com.tydic.agreement.busi.bo.AgrNotApproveTaskSyncBusiReqBO;
import com.tydic.agreement.busi.bo.AgrNotApproveTaskSyncBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementAttachChangeMapper;
import com.tydic.agreement.dao.AgrAgreementAttachLogMapper;
import com.tydic.agreement.dao.AgreementAttachMapper;
import com.tydic.agreement.dao.AgreementChangeMapper;
import com.tydic.agreement.dao.AgreementLogMapper;
import com.tydic.agreement.dao.AgreementMajorChangeMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementScopeChangeMapper;
import com.tydic.agreement.dao.AgreementScopeLogMapper;
import com.tydic.agreement.dao.AgreementScopeMapper;
import com.tydic.agreement.dao.AgreementSettlementLogMapper;
import com.tydic.agreement.dao.AgreementSettlementMapper;
import com.tydic.agreement.dao.AgreementSkuChangeMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrAgreementAttachChangePO;
import com.tydic.agreement.po.AgrAgreementAttachLogPO;
import com.tydic.agreement.po.AgreementAttachPO;
import com.tydic.agreement.po.AgreementChangePO;
import com.tydic.agreement.po.AgreementLogPO;
import com.tydic.agreement.po.AgreementMajorChangePO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementScopeChangePO;
import com.tydic.agreement.po.AgreementScopeLogPO;
import com.tydic.agreement.po.AgreementScopePO;
import com.tydic.agreement.po.AgreementSettlementLogPO;
import com.tydic.agreement.po.AgreementSettlementPO;
import com.tydic.agreement.po.AgreementSkuChangePO;
import com.tydic.agreement.po.AgreementSkuPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrNotApproveTaskSyncBusiServiceImpl
implements AgrNotApproveTaskSyncBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrNotApproveTaskSyncBusiServiceImpl.class);
    @Autowired
    private AgreementChangeMapper agreementChangeMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private AgreementAttachMapper agreementAttachMapper;
    @Autowired
    private AgreementMajorChangeMapper agreementMajorChangeMapper;
    @Autowired
    private AgreementSettlementMapper agreementSettlementMapper;
    @Autowired
    private AgreementScopeChangeMapper agreementScopeChangeMapper;
    @Autowired
    private AgrAgreementAttachChangeMapper agrAgreementAttachChangeMapper;
    @Autowired
    private AgreementSkuChangeMapper agreementSkuChangeMapper;
    @Autowired
    private AgreementLogMapper agreementLogMapper;
    @Autowired
    private AgreementScopeLogMapper agreementScopeLogMapper;
    @Autowired
    private AgrAgreementAttachLogMapper agrAgreementAttachLogMapper;
    @Autowired
    private AgreementSettlementLogMapper agreementSettlementLogMapper;
    @Autowired
    private AgrAgreementStatusChangeAtomService agrAgreementStatusChangeAtomService;
    @Autowired
    private AgrSyncSkuStatusToCommidityAtomService agrSyncSkuStatusToCommidityAtomService;

    @Override
    public AgrNotApproveTaskSyncBusiRspBO dealNotApproveTaskMq(AgrNotApproveTaskSyncBusiReqBO reqBO) {
        AgrNotApproveTaskSyncBusiRspBO rspBO = new AgrNotApproveTaskSyncBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        AgrAgreementChangeApplyApprovalBusiReqBO busiReqBO = new AgrAgreementChangeApplyApprovalBusiReqBO();
        HashSet<Long> changeIds = new HashSet<Long>();
        changeIds.add(reqBO.getChangeId());
        busiReqBO.setChangeIds(changeIds);
        busiReqBO.setNotFindFlag(false);
        List<AgreementChangePO> agreementChangePOs = this.validAgreementChangeInfo(busiReqBO);
        Map<Long, Byte> map = this.validAgreementInfo(agreementChangePOs, busiReqBO.getSupplierId());
        log.info("\u6279\u91cf\u96c6\u5408:map={},agreementChangePOs={}", map, agreementChangePOs);
        Set<Long> skuChangeIds = this.updateAgreement(map, agreementChangePOs, busiReqBO.getSupplierId(), busiReqBO.getSysTenantId());
        log.info("\u4fee\u6539\u534f\u8bae\u72b6\u6001,{},{}", (Object)reqBO.getChangeId());
        busiReqBO.setAuditResult(0);
        Byte status1 = this.updateAgreementChangeMapper(busiReqBO, map.keySet());
        if (skuChangeIds.size() > 0) {
            this.updateAgreementSku(busiReqBO.getSupplierId(), skuChangeIds);
        }
        HashSet<Long> agreementIds = new HashSet<Long>();
        for (AgreementChangePO agreementChangePO : agreementChangePOs) {
            if (!AgrCommConstant.AgreementChangeType.SUPPLEMENT.equals(agreementChangePO.getChangeType()) && !AgrCommConstant.AgreementChangeType.CHANGE_PRICE.equals(agreementChangePO.getChangeType()) && !AgrCommConstant.AgreementChangeType.OTHER.equals(agreementChangePO.getChangeType())) continue;
            agreementIds.add(agreementChangePO.getAgreementId());
        }
        if (agreementIds.size() > 0) {
            this.updateAgreementVersion(busiReqBO.getSupplierId(), agreementIds);
        }
        try {
            Set<Long> set = this.updateLog(agreementChangePOs, busiReqBO.getSupplierId());
        }
        catch (Exception e) {
            throw new com.tydic.uac.exception.BusinessException("0101", "\u4fee\u6539\u534f\u8bae\u7248\u672c\u5f02\u5e38\uff01\uff01" + e);
        }
        return rspBO;
    }

    private List<AgreementChangePO> validAgreementChangeInfo(AgrAgreementChangeApplyApprovalBusiReqBO busiReqBO) {
        AgreementChangePO agreementChangePO = new AgreementChangePO();
        agreementChangePO.setSupplierId(busiReqBO.getSupplierId());
        agreementChangePO.setChangeIds(busiReqBO.getChangeIds());
        List<AgreementChangePO> agreementChangePOs = this.agreementChangeMapper.getList(agreementChangePO);
        if (CollectionUtils.isEmpty(agreementChangePOs)) {
            throw new com.tydic.uac.exception.BusinessException("22001", "\u53d8\u66f4\u7533\u8bf7\u4e0d\u5b58\u5728");
        }
        return agreementChangePOs;
    }

    private Map<Long, Byte> validAgreementInfo(List<AgreementChangePO> agreementChangePOs, Long supplierId) {
        HashMap<Long, Byte> result = new HashMap<Long, Byte>();
        HashSet<Long> agreementIds = new HashSet<Long>();
        for (AgreementChangePO po : agreementChangePOs) {
            agreementIds.add(po.getAgreementId());
        }
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setSupplierId(supplierId);
        agreementPO.setAgreementIds(new ArrayList<Long>(agreementIds));
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementPO> list = this.agreementMapper.checkByCondition(agreementPO);
        if (CollectionUtils.isEmpty(list)) {
            throw new BusinessException("22001", "\u534f\u8bae\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        for (AgreementPO agreementPO1 : list) {
            result.put(agreementPO1.getAgreementId(), agreementPO1.getAgreementStatus());
        }
        if (agreementIds.size() != result.keySet().size()) {
            agreementIds.removeAll(result.keySet());
            throw new BusinessException("22006", "\u534f\u8bae\u4fe1\u606f\u3010" + agreementIds + "\u3011\u4e0d\u5b58\u5728");
        }
        return result;
    }

    private Set<Long> updateAgreement(Map<Long, Byte> map, List<AgreementChangePO> agreementChangePOs, Long supplierId, Long sysTenantId) {
        HashSet<Long> stopAgreementIds = new HashSet<Long>();
        HashSet<Long> startAgreementIds = new HashSet<Long>();
        HashSet<Long> terminationAgreementIds = new HashSet<Long>();
        HashSet<Long> changeAgreementIds = new HashSet<Long>();
        HashSet<Long> delayAgreementIds = new HashSet<Long>();
        HashSet<AgreementChangePO> delayAgreementChangePOs = new HashSet<AgreementChangePO>();
        HashSet<Long> majorChangIds = new HashSet<Long>();
        HashSet<Long> stockChangIds = new HashSet<Long>();
        HashSet<Long> skuChangIds = new HashSet<Long>();
        block10: for (AgreementChangePO agreementChangePO : agreementChangePOs) {
            switch (agreementChangePO.getChangeType()) {
                case 1: {
                    stopAgreementIds.add(agreementChangePO.getAgreementId());
                    continue block10;
                }
                case 2: {
                    startAgreementIds.add(agreementChangePO.getAgreementId());
                    continue block10;
                }
                case 3: {
                    terminationAgreementIds.add(agreementChangePO.getAgreementId());
                    continue block10;
                }
                case 4: {
                    changeAgreementIds.add(agreementChangePO.getAgreementId());
                    skuChangIds.add(agreementChangePO.getChangeId());
                    continue block10;
                }
                case 5: {
                    delayAgreementIds.add(agreementChangePO.getAgreementId());
                    delayAgreementChangePOs.add(agreementChangePO);
                    continue block10;
                }
                case 6: {
                    skuChangIds.add(agreementChangePO.getChangeId());
                    continue block10;
                }
                case 7: {
                    majorChangIds.add(agreementChangePO.getChangeId());
                    skuChangIds.add(agreementChangePO.getChangeId());
                    continue block10;
                }
                case 8: {
                    stockChangIds.add(agreementChangePO.getAgreementId());
                    skuChangIds.add(agreementChangePO.getChangeId());
                    continue block10;
                }
            }
            throw new BusinessException("0002", "\u53d8\u66f4\u7c7b\u578b\u3010" + agreementChangePO.getChangeType() + "\u3011\u4e0d\u652f\u6301");
        }
        if (!CollectionUtils.isEmpty(stopAgreementIds)) {
            HashSet<Long> startToSuspend = new HashSet<Long>();
            for (Long agreementId : stopAgreementIds) {
                if (!map.get(agreementId).equals(AgrCommConstant.AgreementStatus.ENABLE)) continue;
                startToSuspend.add(agreementId);
                stopAgreementIds.remove(agreementId);
            }
            if (!CollectionUtils.isEmpty(stopAgreementIds)) {
                log.info("\u6279\u91cf\u96c6\u5408:stopAgreementIds={}", stopAgreementIds);
                this.invokeAgreementStatusChange(supplierId, stopAgreementIds, AgrCommConstant.AgreementStatus.FROZEN, AgrCommConstant.AgreementStatus.SUSPEND);
            }
            if (!CollectionUtils.isEmpty(startToSuspend)) {
                this.invokeAgreementStatusChange(supplierId, startToSuspend, AgrCommConstant.AgreementStatus.ENABLE, AgrCommConstant.AgreementStatus.SUSPEND);
            }
        }
        if (!CollectionUtils.isEmpty(startAgreementIds)) {
            HashSet<Long> frozenToStart = new HashSet<Long>();
            for (Long agreementId : startAgreementIds) {
                if (!map.get(agreementId).equals(AgrCommConstant.AgreementStatus.FROZEN)) continue;
                frozenToStart.add(agreementId);
                startAgreementIds.remove(agreementId);
            }
            if (!CollectionUtils.isEmpty(frozenToStart)) {
                this.invokeAgreementStatusChange(supplierId, frozenToStart, AgrCommConstant.AgreementStatus.FROZEN, AgrCommConstant.AgreementStatus.ENABLE);
            }
            if (!CollectionUtils.isEmpty(startAgreementIds)) {
                this.invokeAgreementStatusChange(supplierId, startAgreementIds, AgrCommConstant.AgreementStatus.SUSPEND, AgrCommConstant.AgreementStatus.ENABLE);
            }
        }
        if (!CollectionUtils.isEmpty(terminationAgreementIds)) {
            HashSet<Long> startToTermination = new HashSet<Long>();
            for (Long agreementId : terminationAgreementIds) {
                if (!map.get(agreementId).equals(AgrCommConstant.AgreementStatus.ENABLE)) continue;
                startToTermination.add(agreementId);
                terminationAgreementIds.remove(agreementId);
            }
            if (!CollectionUtils.isEmpty(startToTermination)) {
                this.invokeAgreementStatusChange(supplierId, startToTermination, AgrCommConstant.AgreementStatus.ENABLE, AgrCommConstant.AgreementStatus.TERMINATION);
            }
            if (!CollectionUtils.isEmpty(terminationAgreementIds)) {
                this.invokeAgreementStatusChange(supplierId, terminationAgreementIds, AgrCommConstant.AgreementStatus.FROZEN, AgrCommConstant.AgreementStatus.TERMINATION);
            }
        }
        if (!CollectionUtils.isEmpty(delayAgreementIds)) {
            log.info("\u5ef6\u671f\u53d8\u66f4\u53c2\u6570:{},map:{}", delayAgreementIds, map);
            for (Long l : delayAgreementIds) {
                if (map.get(l).equals(AgrCommConstant.AgreementStatus.BE_OVERDUE)) continue;
                delayAgreementIds.remove(l);
            }
            this.invokeAgreementStatusChange(supplierId, delayAgreementIds, AgrCommConstant.AgreementStatus.BE_OVERDUE, AgrCommConstant.AgreementStatus.ENABLE);
            this.dealDelayChange(delayAgreementChangePOs);
        }
        if (!CollectionUtils.isEmpty(majorChangIds)) {
            this.dealMajorChang(supplierId, majorChangIds, sysTenantId);
        }
        return skuChangIds;
    }

    private void updateAgreementSku(Long supplierId, Set<Long> changIds) {
        Object atomRspBO;
        AgrskuChangePriceBO bo;
        ArrayList<AgreementSkuPO> addAgreementSkuPOList = new ArrayList<AgreementSkuPO>();
        ArrayList<AgreementSkuPO> updateAgreementSkuPOList = new ArrayList<AgreementSkuPO>();
        ArrayList<AgreementSkuPO> deleteAgreementSkuPOList = new ArrayList<AgreementSkuPO>();
        ArrayList<AgreementSkuPO> updateDetailAgreementSkuPOList = new ArrayList<AgreementSkuPO>();
        this.dealSkuChang(supplierId, changIds, addAgreementSkuPOList, updateAgreementSkuPOList, deleteAgreementSkuPOList, updateDetailAgreementSkuPOList);
        if (!CollectionUtils.isEmpty(addAgreementSkuPOList)) {
            ArrayList<AgreementSkuPO> list = new ArrayList<AgreementSkuPO>();
            for (AgreementSkuPO agreementSkuPO : addAgreementSkuPOList) {
                AgreementSkuPO addAgreementSkuPO = new AgreementSkuPO();
                BeanUtils.copyProperties((Object)agreementSkuPO, (Object)addAgreementSkuPO);
                if (agreementSkuPO.getAgreementSkuId() == null) {
                    addAgreementSkuPO.setAgreementSkuId(Sequence.getInstance().nextId());
                }
                list.add(addAgreementSkuPO);
            }
            int count = this.agreementSkuMapper.insertBatch(list);
            if (count != list.size()) {
                throw new BusinessException("22005", "\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25");
            }
        }
        if (!CollectionUtils.isEmpty(updateAgreementSkuPOList)) {
            ArrayList<AgrskuChangePriceBO> skuChangePriceBOs = new ArrayList<AgrskuChangePriceBO>();
            for (AgreementSkuPO agreementSkuPO : updateAgreementSkuPOList) {
                AgreementSkuPO updateAgreementSkuPO = new AgreementSkuPO();
                BeanUtils.copyProperties((Object)agreementSkuPO, (Object)updateAgreementSkuPO);
                bo = new AgrskuChangePriceBO();
                if (StringUtils.hasText((String)agreementSkuPO.getExtField1()) && StringUtils.hasText((String)agreementSkuPO.getExtField2())) {
                    updateAgreementSkuPO.setBuyNumber(agreementSkuPO.getBuyNumber().add(new BigDecimal(agreementSkuPO.getExtField1()).subtract(new BigDecimal(agreementSkuPO.getExtField2()))));
                    bo.setBuyNumber(new BigDecimal(agreementSkuPO.getExtField1()).subtract(new BigDecimal(agreementSkuPO.getExtField2())));
                }
                updateAgreementSkuPO.setExtField1(null);
                updateAgreementSkuPO.setExtField2(null);
                updateAgreementSkuPO.setExtField3(null);
                int count = this.agreementSkuMapper.updateBy(updateAgreementSkuPO);
                if (count < 1) {
                    throw new BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25");
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)agreementSkuPO.getExtField6())) {
                    bo.setExtField6(null);
                } else {
                    bo.setExtField6(agreementSkuPO.getExtField6());
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)agreementSkuPO.getExtField7())) {
                    bo.setExtField7(null);
                } else {
                    bo.setExtField7(agreementSkuPO.getExtField7());
                }
                bo.setAgreementId(agreementSkuPO.getAgreementId());
                bo.setAgreementSkuId(agreementSkuPO.getAgreementSkuId());
                bo.setBuyPrice(agreementSkuPO.getBuyPrice());
                bo.setSalePrice(agreementSkuPO.getSalePrice());
                log.info("111111");
                if (null != agreementSkuPO.getSupplyCycle()) {
                    log.info("222222");
                    bo.setSupplyCycle(agreementSkuPO.getSupplyCycle().toString());
                }
                skuChangePriceBOs.add(bo);
            }
            AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
            atomReqBO.setSkuChangePriceBOs(skuChangePriceBOs);
            atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespCode());
            }
        }
        if (!CollectionUtils.isEmpty(deleteAgreementSkuPOList)) {
            ArrayList<Long> agreementSkuIds = new ArrayList<Long>();
            HashSet<Long> agreementIds = new HashSet<Long>();
            for (AgreementSkuPO agreementSkuPO : deleteAgreementSkuPOList) {
                agreementSkuIds.add(agreementSkuPO.getAgreementSkuId());
                agreementIds.add(agreementSkuPO.getAgreementId());
            }
            AgreementSkuPO agreementSkuPO1 = new AgreementSkuPO();
            agreementSkuPO1.setSupplierId(supplierId);
            agreementSkuPO1.setAgreementSkuIds(agreementSkuIds);
            agreementSkuPO1.setAgreementIds(agreementIds);
            int count = this.agreementSkuMapper.deleteBy(agreementSkuPO1);
            if (count != agreementSkuIds.size()) {
                throw new BusinessException("22005", "\u5220\u9664\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25");
            }
            AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
            atomReqBO.setSkuStatus(AgrCommConstant.CommiditySkuStatus.INVALID);
            atomReqBO.setAgreementSkuIds(new HashSet<Long>(agreementSkuIds));
            AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO2 = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
            if (!"0000".equals(atomRspBO2.getRespCode())) {
                throw new BusinessException(atomRspBO2.getRespCode(), atomRspBO2.getRespCode());
            }
        }
        if (!CollectionUtils.isEmpty(updateDetailAgreementSkuPOList)) {
            ArrayList<AgrskuChangeDetailBO> skuChangeDetailBOs = new ArrayList<AgrskuChangeDetailBO>();
            for (AgreementSkuPO agreementSkuPO : updateDetailAgreementSkuPOList) {
                AgreementSkuPO updateAgreementSkuPO = new AgreementSkuPO();
                BeanUtils.copyProperties((Object)agreementSkuPO, (Object)updateAgreementSkuPO);
                bo = new AgrskuChangeDetailBO();
                if (StringUtils.hasText((String)agreementSkuPO.getExtField1()) && StringUtils.hasText((String)agreementSkuPO.getExtField2())) {
                    updateAgreementSkuPO.setBuyNumber(agreementSkuPO.getBuyNumber().add(new BigDecimal(agreementSkuPO.getExtField1()).subtract(new BigDecimal(agreementSkuPO.getExtField2()))));
                    bo.setBuyNumber(new BigDecimal(agreementSkuPO.getExtField1()).subtract(new BigDecimal(agreementSkuPO.getExtField2())));
                }
                updateAgreementSkuPO.setExtField1(null);
                updateAgreementSkuPO.setExtField2(null);
                updateAgreementSkuPO.setExtField3(null);
                int count = this.agreementSkuMapper.updateBy(updateAgreementSkuPO);
                if (count < 1) {
                    throw new BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25");
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)agreementSkuPO.getExtField6())) {
                    bo.setExtField6(null);
                } else {
                    bo.setExtField6(agreementSkuPO.getExtField6());
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)agreementSkuPO.getExtField7())) {
                    bo.setExtField7(null);
                } else {
                    bo.setExtField7(agreementSkuPO.getExtField7());
                }
                bo.setAgreementId(agreementSkuPO.getAgreementId());
                bo.setAgreementSkuId(agreementSkuPO.getAgreementSkuId());
                bo.setBuyPrice(agreementSkuPO.getBuyPrice());
                bo.setSalePrice(agreementSkuPO.getSalePrice());
                log.info("111111");
                if (null != agreementSkuPO.getSupplyCycle()) {
                    log.info("222222");
                    bo.setSupplyCycle(agreementSkuPO.getSupplyCycle().toString());
                }
                bo.setCommodityTypeId(agreementSkuPO.getCommodityTypeId());
                bo.setCommodityTypeName(agreementSkuPO.getCommodityTypeName());
                bo.setVendorMaterialCode(agreementSkuPO.getVendorMaterialCode());
                bo.setVendorMaterialName(agreementSkuPO.getVendorMaterialName());
                bo.setEbsMaterialCode(agreementSkuPO.getEbsMaterialCode());
                bo.setModel(agreementSkuPO.getModel());
                bo.setSpec(agreementSkuPO.getSpec());
                bo.setBrandId(agreementSkuPO.getBrandId());
                bo.setBrandName(agreementSkuPO.getBrandName());
                bo.setMeasureId(agreementSkuPO.getMeasureId());
                bo.setMeasureName(agreementSkuPO.getMeasureName());
                bo.setTaxCatalog(agreementSkuPO.getTaxCatalog());
                bo.setMaterialId(agreementSkuPO.getMaterialId());
                bo.setMaterialName(agreementSkuPO.getMaterialName());
                bo.setTaxRate(agreementSkuPO.getTaxRate());
                skuChangeDetailBOs.add((AgrskuChangeDetailBO)bo);
            }
            AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
            atomReqBO.setAgrskuChangeDetailBOS(skuChangeDetailBOs);
            atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespCode());
            }
        }
    }

    private void updateAgreementVersion(Long supplierId, Set<Long> agreementIdSet) {
        int count = this.agreementMapper.updateAgreementVersion(supplierId, agreementIdSet);
        if (count != agreementIdSet.size()) {
            throw new BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u8868\u7248\u672c\u53f7\u5931\u8d25");
        }
        this.agreementScopeMapper.updateAgreementVersion(supplierId, agreementIdSet);
        this.agreementSkuMapper.updateAgreementVersion(supplierId, agreementIdSet);
        this.agreementAttachMapper.updateAgreementVersion(supplierId, agreementIdSet);
    }

    private Byte updateAgreementChangeMapper(AgrAgreementChangeApplyApprovalBusiReqBO busiReqBO, Set<Long> agreementIds) {
        AgreementChangePO agreementChangePO = new AgreementChangePO();
        agreementChangePO.setChangeIds(busiReqBO.getChangeIds());
        agreementChangePO.setSupplierId(busiReqBO.getSupplierId());
        agreementChangePO.setStatus(AgrCommConstant.ChangeApplyStatus.PASS);
        int count = this.agreementChangeMapper.updateBy(agreementChangePO);
        if (count != busiReqBO.getChangeIds().size()) {
            throw new BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u53d8\u66f4\u8868\u72b6\u6001\u5931\u8d25");
        }
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setAgreementIds(new ArrayList<Long>(agreementIds));
        agreementPO.setMaterialNameSum("");
        agreementPO.setAuditAdvice(busiReqBO.getAuditAdvice());
        agreementPO.setAuditResult(busiReqBO.getAuditResult());
        agreementPO.setConfirmationTime(new Date());
        int count1 = this.agreementMapper.updateByCondition(agreementPO);
        if (count1 != agreementIds.size()) {
            throw new BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u8868extField1\u5931\u8d25");
        }
        return agreementChangePO.getStatus();
    }

    private void invokeAgreementStatusChange(Long supplierId, Set<Long> agreementIds, Byte preStatus, Byte posStatus) {
        log.info("\u6279\u91cf\u96c6\u5408:agreementIds={}", agreementIds);
        if (!CollectionUtils.isEmpty(agreementIds)) {
            AgrAgreementStatusChangeAtomReqBO atomReqBO = new AgrAgreementStatusChangeAtomReqBO();
            atomReqBO.setSupplierId(supplierId);
            atomReqBO.setAgreementIds(agreementIds);
            atomReqBO.setAgreementStatusPre(preStatus);
            atomReqBO.setAgreementStatusPost(posStatus);
            AgrAgreementStatusChangeAtomRspBO atomRspBO = this.agrAgreementStatusChangeAtomService.updateAgreementStatus(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
            }
        }
    }

    private void dealDelayChange(Set<AgreementChangePO> delayAgreementChangePOs) {
        if (!CollectionUtils.isEmpty(delayAgreementChangePOs)) {
            for (AgreementChangePO po : delayAgreementChangePOs) {
                AgreementPO agreementPO = new AgreementPO();
                agreementPO.setSupplierId(po.getSupplierId());
                agreementPO.setAgreementId(po.getAgreementId());
                agreementPO.setExpDate(po.getPostInvalidDate());
                int count = this.agreementMapper.updateByCondition(agreementPO);
                if (count == 1) continue;
                throw new BusinessException("22005", "\u66f4\u65b0\u534f\u8bae\u8868\u534f\u8bae\u3010" + po.getAgreementId() + "\u3011\u5230\u671f\u65f6\u95f4\u5931\u8d25");
            }
        }
    }

    private void dealMajorChang(Long supplierId, Set<Long> changIds, Long sysTenantId) {
        AgreementMajorChangePO agreementMajorChangePO = new AgreementMajorChangePO();
        agreementMajorChangePO.setSupplierId(supplierId);
        agreementMajorChangePO.setChangeIds(changIds);
        agreementMajorChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementMajorChangePO> list = this.agreementMajorChangeMapper.getList(agreementMajorChangePO);
        if (!CollectionUtils.isEmpty(list)) {
            for (AgreementMajorChangePO agreementMajorChangePO1 : list) {
                AgreementPO agreementPO2 = new AgreementPO();
                agreementPO2.setAgreementId(agreementMajorChangePO1.getAgreementId());
                AgreementPO agreementPO1 = this.agreementMapper.getModelBy(agreementPO2);
                AgreementPO agreementPO = new AgreementPO();
                BeanUtils.copyProperties((Object)agreementMajorChangePO1, (Object)agreementPO);
                agreementPO.setAdjustPriceFormulaValue(ObjectUtils.isEmpty((Object)agreementMajorChangePO1.getPriceAdjustmentFormula()) ? "" : agreementMajorChangePO1.getPriceAdjustmentFormula());
                agreementPO.setPriceAdjustmentBasis(ObjectUtils.isEmpty((Object)agreementMajorChangePO1.getPriceAdjustmentBasis()) ? "" : agreementMajorChangePO1.getPriceAdjustmentBasis());
                int count = this.agreementMapper.updateByMajorChange(agreementPO);
                if (count != 1) {
                    throw new BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u8868\u5931\u8d25");
                }
                ArrayList<AgrAdjustPriceBO> agrAdjustPriceBOS = new ArrayList<AgrAdjustPriceBO>();
                if (AgrCommConstant.AdjustPrice.PRICE_ADJUSTMENT_BEFOREHAND == agreementMajorChangePO1.getAdjustPrice() && agreementMajorChangePO1.getAdjustPrice() != agreementPO1.getAdjustPrice()) {
                    AgrAdjustPriceBO agrAdjustPriceBO = new AgrAdjustPriceBO();
                    agrAdjustPriceBO.setAdjustPrice(Byte.valueOf((byte)1));
                    agrAdjustPriceBO.setAgreementId(agreementMajorChangePO1.getAgreementId());
                    agrAdjustPriceBOS.add(agrAdjustPriceBO);
                }
                if (!CollectionUtils.isEmpty(agrAdjustPriceBOS)) {
                    AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
                    atomReqBO.setAgrAdjustPriceBOS(agrAdjustPriceBOS);
                    AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
                    if (!"0000".equals(atomRspBO.getRespCode())) {
                        throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespCode());
                    }
                }
                AgreementSettlementPO queryPO = new AgreementSettlementPO();
                queryPO.setChangeId(agreementMajorChangePO1.getChangeId());
                List<AgreementSettlementPO> agreementSettlementPOList = this.agreementSettlementMapper.getList(queryPO);
                AgreementSettlementPO deletePO = new AgreementSettlementPO();
                deletePO.setAgreementId(agreementMajorChangePO1.getAgreementId());
                this.agreementSettlementMapper.deleteBy(deletePO);
                if (CollectionUtils.isEmpty(agreementSettlementPOList)) continue;
                ArrayList<AgreementSettlementPO> poList = new ArrayList<AgreementSettlementPO>();
                for (AgreementSettlementPO po : agreementSettlementPOList) {
                    AgreementSettlementPO agreementSettlementPO = new AgreementSettlementPO();
                    BeanUtils.copyProperties((Object)po, (Object)agreementSettlementPO);
                    Long settlementId = Sequence.getInstance().nextId();
                    agreementSettlementPO.setSettlementId(settlementId);
                    agreementSettlementPO.setChangeId(null);
                    agreementSettlementPO.setAgreementId(agreementMajorChangePO1.getAgreementId());
                    agreementSettlementPO.setSettlementId(settlementId);
                    poList.add(agreementSettlementPO);
                }
                this.agreementSettlementMapper.insertBatch(poList);
            }
        }
        List<AgrScopeSyncBO> agrScopeSyncBOSet = this.updateAgreementScope(changIds, supplierId);
        AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
        atomReqBO.setAgrScopeSyncBOs(agrScopeSyncBOSet);
        AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespCode());
        }
        this.updateAgreementAttach(changIds, supplierId, sysTenantId);
    }

    private List<AgrScopeSyncBO> updateAgreementScope(Set<Long> changIds, Long supplierId) {
        Object agreementScopePO;
        AgreementScopeChangePO agreementScopeChangePO = new AgreementScopeChangePO();
        agreementScopeChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        agreementScopeChangePO.setSupplierId(supplierId);
        agreementScopeChangePO.setChangeIds(changIds);
        List<AgreementScopeChangePO> agreementScopeChangeList = this.agreementScopeChangeMapper.getList(agreementScopeChangePO);
        ArrayList<AgreementScopePO> addAgreementScopePOList = new ArrayList<AgreementScopePO>();
        ArrayList<AgrScopeSyncBO> agrScopeSyncBOS = new ArrayList<AgrScopeSyncBO>();
        if (!CollectionUtils.isEmpty(agreementScopeChangeList)) {
            for (AgreementScopeChangePO agreementScopeChangePO1 : agreementScopeChangeList) {
                agreementScopePO = new AgreementScopePO();
                BeanUtils.copyProperties((Object)agreementScopeChangePO1, (Object)agreementScopePO);
                addAgreementScopePOList.add((AgreementScopePO)agreementScopePO);
                AgrScopeSyncBO agrScopeSyncBO = new AgrScopeSyncBO();
                agrScopeSyncBO.setAgreementId(agreementScopeChangePO1.getAgreementId());
                agrScopeSyncBO.setScopeType(agreementScopeChangePO1.getScopeType());
                agrScopeSyncBO.setScopeCode(agreementScopeChangePO1.getScopeCode().toString());
                if (agreementScopeChangePO1.getScopeType() == 9) {
                    agrScopeSyncBO.setIncludeSubOrg(agreementScopeChangePO1.getIncludeSubOrg());
                    agrScopeSyncBO.setScopeTreePath(agreementScopeChangePO1.getScopeTreePath());
                }
                agrScopeSyncBOS.add(agrScopeSyncBO);
            }
        }
        HashMap syncMap = new HashMap();
        if (!CollectionUtils.isEmpty(addAgreementScopePOList)) {
            HashSet<Long> agreementIds = new HashSet<Long>();
            for (AgreementScopePO po : addAgreementScopePOList) {
                List<AgreementScopePO> scopeCodes;
                agreementIds.add(po.getAgreementId());
                if (syncMap.get(po.getAgreementId()) != null) {
                    scopeCodes = (List)syncMap.get(po.getAgreementId());
                    scopeCodes.add(po);
                    syncMap.put(po.getAgreementId(), scopeCodes);
                    continue;
                }
                scopeCodes = new ArrayList<AgreementScopePO>();
                scopeCodes.add(po);
                syncMap.put(po.getAgreementId(), scopeCodes);
            }
            log.info("AgreementScopePO:" + JSON.toJSONString(agrScopeSyncBOS));
            agreementScopePO = new AgreementScopePO();
            ((AgreementScopePO)agreementScopePO).setAgreementIds(agreementIds);
            ((AgreementScopePO)agreementScopePO).setSupplierId(supplierId);
            this.agreementScopeMapper.deleteBy((AgreementScopePO)agreementScopePO);
            int count2 = this.agreementScopeMapper.insertBatch(addAgreementScopePOList);
            if (count2 < addAgreementScopePOList.size()) {
                throw new BusinessException("22005", "\u65b0\u589e\u534f\u8bae\u8303\u56f4\u8868\u5931\u8d25");
            }
        }
        return agrScopeSyncBOS;
    }

    private void updateAgreementAttach(Set<Long> changIds, Long supplierId, Long sysTenantId) {
        AgrAgreementAttachChangePO agrAgreementAttachChangePO = new AgrAgreementAttachChangePO();
        agrAgreementAttachChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        agrAgreementAttachChangePO.setSupplierId(supplierId);
        agrAgreementAttachChangePO.setChangeIds(changIds);
        agrAgreementAttachChangePO.setSysTenantId(sysTenantId);
        List<AgrAgreementAttachChangePO> agrAgreementAttachChangePOList = this.agrAgreementAttachChangeMapper.getList(agrAgreementAttachChangePO);
        ArrayList<AgreementAttachPO> addAgreementAttachPOList = new ArrayList<AgreementAttachPO>();
        if (!CollectionUtils.isEmpty(agrAgreementAttachChangePOList)) {
            for (AgrAgreementAttachChangePO agrAgreementAttachChangePO2 : agrAgreementAttachChangePOList) {
                AgreementAttachPO agreementAttachPO = new AgreementAttachPO();
                BeanUtils.copyProperties((Object)agrAgreementAttachChangePO2, (Object)agreementAttachPO);
                addAgreementAttachPOList.add(agreementAttachPO);
            }
        }
        if (!CollectionUtils.isEmpty(addAgreementAttachPOList)) {
            HashSet<Long> agreementIds = new HashSet<Long>();
            for (AgreementAttachPO po : addAgreementAttachPOList) {
                agreementIds.add(po.getAgreementId());
            }
            AgreementAttachPO agreementAttachPO = new AgreementAttachPO();
            agreementAttachPO.setAgreementIds(agreementIds);
            agreementAttachPO.setSupplierId(supplierId);
            this.agreementAttachMapper.deleteBy(agreementAttachPO);
            int count2 = this.agreementAttachMapper.insertBatch(addAgreementAttachPOList);
            if (count2 < addAgreementAttachPOList.size()) {
                throw new BusinessException("22005", "\u65b0\u589e\u534f\u8bae\u9644\u4ef6\u8868\u5931\u8d25");
            }
        }
    }

    private void dealSkuChang(Long supplierId, Set<Long> changIds, List<AgreementSkuPO> addAgreementSkuPOList, List<AgreementSkuPO> updateAgreementSkuPOList, List<AgreementSkuPO> deleteAgreementSkuPOList, List<AgreementSkuPO> updateDetailAgreementSkuPOList) {
        AgreementSkuChangePO agreementSkuChangePO = new AgreementSkuChangePO();
        agreementSkuChangePO.setSupplierId(supplierId);
        agreementSkuChangePO.setChangeIds(changIds);
        agreementSkuChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementSkuChangePO> list = this.agreementSkuChangeMapper.getList(agreementSkuChangePO);
        if (!CollectionUtils.isEmpty(list)) {
            for (AgreementSkuChangePO agreementSkuChangePO1 : list) {
                AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
                if (AgrCommConstant.AgreementSkuChangeType.ADD.equals(agreementSkuChangePO1.getChangeType())) {
                    BeanUtils.copyProperties((Object)agreementSkuChangePO1, (Object)agreementSkuPO);
                    agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                    addAgreementSkuPOList.add(agreementSkuPO);
                    continue;
                }
                if (AgrCommConstant.AgreementSkuChangeType.UPDATE.equals(agreementSkuChangePO1.getChangeType())) {
                    if (!StringUtils.isEmpty((Object)agreementSkuChangePO1.getExtField7()) && "4".equals(agreementSkuChangePO1.getExtField7())) {
                        agreementSkuPO.setAgreementSkuId(agreementSkuChangePO1.getAgreementSkuId());
                        agreementSkuPO.setCommodityTypeName(agreementSkuChangePO1.getCommodityTypeName());
                        agreementSkuPO.setCommodityTypeId(agreementSkuChangePO1.getCommodityTypeId());
                        agreementSkuPO.setVendorMaterialCode(agreementSkuChangePO1.getVendorMaterialCode());
                        agreementSkuPO.setVendorMaterialName(agreementSkuChangePO1.getVendorMaterialName());
                        agreementSkuPO.setEbsMaterialCode(agreementSkuChangePO1.getEbsMaterialCode());
                        agreementSkuPO.setSpec(agreementSkuChangePO1.getSpec());
                        agreementSkuPO.setModel(agreementSkuChangePO1.getModel());
                        agreementSkuPO.setBrandId(agreementSkuChangePO1.getBrandId());
                        agreementSkuPO.setBrandName(agreementSkuChangePO1.getBrandName());
                        agreementSkuPO.setMeasureId(agreementSkuChangePO1.getMeasureId());
                        agreementSkuPO.setMeasureName(agreementSkuChangePO1.getMeasureName());
                        agreementSkuPO.setTaxCatalog(agreementSkuChangePO1.getTaxCatalog());
                        agreementSkuPO.setTaxRate(agreementSkuChangePO1.getTaxRate());
                        agreementSkuPO.setSupplyCycle(agreementSkuChangePO1.getSupplyCycle());
                        agreementSkuPO.setBuyNumber(agreementSkuChangePO1.getBuyNumber());
                        agreementSkuPO.setBuyPrice(agreementSkuChangePO1.getBuyPrice());
                        agreementSkuPO.setBuyPriceSum(agreementSkuChangePO1.getBuyPriceSum());
                        agreementSkuPO.setSalePrice(agreementSkuChangePO1.getSalePrice());
                        agreementSkuPO.setSalePriceSum(agreementSkuChangePO1.getSalePriceSum());
                        agreementSkuPO.setXcCategory(agreementSkuChangePO1.getXcCategory());
                        agreementSkuPO.setXcSku(agreementSkuChangePO1.getXcSku());
                        agreementSkuPO.setExtField6(agreementSkuChangePO1.getExtField6());
                        agreementSkuPO.setExtField7(agreementSkuChangePO1.getExtField7());
                        updateDetailAgreementSkuPOList.add(agreementSkuPO);
                        continue;
                    }
                    agreementSkuPO.setAgreementSkuId(agreementSkuChangePO1.getAgreementSkuId());
                    agreementSkuPO.setBuyPrice(agreementSkuChangePO1.getBuyPrice());
                    agreementSkuPO.setBuyPriceSum(agreementSkuChangePO1.getBuyPriceSum());
                    agreementSkuPO.setSalePrice(agreementSkuChangePO1.getSalePrice());
                    agreementSkuPO.setSalePriceSum(agreementSkuChangePO1.getSalePriceSum());
                    agreementSkuPO.setMarkupRate(agreementSkuChangePO1.getMarkupRate());
                    agreementSkuPO.setUpdateLoginId(agreementSkuChangePO1.getCreateLoginId());
                    agreementSkuPO.setUpdateName(agreementSkuChangePO1.getCreateName());
                    agreementSkuPO.setAgreementId(agreementSkuChangePO1.getAgreementId());
                    agreementSkuPO.setBuyNumber(agreementSkuChangePO1.getBuyNumber());
                    agreementSkuPO.setExtField1(agreementSkuChangePO1.getExtField1());
                    agreementSkuPO.setExtField2(agreementSkuChangePO1.getExtField2());
                    agreementSkuPO.setExtField6(agreementSkuChangePO1.getExtField6());
                    agreementSkuPO.setExtField7(agreementSkuChangePO1.getExtField7());
                    agreementSkuPO.setCommodityTypeName(agreementSkuChangePO1.getCommodityTypeName());
                    agreementSkuPO.setCommodityTypeId(agreementSkuChangePO1.getCommodityTypeId());
                    agreementSkuPO.setSupplyCycle(agreementSkuChangePO1.getSupplyCycle());
                    updateAgreementSkuPOList.add(agreementSkuPO);
                    continue;
                }
                if (!AgrCommConstant.AgreementSkuChangeType.DELETE.equals(agreementSkuChangePO1.getChangeType())) continue;
                agreementSkuPO.setAgreementSkuId(agreementSkuChangePO1.getAgreementSkuId());
                agreementSkuPO.setUpdateLoginId(agreementSkuChangePO1.getCreateLoginId());
                agreementSkuPO.setUpdateTime(agreementSkuChangePO1.getCreateTime());
                agreementSkuPO.setUpdateName(agreementSkuChangePO1.getCreateName());
                agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.DELETED);
                agreementSkuPO.setAgreementId(agreementSkuChangePO1.getAgreementId());
                deleteAgreementSkuPOList.add(agreementSkuPO);
            }
        }
    }

    private Set<Long> updateLog(List<AgreementChangePO> agreementChangePOs, Long supplierId) {
        HashSet<Long> agreementIds = new HashSet<Long>();
        this.updateAgreementLog(agreementChangePOs, supplierId);
        return agreementIds;
    }

    private void updateAgreementLog(List<AgreementChangePO> agreementChangePOs, Long supplierId) {
        ArrayList<AgreementChangePO> agreementChangePOSet = new ArrayList<AgreementChangePO>();
        for (AgreementChangePO agreementChangePO : agreementChangePOs) {
            List agreementIds = agreementChangePOSet.stream().map(AgreementChangePO::getAgreementId).collect(Collectors.toList());
            if (agreementIds.contains(agreementChangePO.getAgreementId())) continue;
            agreementChangePOSet.add(agreementChangePO);
        }
        log.info("==============\u53bb\u91cd\u540e\u7684\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f\uff1a" + agreementChangePOSet);
        HashSet<Long> agreementIds = new HashSet<Long>();
        for (AgreementChangePO agreementChangePO : agreementChangePOSet) {
            agreementIds.add(agreementChangePO.getAgreementId());
            AgreementPO agreementPO = new AgreementPO();
            agreementPO.setAgreementId(agreementChangePO.getAgreementId());
            agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            AgreementPO ao = this.agreementMapper.getModelBy(agreementPO);
            AgreementLogPO agreementLogPO = new AgreementLogPO();
            agreementLogPO.setLogStatus("0");
            agreementLogPO.setAgreementId(agreementChangePO.getAgreementId());
            agreementLogPO.setChangeType(agreementChangePO.getChangeType());
            AgreementLogPO alo = this.agreementLogMapper.getModelBy(agreementLogPO);
            log.info("\u5ba1\u6279\u4e2d\u65e5\u5fd7====================" + alo);
            if (alo == null) {
                throw new BusinessException("22003", "\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u5ba1\u6279\u4e2d\u65e5\u5fd7");
            }
            List<Byte> changeTypeList = Arrays.asList(Byte.valueOf("4"), Byte.valueOf("5"), Byte.valueOf("6"), Byte.valueOf("7"));
            if (changeTypeList.contains(agreementChangePO.getChangeType())) {
                AgreementLogPO apos = new AgreementLogPO();
                apos.setAgreementId(agreementChangePO.getAgreementId());
                apos.setLogStatus("1");
                apos.setPreLogStatus("2");
                log.info("\u539f\u59cb\u534f\u8bae-\u5931\u6548\u72b6\u6001\u4fee\u6539\u5165\u53c2:{}", (Object)apos);
                this.agreementLogMapper.updateBy(apos);
            }
            AgreementLogPO al = new AgreementLogPO();
            al.setAgreementId(agreementChangePO.getAgreementId());
            al.setLogStatus("2");
            al.setPreLogStatus("0");
            al.setAgreementVersion(ao.getAgreementVersion());
            al.setPreChangeType(agreementChangePO.getChangeType());
            List<Byte> unChangeTypeList = Arrays.asList(Byte.valueOf("1"), Byte.valueOf("2"), Byte.valueOf("3"));
            if (unChangeTypeList.contains(agreementChangePO.getChangeType())) {
                al.setIsDelete(Byte.valueOf("1"));
            }
            log.info("\u751f\u6548\u72b6\u6001\u4fee\u6539\u5165\u53c2:{}", (Object)al);
            this.agreementLogMapper.updateBy(al);
            this.insertAgreementScopeLog(agreementIds, agreementChangePO.getSupplierId(), alo.getAgreementLogId());
            this.insertAgreementAttachLog(agreementIds, agreementChangePO.getSupplierId(), alo.getAgreementLogId());
            this.insertAgreementSettlementLog(agreementIds, agreementChangePO.getSupplierId(), alo.getAgreementLogId());
        }
    }

    private void insertAgreementScopeLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId) {
        int count;
        AgreementScopePO agreementScopePO = new AgreementScopePO();
        agreementScopePO.setSupplierId(supplierId);
        agreementScopePO.setAgreementIds(agreementIds);
        agreementScopePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementScopePO> agreementScopeList = this.agreementScopeMapper.getList(agreementScopePO);
        ArrayList<AgreementScopeLogPO> agreementScopeLogPOList = new ArrayList<AgreementScopeLogPO>();
        for (AgreementScopePO agreementScopePO1 : agreementScopeList) {
            AgreementScopeLogPO agreementScopeLogPO = new AgreementScopeLogPO();
            BeanUtils.copyProperties((Object)agreementScopePO1, (Object)agreementScopeLogPO);
            agreementScopeLogPO.setAgreementLogId(agreementLogId);
            agreementScopeLogPOList.add(agreementScopeLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementScopeLogPOList) && (count = this.agreementScopeLogMapper.insertBatch(agreementScopeLogPOList)) != agreementScopeLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u8303\u56f4\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementAttachLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId) {
        int count;
        AgreementAttachPO agreementAttachPO = new AgreementAttachPO();
        agreementAttachPO.setSupplierId(supplierId);
        agreementAttachPO.setAgreementIds(agreementIds);
        agreementAttachPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementAttachPO> agreementAttachList = this.agreementAttachMapper.getList(agreementAttachPO);
        ArrayList<AgrAgreementAttachLogPO> agrAgreementAttachLogPOList = new ArrayList<AgrAgreementAttachLogPO>();
        for (AgreementAttachPO agreementAttachPO1 : agreementAttachList) {
            AgrAgreementAttachLogPO agrAgreementAttachLogPO = new AgrAgreementAttachLogPO();
            BeanUtils.copyProperties((Object)agreementAttachPO1, (Object)agrAgreementAttachLogPO);
            agrAgreementAttachLogPO.setAgreementLogId(agreementLogId);
            agrAgreementAttachLogPOList.add(agrAgreementAttachLogPO);
        }
        if (!CollectionUtils.isEmpty(agrAgreementAttachLogPOList) && (count = this.agrAgreementAttachLogMapper.insertBatch(agrAgreementAttachLogPOList)) != agrAgreementAttachLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u9644\u4ef6\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementSettlementLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId) {
        int count;
        AgreementSettlementPO agreementSettlementPO = new AgreementSettlementPO();
        agreementSettlementPO.setAgreementIds(agreementIds);
        List<AgreementSettlementPO> list = this.agreementSettlementMapper.getList(agreementSettlementPO);
        ArrayList<AgreementSettlementLogPO> agreementSettlementLogPOList = new ArrayList<AgreementSettlementLogPO>();
        for (AgreementSettlementPO as : list) {
            AgreementSettlementLogPO agreementSettlementLogPO = new AgreementSettlementLogPO();
            BeanUtils.copyProperties((Object)as, (Object)agreementSettlementLogPO);
            Long settleMentLogId = Sequence.getInstance().nextId();
            agreementSettlementLogPO.setAgreementLogId(agreementLogId);
            agreementSettlementLogPO.setSettlementLogId(settleMentLogId);
            agreementSettlementLogPOList.add(agreementSettlementLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementSettlementLogPOList) && (count = this.agreementSettlementLogMapper.insertBatch(agreementSettlementLogPOList)) != agreementSettlementLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }
}

