/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementAttachBO;
import com.tydic.agreement.ability.bo.AgrAgreementScopeBO;
import com.tydic.agreement.ability.bo.AgrAgreementSupplierBO;
import com.tydic.agreement.ability.bo.AgreementSettlementBO;
import com.tydic.agreement.ability.bo.CrcAgreementScopeBO;
import com.tydic.agreement.atom.api.AgrCreateAgreementOtherAtomService;
import com.tydic.agreement.atom.api.AgrCreateAgreementSettlementAtomService;
import com.tydic.agreement.atom.bo.AgrCreateAgreementOtherAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementOtherAtomRspBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSettlementAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSettlementAtomRspBO;
import com.tydic.agreement.busi.api.CrcAddAgreementSubjectBusiService;
import com.tydic.agreement.busi.bo.CrcAddAgreementSubjectBusiReqBO;
import com.tydic.agreement.busi.bo.CrcAddAgreementSubjectBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementAttachLogMapper;
import com.tydic.agreement.dao.AgrAgreementSupplierMapper;
import com.tydic.agreement.dao.AgrPushLogMapper;
import com.tydic.agreement.dao.AgreementAttachMapper;
import com.tydic.agreement.dao.AgreementLogMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementScopeLogMapper;
import com.tydic.agreement.dao.AgreementScopeMapper;
import com.tydic.agreement.dao.AgreementSettlementLogMapper;
import com.tydic.agreement.dao.AgreementSettlementMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrAgreementAttachLogPO;
import com.tydic.agreement.po.AgrAgreementSupplierPO;
import com.tydic.agreement.po.AgrPushLogPO;
import com.tydic.agreement.po.AgreementAttachPO;
import com.tydic.agreement.po.AgreementLogPO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementScopeLogPO;
import com.tydic.agreement.po.AgreementScopePO;
import com.tydic.agreement.po.AgreementSettlementLogPO;
import com.tydic.agreement.po.AgreementSettlementPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.umc.general.ability.api.CrcQryCorporationByFmsAbilityService;
import com.tydic.umc.general.ability.api.UmcQryMemLegalOrgInfoAbilityService;
import com.tydic.umc.general.ability.bo.CrcQryCorporationByFmsAbilityReqBO;
import com.tydic.umc.general.ability.bo.CrcQryCorporationByFmsAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceReqBO;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceRspBO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CrcAddAgreementSubjectBusiServiceImpl
implements CrcAddAgreementSubjectBusiService {
    private static final Logger log = LoggerFactory.getLogger(CrcAddAgreementSubjectBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private AgrCreateAgreementSettlementAtomService agrCreateAgreementSettlementAtomService;
    @Autowired
    private AgrCreateAgreementOtherAtomService agrCreateAgreementOtherAtomService;
    @Autowired
    private AgreementLogMapper agreementLogMapper;
    @Autowired
    private AgreementAttachMapper agreementAttachMapper;
    @Autowired
    private AgreementScopeLogMapper agreementScopeLogMapper;
    @Autowired
    private AgrAgreementAttachLogMapper agrAgreementAttachLogMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private AgreementSettlementLogMapper agreementSettlementLogMapper;
    @Autowired
    private AgreementSettlementMapper agreementSettlementMapper;
    @Autowired
    private AgrPushLogMapper agrPushLogMapper;
    @Autowired
    private CrcQryCorporationByFmsAbilityService crcQryCorporationByFmsAbilityService;
    @Autowired
    private UmcQryMemLegalOrgInfoAbilityService umcQryMemLegalOrgInfoAbilityService;
    @Autowired
    private AgrAgreementSupplierMapper agrAgreementSupplierMapper;

    @Override
    public CrcAddAgreementSubjectBusiRspBO addAgreementSubject(CrcAddAgreementSubjectBusiReqBO reqBO) {
        CrcAddAgreementSubjectBusiRspBO rspBO = new CrcAddAgreementSubjectBusiRspBO();
        AgrPushLogPO agrPushLogPO = new AgrPushLogPO();
        agrPushLogPO.setId(Sequence.getInstance().nextId());
        agrPushLogPO.setSysCode(reqBO.getSysCode());
        agrPushLogPO.setPushType("1");
        agrPushLogPO.setInContent(JSONObject.toJSONString((Object)((Object)reqBO)));
        agrPushLogPO.setCreateTime(new Date());
        if (!StringUtils.isEmpty((CharSequence)reqBO.getEntAgreementCode())) {
            AgreementPO agreementPO = new AgreementPO();
            agreementPO.setEntAgreementCode(reqBO.getEntAgreementCode());
            List<AgreementPO> count = this.agreementMapper.getCount(agreementPO);
            if (!CollectionUtils.isEmpty(count)) {
                rspBO.setReturnCode("0000");
                rspBO.setReturnDesc("\u534f\u8bae\u4e3b\u4f53\u521b\u5efa\u6210\u529f\uff01");
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u534f\u8bae\u4e3b\u4f53\u521b\u5efa\u6210\u529f\uff01");
                return rspBO;
            }
        }
        this.validPlaAgreementCode(reqBO, agrPushLogPO);
        String plaAgreementCode = this.createAgreementCode();
        log.info("\u534f\u8bae\u7f16\u53f7\u4e3a:{}", (Object)plaAgreementCode);
        if (StringUtils.isBlank((CharSequence)plaAgreementCode)) {
            throw new BusinessException("8888", "\u534f\u8bae\u7f16\u53f7\u751f\u6210\u5931\u8d25\uff01");
        }
        Long agreementId = Sequence.getInstance().nextId();
        AgreementPO agreementPO = this.insertAgreement(reqBO, agreementId, agrPushLogPO, plaAgreementCode);
        this.insertAgreementSettlement(reqBO, agreementId, agrPushLogPO);
        if (!CollectionUtils.isEmpty(reqBO.getAttach()) || !CollectionUtils.isEmpty(reqBO.getScope())) {
            this.insertAgreementOther(reqBO, agreementPO, agrPushLogPO);
        }
        ArrayList<AgrAgreementSupplierBO> distribution = new ArrayList<AgrAgreementSupplierBO>();
        AgrAgreementSupplierBO agrAgreementSupplierBO = new AgrAgreementSupplierBO();
        agrAgreementSupplierBO.setAgreementId(agreementId);
        agrAgreementSupplierBO.setSupplierMode(Integer.valueOf(2));
        agrAgreementSupplierBO.setSupplierId(agreementPO.getVendorDepartmentId());
        agrAgreementSupplierBO.setSupplierName(agreementPO.getVendorDepartmentName());
        distribution.add(agrAgreementSupplierBO);
        reqBO.setDistribution(distribution);
        this.insertAgreementSupplier(reqBO);
        Long agreementLogId = Sequence.getInstance().nextId();
        try {
            AgreementLogPO agreementLogPO = new AgreementLogPO();
            BeanUtils.copyProperties((Object)agreementPO, (Object)agreementLogPO);
            agreementLogPO.setAgreementLogId(agreementLogId);
            agreementLogPO.setLogStatus("2");
            agreementLogPO.setChangeType(new Byte("99"));
            agreementLogPO.setChangeTime(new Date());
            this.agreementLogMapper.insert(agreementLogPO);
            HashSet<Long> agreementIds = new HashSet<Long>();
            agreementIds.add(agreementId);
            this.insertAgreementScopeLog(agreementIds, agreementPO.getSupplierId(), agreementLogId, agrPushLogPO);
            this.insertAgreementAttachLog(agreementIds, agreementPO.getSupplierId(), agreementLogId, agrPushLogPO);
            this.insertAgreementSettlementLog(agreementIds, agreementPO.getSupplierId(), agreementLogId, agrPushLogPO);
        }
        catch (Exception e) {
            throw new BusinessException("0101", "\u751f\u6210\u534f\u8bae\u7248\u672c\u5f02\u5e38\uff01\uff01" + e);
        }
        agrPushLogPO.setIsFinish("1");
        agrPushLogPO.setSysTenantId(305775845729763327L);
        agrPushLogPO.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
        this.agrPushLogMapper.insert(agrPushLogPO);
        rspBO.setReturnCode("0000");
        rspBO.setReturnDesc("\u534f\u8bae\u4e3b\u4f53\u521b\u5efa\u6210\u529f\uff01");
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u534f\u8bae\u4e3b\u4f53\u521b\u5efa\u6210\u529f\uff01");
        return rspBO;
    }

    private void validPlaAgreementCode(CrcAddAgreementSubjectBusiReqBO busiReqBO, AgrPushLogPO agrPushLogPO) {
        AgreementPO checkAgreementPO = new AgreementPO();
        checkAgreementPO.setEntAgreementCode(busiReqBO.getEntAgreementCode());
        AgreementPO checkAgreement = this.agreementMapper.getModelBy(checkAgreementPO);
        if (null != checkAgreement) {
            agrPushLogPO.setIsFinish("0");
            agrPushLogPO.setFailReason("\u534f\u8bae\u7f16\u53f7\u3010" + checkAgreement.getEntAgreementCode() + "\u3011\u5df2\u5b58\u5728\uff01");
            agrPushLogPO.setSysTenantId(305775845729763327L);
            agrPushLogPO.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
            this.agrPushLogMapper.insert(agrPushLogPO);
            throw new BusinessException("22053", "\u534f\u8bae\u7f16\u53f7\u3010" + checkAgreement.getEntAgreementCode() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
    }

    public String createAgreementCode() {
        List serialNoList;
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("AGR");
        encodedSerialGetServiceReqBO.setRelType("org");
        encodedSerialGetServiceReqBO.setExtendFlag("1");
        encodedSerialGetServiceReqBO.setRelId("1-305775845729763327-400000000000000020-798977551508250624-");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("ARG_AGREEMENT_CODE");
        encodedSerialGetServiceReqBO.setSysTenantId(Long.valueOf(305775845729763327L));
        String rspString = JSONObject.toJSONString((Object)encodedSerialGetServiceReqBO);
        log.debug("\u83b7\u53d6\u534f\u8bae\u7f16\u7801\u5165\u53c2=" + rspString);
        CfcEncodedSerialGetServiceRspBO encodedSerial = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        String plaAgreementCode = "";
        if (encodedSerial != null && !CollectionUtils.isEmpty((Collection)(serialNoList = encodedSerial.getSerialNoList()))) {
            plaAgreementCode = (String)serialNoList.get(0);
            return plaAgreementCode;
        }
        return null;
    }

    private AgreementPO insertAgreement(CrcAddAgreementSubjectBusiReqBO busiReqBO, Long agreementId, AgrPushLogPO agrPushLogPO, String plaAgreementCode) {
        int isInsert;
        int i1;
        AgreementPO agreementPO = new AgreementPO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)agreementPO);
        agreementPO.setAgreementSrc((byte)6);
        agreementPO.setAdjustPriceFormulaName(busiReqBO.getSysCode());
        agreementPO.setExtField2(busiReqBO.getPlaAgreementCode());
        agreementPO.setPlaAgreementCode(plaAgreementCode);
        String agreementVersion = "V1";
        agreementPO.setAgreementId(agreementId);
        agreementPO.setAgreementVersion(agreementVersion);
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date effDate = null;
        Date expDate = null;
        Date produceTime = null;
        try {
            effDate = sdf1.parse(sdf.format(new Date(busiReqBO.getEffDate())));
            expDate = sdf1.parse(sdf.format(new Date(busiReqBO.getExpDate())));
            produceTime = sdf1.parse(sdf.format(new Date(busiReqBO.getProduceTime())));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Date date = new Date();
        int i = date.compareTo(expDate);
        if (i > 0) {
            agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.INVALID_CONTRACT);
        }
        if ((i1 = date.compareTo(effDate)) < 0) {
            agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.WAIT_ENABLE);
        } else {
            agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
        }
        agreementPO.setAssignStatus(AgrCommConstant.AssignStatus.BE_ASSIGN);
        agreementPO.setEffDate(effDate);
        agreementPO.setExpDate(expDate);
        UmcQryMemLegalOrgInfoAbilityServiceReqBO umcQryMemLegalOrgInfoAbilityServiceReqBO = new UmcQryMemLegalOrgInfoAbilityServiceReqBO();
        umcQryMemLegalOrgInfoAbilityServiceReqBO.setRegAccount(busiReqBO.getProducerId().toLowerCase());
        umcQryMemLegalOrgInfoAbilityServiceReqBO.setSysTenantId(Long.valueOf(305775845729763327L));
        log.info("\u901a\u8fc7ldap\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)umcQryMemLegalOrgInfoAbilityServiceReqBO));
        UmcQryMemLegalOrgInfoAbilityServiceRspBO umcQryMemLegalOrgInfoAbilityServiceRspBO = this.umcQryMemLegalOrgInfoAbilityService.qryMemLegalOrgInfo(umcQryMemLegalOrgInfoAbilityServiceReqBO);
        log.info("\u901a\u8fc7ldap\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)umcQryMemLegalOrgInfoAbilityServiceRspBO));
        if (!"0000".equals(umcQryMemLegalOrgInfoAbilityServiceRspBO.getRespCode())) {
            throw new BusinessException("0101", umcQryMemLegalOrgInfoAbilityServiceRspBO.getRespDesc());
        }
        agreementPO.setProducerId(umcQryMemLegalOrgInfoAbilityServiceRspBO.getMemInformation().getMemId());
        agreementPO.setProducerName(umcQryMemLegalOrgInfoAbilityServiceRspBO.getMemInformation().getMemName2());
        agreementPO.setAssignStatus(AgrCommConstant.AssignStatus.BE_ASSIGN);
        agreementPO.setProduceTime(produceTime);
        CrcQryCorporationByFmsAbilityReqBO crcQryCorporationByFmsAbilityReqBO = new CrcQryCorporationByFmsAbilityReqBO();
        crcQryCorporationByFmsAbilityReqBO.setFmsCode(busiReqBO.getCreateOrgId());
        crcQryCorporationByFmsAbilityReqBO.setSysTenantId(Long.valueOf(305775845729763327L));
        log.info("\u901a\u8fc7fms\u7f16\u7801\u67e5\u8be2\u521b\u5efa\u5355\u4f4d\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)crcQryCorporationByFmsAbilityReqBO));
        CrcQryCorporationByFmsAbilityRspBO crcQryCorporationByFmsAbilityRspBO = this.crcQryCorporationByFmsAbilityService.qryCorporationByFms(crcQryCorporationByFmsAbilityReqBO);
        log.info("\u901a\u8fc7fms\u7f16\u7801\u67e5\u8be2\u521b\u5efa\u5355\u4f4d\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)crcQryCorporationByFmsAbilityRspBO));
        if (!"0000".equals(crcQryCorporationByFmsAbilityRspBO.getRespCode()) || null == crcQryCorporationByFmsAbilityRspBO.getCorPorationBO()) {
            throw new BusinessException("0101", busiReqBO.getCreateOrgId() + "fms\u7801\u67e5\u8be2\u521b\u5efa\u5355\u4f4d\u5931\u8d25");
        }
        agreementPO.setCreateOrgId(crcQryCorporationByFmsAbilityRspBO.getCorPorationBO().getCorporationId());
        agreementPO.setCreateOrgName(crcQryCorporationByFmsAbilityRspBO.getCorPorationBO().getCorporationName());
        CrcQryCorporationByFmsAbilityReqBO verndorReqBO = new CrcQryCorporationByFmsAbilityReqBO();
        verndorReqBO.setCorporationCode(busiReqBO.getVendorId());
        verndorReqBO.setSysTenantId(Long.valueOf(305775845729763327L));
        log.info("\u901a\u8fc7fms\u7f16\u7801\u67e5\u8be2\u4f9b\u5e94\u5546\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)verndorReqBO));
        CrcQryCorporationByFmsAbilityRspBO verndorRspBO = this.crcQryCorporationByFmsAbilityService.qryCorporationByFms(verndorReqBO);
        log.info("\u901a\u8fc7fms\u7f16\u7801\u67e5\u8be2\u4f9b\u5e94\u5546\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)verndorRspBO));
        if (!"0000".equals(verndorRspBO.getRespCode()) || null == verndorRspBO.getCorPorationBO()) {
            throw new BusinessException("0101", "fms\u7801\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        }
        agreementPO.setVendorId(verndorRspBO.getCorPorationBO().getCorporationId());
        agreementPO.setVendorName(verndorRspBO.getCorPorationBO().getCorporationName());
        agreementPO.setVendorContact(verndorRspBO.getCorPorationBO().getRemark());
        agreementPO.setVendorPhone(verndorRspBO.getCorPorationBO().getPhone());
        agreementPO.setSupplierMode((byte)2);
        agreementPO.setVendorDepartmentId(agreementPO.getVendorId());
        agreementPO.setVendorDepartmentName(agreementPO.getVendorName());
        agreementPO.setUnitAccountId(agreementPO.getVendorId());
        agreementPO.setUnitAccountName(agreementPO.getVendorName());
        agreementPO.setSupplierId(agreementPO.getVendorId());
        agreementPO.setSupplierName(agreementPO.getVendorName());
        agreementPO.setAgreementMode((byte)2);
        agreementPO.setCurrency((byte)0);
        agreementPO.setAgreementVariety((byte)1);
        agreementPO.setExtField1("798977551508250624");
        agreementPO.setScopeType((byte)5);
        agreementPO.setSubmissionTime(agreementPO.getProduceTime());
        agreementPO.setSysTenantId(305775845729763327L);
        agreementPO.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
        if (null == agreementPO.getInstandOrder()) {
            agreementPO.setInstandOrder(0);
        }
        if (null == agreementPO.getAgreementPurpose()) {
            agreementPO.setAgreementPurpose(1);
        }
        if ((isInsert = this.agreementMapper.insert(agreementPO)) < 1) {
            throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u8868\u5931\u8d25\uff01");
        }
        return agreementPO;
    }

    private void insertAgreementSettlement(CrcAddAgreementSubjectBusiReqBO busiReqBO, Long agreementId, AgrPushLogPO agrPushLogPO) {
        List<AgreementSettlementBO> paymentMethodList = busiReqBO.getPaymentMethod();
        log.error("paymentMethodList\u7684\u503c" + paymentMethodList);
        if (paymentMethodList == null) {
            throw new BusinessException("0101", "\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u7a7a");
        }
        for (AgreementSettlementBO asb : paymentMethodList) {
            AgrCreateAgreementSettlementAtomReqBO atomReqBO = new AgrCreateAgreementSettlementAtomReqBO();
            BeanUtils.copyProperties((Object)asb, (Object)((Object)atomReqBO));
            atomReqBO.setAgreementId(agreementId);
            atomReqBO.setSettlementDate("60");
            atomReqBO.setAssign("2");
            AgrCreateAgreementSettlementAtomRspBO agreementSettlementInfo = this.agrCreateAgreementSettlementAtomService.createAgreementSettlementInfo(atomReqBO);
            if ("0000".equals(agreementSettlementInfo.getRespCode())) continue;
            throw new BusinessException(agreementSettlementInfo.getRespCode(), agreementSettlementInfo.getRespDesc());
        }
    }

    private void insertAgreementOther(CrcAddAgreementSubjectBusiReqBO busiReqBO, AgreementPO agreementPO, AgrPushLogPO agrPushLogPO) {
        AgrCreateAgreementOtherAtomReqBO atomReqBO = new AgrCreateAgreementOtherAtomReqBO();
        atomReqBO.setMemIdIn(busiReqBO.getMemIdIn());
        atomReqBO.setSupplierId(agreementPO.getSupplierId());
        atomReqBO.setUserName(busiReqBO.getUserName());
        atomReqBO.setAgreementId(agreementPO.getAgreementId());
        atomReqBO.setAgreementVersion(agreementPO.getAgreementVersion());
        if (!CollectionUtils.isEmpty(busiReqBO.getAttach())) {
            for (AgrAgreementAttachBO agrAgreementAttachBO : busiReqBO.getAttach()) {
                agrAgreementAttachBO.setAttachmentType(Byte.valueOf((byte)1));
            }
        }
        atomReqBO.setAgrAgreementAttachBOs(busiReqBO.getAttach());
        ArrayList<AgrAgreementScopeBO> agrAgreementScopeBOs = new ArrayList<AgrAgreementScopeBO>();
        for (CrcAgreementScopeBO crcAgreementScopeBO : busiReqBO.getScope()) {
            CrcQryCorporationByFmsAbilityReqBO crcQryCorporationByFmsAbilityReqBO = new CrcQryCorporationByFmsAbilityReqBO();
            crcQryCorporationByFmsAbilityReqBO.setFmsCode(crcAgreementScopeBO.getScopeCode());
            crcQryCorporationByFmsAbilityReqBO.setSysTenantId(Long.valueOf(305775845729763327L));
            log.info("\u901a\u8fc7fms\u7f16\u7801\u67e5\u8be2\u521b\u5efa\u5355\u4f4d\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)crcQryCorporationByFmsAbilityReqBO));
            CrcQryCorporationByFmsAbilityRspBO crcQryCorporationByFmsAbilityRspBO = this.crcQryCorporationByFmsAbilityService.qryCorporationByFms(crcQryCorporationByFmsAbilityReqBO);
            log.info("\u901a\u8fc7fms\u7f16\u7801\u67e5\u8be2\u521b\u5efa\u5355\u4f4d\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)crcQryCorporationByFmsAbilityRspBO));
            if (!"0000".equals(crcQryCorporationByFmsAbilityRspBO.getRespCode()) || null == crcQryCorporationByFmsAbilityRspBO.getCorPorationBO()) {
                throw new BusinessException("0101", crcAgreementScopeBO.getScopeCode() + "fms\u7801\u67e5\u8be2\u516c\u53f8\u4fe1\u606f\u5931\u8d25");
            }
            AgrAgreementScopeBO agrAgreementScopeBO = new AgrAgreementScopeBO();
            agrAgreementScopeBO.setScopeCode(crcQryCorporationByFmsAbilityRspBO.getCorPorationBO().getCorporationId());
            agrAgreementScopeBO.setScopeName(crcQryCorporationByFmsAbilityRspBO.getCorPorationBO().getCorporationName());
            agrAgreementScopeBOs.add(agrAgreementScopeBO);
        }
        atomReqBO.setAgrAgreementScopeBOs(agrAgreementScopeBOs);
        atomReqBO.setScopeType((byte)5);
        atomReqBO.setOperType("add");
        AgrCreateAgreementOtherAtomRspBO agrCreateAgreementOtherAtomRspBO = this.agrCreateAgreementOtherAtomService.createAgreementOtherInfo(atomReqBO);
        if (!"0000".equals(agrCreateAgreementOtherAtomRspBO.getRespCode())) {
            throw new BusinessException(agrCreateAgreementOtherAtomRspBO.getRespCode(), agrCreateAgreementOtherAtomRspBO.getRespDesc());
        }
    }

    private void insertAgreementSettlementLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId, AgrPushLogPO agrPushLogPO) {
        AgreementSettlementPO agreementSettlementPO = new AgreementSettlementPO();
        agreementSettlementPO.setAgreementIds(agreementIds);
        List<AgreementSettlementPO> list = this.agreementSettlementMapper.getList(agreementSettlementPO);
        ArrayList<AgreementSettlementLogPO> agreementSettlementLogPOList = new ArrayList<AgreementSettlementLogPO>();
        for (AgreementSettlementPO as : list) {
            AgreementSettlementLogPO agreementSettlementLogPO = new AgreementSettlementLogPO();
            BeanUtils.copyProperties((Object)as, (Object)agreementSettlementLogPO);
            Long settleMentLogId = Sequence.getInstance().nextId();
            agreementSettlementLogPO.setAgreementLogId(agreementLogId);
            agreementSettlementLogPO.setSettlementLogId(settleMentLogId);
            agreementSettlementLogPOList.add(agreementSettlementLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementSettlementLogPOList)) {
            log.info("\u534f\u8bae\u4ed8\u6b3e\u65b9\u5f0f\u5199\u5165\u5165\u53c2==========================================" + agreementSettlementLogPOList);
            int count = this.agreementSettlementLogMapper.insertBatch(agreementSettlementLogPOList);
            if (count != agreementSettlementLogPOList.size()) {
                throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u65e5\u5fd7\u8868\u5931\u8d25");
            }
        }
    }

    private void insertAgreementScopeLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId, AgrPushLogPO agrPushLogPO) {
        int count;
        AgreementScopePO agreementScopePO = new AgreementScopePO();
        agreementScopePO.setSupplierId(supplierId);
        agreementScopePO.setAgreementIds(agreementIds);
        agreementScopePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementScopePO> agreementScopeList = this.agreementScopeMapper.getList(agreementScopePO);
        ArrayList<AgreementScopeLogPO> agreementScopeLogPOList = new ArrayList<AgreementScopeLogPO>();
        for (AgreementScopePO agreementScopePO1 : agreementScopeList) {
            AgreementScopeLogPO agreementScopeLogPO = new AgreementScopeLogPO();
            BeanUtils.copyProperties((Object)agreementScopePO1, (Object)agreementScopeLogPO);
            agreementScopeLogPO.setAgreementLogId(agreementLogId);
            agreementScopeLogPOList.add(agreementScopeLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementScopeLogPOList) && (count = this.agreementScopeLogMapper.insertBatch(agreementScopeLogPOList)) != agreementScopeLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u8303\u56f4\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementAttachLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId, AgrPushLogPO agrPushLogPO) {
        int count;
        AgreementAttachPO agreementAttachPO = new AgreementAttachPO();
        agreementAttachPO.setSupplierId(supplierId);
        agreementAttachPO.setAgreementIds(agreementIds);
        agreementAttachPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementAttachPO> agreementAttachList = this.agreementAttachMapper.getList(agreementAttachPO);
        ArrayList<AgrAgreementAttachLogPO> agrAgreementAttachLogPOList = new ArrayList<AgrAgreementAttachLogPO>();
        for (AgreementAttachPO agreementAttachPO1 : agreementAttachList) {
            AgrAgreementAttachLogPO agrAgreementAttachLogPO = new AgrAgreementAttachLogPO();
            BeanUtils.copyProperties((Object)agreementAttachPO1, (Object)agrAgreementAttachLogPO);
            agrAgreementAttachLogPO.setAgreementLogId(agreementLogId);
            agrAgreementAttachLogPOList.add(agrAgreementAttachLogPO);
        }
        if (!CollectionUtils.isEmpty(agrAgreementAttachLogPOList) && (count = this.agrAgreementAttachLogMapper.insertBatch(agrAgreementAttachLogPOList)) != agrAgreementAttachLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u9644\u4ef6\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementSupplier(CrcAddAgreementSubjectBusiReqBO busiReqBO) {
        ArrayList<AgrAgreementSupplierPO> list = new ArrayList<AgrAgreementSupplierPO>();
        for (AgrAgreementSupplierBO agrAgreementSupplierBO : busiReqBO.getDistribution()) {
            AgrAgreementSupplierPO agrAgreementSupplierPO = new AgrAgreementSupplierPO();
            Long id = Sequence.getInstance().nextId();
            BeanUtils.copyProperties((Object)agrAgreementSupplierBO, (Object)agrAgreementSupplierPO);
            agrAgreementSupplierPO.setId(id);
            agrAgreementSupplierPO.setIsDelete("0");
            agrAgreementSupplierPO.setSysTenantId(305775845729763327L);
            agrAgreementSupplierPO.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
            list.add(agrAgreementSupplierPO);
        }
        this.agrAgreementSupplierMapper.insertBatch(list);
    }
}

