/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.util;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.bo.FscInvoiceInfoBO;
import com.tydic.fsc.bo.InvoiceItemBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.ExcelFileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class InvoiceExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(InvoiceExcelUtils.class);
    public static final String[] sheetNames = new String[]{"\u586b\u5199\u8bf4\u660e", "\u7ed3\u7b97\u5355\u4fe1\u606f", "\u5f00\u7968\u660e\u7ec6", "\u90ae\u5bc4\u4fe1\u606f"};
    public static final String EXCEL_XLS = "xls";
    public static final String EXCEL_XLSX = "xlsx";
    public static final String[][] notifiInMap = new String[][]{{"fscOrderNo", "A", "S"}, {"invoiceTypeStr", "B", "S"}, {"buyName", "C", "S"}, {"taxNo", "D", "S"}, {"address", "E", "S"}, {"phone", "F", "S"}, {"bank", "G", "S"}, {"account", "H", "S"}, {"amt", "I", "D"}};
    public static final String[][] ivDetailInMap = new String[][]{{"fscOrderNo", "A", "S"}, {"invoiceCode", "B", "S"}, {"invoiceNo", "C", "S"}, {"billDate", "D", "S"}, {"orderNo", "E", "L"}, {"purchaserName", "E", "L"}, {"identify", "G", "L"}, {"skuId", "H", "L"}, {"skuName", "I", "S"}, {"specModelFigureNo", "J", "S"}, {"unit", "K", "S"}, {"num", "L", "D"}, {"price", "M", "D"}, {"priceUntax", "N", "D"}, {"amt", "O", "D"}, {"untaxAmt", "P", "D"}, {"taxAmt", "Q", "D"}, {"tax", "R", "D"}};
    public static final String[][] notifiOutMap = new String[][]{{"fscOrderNo", "A", "S"}, {"invoiceTypeStr", "B", "S"}, {"buyName", "C", "S"}, {"taxNo", "D", "S"}, {"address", "E", "S"}, {"phone", "F", "S"}, {"bank", "G", "S"}, {"account", "H", "S"}, {"amt", "I", "D"}};
    public static final String[][] ivDetailOutMap = new String[][]{{"fscOrderNo", "A", "S"}, {"invoiceCode", "B", "S"}, {"invoiceNo", "C", "S"}, {"billDate", "D", "S"}, {"orderId", "E", "L"}, {"identify", "F", "L"}, {"skuId", "G", "L"}, {"skuName", "H", "S"}, {"specModelFigureNo", "I", "S"}, {"unit", "I", "S"}, {"num", "K", "D"}, {"price", "L", "D"}, {"priceUntax", "M", "D"}, {"amt", "N", "D"}, {"untaxAmt", "O", "D"}, {"taxAmt", "P", "D"}, {"taxRate", "Q", "D"}};
    public static final String BILL_DATE_KEY = "billDate";

    private static FscInvoiceInfoBO explainExcel(InputStream is, boolean xlsxMode) {
        ExcelFileUtils excel = new ExcelFileUtils(is, xlsxMode);
        if (!excel.isReady()) {
            throw new ZTBusinessException("\u65e0\u6cd5\u89e3\u6790Excel\u6587\u4ef6");
        }
        if (excel.getSheetCount() == 4 ? !"\u90ae\u5bc4\u4fe1\u606f".equals(excel.getSheetName(3)) && excel.getSheetCount() != 3 : excel.getSheetCount() != 3) {
            throw new ZTBusinessException("\u4e0a\u4f20\u7684Excel\u5e94\u67093\u9875");
        }
        for (int i = 0; i < 3; ++i) {
            if (sheetNames[i].equals(excel.getSheetName(i))) continue;
            throw new ZTBusinessException("\u7b2c" + (i + 1) + "\u4e2a\u6570\u636e\u9875\u7684\u540d\u79f0[" + excel.getSheetName(i) + "]\u4e0e\u9884\u671f\u4e0d\u7b26\u5408,\u8bf7\u4e0d\u8981\u4fee\u6539\u6a21\u677f\u6587\u4ef6\u7684\u9875\u540d\u79f0");
        }
        FscInvoiceInfoBO invoice = new FscInvoiceInfoBO();
        StringBuilder errorCollection = new StringBuilder();
        List<String[]> dataRows = excel.readRows(1, 0, -1);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 1; i < dataRows.size(); ++i) {
            String[] fields = dataRows.get(i);
            map.clear();
            StringBuilder errorMsg = InvoiceExcelUtils.arrayToMap(fields, notifiInMap, map);
            if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                errorCollection.append(errorMsg.toString());
                break;
            }
            errorMsg = InvoiceExcelUtils.arrayToMap(fields, notifiInMap, map);
            if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                errorCollection.append(errorMsg.toString());
                break;
            }
            InvoiceExcelUtils.mapToBean(map, invoice);
        }
        if (!StringUtils.isBlank((CharSequence)errorCollection)) {
            throw new FscBusinessException("198888", errorCollection.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug("Excel\u8f7d\u5165\u7684\u53d1\u7968:{}", (Object)JSON.toJSONString((Object)invoice));
        }
        ArrayList<FscInvoiceInfoBO> invoices = new ArrayList<FscInvoiceInfoBO>();
        HashMap<String, FscInvoiceInfoBO> existInvoiceMap = new HashMap<String, FscInvoiceInfoBO>();
        try {
            dataRows = excel.readRows(2, 0, -1);
        }
        catch (Exception e) {
            log.error("\u65e0\u6cd5\u89e3\u6790Excel\u6587\u4ef6, \u53d1\u751f\u9519\u8bef\u7684\u4f4d\u7f6e{}:{}", (Object)excel.getLastCellLocation(), (Object)e);
            excel.close();
            throw new FscBusinessException("198888", "\u65e0\u6cd5\u89e3\u6790Excel\u6587\u4ef6,\u53d1\u751f\u9519\u8bef\u7684\u4f4d\u7f6e" + excel.getLastCellLocation() + e);
        }
        FscInvoiceInfoBO iv = null;
        StringBuilder nullErrorMsg = new StringBuilder();
        ArrayList<InvoiceItemBO> invoiceItems = new ArrayList<InvoiceItemBO>();
        for (int i = 1; i < dataRows.size(); ++i) {
            String ivNo;
            String[] fields = dataRows.get(i);
            if (fields[0].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u7ed3\u7b97\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (fields[1].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (fields[2].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (fields[3].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (!StringUtils.isBlank((CharSequence)nullErrorMsg)) {
                errorCollection.append(nullErrorMsg.toString());
                break;
            }
            map.clear();
            StringBuilder errorMsg = InvoiceExcelUtils.arrayToMap(fields, ivDetailInMap, map);
            if (!StringUtils.isBlank((CharSequence)errorCollection)) {
                errorCollection.append(errorMsg.toString());
                break;
            }
            InvoiceExcelUtils.mapToBean(map, invoice);
            Object billDate = map.get(BILL_DATE_KEY);
            if (null != billDate) {
                invoice.setBillDate(billDate.toString());
            }
            if (!existInvoiceMap.containsKey(ivNo = invoice.getInvoiceCode() + "-" + invoice.getInvoiceNo())) {
                iv = new FscInvoiceInfoBO();
                invoices.add(iv);
                BeanUtils.copyProperties((Object)invoice, (Object)iv);
                existInvoiceMap.put(ivNo, iv);
                iv.setInvoiceItemBOS(invoiceItems);
            }
            if (!StringUtils.isBlank((CharSequence)(errorMsg = InvoiceExcelUtils.arrayToMap(fields, ivDetailInMap, map)))) {
                errorCollection.append(errorMsg.toString());
                break;
            }
            InvoiceItemBO ivDetail = new InvoiceItemBO();
            InvoiceExcelUtils.mapToBean(map, ivDetail);
            iv.getInvoiceItemBOS().add(ivDetail);
        }
        if (!StringUtils.isBlank((CharSequence)errorCollection)) {
            throw new FscBusinessException("198888", errorCollection.toString());
        }
        excel.close();
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal untaxAmt = BigDecimal.ZERO;
        BigDecimal taxAmt = BigDecimal.ZERO;
        List<InvoiceItemBO> invoiceItemBOS = iv.getInvoiceItemBOS();
        for (InvoiceItemBO invoiceItemBO : invoiceItemBOS) {
            totalAmt = totalAmt.add(invoiceItemBO.getAmt());
            untaxAmt = untaxAmt.add(invoiceItemBO.getUntaxAmt());
            taxAmt = taxAmt.add(invoiceItemBO.getTaxAmt());
        }
        iv.setAmt(totalAmt);
        iv.setUntaxAmt(untaxAmt);
        iv.setTaxAmt(taxAmt);
        return iv;
    }

    private static StringBuilder arrayToMap(String[] datasource, String[][] fieldDefine, Map<String, Object> targetMap) {
        StringBuilder errorMsg = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (int j = 0; j < fieldDefine.length; ++j) {
            String taxStr;
            DecimalFormat decimalFormat;
            String type = fieldDefine[j][2];
            if (type.length() == 0) continue;
            int idx = ExcelFileUtils.cellNameToIndex(fieldDefine[j][1]);
            String fName = fieldDefine[j][0];
            log.debug("\u6570\u636e-\u524d" + fName + datasource[idx] + "\u6570\u636e\u957f\u5ea6" + datasource.length + "\u4e0b\u6807" + idx);
            if ("taxRate".equals(fName)) {
                decimalFormat = new DecimalFormat("#0.00");
                taxStr = datasource[idx].replace("%", "");
                datasource[idx] = new BigDecimal(decimalFormat.format(Double.parseDouble(taxStr) / 100.0)).toString();
            } else if ("tax".equals(fName)) {
                decimalFormat = new DecimalFormat("#0.00");
                taxStr = datasource[idx].replace("%", "");
                datasource[idx] = new BigDecimal(decimalFormat.format(Double.parseDouble(taxStr) / 100.0)).toString();
            }
            log.debug("\u6570\u636e" + fName + datasource[idx]);
            if ("D".equals(type) && datasource[idx] != null) {
                if (datasource[idx].length() == 0) {
                    datasource[idx] = "0";
                }
                targetMap.put(fName, new BigDecimal(datasource[idx]));
                continue;
            }
            if ("T".equals(type)) {
                Date dt = null;
                try {
                    dt = sdf.parse(datasource[idx]);
                }
                catch (Exception e) {
                    errorMsg.append("\u65e5\u671f" + datasource[idx] + "\u683c\u5f0f\u6709\u8bef\u3002");
                    break;
                }
                if (dt == null) continue;
                targetMap.put(fName, dt);
                continue;
            }
            targetMap.put(fName, datasource[idx]);
        }
        if (null != errorMsg && errorMsg.length() <= 0) {
            errorMsg = null;
        }
        return errorMsg;
    }

    private static void mapToBean(Map<String, Object> map, Object bean) {
        try {
            org.apache.commons.beanutils.BeanUtils.populate((Object)bean, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FscInvoiceInfoBO dealExcel(File file) {
        try {
            boolean xlsFlag = false;
            FileInputStream is = new FileInputStream(file);
            if (file.getName().endsWith(EXCEL_XLS)) {
                xlsFlag = false;
            } else if (file.getName().endsWith(EXCEL_XLSX)) {
                xlsFlag = true;
            }
            return InvoiceExcelUtils.explainExcel(is, xlsFlag);
        }
        catch (FileNotFoundException e) {
            throw new FscBusinessException("198888", "FileNotFound\u5f02\u5e38");
        }
    }
}

