/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.util;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtils {
    private static final String FONT_NAME = "\u5fae\u8f6f\u96c5\u9ed1";
    public static final Logger logger = LoggerFactory.getLogger(ExcelUtils.class);
    private static final String EXCEL_XLS = "xls";
    private static final String EXCEL_XLSX = "xlsx";

    public static CellStyle setHeadCellStyle(SXSSFWorkbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontName(FONT_NAME);
        font.setFontHeightInPoints((short)12);
        font.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.PALE_BLUE.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public static CellStyle setBodyCellStyle(SXSSFWorkbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontName(FONT_NAME);
        font.setFontHeightInPoints((short)12);
        font.setColor((short)Short.MAX_VALUE);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public static void createHeadContent(SXSSFSheet sheet, CellStyle cellStyle, List<Map<String, Object>> mapList, boolean flag, SXSSFWorkbook workbook) {
        if (mapList != null && mapList.size() > 0) {
            HashMap map = new HashMap();
            for (Map<String, Object> aMapList : mapList) {
                map = map.size() > aMapList.size() ? map : aMapList;
            }
            if (flag) {
                CellStyle headStyle2 = ExcelUtils.setBodyCellStyle(workbook);
                Font font = workbook.createFont();
                font.setBold(true);
                font.setFontName(FONT_NAME);
                font.setFontHeightInPoints((short)12);
                font.setColor((short)Short.MAX_VALUE);
                headStyle2.setFont(font);
                SXSSFRow rowHerder = sheet.createRow(0);
                SXSSFCell cell = rowHerder.createCell(0);
                cell.setCellStyle(headStyle2);
                sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 11));
                cell.setCellValue("\u7535\u5b50\u8d85\u5e02_\u5546\u54c1\u6e05\u5355");
                SXSSFRow row2 = sheet.createRow(1);
                Set keySet = map.keySet();
                Iterator iterator = keySet.iterator();
                int col = 0;
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    SXSSFCell cell2 = row2.createCell(col);
                    cell2.setCellStyle(cellStyle);
                    cell2.setCellValue(StringUtils.isBlank((CharSequence)key) ? "" : key);
                    ++col;
                }
            } else {
                cellStyle.setFillPattern(FillPatternType.NO_FILL);
                SXSSFRow row = sheet.createRow(0);
                Set keySet = map.keySet();
                Iterator iterator = keySet.iterator();
                int col = 0;
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    SXSSFCell cell = row.createCell(col);
                    cell.setCellStyle(cellStyle);
                    cell.setCellValue(StringUtils.isBlank((CharSequence)key) ? "" : key);
                    ++col;
                }
            }
        } else {
            logger.error("\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static void createBodyContent(SXSSFSheet sheet, CellStyle cellStyle, List<Map<String, Object>> mapList, boolean flag, SXSSFWorkbook workbook, BigDecimal totalPrice) {
        if (mapList != null && !mapList.isEmpty()) {
            if (!flag) {
                return;
            }
            Map<String, Object> map = null;
            int j = 1;
            if (flag) {
                j = 2;
            }
            for (int i = 0; i < mapList.size(); ++i) {
                map = mapList.get(i);
                SXSSFRow row = sheet.createRow(i + j);
                Set<String> keySet = map.keySet();
                Iterator<String> iterator = keySet.iterator();
                int col = 0;
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    Object object = map.get(key);
                    SXSSFCell cell = row.createCell(col);
                    cell.setCellValue(object == null ? "" : object.toString());
                    cell.setCellStyle(cellStyle);
                    ++col;
                }
                map.clear();
            }
            if (flag) {
                CellStyle headStyle2 = ExcelUtils.setBodyCellStyle(workbook);
                headStyle2.setAlignment(HorizontalAlignment.RIGHT);
                headStyle2.setVerticalAlignment(VerticalAlignment.TOP);
                SXSSFRow row2 = sheet.createRow(mapList.size() + 2);
                SXSSFCell cell2 = row2.createCell(0);
                cell2.setCellStyle(headStyle2);
                sheet.addMergedRegion(new CellRangeAddress(mapList.size() + 2, mapList.size() + 2, 0, 11));
                cell2.setCellValue("\u603b\u4ef7\u5408\u8ba1\uff1a" + totalPrice);
            }
            mapList.clear();
            mapList = null;
        } else {
            logger.error("\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static SXSSFWorkbook createWorkbook(List<Map<String, Object>> data, String name, boolean flag, BigDecimal totalPrice) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet sheet = workbook.createSheet(name);
        CellStyle headStyle = ExcelUtils.setHeadCellStyle(workbook);
        ExcelUtils.createHeadContent(sheet, headStyle, data, flag, workbook);
        CellStyle bodyStyle = ExcelUtils.setBodyCellStyle(workbook);
        ExcelUtils.createBodyContent(sheet, bodyStyle, data, flag, workbook, totalPrice);
        return workbook;
    }

    public static List<Map<String, String>> getExcelData(MultipartFile file) throws Exception {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        ExcelUtils.format(title, list, result);
        return result;
    }

    public static void getExcelData(MultipartFile file, List<List<String>> data, List<String> title) throws Exception {
        ExcelUtils.checkExcelVaild(file);
        Workbook workbook = ExcelUtils.getWorkbok(file);
        int count = 0;
        Sheet sheet = workbook.getSheetAt(0);
        for (Row row : sheet) {
            ArrayList<String> c = new ArrayList<String>();
            int end = row.getLastCellNum();
            if ("".equals(row.getCell(0).toString())) continue;
            for (int i = 0; i < end; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) {
                    c.add("");
                    continue;
                }
                Object obj = ExcelUtils.getValue(cell);
                if (count == 0) {
                    title.add(String.valueOf(obj).trim());
                    continue;
                }
                if (count < 1) continue;
                c.add(String.valueOf(obj).trim());
            }
            ++count;
            if (c.size() <= 0) continue;
            data.add(c);
        }
    }

    public static List<List<String>> getExcelData(MultipartFile file, Integer startIndex) throws Exception {
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        ExcelUtils.checkExcelVaild(file);
        Workbook workbook = ExcelUtils.getWorkbok(file);
        Sheet sheet = workbook.getSheetAt(0);
        for (int i = startIndex.intValue(); i <= sheet.getPhysicalNumberOfRows(); ++i) {
            Row row = sheet.getRow(i);
            ArrayList<String> c = new ArrayList<String>();
            if (row == null) continue;
            int end = row.getLastCellNum();
            if ("".equals(row.getCell(1).toString()) && "".equals(row.getCell(2).toString())) continue;
            for (int j = 0; j < end; ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) {
                    c.add("");
                    continue;
                }
                Object obj = ExcelUtils.getValue(cell);
                c.add(String.valueOf(obj).trim());
            }
            if (c.size() <= 0) continue;
            data.add(c);
        }
        return data;
    }

    public static List<List<String>> getExcelDataImport(MultipartFile file, Integer startIndex) throws Exception {
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        ExcelUtils.checkExcelVaild(file);
        Workbook workbook = ExcelUtils.getWorkbok(file);
        Sheet sheet = workbook.getSheetAt(0);
        for (int i = startIndex.intValue(); i <= sheet.getPhysicalNumberOfRows(); ++i) {
            Row row = sheet.getRow(i);
            ArrayList<String> c = new ArrayList<String>();
            if (row == null) continue;
            int end = row.getLastCellNum();
            if ("".equals(row.getCell(0).toString())) continue;
            for (int j = 0; j < end; ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) {
                    c.add("");
                    continue;
                }
                Object obj = ExcelUtils.getValue(cell);
                c.add(String.valueOf(obj).trim());
            }
            if (c.size() <= 0) continue;
            data.add(c);
        }
        return data;
    }

    private static void format(List<String> title, List<List<String>> lists, List<Map<String, String>> result) {
        logger.info("lists==={}", (Object)JSON.toJSONString(lists));
        logger.info("title==={}", (Object)JSON.toJSONString(title));
        for (List<String> list : lists) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (int i = 0; i < title.size(); ++i) {
                String s;
                String string = s = ObjectUtils.isEmpty((Object)title.get(i)) ? "" : title.get(i);
                if (i < list.size()) {
                    map.put(s, list.get(i));
                    continue;
                }
                map.put(s, "");
            }
            result.add(map);
        }
    }

    private static Workbook getWorkbok(MultipartFile file) throws IOException {
        HSSFWorkbook wb = null;
        if (file.getOriginalFilename().endsWith(EXCEL_XLS)) {
            wb = new HSSFWorkbook(file.getInputStream());
        } else if (file.getOriginalFilename().endsWith(EXCEL_XLSX)) {
            wb = new XSSFWorkbook(file.getInputStream());
        }
        return wb;
    }

    private static void checkExcelVaild(MultipartFile file) throws Exception {
        if (!file.getOriginalFilename().endsWith(EXCEL_XLS) && !file.getOriginalFilename().endsWith(EXCEL_XLSX)) {
            throw new Exception("\u6587\u4ef6\u4e0d\u662fExcel");
        }
    }

    private static Object getValue(Cell cell) {
        Object obj = null;
        switch (cell.getCellTypeEnum()) {
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case ERROR: {
                obj = cell.getErrorCellValue();
                break;
            }
            case NUMERIC: {
                obj = cell.getNumericCellValue();
                break;
            }
            case STRING: {
                obj = cell.getStringCellValue();
                break;
            }
        }
        return obj;
    }
}

